/*--------------------------------------------------------------------------*/
/* ALBERTA:  an Adaptive multi Level finite element toolbox using           */
/*           Bisectioning refinement and Error control by Residual          */
/*           Techniques for scientific Applications                         */
/*                                                                          */
/* file:     bas_fct_3d.c                                                   */
/*                                                                          */
/*                                                                          */
/* description:  Lagrange basis functions up to order 4 in 3d               */
/*               includes ./lagrange_[1234]_3d.c                            */
/*               includes ./disc_lagrange_[012]_3d.c                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  authors:   Alfred Schmidt                                               */
/*             Zentrum fuer Technomathematik                                */
/*             Fachbereich 3 Mathematik/Informatik                          */
/*             Universitaet Bremen                                          */
/*             Bibliothekstr. 2                                             */
/*             D-28359 Bremen, Germany                                      */
/*                                                                          */
/*             Kunibert G. Siebert                                          */
/*             Institut fuer Mathematik                                     */
/*             Universitaet Augsburg                                        */
/*             Universitaetsstr. 14                                         */
/*             D-86159 Augsburg, Germany                                    */
/*                                                                          */
/*  http://www.mathematik.uni-freiburg.de/IAM/ALBERTA                       */
/*                                                                          */
/*  (c) by A. Schmidt and K.G. Siebert (1996-2003)                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*  discontinuous Lagrangian basisfunctions of order 0-2; these             */
/*  functions are evaluated in barycentric coordinates; the derivatives     */
/*  are those corresponding to these barycentric coordinates.               */
/*--------------------------------------------------------------------------*/

#include "disc_lagrange_0_3d.c"
#include "disc_lagrange_1_3d.c"
#include "disc_lagrange_2_3d.c"

/*--------------------------------------------------------------------------*/
/*  Lagrangian basis functions of order 1-4; these                          */
/*  functions are evaluated in barycentric coordinates; the derivatives     */
/*  are those corresponding to these barycentric coordinates.               */
/*--------------------------------------------------------------------------*/

#include "lagrange_1_3d.c"
#include "lagrange_2_3d.c"
#include "lagrange_3_3d.c"
#include "lagrange_4_3d.c"
