/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.authentication;

import org.intabulas.sandler.AtomConstants;
import org.intabulas.sandler.authentication.DigestUtilities;

public class AtomAuthentication
implements AtomConstants {
    private String _username;
    private String _relm;
    private String _nonce;
    private String _uri;
    private String _qop;
    private String _nc;
    private String _cnonce;
    private String _response;

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String _username) {
        this._username = _username;
    }

    public AtomAuthentication(String authHeader) {
        this.parseAuthHeader(authHeader);
    }

    private void parseAuthHeader(String header) {
        String[] tokens = header.split(",");
        for (int x = 0; x < tokens.length; ++x) {
            int index = tokens[x].indexOf(61);
            if (index == -1) continue;
            String key = tokens[x].substring(0, index).trim();
            String value = tokens[x].substring(index + 1).trim();
            value = value.replaceAll("\"", "");
            if (key.startsWith("Atom")) {
                key = key.substring(ATOM_REALM_KEY_LENGTH).trim();
            }
            if (key.equalsIgnoreCase("username")) {
                this._username = value;
                continue;
            }
            if (key.equalsIgnoreCase("realm")) {
                this._relm = value;
                continue;
            }
            if (key.equalsIgnoreCase("nonce")) {
                this._nonce = value;
                continue;
            }
            if (key.equalsIgnoreCase("uri")) {
                this._uri = value;
                continue;
            }
            if (key.equalsIgnoreCase("qop")) {
                this._qop = value;
                continue;
            }
            if (key.equalsIgnoreCase("nc")) {
                this._nc = value;
                continue;
            }
            if (key.equalsIgnoreCase("cnonce")) {
                this._cnonce = value;
                continue;
            }
            if (!key.equalsIgnoreCase("response")) continue;
            this._response = value;
        }
    }

    public boolean authenticate(String password, String verb) {
        String a1 = DigestUtilities.digestString(this._username + ':' + this._relm + ':' + password);
        String a2 = DigestUtilities.digestString(verb + ':' + this._uri);
        String check = DigestUtilities.digestString(a1 + ':' + this._nonce + ':' + this._nc + ':' + this._cnonce + ':' + this._qop + ':' + a2);
        return check.equals(this._response);
    }
}

