/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;

class ValidationErrorReportResolution
implements Resolution {
    private static final Log log = Log.getInstance(ValidationErrorReportResolution.class);
    private ValidationErrors errors;

    protected ValidationErrorReportResolution(ValidationErrors errors) {
        this.errors = errors;
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        IllegalStateException exception = new IllegalStateException("Here's how it is. Someone (quite possibly the Stripes Dispatcher) needed to get the source page resolution. But no source page was supplied in the request, and unless you override ActionBeanContext.getSourcePageResolution() you're going to need that value. When you use a <stripes:form> tag a hidden field called '_sourcePage' is included. If you write your own forms or links that could generate validation errors, you must include a value  for this parameter. This can be done by calling request.getServletPath().");
        log.error(exception, new Object[0]);
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<html>");
        writer.println("<head><title>Stripes validation error report</title></head>");
        writer.println("<body style=\"font-family: Arial, sans-serif; font-size: 10pt;\">");
        writer.println("<h1>Stripes validation error report</h1><p>");
        writer.println(exception.getMessage());
        writer.println("</p><h2>Validation errors</h2><p>");
        this.sendErrors(request, response);
        writer.println("</p></body></html>");
    }

    protected void sendErrors(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        ResourceBundle bundle = null;
        try {
            bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
        }
        catch (MissingResourceException mre) {
            log.warn(this.getClass().getName(), " could not find the error messages resource bundle. ", "As a result default headers/footers etc. will be used. Check that ", "you have a StripesResources.properties in your classpath (unless ", "of course you have configured a different bundle).");
        }
        String header = this.getResource(bundle, "header", "<div class=\"errorHeader\">Validation Errors</div><ul>");
        String footer = this.getResource(bundle, "footer", "</ul>");
        String openElement = this.getResource(bundle, "beforeError", "<li>");
        String closeElement = this.getResource(bundle, "afterError", "</li>");
        PrintWriter writer = response.getWriter();
        writer.write(header);
        for (List list : this.errors.values()) {
            for (ValidationError fieldError : list) {
                writer.write(openElement);
                writer.write(fieldError.getMessage(locale));
                writer.write(closeElement);
            }
        }
        writer.write(footer);
    }

    protected String getResource(ResourceBundle bundle, String name, String fallback) {
        String resource;
        if (bundle == null) {
            return fallback;
        }
        try {
            resource = bundle.getString("stripes.errors." + name);
        }
        catch (MissingResourceException mre) {
            resource = fallback;
        }
        return resource;
    }
}

