# 1 "compiler/lib/js_lexer.mll"
 

(* Js_of_ocaml compiler
 * Copyright (C) 2013 Hugo Heuzard
 *)

(* Yoann Padioleau
 *
 * Copyright (C) 2010 Facebook
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation, with the
 * special exception on linking described in file license.txt.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the file
 * license.txt for more details.
 *)

open Js_token

let tok lexbuf = Lexing.lexeme lexbuf

let keyword_table =
  let h = Hashtbl.create 17 in
  List.iter (fun (s,f) -> Hashtbl.add h s f ) [
    "break",      (fun ii -> T_BREAK ii);
    "case",       (fun ii -> T_CASE ii);
    "catch",      (fun ii -> T_CATCH ii);
    "continue",   (fun ii -> T_CONTINUE ii);
    "debugger",   (fun ii -> T_DEBUGGER ii);
    "default",    (fun ii -> T_DEFAULT ii);
    "delete",     (fun ii -> T_DELETE ii);
    "do",         (fun ii -> T_DO ii);
    "else",       (fun ii -> T_ELSE ii);
    "false",      (fun ii -> T_FALSE ii);
    "finally",    (fun ii -> T_FINALLY ii);
    "for",        (fun ii -> T_FOR ii);
    "function",   (fun ii -> T_FUNCTION ii);
    "if",         (fun ii -> T_IF ii);
    "in",         (fun ii -> T_IN ii);
    "instanceof", (fun ii -> T_INSTANCEOF ii);
    "new",        (fun ii -> T_NEW ii);
    "null",       (fun ii -> T_NULL ii);
    "return",     (fun ii -> T_RETURN ii);
    "switch",     (fun ii -> T_SWITCH ii);
    "this",       (fun ii -> T_THIS ii);
    "throw",      (fun ii -> T_THROW ii);
    "true",       (fun ii -> T_TRUE ii);
    "try",        (fun ii -> T_TRY ii);
    "typeof",     (fun ii -> T_TYPEOF ii);
    "var",        (fun ii -> T_VAR ii);
    "void",       (fun ii -> T_VOID ii);
    "while",      (fun ii -> T_WHILE ii);
    "while",      (fun ii -> T_WHILE ii);
    "with",       (fun ii -> T_WITH ii);
  ];
  h


# 65 "compiler/lib/js_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\197\255\198\255\200\255\081\000\103\000\160\000\207\255\
    \003\000\031\000\035\000\083\000\100\000\078\000\081\000\084\000\
    \085\000\127\000\109\000\241\255\242\255\243\255\244\255\235\000\
    \246\255\247\255\248\255\249\255\250\255\251\255\252\255\001\000\
    \003\000\120\000\199\255\153\000\255\255\245\000\011\001\021\001\
    \031\001\220\255\240\255\219\255\239\255\087\000\238\255\103\000\
    \237\255\104\000\236\255\230\255\107\000\235\255\110\000\228\255\
    \227\255\224\255\232\255\223\255\231\255\222\255\221\255\218\255\
    \043\001\055\001\065\001\120\001\102\000\252\255\253\255\143\001\
    \181\001\255\255\204\001\254\255\242\001\009\002\047\002\161\000\
    \251\255\252\255\004\000\255\255\254\255\129\000\251\255\252\255\
    \253\255\254\255\047\000\255\255\214\000\252\255\253\255\048\000\
    \255\255\254\255\053\002\166\002\251\255\167\002\254\255\005\000\
    \126\000\255\255\139\000\166\000\169\002\179\002\116\001\255\255\
    ";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\255\255\054\000\054\000\050\000\255\255\
    \046\000\043\000\042\000\041\000\040\000\039\000\038\000\047\000\
    \049\000\044\000\045\000\255\255\255\255\255\255\255\255\010\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\003\000\
    \002\000\056\000\255\255\001\000\255\255\054\000\255\255\053\000\
    \255\255\255\255\255\255\255\255\255\255\021\000\255\255\022\000\
    \255\255\026\000\255\255\255\255\030\000\255\255\029\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \054\000\052\000\255\255\051\000\255\255\255\255\255\255\002\000\
    \002\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\002\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\003\000\255\255\255\255\255\255\255\255\002\000\
    \255\255\255\255\000\000\255\255\255\255\002\000\255\255\001\000\
    \003\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_default =
   "\001\000\000\000\000\000\000\000\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\000\000\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\255\255\000\000\035\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\255\255\000\000\255\255\
    \000\000\255\255\000\000\000\000\255\255\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\070\000\000\000\000\000\255\255\
    \255\255\000\000\255\255\000\000\255\255\255\255\255\255\081\000\
    \000\000\000\000\255\255\000\000\000\000\087\000\000\000\000\000\
    \000\000\000\000\091\000\000\000\094\000\000\000\000\000\097\000\
    \000\000\000\000\255\255\101\000\000\000\101\000\000\000\255\255\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\000\000\
    ";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\032\000\030\000\030\000\032\000\031\000\084\000\102\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \032\000\015\000\003\000\032\000\006\000\009\000\018\000\003\000\
    \027\000\026\000\010\000\012\000\021\000\011\000\023\000\033\000\
    \005\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\020\000\022\000\014\000\016\000\013\000\019\000\
    \063\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\025\000\062\000\024\000\008\000\006\000\
    \061\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\029\000\017\000\028\000\007\000\064\000\
    \060\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\053\000\052\000\049\000\050\000\058\000\
    \059\000\047\000\045\000\042\000\046\000\064\000\038\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\004\000\
    \004\000\057\000\036\000\255\255\048\000\051\000\255\255\035\000\
    \055\000\054\000\041\000\056\000\038\000\105\000\107\000\108\000\
    \089\000\000\000\000\000\000\000\000\000\034\000\038\000\000\000\
    \000\000\000\000\000\000\000\000\043\000\000\000\000\000\066\000\
    \000\000\000\000\073\000\083\000\006\000\000\000\108\000\000\000\
    \083\000\000\000\000\000\000\000\038\000\000\000\000\000\000\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\000\000\071\000\088\000\090\000\072\000\066\000\
    \000\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\044\000\000\000\082\000\000\000\006\000\
    \002\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\255\255\
    \255\255\000\000\095\000\096\000\000\000\000\000\040\000\000\000\
    \040\000\000\000\038\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\000\000\038\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\064\000\069\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\004\000\
    \004\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\000\000\038\000\110\000\000\000\000\000\
    \000\000\086\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\110\000\000\000\111\000\000\000\
    \000\000\255\255\000\000\111\000\038\000\000\000\000\000\000\000\
    \000\000\080\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\067\000\067\000\067\000\067\000\067\000\067\000\076\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\093\000\000\000\
    \000\000\067\000\067\000\067\000\067\000\067\000\067\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\000\000\000\000\000\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\077\000\000\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \000\000\000\000\000\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\075\000\
    \075\000\000\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \102\000\255\255\108\000\103\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\110\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\108\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \104\000\255\255\000\000\110\000\000\000\000\000\000\000\000\000\
    \000\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\100\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\031\000\032\000\000\000\082\000\103\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\032\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \008\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\009\000\000\000\000\000\000\000\
    \010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
    \011\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\013\000\013\000\014\000\014\000\012\000\
    \011\000\015\000\016\000\018\000\045\000\005\000\004\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\012\000\033\000\035\000\047\000\049\000\035\000\033\000\
    \052\000\052\000\018\000\054\000\005\000\104\000\106\000\107\000\
    \085\000\255\255\255\255\255\255\255\255\033\000\004\000\255\255\
    \255\255\255\255\255\255\255\255\017\000\255\255\255\255\005\000\
    \255\255\255\255\068\000\079\000\006\000\255\255\107\000\255\255\
    \079\000\255\255\255\255\255\255\005\000\255\255\255\255\255\255\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\255\255\068\000\085\000\085\000\068\000\005\000\
    \255\255\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\017\000\255\255\079\000\255\255\006\000\
    \000\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\090\000\
    \095\000\255\255\092\000\092\000\255\255\255\255\038\000\255\255\
    \038\000\255\255\037\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\255\255\037\000\064\000\064\000\064\000\064\000\064\000\
    \064\000\064\000\064\000\064\000\064\000\065\000\068\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \066\000\066\000\066\000\255\255\065\000\110\000\255\255\255\255\
    \255\255\085\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\110\000\255\255\110\000\255\255\
    \255\255\035\000\255\255\110\000\065\000\255\255\255\255\255\255\
    \255\255\079\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\067\000\067\000\067\000\067\000\067\000\067\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \071\000\071\000\071\000\071\000\071\000\071\000\092\000\255\255\
    \255\255\067\000\067\000\067\000\067\000\067\000\067\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\072\000\072\000\072\000\
    \072\000\072\000\072\000\072\000\072\000\072\000\072\000\255\255\
    \071\000\071\000\071\000\071\000\071\000\071\000\072\000\072\000\
    \072\000\072\000\072\000\072\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\074\000\074\000\074\000\
    \074\000\074\000\074\000\255\255\255\255\255\255\072\000\072\000\
    \072\000\072\000\072\000\072\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\076\000\255\255\074\000\074\000\074\000\
    \074\000\074\000\074\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\077\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\077\000\077\000\077\000\077\000\077\000\077\000\
    \255\255\255\255\255\255\076\000\076\000\076\000\076\000\076\000\
    \076\000\255\255\255\255\255\255\255\255\255\255\255\255\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\255\255\077\000\077\000\077\000\077\000\077\000\077\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \099\000\101\000\108\000\099\000\101\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\108\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \099\000\101\000\255\255\109\000\255\255\255\255\255\255\255\255\
    \255\255\108\000\108\000\108\000\108\000\108\000\108\000\108\000\
    \108\000\108\000\108\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\099\000\101\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\001\000\011\000\000\000\007\000\
    ";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_default_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\107\000\108\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \107\000\108\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\108\000\108\000\108\000\108\000\108\000\108\000\108\000\
    \108\000\108\000\108\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_code =
   "\255\002\255\255\003\255\255\000\002\001\003\255";
}

let rec initial tokinfo prev lexbuf =
   __ocaml_lex_initial_rec tokinfo prev lexbuf 0
and __ocaml_lex_initial_rec tokinfo prev lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 76 "compiler/lib/js_lexer.mll"
         (
      let info = tokinfo lexbuf in
      let buf = Buffer.create 127 in
      let nl = ref false in
      st_comment buf nl lexbuf;
      let content = Buffer.contents buf in
      if !nl
      then TCommentML(info,content)
      else TComment(info,content)
    )
# 493 "compiler/lib/js_lexer.ml"

  | 1 ->
let
# 87 "compiler/lib/js_lexer.mll"
                             cmt
# 499 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 87 "compiler/lib/js_lexer.mll"
                                  ( TComment(tokinfo lexbuf,cmt) )
# 503 "compiler/lib/js_lexer.ml"

  | 2 ->
let
# 89 "compiler/lib/js_lexer.mll"
                     cmt
# 509 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 89 "compiler/lib/js_lexer.mll"
                                  ( TCommentSpace(tokinfo lexbuf,cmt) )
# 513 "compiler/lib/js_lexer.ml"

  | 3 ->
# 90 "compiler/lib/js_lexer.mll"
            (
      lexbuf.Lexing.lex_curr_p <- { lexbuf.Lexing.lex_curr_p with
                                      Lexing.pos_lnum = lexbuf.Lexing.lex_curr_p.Lexing.pos_lnum + 1 };
      TCommentNewline(tokinfo lexbuf,"") )
# 521 "compiler/lib/js_lexer.ml"

  | 4 ->
# 99 "compiler/lib/js_lexer.mll"
        ( T_LCURLY (tokinfo lexbuf); )
# 526 "compiler/lib/js_lexer.ml"

  | 5 ->
# 100 "compiler/lib/js_lexer.mll"
        ( T_RCURLY (tokinfo lexbuf); )
# 531 "compiler/lib/js_lexer.ml"

  | 6 ->
# 102 "compiler/lib/js_lexer.mll"
        ( T_LPAREN (tokinfo lexbuf); )
# 536 "compiler/lib/js_lexer.ml"

  | 7 ->
# 103 "compiler/lib/js_lexer.mll"
        ( T_RPAREN (tokinfo lexbuf); )
# 541 "compiler/lib/js_lexer.ml"

  | 8 ->
# 105 "compiler/lib/js_lexer.mll"
        ( T_LBRACKET (tokinfo lexbuf); )
# 546 "compiler/lib/js_lexer.ml"

  | 9 ->
# 106 "compiler/lib/js_lexer.mll"
        ( T_RBRACKET (tokinfo lexbuf); )
# 551 "compiler/lib/js_lexer.ml"

  | 10 ->
# 107 "compiler/lib/js_lexer.mll"
        ( T_PERIOD (tokinfo lexbuf); )
# 556 "compiler/lib/js_lexer.ml"

  | 11 ->
# 108 "compiler/lib/js_lexer.mll"
        ( T_SEMICOLON (tokinfo lexbuf); )
# 561 "compiler/lib/js_lexer.ml"

  | 12 ->
# 109 "compiler/lib/js_lexer.mll"
        ( T_COMMA (tokinfo lexbuf); )
# 566 "compiler/lib/js_lexer.ml"

  | 13 ->
# 110 "compiler/lib/js_lexer.mll"
        ( T_COLON (tokinfo lexbuf); )
# 571 "compiler/lib/js_lexer.ml"

  | 14 ->
# 111 "compiler/lib/js_lexer.mll"
        ( T_PLING (tokinfo lexbuf); )
# 576 "compiler/lib/js_lexer.ml"

  | 15 ->
# 112 "compiler/lib/js_lexer.mll"
         ( T_AND (tokinfo lexbuf); )
# 581 "compiler/lib/js_lexer.ml"

  | 16 ->
# 113 "compiler/lib/js_lexer.mll"
         ( T_OR (tokinfo lexbuf); )
# 586 "compiler/lib/js_lexer.ml"

  | 17 ->
# 114 "compiler/lib/js_lexer.mll"
          ( T_STRICT_EQUAL (tokinfo lexbuf); )
# 591 "compiler/lib/js_lexer.ml"

  | 18 ->
# 115 "compiler/lib/js_lexer.mll"
          ( T_STRICT_NOT_EQUAL (tokinfo lexbuf); )
# 596 "compiler/lib/js_lexer.ml"

  | 19 ->
# 116 "compiler/lib/js_lexer.mll"
         ( T_LESS_THAN_EQUAL (tokinfo lexbuf); )
# 601 "compiler/lib/js_lexer.ml"

  | 20 ->
# 117 "compiler/lib/js_lexer.mll"
         ( T_GREATER_THAN_EQUAL (tokinfo lexbuf); )
# 606 "compiler/lib/js_lexer.ml"

  | 21 ->
# 118 "compiler/lib/js_lexer.mll"
         ( T_EQUAL (tokinfo lexbuf); )
# 611 "compiler/lib/js_lexer.ml"

  | 22 ->
# 119 "compiler/lib/js_lexer.mll"
         ( T_NOT_EQUAL (tokinfo lexbuf); )
# 616 "compiler/lib/js_lexer.ml"

  | 23 ->
# 120 "compiler/lib/js_lexer.mll"
         (
      let cpi = tokinfo lexbuf in
      match prev with
        | Some p when (Js_token.info_of_tok p).Parse_info.line = cpi.Parse_info.line ->
          T_INCR_NB(cpi)
        | _ -> T_INCR(cpi) )
# 626 "compiler/lib/js_lexer.ml"

  | 24 ->
# 126 "compiler/lib/js_lexer.mll"
         (
      let cpi = tokinfo lexbuf in
      match prev with
        | Some p when (Js_token.info_of_tok p).Parse_info.line = cpi.Parse_info.line ->
          T_DECR_NB(cpi)
        | _ -> T_DECR(cpi) )
# 636 "compiler/lib/js_lexer.ml"

  | 25 ->
# 132 "compiler/lib/js_lexer.mll"
          ( T_LSHIFT_ASSIGN (tokinfo lexbuf); )
# 641 "compiler/lib/js_lexer.ml"

  | 26 ->
# 133 "compiler/lib/js_lexer.mll"
         ( T_LSHIFT (tokinfo lexbuf); )
# 646 "compiler/lib/js_lexer.ml"

  | 27 ->
# 134 "compiler/lib/js_lexer.mll"
          ( T_RSHIFT_ASSIGN (tokinfo lexbuf); )
# 651 "compiler/lib/js_lexer.ml"

  | 28 ->
# 135 "compiler/lib/js_lexer.mll"
           ( T_RSHIFT3_ASSIGN (tokinfo lexbuf); )
# 656 "compiler/lib/js_lexer.ml"

  | 29 ->
# 136 "compiler/lib/js_lexer.mll"
          ( T_RSHIFT3 (tokinfo lexbuf); )
# 661 "compiler/lib/js_lexer.ml"

  | 30 ->
# 137 "compiler/lib/js_lexer.mll"
         ( T_RSHIFT (tokinfo lexbuf); )
# 666 "compiler/lib/js_lexer.ml"

  | 31 ->
# 138 "compiler/lib/js_lexer.mll"
         ( T_PLUS_ASSIGN (tokinfo lexbuf); )
# 671 "compiler/lib/js_lexer.ml"

  | 32 ->
# 139 "compiler/lib/js_lexer.mll"
         ( T_MINUS_ASSIGN (tokinfo lexbuf); )
# 676 "compiler/lib/js_lexer.ml"

  | 33 ->
# 141 "compiler/lib/js_lexer.mll"
         ( T_MULT_ASSIGN (tokinfo lexbuf); )
# 681 "compiler/lib/js_lexer.ml"

  | 34 ->
# 142 "compiler/lib/js_lexer.mll"
         ( T_MOD_ASSIGN (tokinfo lexbuf); )
# 686 "compiler/lib/js_lexer.ml"

  | 35 ->
# 143 "compiler/lib/js_lexer.mll"
         ( T_BIT_AND_ASSIGN (tokinfo lexbuf); )
# 691 "compiler/lib/js_lexer.ml"

  | 36 ->
# 144 "compiler/lib/js_lexer.mll"
         ( T_BIT_OR_ASSIGN (tokinfo lexbuf); )
# 696 "compiler/lib/js_lexer.ml"

  | 37 ->
# 145 "compiler/lib/js_lexer.mll"
         ( T_BIT_XOR_ASSIGN (tokinfo lexbuf); )
# 701 "compiler/lib/js_lexer.ml"

  | 38 ->
# 146 "compiler/lib/js_lexer.mll"
        ( T_LESS_THAN (tokinfo lexbuf); )
# 706 "compiler/lib/js_lexer.ml"

  | 39 ->
# 147 "compiler/lib/js_lexer.mll"
        ( T_GREATER_THAN (tokinfo lexbuf); )
# 711 "compiler/lib/js_lexer.ml"

  | 40 ->
# 148 "compiler/lib/js_lexer.mll"
        ( T_PLUS (tokinfo lexbuf); )
# 716 "compiler/lib/js_lexer.ml"

  | 41 ->
# 149 "compiler/lib/js_lexer.mll"
        ( T_MINUS (tokinfo lexbuf); )
# 721 "compiler/lib/js_lexer.ml"

  | 42 ->
# 150 "compiler/lib/js_lexer.mll"
        ( T_MULT (tokinfo lexbuf); )
# 726 "compiler/lib/js_lexer.ml"

  | 43 ->
# 152 "compiler/lib/js_lexer.mll"
        ( T_MOD (tokinfo lexbuf); )
# 731 "compiler/lib/js_lexer.ml"

  | 44 ->
# 153 "compiler/lib/js_lexer.mll"
        ( T_BIT_OR (tokinfo lexbuf); )
# 736 "compiler/lib/js_lexer.ml"

  | 45 ->
# 154 "compiler/lib/js_lexer.mll"
        ( T_BIT_AND (tokinfo lexbuf); )
# 741 "compiler/lib/js_lexer.ml"

  | 46 ->
# 155 "compiler/lib/js_lexer.mll"
        ( T_BIT_XOR (tokinfo lexbuf); )
# 746 "compiler/lib/js_lexer.ml"

  | 47 ->
# 156 "compiler/lib/js_lexer.mll"
        ( T_NOT (tokinfo lexbuf); )
# 751 "compiler/lib/js_lexer.ml"

  | 48 ->
# 157 "compiler/lib/js_lexer.mll"
        ( T_BIT_NOT (tokinfo lexbuf); )
# 756 "compiler/lib/js_lexer.ml"

  | 49 ->
# 158 "compiler/lib/js_lexer.mll"
        ( T_ASSIGN (tokinfo lexbuf); )
# 761 "compiler/lib/js_lexer.ml"

  | 50 ->
# 163 "compiler/lib/js_lexer.mll"
                                                         (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      try
        let f = Hashtbl.find keyword_table s in
        f info (* need case insensitive ? *)
      with
        | Not_found -> T_IDENTIFIER (s, info)
    )
# 774 "compiler/lib/js_lexer.ml"

  | 51 ->
# 177 "compiler/lib/js_lexer.mll"
                       (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, info)
    )
# 783 "compiler/lib/js_lexer.ml"

  | 52 ->
# 182 "compiler/lib/js_lexer.mll"
                  (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, info)
    )
# 792 "compiler/lib/js_lexer.ml"

  | 53 ->
# 188 "compiler/lib/js_lexer.mll"
                                                                    (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, info)
    )
# 801 "compiler/lib/js_lexer.ml"

  | 54 ->
# 195 "compiler/lib/js_lexer.mll"
                            (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, info)
    )
# 810 "compiler/lib/js_lexer.ml"

  | 55 ->
let
# 204 "compiler/lib/js_lexer.mll"
                 quote
# 816 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 204 "compiler/lib/js_lexer.mll"
                       (
      let info = tokinfo lexbuf in
      let buf = Buffer.create 127 in
      string_quote quote buf lexbuf;
      let s = Buffer.contents buf in
      (* s does not contain the enclosing "'" but the info does *)
      T_STRING (s, info)
    )
# 827 "compiler/lib/js_lexer.ml"

  | 56 ->
# 229 "compiler/lib/js_lexer.mll"
               (
    let s = tok lexbuf in
      let info = tokinfo lexbuf in

      match prev with
      | Some (
            T_IDENTIFIER _
          | T_NUMBER _ | T_STRING _ | T_REGEX _
          | T_FALSE _ | T_TRUE _ | T_NULL _
          | T_THIS _
          | T_INCR _ | T_DECR _
          | T_RBRACKET _ | T_RPAREN _
        ) -> begin match s with
          | "/" -> T_DIV (info);
          | "/=" -> T_DIV_ASSIGN info
          | _ -> assert false
        end
      | _ ->
          (* raise (Token t); *)
          let buf = Buffer.create 127 in
          Buffer.add_string buf s;
          regexp buf lexbuf;
          T_REGEX (Buffer.contents buf, info)
    )
# 855 "compiler/lib/js_lexer.ml"

  | 57 ->
# 258 "compiler/lib/js_lexer.mll"
        ( EOF (tokinfo lexbuf) )
# 860 "compiler/lib/js_lexer.ml"

  | 58 ->
# 260 "compiler/lib/js_lexer.mll"
      (
      (* Format.eprintf "LEXER:unrecognised symbol, in token rule: %s@." (tok lexbuf); *)
      TUnknown (tokinfo lexbuf, tok lexbuf)
    )
# 868 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_initial_rec tokinfo prev lexbuf __ocaml_lex_state

and string_escape quote buf lexbuf =
   __ocaml_lex_string_escape_rec quote buf lexbuf 68
and __ocaml_lex_string_escape_rec quote buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 267 "compiler/lib/js_lexer.mll"
        ( Buffer.add_string buf "\\\\" )
# 880 "compiler/lib/js_lexer.ml"

  | 1 ->
# 269 "compiler/lib/js_lexer.mll"
                            (
      Buffer.add_char buf '\\';
      Buffer.add_string buf (Lexing.lexeme lexbuf) )
# 887 "compiler/lib/js_lexer.ml"

  | 2 ->
let
# 272 "compiler/lib/js_lexer.mll"
          c
# 893 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 273 "compiler/lib/js_lexer.mll"
    ( if c <> '\'' && c <> '\"' then Buffer.add_char buf '\\';
      Buffer.add_char buf c )
# 898 "compiler/lib/js_lexer.ml"

  | 3 ->
# 275 "compiler/lib/js_lexer.mll"
        ( Format.eprintf  "LEXER: WEIRD end of file in string_escape@."; ())
# 903 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_escape_rec quote buf lexbuf __ocaml_lex_state

and string_quote q buf lexbuf =
   __ocaml_lex_string_quote_rec q buf lexbuf 79
and __ocaml_lex_string_quote_rec q buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 278 "compiler/lib/js_lexer.mll"
                 q'
# 916 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 278 "compiler/lib/js_lexer.mll"
                    (
    if q = q'
    then ()
    else (Buffer.add_char buf q'; string_quote q buf lexbuf) )
# 923 "compiler/lib/js_lexer.ml"

  | 1 ->
# 282 "compiler/lib/js_lexer.mll"
           ( string_quote q buf lexbuf )
# 928 "compiler/lib/js_lexer.ml"

  | 2 ->
# 283 "compiler/lib/js_lexer.mll"
         (
      string_escape q buf lexbuf;
      string_quote q buf lexbuf
    )
# 936 "compiler/lib/js_lexer.ml"

  | 3 ->
let
# 287 "compiler/lib/js_lexer.mll"
          x
# 942 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 287 "compiler/lib/js_lexer.mll"
                   ( Buffer.add_char buf x; string_quote q buf lexbuf )
# 946 "compiler/lib/js_lexer.ml"

  | 4 ->
# 288 "compiler/lib/js_lexer.mll"
        ( Format.eprintf  "LEXER: WEIRD end of file in quoted string@."; ())
# 951 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_quote_rec q buf lexbuf __ocaml_lex_state

and regexp buf lexbuf =
   __ocaml_lex_regexp_rec buf lexbuf 85
and __ocaml_lex_regexp_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 292 "compiler/lib/js_lexer.mll"
               x
# 964 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 292 "compiler/lib/js_lexer.mll"
                  ( Buffer.add_char buf '\\';
                    Buffer.add_char buf x;
                    regexp buf lexbuf )
# 970 "compiler/lib/js_lexer.ml"

  | 1 ->
# 295 "compiler/lib/js_lexer.mll"
        ( Buffer.add_char buf '/'; regexp_maybe_ident buf lexbuf )
# 975 "compiler/lib/js_lexer.ml"

  | 2 ->
# 296 "compiler/lib/js_lexer.mll"
        ( Buffer.add_char buf '['; regexp_class buf lexbuf )
# 980 "compiler/lib/js_lexer.ml"

  | 3 ->
let
# 297 "compiler/lib/js_lexer.mll"
          x
# 986 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 297 "compiler/lib/js_lexer.mll"
                   ( Buffer.add_char buf x; regexp buf lexbuf )
# 990 "compiler/lib/js_lexer.ml"

  | 4 ->
# 298 "compiler/lib/js_lexer.mll"
        ( Format.eprintf "LEXER: WEIRD end of file in regexp@."; ())
# 995 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_regexp_rec buf lexbuf __ocaml_lex_state

and regexp_class buf lexbuf =
   __ocaml_lex_regexp_class_rec buf lexbuf 92
and __ocaml_lex_regexp_class_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 301 "compiler/lib/js_lexer.mll"
        ( Buffer.add_char buf ']';
             regexp buf lexbuf )
# 1008 "compiler/lib/js_lexer.ml"

  | 1 ->
let
# 303 "compiler/lib/js_lexer.mll"
               x
# 1014 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 303 "compiler/lib/js_lexer.mll"
                  ( Buffer.add_char buf '\\';
                    Buffer.add_char buf x;
                    regexp_class buf lexbuf )
# 1020 "compiler/lib/js_lexer.ml"

  | 2 ->
let
# 306 "compiler/lib/js_lexer.mll"
          x
# 1026 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 306 "compiler/lib/js_lexer.mll"
             ( Buffer.add_char buf x; regexp_class buf lexbuf )
# 1030 "compiler/lib/js_lexer.ml"

  | 3 ->
# 307 "compiler/lib/js_lexer.mll"
        ( Format.eprintf "LEXER: WEIRD end of file in regexp_class@."; ())
# 1035 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_regexp_class_rec buf lexbuf __ocaml_lex_state

and regexp_maybe_ident buf lexbuf =
   __ocaml_lex_regexp_maybe_ident_rec buf lexbuf 98
and __ocaml_lex_regexp_maybe_ident_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 310 "compiler/lib/js_lexer.mll"
                      ( Buffer.add_string buf (tok lexbuf) )
# 1047 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_regexp_maybe_ident_rec buf lexbuf __ocaml_lex_state

and st_comment buf nl lexbuf =
   __ocaml_lex_st_comment_rec buf nl lexbuf 99
and __ocaml_lex_st_comment_rec buf nl lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 315 "compiler/lib/js_lexer.mll"
         ( Buffer.add_string buf (tok lexbuf) )
# 1059 "compiler/lib/js_lexer.ml"

  | 1 ->
# 318 "compiler/lib/js_lexer.mll"
            ( Buffer.add_string buf (tok lexbuf);
              nl := true;
              st_comment buf nl lexbuf )
# 1066 "compiler/lib/js_lexer.ml"

  | 2 ->
# 321 "compiler/lib/js_lexer.mll"
                       ( Buffer.add_string buf (tok lexbuf);st_comment buf nl lexbuf )
# 1071 "compiler/lib/js_lexer.ml"

  | 3 ->
# 322 "compiler/lib/js_lexer.mll"
            ( Buffer.add_char buf '*';st_comment buf nl lexbuf )
# 1076 "compiler/lib/js_lexer.ml"

  | 4 ->
# 324 "compiler/lib/js_lexer.mll"
        ( Format.eprintf "LEXER: end of file in comment@."; Buffer.add_string buf "*/")
# 1081 "compiler/lib/js_lexer.ml"

  | 5 ->
# 325 "compiler/lib/js_lexer.mll"
       (
      let s = tok lexbuf in
      Format.eprintf "LEXER: unrecognised symbol in comment: %s@." s;
      Buffer.add_string buf s;
      st_comment buf nl lexbuf
    )
# 1091 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_st_comment_rec buf nl lexbuf __ocaml_lex_state

and pos lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 4 (-1); __ocaml_lex_pos_rec lexbuf 106
and __ocaml_lex_pos_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 333 "compiler/lib/js_lexer.mll"
                                    line
# 1104 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 333 "compiler/lib/js_lexer.mll"
                                                                     quote
# 1109 "compiler/lib/js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_curr_pos + -1) in
# 333 "compiler/lib/js_lexer.mll"
                                                                            (
      let buf = Buffer.create 127 in
      string_quote quote buf lexbuf;
      Buffer.contents buf, int_of_string line )
# 1116 "compiler/lib/js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_pos_rec lexbuf __ocaml_lex_state

;;

