// Code generated by goderive DO NOT EDIT.

package types

// deriveDeepCopyProject recursively copies the contents of src into dst.
func deriveDeepCopyProject(dst, src *Project) {
	dst.Name = src.Name
	dst.WorkingDir = src.WorkingDir
	if src.Services != nil {
		dst.Services = make(map[string]ServiceConfig, len(src.Services))
		deriveDeepCopy(dst.Services, src.Services)
	} else {
		dst.Services = nil
	}
	if src.Networks != nil {
		dst.Networks = make(map[string]NetworkConfig, len(src.Networks))
		deriveDeepCopy_(dst.Networks, src.Networks)
	} else {
		dst.Networks = nil
	}
	if src.Volumes != nil {
		dst.Volumes = make(map[string]VolumeConfig, len(src.Volumes))
		deriveDeepCopy_1(dst.Volumes, src.Volumes)
	} else {
		dst.Volumes = nil
	}
	if src.Secrets != nil {
		dst.Secrets = make(map[string]SecretConfig, len(src.Secrets))
		deriveDeepCopy_2(dst.Secrets, src.Secrets)
	} else {
		dst.Secrets = nil
	}
	if src.Configs != nil {
		dst.Configs = make(map[string]ConfigObjConfig, len(src.Configs))
		deriveDeepCopy_3(dst.Configs, src.Configs)
	} else {
		dst.Configs = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
	if src.ComposeFiles == nil {
		dst.ComposeFiles = nil
	} else {
		if dst.ComposeFiles != nil {
			if len(src.ComposeFiles) > len(dst.ComposeFiles) {
				if cap(dst.ComposeFiles) >= len(src.ComposeFiles) {
					dst.ComposeFiles = (dst.ComposeFiles)[:len(src.ComposeFiles)]
				} else {
					dst.ComposeFiles = make([]string, len(src.ComposeFiles))
				}
			} else if len(src.ComposeFiles) < len(dst.ComposeFiles) {
				dst.ComposeFiles = (dst.ComposeFiles)[:len(src.ComposeFiles)]
			}
		} else {
			dst.ComposeFiles = make([]string, len(src.ComposeFiles))
		}
		copy(dst.ComposeFiles, src.ComposeFiles)
	}
	if src.Environment != nil {
		dst.Environment = make(map[string]string, len(src.Environment))
		deriveDeepCopy_4(dst.Environment, src.Environment)
	} else {
		dst.Environment = nil
	}
	if src.DisabledServices != nil {
		dst.DisabledServices = make(map[string]ServiceConfig, len(src.DisabledServices))
		deriveDeepCopy(dst.DisabledServices, src.DisabledServices)
	} else {
		dst.DisabledServices = nil
	}
	if src.Profiles == nil {
		dst.Profiles = nil
	} else {
		if dst.Profiles != nil {
			if len(src.Profiles) > len(dst.Profiles) {
				if cap(dst.Profiles) >= len(src.Profiles) {
					dst.Profiles = (dst.Profiles)[:len(src.Profiles)]
				} else {
					dst.Profiles = make([]string, len(src.Profiles))
				}
			} else if len(src.Profiles) < len(dst.Profiles) {
				dst.Profiles = (dst.Profiles)[:len(src.Profiles)]
			}
		} else {
			dst.Profiles = make([]string, len(src.Profiles))
		}
		copy(dst.Profiles, src.Profiles)
	}
}

// deriveDeepCopyService recursively copies the contents of src into dst.
func deriveDeepCopyService(dst, src *ServiceConfig) {
	dst.Name = src.Name
	if src.Profiles == nil {
		dst.Profiles = nil
	} else {
		if dst.Profiles != nil {
			if len(src.Profiles) > len(dst.Profiles) {
				if cap(dst.Profiles) >= len(src.Profiles) {
					dst.Profiles = (dst.Profiles)[:len(src.Profiles)]
				} else {
					dst.Profiles = make([]string, len(src.Profiles))
				}
			} else if len(src.Profiles) < len(dst.Profiles) {
				dst.Profiles = (dst.Profiles)[:len(src.Profiles)]
			}
		} else {
			dst.Profiles = make([]string, len(src.Profiles))
		}
		copy(dst.Profiles, src.Profiles)
	}
	if src.Annotations != nil {
		dst.Annotations = make(map[string]string, len(src.Annotations))
		deriveDeepCopy_4(dst.Annotations, src.Annotations)
	} else {
		dst.Annotations = nil
	}
	if src.Attach == nil {
		dst.Attach = nil
	} else {
		dst.Attach = new(bool)
		*dst.Attach = *src.Attach
	}
	if src.Build == nil {
		dst.Build = nil
	} else {
		dst.Build = new(BuildConfig)
		deriveDeepCopy_5(dst.Build, src.Build)
	}
	if src.Develop == nil {
		dst.Develop = nil
	} else {
		dst.Develop = new(DevelopConfig)
		deriveDeepCopy_6(dst.Develop, src.Develop)
	}
	if src.BlkioConfig == nil {
		dst.BlkioConfig = nil
	} else {
		dst.BlkioConfig = new(BlkioConfig)
		deriveDeepCopy_7(dst.BlkioConfig, src.BlkioConfig)
	}
	if src.CapAdd == nil {
		dst.CapAdd = nil
	} else {
		if dst.CapAdd != nil {
			if len(src.CapAdd) > len(dst.CapAdd) {
				if cap(dst.CapAdd) >= len(src.CapAdd) {
					dst.CapAdd = (dst.CapAdd)[:len(src.CapAdd)]
				} else {
					dst.CapAdd = make([]string, len(src.CapAdd))
				}
			} else if len(src.CapAdd) < len(dst.CapAdd) {
				dst.CapAdd = (dst.CapAdd)[:len(src.CapAdd)]
			}
		} else {
			dst.CapAdd = make([]string, len(src.CapAdd))
		}
		copy(dst.CapAdd, src.CapAdd)
	}
	if src.CapDrop == nil {
		dst.CapDrop = nil
	} else {
		if dst.CapDrop != nil {
			if len(src.CapDrop) > len(dst.CapDrop) {
				if cap(dst.CapDrop) >= len(src.CapDrop) {
					dst.CapDrop = (dst.CapDrop)[:len(src.CapDrop)]
				} else {
					dst.CapDrop = make([]string, len(src.CapDrop))
				}
			} else if len(src.CapDrop) < len(dst.CapDrop) {
				dst.CapDrop = (dst.CapDrop)[:len(src.CapDrop)]
			}
		} else {
			dst.CapDrop = make([]string, len(src.CapDrop))
		}
		copy(dst.CapDrop, src.CapDrop)
	}
	dst.CgroupParent = src.CgroupParent
	dst.Cgroup = src.Cgroup
	dst.CPUCount = src.CPUCount
	dst.CPUPercent = src.CPUPercent
	dst.CPUPeriod = src.CPUPeriod
	dst.CPUQuota = src.CPUQuota
	dst.CPURTPeriod = src.CPURTPeriod
	dst.CPURTRuntime = src.CPURTRuntime
	dst.CPUS = src.CPUS
	dst.CPUSet = src.CPUSet
	dst.CPUShares = src.CPUShares
	if src.Command == nil {
		dst.Command = nil
	} else {
		if dst.Command != nil {
			if len(src.Command) > len(dst.Command) {
				if cap(dst.Command) >= len(src.Command) {
					dst.Command = (dst.Command)[:len(src.Command)]
				} else {
					dst.Command = make([]string, len(src.Command))
				}
			} else if len(src.Command) < len(dst.Command) {
				dst.Command = (dst.Command)[:len(src.Command)]
			}
		} else {
			dst.Command = make([]string, len(src.Command))
		}
		copy(dst.Command, src.Command)
	}
	if src.Configs == nil {
		dst.Configs = nil
	} else {
		if dst.Configs != nil {
			if len(src.Configs) > len(dst.Configs) {
				if cap(dst.Configs) >= len(src.Configs) {
					dst.Configs = (dst.Configs)[:len(src.Configs)]
				} else {
					dst.Configs = make([]ServiceConfigObjConfig, len(src.Configs))
				}
			} else if len(src.Configs) < len(dst.Configs) {
				dst.Configs = (dst.Configs)[:len(src.Configs)]
			}
		} else {
			dst.Configs = make([]ServiceConfigObjConfig, len(src.Configs))
		}
		deriveDeepCopy_8(dst.Configs, src.Configs)
	}
	dst.ContainerName = src.ContainerName
	if src.CredentialSpec == nil {
		dst.CredentialSpec = nil
	} else {
		dst.CredentialSpec = new(CredentialSpecConfig)
		deriveDeepCopy_9(dst.CredentialSpec, src.CredentialSpec)
	}
	if src.DependsOn != nil {
		dst.DependsOn = make(map[string]ServiceDependency, len(src.DependsOn))
		deriveDeepCopy_10(dst.DependsOn, src.DependsOn)
	} else {
		dst.DependsOn = nil
	}
	if src.Deploy == nil {
		dst.Deploy = nil
	} else {
		dst.Deploy = new(DeployConfig)
		deriveDeepCopy_11(dst.Deploy, src.Deploy)
	}
	if src.DeviceCgroupRules == nil {
		dst.DeviceCgroupRules = nil
	} else {
		if dst.DeviceCgroupRules != nil {
			if len(src.DeviceCgroupRules) > len(dst.DeviceCgroupRules) {
				if cap(dst.DeviceCgroupRules) >= len(src.DeviceCgroupRules) {
					dst.DeviceCgroupRules = (dst.DeviceCgroupRules)[:len(src.DeviceCgroupRules)]
				} else {
					dst.DeviceCgroupRules = make([]string, len(src.DeviceCgroupRules))
				}
			} else if len(src.DeviceCgroupRules) < len(dst.DeviceCgroupRules) {
				dst.DeviceCgroupRules = (dst.DeviceCgroupRules)[:len(src.DeviceCgroupRules)]
			}
		} else {
			dst.DeviceCgroupRules = make([]string, len(src.DeviceCgroupRules))
		}
		copy(dst.DeviceCgroupRules, src.DeviceCgroupRules)
	}
	if src.Devices == nil {
		dst.Devices = nil
	} else {
		if dst.Devices != nil {
			if len(src.Devices) > len(dst.Devices) {
				if cap(dst.Devices) >= len(src.Devices) {
					dst.Devices = (dst.Devices)[:len(src.Devices)]
				} else {
					dst.Devices = make([]DeviceMapping, len(src.Devices))
				}
			} else if len(src.Devices) < len(dst.Devices) {
				dst.Devices = (dst.Devices)[:len(src.Devices)]
			}
		} else {
			dst.Devices = make([]DeviceMapping, len(src.Devices))
		}
		deriveDeepCopy_12(dst.Devices, src.Devices)
	}
	if src.DNS == nil {
		dst.DNS = nil
	} else {
		if dst.DNS != nil {
			if len(src.DNS) > len(dst.DNS) {
				if cap(dst.DNS) >= len(src.DNS) {
					dst.DNS = (dst.DNS)[:len(src.DNS)]
				} else {
					dst.DNS = make([]string, len(src.DNS))
				}
			} else if len(src.DNS) < len(dst.DNS) {
				dst.DNS = (dst.DNS)[:len(src.DNS)]
			}
		} else {
			dst.DNS = make([]string, len(src.DNS))
		}
		copy(dst.DNS, src.DNS)
	}
	if src.DNSOpts == nil {
		dst.DNSOpts = nil
	} else {
		if dst.DNSOpts != nil {
			if len(src.DNSOpts) > len(dst.DNSOpts) {
				if cap(dst.DNSOpts) >= len(src.DNSOpts) {
					dst.DNSOpts = (dst.DNSOpts)[:len(src.DNSOpts)]
				} else {
					dst.DNSOpts = make([]string, len(src.DNSOpts))
				}
			} else if len(src.DNSOpts) < len(dst.DNSOpts) {
				dst.DNSOpts = (dst.DNSOpts)[:len(src.DNSOpts)]
			}
		} else {
			dst.DNSOpts = make([]string, len(src.DNSOpts))
		}
		copy(dst.DNSOpts, src.DNSOpts)
	}
	if src.DNSSearch == nil {
		dst.DNSSearch = nil
	} else {
		if dst.DNSSearch != nil {
			if len(src.DNSSearch) > len(dst.DNSSearch) {
				if cap(dst.DNSSearch) >= len(src.DNSSearch) {
					dst.DNSSearch = (dst.DNSSearch)[:len(src.DNSSearch)]
				} else {
					dst.DNSSearch = make([]string, len(src.DNSSearch))
				}
			} else if len(src.DNSSearch) < len(dst.DNSSearch) {
				dst.DNSSearch = (dst.DNSSearch)[:len(src.DNSSearch)]
			}
		} else {
			dst.DNSSearch = make([]string, len(src.DNSSearch))
		}
		copy(dst.DNSSearch, src.DNSSearch)
	}
	dst.Dockerfile = src.Dockerfile
	dst.DomainName = src.DomainName
	if src.Entrypoint == nil {
		dst.Entrypoint = nil
	} else {
		if dst.Entrypoint != nil {
			if len(src.Entrypoint) > len(dst.Entrypoint) {
				if cap(dst.Entrypoint) >= len(src.Entrypoint) {
					dst.Entrypoint = (dst.Entrypoint)[:len(src.Entrypoint)]
				} else {
					dst.Entrypoint = make([]string, len(src.Entrypoint))
				}
			} else if len(src.Entrypoint) < len(dst.Entrypoint) {
				dst.Entrypoint = (dst.Entrypoint)[:len(src.Entrypoint)]
			}
		} else {
			dst.Entrypoint = make([]string, len(src.Entrypoint))
		}
		copy(dst.Entrypoint, src.Entrypoint)
	}
	if src.Provider == nil {
		dst.Provider = nil
	} else {
		dst.Provider = new(ServiceProviderConfig)
		deriveDeepCopy_13(dst.Provider, src.Provider)
	}
	if src.Environment != nil {
		dst.Environment = make(map[string]*string, len(src.Environment))
		deriveDeepCopy_14(dst.Environment, src.Environment)
	} else {
		dst.Environment = nil
	}
	if src.EnvFiles == nil {
		dst.EnvFiles = nil
	} else {
		if dst.EnvFiles != nil {
			if len(src.EnvFiles) > len(dst.EnvFiles) {
				if cap(dst.EnvFiles) >= len(src.EnvFiles) {
					dst.EnvFiles = (dst.EnvFiles)[:len(src.EnvFiles)]
				} else {
					dst.EnvFiles = make([]EnvFile, len(src.EnvFiles))
				}
			} else if len(src.EnvFiles) < len(dst.EnvFiles) {
				dst.EnvFiles = (dst.EnvFiles)[:len(src.EnvFiles)]
			}
		} else {
			dst.EnvFiles = make([]EnvFile, len(src.EnvFiles))
		}
		copy(dst.EnvFiles, src.EnvFiles)
	}
	if src.Expose == nil {
		dst.Expose = nil
	} else {
		if dst.Expose != nil {
			if len(src.Expose) > len(dst.Expose) {
				if cap(dst.Expose) >= len(src.Expose) {
					dst.Expose = (dst.Expose)[:len(src.Expose)]
				} else {
					dst.Expose = make([]string, len(src.Expose))
				}
			} else if len(src.Expose) < len(dst.Expose) {
				dst.Expose = (dst.Expose)[:len(src.Expose)]
			}
		} else {
			dst.Expose = make([]string, len(src.Expose))
		}
		copy(dst.Expose, src.Expose)
	}
	if src.Extends == nil {
		dst.Extends = nil
	} else {
		dst.Extends = new(ExtendsConfig)
		*dst.Extends = *src.Extends
	}
	if src.ExternalLinks == nil {
		dst.ExternalLinks = nil
	} else {
		if dst.ExternalLinks != nil {
			if len(src.ExternalLinks) > len(dst.ExternalLinks) {
				if cap(dst.ExternalLinks) >= len(src.ExternalLinks) {
					dst.ExternalLinks = (dst.ExternalLinks)[:len(src.ExternalLinks)]
				} else {
					dst.ExternalLinks = make([]string, len(src.ExternalLinks))
				}
			} else if len(src.ExternalLinks) < len(dst.ExternalLinks) {
				dst.ExternalLinks = (dst.ExternalLinks)[:len(src.ExternalLinks)]
			}
		} else {
			dst.ExternalLinks = make([]string, len(src.ExternalLinks))
		}
		copy(dst.ExternalLinks, src.ExternalLinks)
	}
	if src.ExtraHosts != nil {
		dst.ExtraHosts = make(map[string][]string, len(src.ExtraHosts))
		deriveDeepCopy_15(dst.ExtraHosts, src.ExtraHosts)
	} else {
		dst.ExtraHosts = nil
	}
	if src.GroupAdd == nil {
		dst.GroupAdd = nil
	} else {
		if dst.GroupAdd != nil {
			if len(src.GroupAdd) > len(dst.GroupAdd) {
				if cap(dst.GroupAdd) >= len(src.GroupAdd) {
					dst.GroupAdd = (dst.GroupAdd)[:len(src.GroupAdd)]
				} else {
					dst.GroupAdd = make([]string, len(src.GroupAdd))
				}
			} else if len(src.GroupAdd) < len(dst.GroupAdd) {
				dst.GroupAdd = (dst.GroupAdd)[:len(src.GroupAdd)]
			}
		} else {
			dst.GroupAdd = make([]string, len(src.GroupAdd))
		}
		copy(dst.GroupAdd, src.GroupAdd)
	}
	if src.Gpus == nil {
		dst.Gpus = nil
	} else {
		if dst.Gpus != nil {
			if len(src.Gpus) > len(dst.Gpus) {
				if cap(dst.Gpus) >= len(src.Gpus) {
					dst.Gpus = (dst.Gpus)[:len(src.Gpus)]
				} else {
					dst.Gpus = make([]DeviceRequest, len(src.Gpus))
				}
			} else if len(src.Gpus) < len(dst.Gpus) {
				dst.Gpus = (dst.Gpus)[:len(src.Gpus)]
			}
		} else {
			dst.Gpus = make([]DeviceRequest, len(src.Gpus))
		}
		deriveDeepCopy_16(dst.Gpus, src.Gpus)
	}
	dst.Hostname = src.Hostname
	if src.HealthCheck == nil {
		dst.HealthCheck = nil
	} else {
		dst.HealthCheck = new(HealthCheckConfig)
		deriveDeepCopy_17(dst.HealthCheck, src.HealthCheck)
	}
	dst.Image = src.Image
	if src.Init == nil {
		dst.Init = nil
	} else {
		dst.Init = new(bool)
		*dst.Init = *src.Init
	}
	dst.Ipc = src.Ipc
	dst.Isolation = src.Isolation
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	if src.LabelFiles == nil {
		dst.LabelFiles = nil
	} else {
		if dst.LabelFiles != nil {
			if len(src.LabelFiles) > len(dst.LabelFiles) {
				if cap(dst.LabelFiles) >= len(src.LabelFiles) {
					dst.LabelFiles = (dst.LabelFiles)[:len(src.LabelFiles)]
				} else {
					dst.LabelFiles = make([]string, len(src.LabelFiles))
				}
			} else if len(src.LabelFiles) < len(dst.LabelFiles) {
				dst.LabelFiles = (dst.LabelFiles)[:len(src.LabelFiles)]
			}
		} else {
			dst.LabelFiles = make([]string, len(src.LabelFiles))
		}
		copy(dst.LabelFiles, src.LabelFiles)
	}
	if src.CustomLabels != nil {
		dst.CustomLabels = make(map[string]string, len(src.CustomLabels))
		deriveDeepCopy_4(dst.CustomLabels, src.CustomLabels)
	} else {
		dst.CustomLabels = nil
	}
	if src.Links == nil {
		dst.Links = nil
	} else {
		if dst.Links != nil {
			if len(src.Links) > len(dst.Links) {
				if cap(dst.Links) >= len(src.Links) {
					dst.Links = (dst.Links)[:len(src.Links)]
				} else {
					dst.Links = make([]string, len(src.Links))
				}
			} else if len(src.Links) < len(dst.Links) {
				dst.Links = (dst.Links)[:len(src.Links)]
			}
		} else {
			dst.Links = make([]string, len(src.Links))
		}
		copy(dst.Links, src.Links)
	}
	if src.Logging == nil {
		dst.Logging = nil
	} else {
		dst.Logging = new(LoggingConfig)
		deriveDeepCopy_18(dst.Logging, src.Logging)
	}
	dst.LogDriver = src.LogDriver
	if src.LogOpt != nil {
		dst.LogOpt = make(map[string]string, len(src.LogOpt))
		deriveDeepCopy_4(dst.LogOpt, src.LogOpt)
	} else {
		dst.LogOpt = nil
	}
	dst.MemLimit = src.MemLimit
	dst.MemReservation = src.MemReservation
	dst.MemSwapLimit = src.MemSwapLimit
	dst.MemSwappiness = src.MemSwappiness
	dst.MacAddress = src.MacAddress
	dst.Net = src.Net
	dst.NetworkMode = src.NetworkMode
	if src.Networks != nil {
		dst.Networks = make(map[string]*ServiceNetworkConfig, len(src.Networks))
		deriveDeepCopy_19(dst.Networks, src.Networks)
	} else {
		dst.Networks = nil
	}
	dst.OomKillDisable = src.OomKillDisable
	dst.OomScoreAdj = src.OomScoreAdj
	dst.Pid = src.Pid
	dst.PidsLimit = src.PidsLimit
	dst.Platform = src.Platform
	if src.Ports == nil {
		dst.Ports = nil
	} else {
		if dst.Ports != nil {
			if len(src.Ports) > len(dst.Ports) {
				if cap(dst.Ports) >= len(src.Ports) {
					dst.Ports = (dst.Ports)[:len(src.Ports)]
				} else {
					dst.Ports = make([]ServicePortConfig, len(src.Ports))
				}
			} else if len(src.Ports) < len(dst.Ports) {
				dst.Ports = (dst.Ports)[:len(src.Ports)]
			}
		} else {
			dst.Ports = make([]ServicePortConfig, len(src.Ports))
		}
		deriveDeepCopy_20(dst.Ports, src.Ports)
	}
	dst.Privileged = src.Privileged
	dst.PullPolicy = src.PullPolicy
	dst.ReadOnly = src.ReadOnly
	dst.Restart = src.Restart
	dst.Runtime = src.Runtime
	if src.Scale == nil {
		dst.Scale = nil
	} else {
		dst.Scale = new(int)
		*dst.Scale = *src.Scale
	}
	if src.Secrets == nil {
		dst.Secrets = nil
	} else {
		if dst.Secrets != nil {
			if len(src.Secrets) > len(dst.Secrets) {
				if cap(dst.Secrets) >= len(src.Secrets) {
					dst.Secrets = (dst.Secrets)[:len(src.Secrets)]
				} else {
					dst.Secrets = make([]ServiceSecretConfig, len(src.Secrets))
				}
			} else if len(src.Secrets) < len(dst.Secrets) {
				dst.Secrets = (dst.Secrets)[:len(src.Secrets)]
			}
		} else {
			dst.Secrets = make([]ServiceSecretConfig, len(src.Secrets))
		}
		deriveDeepCopy_21(dst.Secrets, src.Secrets)
	}
	if src.SecurityOpt == nil {
		dst.SecurityOpt = nil
	} else {
		if dst.SecurityOpt != nil {
			if len(src.SecurityOpt) > len(dst.SecurityOpt) {
				if cap(dst.SecurityOpt) >= len(src.SecurityOpt) {
					dst.SecurityOpt = (dst.SecurityOpt)[:len(src.SecurityOpt)]
				} else {
					dst.SecurityOpt = make([]string, len(src.SecurityOpt))
				}
			} else if len(src.SecurityOpt) < len(dst.SecurityOpt) {
				dst.SecurityOpt = (dst.SecurityOpt)[:len(src.SecurityOpt)]
			}
		} else {
			dst.SecurityOpt = make([]string, len(src.SecurityOpt))
		}
		copy(dst.SecurityOpt, src.SecurityOpt)
	}
	dst.ShmSize = src.ShmSize
	dst.StdinOpen = src.StdinOpen
	if src.StopGracePeriod == nil {
		dst.StopGracePeriod = nil
	} else {
		dst.StopGracePeriod = new(Duration)
		*dst.StopGracePeriod = *src.StopGracePeriod
	}
	dst.StopSignal = src.StopSignal
	if src.StorageOpt != nil {
		dst.StorageOpt = make(map[string]string, len(src.StorageOpt))
		deriveDeepCopy_4(dst.StorageOpt, src.StorageOpt)
	} else {
		dst.StorageOpt = nil
	}
	if src.Sysctls != nil {
		dst.Sysctls = make(map[string]string, len(src.Sysctls))
		deriveDeepCopy_4(dst.Sysctls, src.Sysctls)
	} else {
		dst.Sysctls = nil
	}
	if src.Tmpfs == nil {
		dst.Tmpfs = nil
	} else {
		if dst.Tmpfs != nil {
			if len(src.Tmpfs) > len(dst.Tmpfs) {
				if cap(dst.Tmpfs) >= len(src.Tmpfs) {
					dst.Tmpfs = (dst.Tmpfs)[:len(src.Tmpfs)]
				} else {
					dst.Tmpfs = make([]string, len(src.Tmpfs))
				}
			} else if len(src.Tmpfs) < len(dst.Tmpfs) {
				dst.Tmpfs = (dst.Tmpfs)[:len(src.Tmpfs)]
			}
		} else {
			dst.Tmpfs = make([]string, len(src.Tmpfs))
		}
		copy(dst.Tmpfs, src.Tmpfs)
	}
	dst.Tty = src.Tty
	if src.Ulimits != nil {
		dst.Ulimits = make(map[string]*UlimitsConfig, len(src.Ulimits))
		deriveDeepCopy_22(dst.Ulimits, src.Ulimits)
	} else {
		dst.Ulimits = nil
	}
	dst.User = src.User
	dst.UserNSMode = src.UserNSMode
	dst.Uts = src.Uts
	dst.VolumeDriver = src.VolumeDriver
	if src.Volumes == nil {
		dst.Volumes = nil
	} else {
		if dst.Volumes != nil {
			if len(src.Volumes) > len(dst.Volumes) {
				if cap(dst.Volumes) >= len(src.Volumes) {
					dst.Volumes = (dst.Volumes)[:len(src.Volumes)]
				} else {
					dst.Volumes = make([]ServiceVolumeConfig, len(src.Volumes))
				}
			} else if len(src.Volumes) < len(dst.Volumes) {
				dst.Volumes = (dst.Volumes)[:len(src.Volumes)]
			}
		} else {
			dst.Volumes = make([]ServiceVolumeConfig, len(src.Volumes))
		}
		deriveDeepCopy_23(dst.Volumes, src.Volumes)
	}
	if src.VolumesFrom == nil {
		dst.VolumesFrom = nil
	} else {
		if dst.VolumesFrom != nil {
			if len(src.VolumesFrom) > len(dst.VolumesFrom) {
				if cap(dst.VolumesFrom) >= len(src.VolumesFrom) {
					dst.VolumesFrom = (dst.VolumesFrom)[:len(src.VolumesFrom)]
				} else {
					dst.VolumesFrom = make([]string, len(src.VolumesFrom))
				}
			} else if len(src.VolumesFrom) < len(dst.VolumesFrom) {
				dst.VolumesFrom = (dst.VolumesFrom)[:len(src.VolumesFrom)]
			}
		} else {
			dst.VolumesFrom = make([]string, len(src.VolumesFrom))
		}
		copy(dst.VolumesFrom, src.VolumesFrom)
	}
	dst.WorkingDir = src.WorkingDir
	if src.PostStart == nil {
		dst.PostStart = nil
	} else {
		if dst.PostStart != nil {
			if len(src.PostStart) > len(dst.PostStart) {
				if cap(dst.PostStart) >= len(src.PostStart) {
					dst.PostStart = (dst.PostStart)[:len(src.PostStart)]
				} else {
					dst.PostStart = make([]ServiceHook, len(src.PostStart))
				}
			} else if len(src.PostStart) < len(dst.PostStart) {
				dst.PostStart = (dst.PostStart)[:len(src.PostStart)]
			}
		} else {
			dst.PostStart = make([]ServiceHook, len(src.PostStart))
		}
		deriveDeepCopy_24(dst.PostStart, src.PostStart)
	}
	if src.PreStop == nil {
		dst.PreStop = nil
	} else {
		if dst.PreStop != nil {
			if len(src.PreStop) > len(dst.PreStop) {
				if cap(dst.PreStop) >= len(src.PreStop) {
					dst.PreStop = (dst.PreStop)[:len(src.PreStop)]
				} else {
					dst.PreStop = make([]ServiceHook, len(src.PreStop))
				}
			} else if len(src.PreStop) < len(dst.PreStop) {
				dst.PreStop = (dst.PreStop)[:len(src.PreStop)]
			}
		} else {
			dst.PreStop = make([]ServiceHook, len(src.PreStop))
		}
		deriveDeepCopy_24(dst.PreStop, src.PreStop)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy recursively copies the contents of src into dst.
func deriveDeepCopy(dst, src map[string]ServiceConfig) {
	for src_key, src_value := range src {
		func() {
			field := new(ServiceConfig)
			deriveDeepCopyService(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_ recursively copies the contents of src into dst.
func deriveDeepCopy_(dst, src map[string]NetworkConfig) {
	for src_key, src_value := range src {
		func() {
			field := new(NetworkConfig)
			deriveDeepCopy_25(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_1 recursively copies the contents of src into dst.
func deriveDeepCopy_1(dst, src map[string]VolumeConfig) {
	for src_key, src_value := range src {
		func() {
			field := new(VolumeConfig)
			deriveDeepCopy_26(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_2 recursively copies the contents of src into dst.
func deriveDeepCopy_2(dst, src map[string]SecretConfig) {
	for src_key, src_value := range src {
		func() {
			field := new(SecretConfig)
			deriveDeepCopy_27(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_3 recursively copies the contents of src into dst.
func deriveDeepCopy_3(dst, src map[string]ConfigObjConfig) {
	for src_key, src_value := range src {
		func() {
			field := new(ConfigObjConfig)
			deriveDeepCopy_28(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_4 recursively copies the contents of src into dst.
func deriveDeepCopy_4(dst, src map[string]string) {
	for src_key, src_value := range src {
		dst[src_key] = src_value
	}
}

// deriveDeepCopy_5 recursively copies the contents of src into dst.
func deriveDeepCopy_5(dst, src *BuildConfig) {
	dst.Context = src.Context
	dst.Dockerfile = src.Dockerfile
	dst.DockerfileInline = src.DockerfileInline
	if src.Entitlements == nil {
		dst.Entitlements = nil
	} else {
		if dst.Entitlements != nil {
			if len(src.Entitlements) > len(dst.Entitlements) {
				if cap(dst.Entitlements) >= len(src.Entitlements) {
					dst.Entitlements = (dst.Entitlements)[:len(src.Entitlements)]
				} else {
					dst.Entitlements = make([]string, len(src.Entitlements))
				}
			} else if len(src.Entitlements) < len(dst.Entitlements) {
				dst.Entitlements = (dst.Entitlements)[:len(src.Entitlements)]
			}
		} else {
			dst.Entitlements = make([]string, len(src.Entitlements))
		}
		copy(dst.Entitlements, src.Entitlements)
	}
	if src.Args != nil {
		dst.Args = make(map[string]*string, len(src.Args))
		deriveDeepCopy_14(dst.Args, src.Args)
	} else {
		dst.Args = nil
	}
	if src.SSH == nil {
		dst.SSH = nil
	} else {
		if dst.SSH != nil {
			if len(src.SSH) > len(dst.SSH) {
				if cap(dst.SSH) >= len(src.SSH) {
					dst.SSH = (dst.SSH)[:len(src.SSH)]
				} else {
					dst.SSH = make([]SSHKey, len(src.SSH))
				}
			} else if len(src.SSH) < len(dst.SSH) {
				dst.SSH = (dst.SSH)[:len(src.SSH)]
			}
		} else {
			dst.SSH = make([]SSHKey, len(src.SSH))
		}
		copy(dst.SSH, src.SSH)
	}
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	if src.CacheFrom == nil {
		dst.CacheFrom = nil
	} else {
		if dst.CacheFrom != nil {
			if len(src.CacheFrom) > len(dst.CacheFrom) {
				if cap(dst.CacheFrom) >= len(src.CacheFrom) {
					dst.CacheFrom = (dst.CacheFrom)[:len(src.CacheFrom)]
				} else {
					dst.CacheFrom = make([]string, len(src.CacheFrom))
				}
			} else if len(src.CacheFrom) < len(dst.CacheFrom) {
				dst.CacheFrom = (dst.CacheFrom)[:len(src.CacheFrom)]
			}
		} else {
			dst.CacheFrom = make([]string, len(src.CacheFrom))
		}
		copy(dst.CacheFrom, src.CacheFrom)
	}
	if src.CacheTo == nil {
		dst.CacheTo = nil
	} else {
		if dst.CacheTo != nil {
			if len(src.CacheTo) > len(dst.CacheTo) {
				if cap(dst.CacheTo) >= len(src.CacheTo) {
					dst.CacheTo = (dst.CacheTo)[:len(src.CacheTo)]
				} else {
					dst.CacheTo = make([]string, len(src.CacheTo))
				}
			} else if len(src.CacheTo) < len(dst.CacheTo) {
				dst.CacheTo = (dst.CacheTo)[:len(src.CacheTo)]
			}
		} else {
			dst.CacheTo = make([]string, len(src.CacheTo))
		}
		copy(dst.CacheTo, src.CacheTo)
	}
	dst.NoCache = src.NoCache
	if src.AdditionalContexts != nil {
		dst.AdditionalContexts = make(map[string]string, len(src.AdditionalContexts))
		deriveDeepCopy_4(dst.AdditionalContexts, src.AdditionalContexts)
	} else {
		dst.AdditionalContexts = nil
	}
	dst.Pull = src.Pull
	if src.ExtraHosts != nil {
		dst.ExtraHosts = make(map[string][]string, len(src.ExtraHosts))
		deriveDeepCopy_15(dst.ExtraHosts, src.ExtraHosts)
	} else {
		dst.ExtraHosts = nil
	}
	dst.Isolation = src.Isolation
	dst.Network = src.Network
	dst.Target = src.Target
	if src.Secrets == nil {
		dst.Secrets = nil
	} else {
		if dst.Secrets != nil {
			if len(src.Secrets) > len(dst.Secrets) {
				if cap(dst.Secrets) >= len(src.Secrets) {
					dst.Secrets = (dst.Secrets)[:len(src.Secrets)]
				} else {
					dst.Secrets = make([]ServiceSecretConfig, len(src.Secrets))
				}
			} else if len(src.Secrets) < len(dst.Secrets) {
				dst.Secrets = (dst.Secrets)[:len(src.Secrets)]
			}
		} else {
			dst.Secrets = make([]ServiceSecretConfig, len(src.Secrets))
		}
		deriveDeepCopy_21(dst.Secrets, src.Secrets)
	}
	dst.ShmSize = src.ShmSize
	if src.Tags == nil {
		dst.Tags = nil
	} else {
		if dst.Tags != nil {
			if len(src.Tags) > len(dst.Tags) {
				if cap(dst.Tags) >= len(src.Tags) {
					dst.Tags = (dst.Tags)[:len(src.Tags)]
				} else {
					dst.Tags = make([]string, len(src.Tags))
				}
			} else if len(src.Tags) < len(dst.Tags) {
				dst.Tags = (dst.Tags)[:len(src.Tags)]
			}
		} else {
			dst.Tags = make([]string, len(src.Tags))
		}
		copy(dst.Tags, src.Tags)
	}
	if src.Ulimits != nil {
		dst.Ulimits = make(map[string]*UlimitsConfig, len(src.Ulimits))
		deriveDeepCopy_22(dst.Ulimits, src.Ulimits)
	} else {
		dst.Ulimits = nil
	}
	if src.Platforms == nil {
		dst.Platforms = nil
	} else {
		if dst.Platforms != nil {
			if len(src.Platforms) > len(dst.Platforms) {
				if cap(dst.Platforms) >= len(src.Platforms) {
					dst.Platforms = (dst.Platforms)[:len(src.Platforms)]
				} else {
					dst.Platforms = make([]string, len(src.Platforms))
				}
			} else if len(src.Platforms) < len(dst.Platforms) {
				dst.Platforms = (dst.Platforms)[:len(src.Platforms)]
			}
		} else {
			dst.Platforms = make([]string, len(src.Platforms))
		}
		copy(dst.Platforms, src.Platforms)
	}
	dst.Privileged = src.Privileged
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_6 recursively copies the contents of src into dst.
func deriveDeepCopy_6(dst, src *DevelopConfig) {
	if src.Watch == nil {
		dst.Watch = nil
	} else {
		if dst.Watch != nil {
			if len(src.Watch) > len(dst.Watch) {
				if cap(dst.Watch) >= len(src.Watch) {
					dst.Watch = (dst.Watch)[:len(src.Watch)]
				} else {
					dst.Watch = make([]Trigger, len(src.Watch))
				}
			} else if len(src.Watch) < len(dst.Watch) {
				dst.Watch = (dst.Watch)[:len(src.Watch)]
			}
		} else {
			dst.Watch = make([]Trigger, len(src.Watch))
		}
		deriveDeepCopy_29(dst.Watch, src.Watch)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_7 recursively copies the contents of src into dst.
func deriveDeepCopy_7(dst, src *BlkioConfig) {
	dst.Weight = src.Weight
	if src.WeightDevice == nil {
		dst.WeightDevice = nil
	} else {
		if dst.WeightDevice != nil {
			if len(src.WeightDevice) > len(dst.WeightDevice) {
				if cap(dst.WeightDevice) >= len(src.WeightDevice) {
					dst.WeightDevice = (dst.WeightDevice)[:len(src.WeightDevice)]
				} else {
					dst.WeightDevice = make([]WeightDevice, len(src.WeightDevice))
				}
			} else if len(src.WeightDevice) < len(dst.WeightDevice) {
				dst.WeightDevice = (dst.WeightDevice)[:len(src.WeightDevice)]
			}
		} else {
			dst.WeightDevice = make([]WeightDevice, len(src.WeightDevice))
		}
		deriveDeepCopy_30(dst.WeightDevice, src.WeightDevice)
	}
	if src.DeviceReadBps == nil {
		dst.DeviceReadBps = nil
	} else {
		if dst.DeviceReadBps != nil {
			if len(src.DeviceReadBps) > len(dst.DeviceReadBps) {
				if cap(dst.DeviceReadBps) >= len(src.DeviceReadBps) {
					dst.DeviceReadBps = (dst.DeviceReadBps)[:len(src.DeviceReadBps)]
				} else {
					dst.DeviceReadBps = make([]ThrottleDevice, len(src.DeviceReadBps))
				}
			} else if len(src.DeviceReadBps) < len(dst.DeviceReadBps) {
				dst.DeviceReadBps = (dst.DeviceReadBps)[:len(src.DeviceReadBps)]
			}
		} else {
			dst.DeviceReadBps = make([]ThrottleDevice, len(src.DeviceReadBps))
		}
		deriveDeepCopy_31(dst.DeviceReadBps, src.DeviceReadBps)
	}
	if src.DeviceReadIOps == nil {
		dst.DeviceReadIOps = nil
	} else {
		if dst.DeviceReadIOps != nil {
			if len(src.DeviceReadIOps) > len(dst.DeviceReadIOps) {
				if cap(dst.DeviceReadIOps) >= len(src.DeviceReadIOps) {
					dst.DeviceReadIOps = (dst.DeviceReadIOps)[:len(src.DeviceReadIOps)]
				} else {
					dst.DeviceReadIOps = make([]ThrottleDevice, len(src.DeviceReadIOps))
				}
			} else if len(src.DeviceReadIOps) < len(dst.DeviceReadIOps) {
				dst.DeviceReadIOps = (dst.DeviceReadIOps)[:len(src.DeviceReadIOps)]
			}
		} else {
			dst.DeviceReadIOps = make([]ThrottleDevice, len(src.DeviceReadIOps))
		}
		deriveDeepCopy_31(dst.DeviceReadIOps, src.DeviceReadIOps)
	}
	if src.DeviceWriteBps == nil {
		dst.DeviceWriteBps = nil
	} else {
		if dst.DeviceWriteBps != nil {
			if len(src.DeviceWriteBps) > len(dst.DeviceWriteBps) {
				if cap(dst.DeviceWriteBps) >= len(src.DeviceWriteBps) {
					dst.DeviceWriteBps = (dst.DeviceWriteBps)[:len(src.DeviceWriteBps)]
				} else {
					dst.DeviceWriteBps = make([]ThrottleDevice, len(src.DeviceWriteBps))
				}
			} else if len(src.DeviceWriteBps) < len(dst.DeviceWriteBps) {
				dst.DeviceWriteBps = (dst.DeviceWriteBps)[:len(src.DeviceWriteBps)]
			}
		} else {
			dst.DeviceWriteBps = make([]ThrottleDevice, len(src.DeviceWriteBps))
		}
		deriveDeepCopy_31(dst.DeviceWriteBps, src.DeviceWriteBps)
	}
	if src.DeviceWriteIOps == nil {
		dst.DeviceWriteIOps = nil
	} else {
		if dst.DeviceWriteIOps != nil {
			if len(src.DeviceWriteIOps) > len(dst.DeviceWriteIOps) {
				if cap(dst.DeviceWriteIOps) >= len(src.DeviceWriteIOps) {
					dst.DeviceWriteIOps = (dst.DeviceWriteIOps)[:len(src.DeviceWriteIOps)]
				} else {
					dst.DeviceWriteIOps = make([]ThrottleDevice, len(src.DeviceWriteIOps))
				}
			} else if len(src.DeviceWriteIOps) < len(dst.DeviceWriteIOps) {
				dst.DeviceWriteIOps = (dst.DeviceWriteIOps)[:len(src.DeviceWriteIOps)]
			}
		} else {
			dst.DeviceWriteIOps = make([]ThrottleDevice, len(src.DeviceWriteIOps))
		}
		deriveDeepCopy_31(dst.DeviceWriteIOps, src.DeviceWriteIOps)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_8 recursively copies the contents of src into dst.
func deriveDeepCopy_8(dst, src []ServiceConfigObjConfig) {
	for src_i, src_value := range src {
		func() {
			field := new(ServiceConfigObjConfig)
			deriveDeepCopy_32(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_9 recursively copies the contents of src into dst.
func deriveDeepCopy_9(dst, src *CredentialSpecConfig) {
	dst.Config = src.Config
	dst.File = src.File
	dst.Registry = src.Registry
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_10 recursively copies the contents of src into dst.
func deriveDeepCopy_10(dst, src map[string]ServiceDependency) {
	for src_key, src_value := range src {
		func() {
			field := new(ServiceDependency)
			deriveDeepCopy_33(field, &src_value)
			dst[src_key] = *field
		}()
	}
}

// deriveDeepCopy_11 recursively copies the contents of src into dst.
func deriveDeepCopy_11(dst, src *DeployConfig) {
	dst.Mode = src.Mode
	if src.Replicas == nil {
		dst.Replicas = nil
	} else {
		dst.Replicas = new(int)
		*dst.Replicas = *src.Replicas
	}
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	if src.UpdateConfig == nil {
		dst.UpdateConfig = nil
	} else {
		dst.UpdateConfig = new(UpdateConfig)
		deriveDeepCopy_34(dst.UpdateConfig, src.UpdateConfig)
	}
	if src.RollbackConfig == nil {
		dst.RollbackConfig = nil
	} else {
		dst.RollbackConfig = new(UpdateConfig)
		deriveDeepCopy_34(dst.RollbackConfig, src.RollbackConfig)
	}
	func() {
		field := new(Resources)
		deriveDeepCopy_35(field, &src.Resources)
		dst.Resources = *field
	}()
	if src.RestartPolicy == nil {
		dst.RestartPolicy = nil
	} else {
		dst.RestartPolicy = new(RestartPolicy)
		deriveDeepCopy_36(dst.RestartPolicy, src.RestartPolicy)
	}
	func() {
		field := new(Placement)
		deriveDeepCopy_37(field, &src.Placement)
		dst.Placement = *field
	}()
	dst.EndpointMode = src.EndpointMode
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_12 recursively copies the contents of src into dst.
func deriveDeepCopy_12(dst, src []DeviceMapping) {
	for src_i, src_value := range src {
		func() {
			field := new(DeviceMapping)
			deriveDeepCopy_38(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_13 recursively copies the contents of src into dst.
func deriveDeepCopy_13(dst, src *ServiceProviderConfig) {
	dst.Type = src.Type
	if src.Options != nil {
		dst.Options = make(map[string][]string, len(src.Options))
		deriveDeepCopy_15(dst.Options, src.Options)
	} else {
		dst.Options = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_14 recursively copies the contents of src into dst.
func deriveDeepCopy_14(dst, src map[string]*string) {
	for src_key, src_value := range src {
		if src_value == nil {
			dst[src_key] = nil
		}
		if src_value == nil {
			dst[src_key] = nil
		} else {
			dst[src_key] = new(string)
			*dst[src_key] = *src_value
		}
	}
}

// deriveDeepCopy_15 recursively copies the contents of src into dst.
func deriveDeepCopy_15(dst, src map[string][]string) {
	for src_key, src_value := range src {
		if src_value == nil {
			dst[src_key] = nil
		}
		if src_value == nil {
			dst[src_key] = nil
		} else {
			if dst[src_key] != nil {
				if len(src_value) > len(dst[src_key]) {
					if cap(dst[src_key]) >= len(src_value) {
						dst[src_key] = (dst[src_key])[:len(src_value)]
					} else {
						dst[src_key] = make([]string, len(src_value))
					}
				} else if len(src_value) < len(dst[src_key]) {
					dst[src_key] = (dst[src_key])[:len(src_value)]
				}
			} else {
				dst[src_key] = make([]string, len(src_value))
			}
			copy(dst[src_key], src_value)
		}
	}
}

// deriveDeepCopy_16 recursively copies the contents of src into dst.
func deriveDeepCopy_16(dst, src []DeviceRequest) {
	for src_i, src_value := range src {
		func() {
			field := new(DeviceRequest)
			deriveDeepCopy_39(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_17 recursively copies the contents of src into dst.
func deriveDeepCopy_17(dst, src *HealthCheckConfig) {
	if src.Test == nil {
		dst.Test = nil
	} else {
		if dst.Test != nil {
			if len(src.Test) > len(dst.Test) {
				if cap(dst.Test) >= len(src.Test) {
					dst.Test = (dst.Test)[:len(src.Test)]
				} else {
					dst.Test = make([]string, len(src.Test))
				}
			} else if len(src.Test) < len(dst.Test) {
				dst.Test = (dst.Test)[:len(src.Test)]
			}
		} else {
			dst.Test = make([]string, len(src.Test))
		}
		copy(dst.Test, src.Test)
	}
	if src.Timeout == nil {
		dst.Timeout = nil
	} else {
		dst.Timeout = new(Duration)
		*dst.Timeout = *src.Timeout
	}
	if src.Interval == nil {
		dst.Interval = nil
	} else {
		dst.Interval = new(Duration)
		*dst.Interval = *src.Interval
	}
	if src.Retries == nil {
		dst.Retries = nil
	} else {
		dst.Retries = new(uint64)
		*dst.Retries = *src.Retries
	}
	if src.StartPeriod == nil {
		dst.StartPeriod = nil
	} else {
		dst.StartPeriod = new(Duration)
		*dst.StartPeriod = *src.StartPeriod
	}
	if src.StartInterval == nil {
		dst.StartInterval = nil
	} else {
		dst.StartInterval = new(Duration)
		*dst.StartInterval = *src.StartInterval
	}
	dst.Disable = src.Disable
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_18 recursively copies the contents of src into dst.
func deriveDeepCopy_18(dst, src *LoggingConfig) {
	dst.Driver = src.Driver
	if src.Options != nil {
		dst.Options = make(map[string]string, len(src.Options))
		deriveDeepCopy_4(dst.Options, src.Options)
	} else {
		dst.Options = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_19 recursively copies the contents of src into dst.
func deriveDeepCopy_19(dst, src map[string]*ServiceNetworkConfig) {
	for src_key, src_value := range src {
		if src_value == nil {
			dst[src_key] = nil
		}
		if src_value == nil {
			dst[src_key] = nil
		} else {
			dst[src_key] = new(ServiceNetworkConfig)
			deriveDeepCopy_40(dst[src_key], src_value)
		}
	}
}

// deriveDeepCopy_20 recursively copies the contents of src into dst.
func deriveDeepCopy_20(dst, src []ServicePortConfig) {
	for src_i, src_value := range src {
		func() {
			field := new(ServicePortConfig)
			deriveDeepCopy_41(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_21 recursively copies the contents of src into dst.
func deriveDeepCopy_21(dst, src []ServiceSecretConfig) {
	for src_i, src_value := range src {
		func() {
			field := new(ServiceSecretConfig)
			deriveDeepCopy_42(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_22 recursively copies the contents of src into dst.
func deriveDeepCopy_22(dst, src map[string]*UlimitsConfig) {
	for src_key, src_value := range src {
		if src_value == nil {
			dst[src_key] = nil
		}
		if src_value == nil {
			dst[src_key] = nil
		} else {
			dst[src_key] = new(UlimitsConfig)
			deriveDeepCopy_43(dst[src_key], src_value)
		}
	}
}

// deriveDeepCopy_23 recursively copies the contents of src into dst.
func deriveDeepCopy_23(dst, src []ServiceVolumeConfig) {
	for src_i, src_value := range src {
		func() {
			field := new(ServiceVolumeConfig)
			deriveDeepCopy_44(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_24 recursively copies the contents of src into dst.
func deriveDeepCopy_24(dst, src []ServiceHook) {
	for src_i, src_value := range src {
		func() {
			field := new(ServiceHook)
			deriveDeepCopy_45(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_25 recursively copies the contents of src into dst.
func deriveDeepCopy_25(dst, src *NetworkConfig) {
	dst.Name = src.Name
	dst.Driver = src.Driver
	if src.DriverOpts != nil {
		dst.DriverOpts = make(map[string]string, len(src.DriverOpts))
		deriveDeepCopy_4(dst.DriverOpts, src.DriverOpts)
	} else {
		dst.DriverOpts = nil
	}
	func() {
		field := new(IPAMConfig)
		deriveDeepCopy_46(field, &src.Ipam)
		dst.Ipam = *field
	}()
	dst.External = src.External
	dst.Internal = src.Internal
	dst.Attachable = src.Attachable
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	if src.CustomLabels != nil {
		dst.CustomLabels = make(map[string]string, len(src.CustomLabels))
		deriveDeepCopy_4(dst.CustomLabels, src.CustomLabels)
	} else {
		dst.CustomLabels = nil
	}
	if src.EnableIPv4 == nil {
		dst.EnableIPv4 = nil
	} else {
		dst.EnableIPv4 = new(bool)
		*dst.EnableIPv4 = *src.EnableIPv4
	}
	if src.EnableIPv6 == nil {
		dst.EnableIPv6 = nil
	} else {
		dst.EnableIPv6 = new(bool)
		*dst.EnableIPv6 = *src.EnableIPv6
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_26 recursively copies the contents of src into dst.
func deriveDeepCopy_26(dst, src *VolumeConfig) {
	dst.Name = src.Name
	dst.Driver = src.Driver
	if src.DriverOpts != nil {
		dst.DriverOpts = make(map[string]string, len(src.DriverOpts))
		deriveDeepCopy_4(dst.DriverOpts, src.DriverOpts)
	} else {
		dst.DriverOpts = nil
	}
	dst.External = src.External
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	if src.CustomLabels != nil {
		dst.CustomLabels = make(map[string]string, len(src.CustomLabels))
		deriveDeepCopy_4(dst.CustomLabels, src.CustomLabels)
	} else {
		dst.CustomLabels = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_27 recursively copies the contents of src into dst.
func deriveDeepCopy_27(dst, src *SecretConfig) {
	dst.Name = src.Name
	dst.File = src.File
	dst.Environment = src.Environment
	dst.Content = src.Content
	dst.marshallContent = src.marshallContent
	dst.External = src.External
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	dst.Driver = src.Driver
	if src.DriverOpts != nil {
		dst.DriverOpts = make(map[string]string, len(src.DriverOpts))
		deriveDeepCopy_4(dst.DriverOpts, src.DriverOpts)
	} else {
		dst.DriverOpts = nil
	}
	dst.TemplateDriver = src.TemplateDriver
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_28 recursively copies the contents of src into dst.
func deriveDeepCopy_28(dst, src *ConfigObjConfig) {
	dst.Name = src.Name
	dst.File = src.File
	dst.Environment = src.Environment
	dst.Content = src.Content
	dst.marshallContent = src.marshallContent
	dst.External = src.External
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	dst.Driver = src.Driver
	if src.DriverOpts != nil {
		dst.DriverOpts = make(map[string]string, len(src.DriverOpts))
		deriveDeepCopy_4(dst.DriverOpts, src.DriverOpts)
	} else {
		dst.DriverOpts = nil
	}
	dst.TemplateDriver = src.TemplateDriver
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_29 recursively copies the contents of src into dst.
func deriveDeepCopy_29(dst, src []Trigger) {
	for src_i, src_value := range src {
		func() {
			field := new(Trigger)
			deriveDeepCopy_47(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_30 recursively copies the contents of src into dst.
func deriveDeepCopy_30(dst, src []WeightDevice) {
	for src_i, src_value := range src {
		func() {
			field := new(WeightDevice)
			deriveDeepCopy_48(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_31 recursively copies the contents of src into dst.
func deriveDeepCopy_31(dst, src []ThrottleDevice) {
	for src_i, src_value := range src {
		func() {
			field := new(ThrottleDevice)
			deriveDeepCopy_49(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_32 recursively copies the contents of src into dst.
func deriveDeepCopy_32(dst, src *ServiceConfigObjConfig) {
	dst.Source = src.Source
	dst.Target = src.Target
	dst.UID = src.UID
	dst.GID = src.GID
	if src.Mode == nil {
		dst.Mode = nil
	} else {
		dst.Mode = new(FileMode)
		*dst.Mode = *src.Mode
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_33 recursively copies the contents of src into dst.
func deriveDeepCopy_33(dst, src *ServiceDependency) {
	dst.Condition = src.Condition
	dst.Restart = src.Restart
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
	dst.Required = src.Required
}

// deriveDeepCopy_34 recursively copies the contents of src into dst.
func deriveDeepCopy_34(dst, src *UpdateConfig) {
	if src.Parallelism == nil {
		dst.Parallelism = nil
	} else {
		dst.Parallelism = new(uint64)
		*dst.Parallelism = *src.Parallelism
	}
	dst.Delay = src.Delay
	dst.FailureAction = src.FailureAction
	dst.Monitor = src.Monitor
	dst.MaxFailureRatio = src.MaxFailureRatio
	dst.Order = src.Order
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_35 recursively copies the contents of src into dst.
func deriveDeepCopy_35(dst, src *Resources) {
	if src.Limits == nil {
		dst.Limits = nil
	} else {
		dst.Limits = new(Resource)
		deriveDeepCopy_50(dst.Limits, src.Limits)
	}
	if src.Reservations == nil {
		dst.Reservations = nil
	} else {
		dst.Reservations = new(Resource)
		deriveDeepCopy_50(dst.Reservations, src.Reservations)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_36 recursively copies the contents of src into dst.
func deriveDeepCopy_36(dst, src *RestartPolicy) {
	dst.Condition = src.Condition
	if src.Delay == nil {
		dst.Delay = nil
	} else {
		dst.Delay = new(Duration)
		*dst.Delay = *src.Delay
	}
	if src.MaxAttempts == nil {
		dst.MaxAttempts = nil
	} else {
		dst.MaxAttempts = new(uint64)
		*dst.MaxAttempts = *src.MaxAttempts
	}
	if src.Window == nil {
		dst.Window = nil
	} else {
		dst.Window = new(Duration)
		*dst.Window = *src.Window
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_37 recursively copies the contents of src into dst.
func deriveDeepCopy_37(dst, src *Placement) {
	if src.Constraints == nil {
		dst.Constraints = nil
	} else {
		if dst.Constraints != nil {
			if len(src.Constraints) > len(dst.Constraints) {
				if cap(dst.Constraints) >= len(src.Constraints) {
					dst.Constraints = (dst.Constraints)[:len(src.Constraints)]
				} else {
					dst.Constraints = make([]string, len(src.Constraints))
				}
			} else if len(src.Constraints) < len(dst.Constraints) {
				dst.Constraints = (dst.Constraints)[:len(src.Constraints)]
			}
		} else {
			dst.Constraints = make([]string, len(src.Constraints))
		}
		copy(dst.Constraints, src.Constraints)
	}
	if src.Preferences == nil {
		dst.Preferences = nil
	} else {
		if dst.Preferences != nil {
			if len(src.Preferences) > len(dst.Preferences) {
				if cap(dst.Preferences) >= len(src.Preferences) {
					dst.Preferences = (dst.Preferences)[:len(src.Preferences)]
				} else {
					dst.Preferences = make([]PlacementPreferences, len(src.Preferences))
				}
			} else if len(src.Preferences) < len(dst.Preferences) {
				dst.Preferences = (dst.Preferences)[:len(src.Preferences)]
			}
		} else {
			dst.Preferences = make([]PlacementPreferences, len(src.Preferences))
		}
		deriveDeepCopy_51(dst.Preferences, src.Preferences)
	}
	dst.MaxReplicas = src.MaxReplicas
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_38 recursively copies the contents of src into dst.
func deriveDeepCopy_38(dst, src *DeviceMapping) {
	dst.Source = src.Source
	dst.Target = src.Target
	dst.Permissions = src.Permissions
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_39 recursively copies the contents of src into dst.
func deriveDeepCopy_39(dst, src *DeviceRequest) {
	if src.Capabilities == nil {
		dst.Capabilities = nil
	} else {
		if dst.Capabilities != nil {
			if len(src.Capabilities) > len(dst.Capabilities) {
				if cap(dst.Capabilities) >= len(src.Capabilities) {
					dst.Capabilities = (dst.Capabilities)[:len(src.Capabilities)]
				} else {
					dst.Capabilities = make([]string, len(src.Capabilities))
				}
			} else if len(src.Capabilities) < len(dst.Capabilities) {
				dst.Capabilities = (dst.Capabilities)[:len(src.Capabilities)]
			}
		} else {
			dst.Capabilities = make([]string, len(src.Capabilities))
		}
		copy(dst.Capabilities, src.Capabilities)
	}
	dst.Driver = src.Driver
	dst.Count = src.Count
	if src.IDs == nil {
		dst.IDs = nil
	} else {
		if dst.IDs != nil {
			if len(src.IDs) > len(dst.IDs) {
				if cap(dst.IDs) >= len(src.IDs) {
					dst.IDs = (dst.IDs)[:len(src.IDs)]
				} else {
					dst.IDs = make([]string, len(src.IDs))
				}
			} else if len(src.IDs) < len(dst.IDs) {
				dst.IDs = (dst.IDs)[:len(src.IDs)]
			}
		} else {
			dst.IDs = make([]string, len(src.IDs))
		}
		copy(dst.IDs, src.IDs)
	}
	if src.Options != nil {
		dst.Options = make(map[string]string, len(src.Options))
		deriveDeepCopy_4(dst.Options, src.Options)
	} else {
		dst.Options = nil
	}
}

// deriveDeepCopy_40 recursively copies the contents of src into dst.
func deriveDeepCopy_40(dst, src *ServiceNetworkConfig) {
	if src.Aliases == nil {
		dst.Aliases = nil
	} else {
		if dst.Aliases != nil {
			if len(src.Aliases) > len(dst.Aliases) {
				if cap(dst.Aliases) >= len(src.Aliases) {
					dst.Aliases = (dst.Aliases)[:len(src.Aliases)]
				} else {
					dst.Aliases = make([]string, len(src.Aliases))
				}
			} else if len(src.Aliases) < len(dst.Aliases) {
				dst.Aliases = (dst.Aliases)[:len(src.Aliases)]
			}
		} else {
			dst.Aliases = make([]string, len(src.Aliases))
		}
		copy(dst.Aliases, src.Aliases)
	}
	if src.DriverOpts != nil {
		dst.DriverOpts = make(map[string]string, len(src.DriverOpts))
		deriveDeepCopy_4(dst.DriverOpts, src.DriverOpts)
	} else {
		dst.DriverOpts = nil
	}
	dst.GatewayPriority = src.GatewayPriority
	dst.InterfaceName = src.InterfaceName
	dst.Ipv4Address = src.Ipv4Address
	dst.Ipv6Address = src.Ipv6Address
	if src.LinkLocalIPs == nil {
		dst.LinkLocalIPs = nil
	} else {
		if dst.LinkLocalIPs != nil {
			if len(src.LinkLocalIPs) > len(dst.LinkLocalIPs) {
				if cap(dst.LinkLocalIPs) >= len(src.LinkLocalIPs) {
					dst.LinkLocalIPs = (dst.LinkLocalIPs)[:len(src.LinkLocalIPs)]
				} else {
					dst.LinkLocalIPs = make([]string, len(src.LinkLocalIPs))
				}
			} else if len(src.LinkLocalIPs) < len(dst.LinkLocalIPs) {
				dst.LinkLocalIPs = (dst.LinkLocalIPs)[:len(src.LinkLocalIPs)]
			}
		} else {
			dst.LinkLocalIPs = make([]string, len(src.LinkLocalIPs))
		}
		copy(dst.LinkLocalIPs, src.LinkLocalIPs)
	}
	dst.MacAddress = src.MacAddress
	dst.Priority = src.Priority
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_41 recursively copies the contents of src into dst.
func deriveDeepCopy_41(dst, src *ServicePortConfig) {
	dst.Name = src.Name
	dst.Mode = src.Mode
	dst.HostIP = src.HostIP
	dst.Target = src.Target
	dst.Published = src.Published
	dst.Protocol = src.Protocol
	dst.AppProtocol = src.AppProtocol
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_42 recursively copies the contents of src into dst.
func deriveDeepCopy_42(dst, src *ServiceSecretConfig) {
	dst.Source = src.Source
	dst.Target = src.Target
	dst.UID = src.UID
	dst.GID = src.GID
	if src.Mode == nil {
		dst.Mode = nil
	} else {
		dst.Mode = new(FileMode)
		*dst.Mode = *src.Mode
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_43 recursively copies the contents of src into dst.
func deriveDeepCopy_43(dst, src *UlimitsConfig) {
	dst.Single = src.Single
	dst.Soft = src.Soft
	dst.Hard = src.Hard
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_44 recursively copies the contents of src into dst.
func deriveDeepCopy_44(dst, src *ServiceVolumeConfig) {
	dst.Type = src.Type
	dst.Source = src.Source
	dst.Target = src.Target
	dst.ReadOnly = src.ReadOnly
	dst.Consistency = src.Consistency
	if src.Bind == nil {
		dst.Bind = nil
	} else {
		dst.Bind = new(ServiceVolumeBind)
		deriveDeepCopy_52(dst.Bind, src.Bind)
	}
	if src.Volume == nil {
		dst.Volume = nil
	} else {
		dst.Volume = new(ServiceVolumeVolume)
		deriveDeepCopy_53(dst.Volume, src.Volume)
	}
	if src.Tmpfs == nil {
		dst.Tmpfs = nil
	} else {
		dst.Tmpfs = new(ServiceVolumeTmpfs)
		deriveDeepCopy_54(dst.Tmpfs, src.Tmpfs)
	}
	if src.Image == nil {
		dst.Image = nil
	} else {
		dst.Image = new(ServiceVolumeImage)
		deriveDeepCopy_55(dst.Image, src.Image)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_45 recursively copies the contents of src into dst.
func deriveDeepCopy_45(dst, src *ServiceHook) {
	if src.Command == nil {
		dst.Command = nil
	} else {
		if dst.Command != nil {
			if len(src.Command) > len(dst.Command) {
				if cap(dst.Command) >= len(src.Command) {
					dst.Command = (dst.Command)[:len(src.Command)]
				} else {
					dst.Command = make([]string, len(src.Command))
				}
			} else if len(src.Command) < len(dst.Command) {
				dst.Command = (dst.Command)[:len(src.Command)]
			}
		} else {
			dst.Command = make([]string, len(src.Command))
		}
		copy(dst.Command, src.Command)
	}
	dst.User = src.User
	dst.Privileged = src.Privileged
	dst.WorkingDir = src.WorkingDir
	if src.Environment != nil {
		dst.Environment = make(map[string]*string, len(src.Environment))
		deriveDeepCopy_14(dst.Environment, src.Environment)
	} else {
		dst.Environment = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_46 recursively copies the contents of src into dst.
func deriveDeepCopy_46(dst, src *IPAMConfig) {
	dst.Driver = src.Driver
	if src.Config == nil {
		dst.Config = nil
	} else {
		if dst.Config != nil {
			if len(src.Config) > len(dst.Config) {
				if cap(dst.Config) >= len(src.Config) {
					dst.Config = (dst.Config)[:len(src.Config)]
				} else {
					dst.Config = make([]*IPAMPool, len(src.Config))
				}
			} else if len(src.Config) < len(dst.Config) {
				dst.Config = (dst.Config)[:len(src.Config)]
			}
		} else {
			dst.Config = make([]*IPAMPool, len(src.Config))
		}
		deriveDeepCopy_56(dst.Config, src.Config)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_47 recursively copies the contents of src into dst.
func deriveDeepCopy_47(dst, src *Trigger) {
	dst.Path = src.Path
	dst.Action = src.Action
	dst.Target = src.Target
	func() {
		field := new(ServiceHook)
		deriveDeepCopy_45(field, &src.Exec)
		dst.Exec = *field
	}()
	if src.Include == nil {
		dst.Include = nil
	} else {
		if dst.Include != nil {
			if len(src.Include) > len(dst.Include) {
				if cap(dst.Include) >= len(src.Include) {
					dst.Include = (dst.Include)[:len(src.Include)]
				} else {
					dst.Include = make([]string, len(src.Include))
				}
			} else if len(src.Include) < len(dst.Include) {
				dst.Include = (dst.Include)[:len(src.Include)]
			}
		} else {
			dst.Include = make([]string, len(src.Include))
		}
		copy(dst.Include, src.Include)
	}
	if src.Ignore == nil {
		dst.Ignore = nil
	} else {
		if dst.Ignore != nil {
			if len(src.Ignore) > len(dst.Ignore) {
				if cap(dst.Ignore) >= len(src.Ignore) {
					dst.Ignore = (dst.Ignore)[:len(src.Ignore)]
				} else {
					dst.Ignore = make([]string, len(src.Ignore))
				}
			} else if len(src.Ignore) < len(dst.Ignore) {
				dst.Ignore = (dst.Ignore)[:len(src.Ignore)]
			}
		} else {
			dst.Ignore = make([]string, len(src.Ignore))
		}
		copy(dst.Ignore, src.Ignore)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_48 recursively copies the contents of src into dst.
func deriveDeepCopy_48(dst, src *WeightDevice) {
	dst.Path = src.Path
	dst.Weight = src.Weight
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_49 recursively copies the contents of src into dst.
func deriveDeepCopy_49(dst, src *ThrottleDevice) {
	dst.Path = src.Path
	dst.Rate = src.Rate
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_50 recursively copies the contents of src into dst.
func deriveDeepCopy_50(dst, src *Resource) {
	dst.NanoCPUs = src.NanoCPUs
	dst.MemoryBytes = src.MemoryBytes
	dst.Pids = src.Pids
	if src.Devices == nil {
		dst.Devices = nil
	} else {
		if dst.Devices != nil {
			if len(src.Devices) > len(dst.Devices) {
				if cap(dst.Devices) >= len(src.Devices) {
					dst.Devices = (dst.Devices)[:len(src.Devices)]
				} else {
					dst.Devices = make([]DeviceRequest, len(src.Devices))
				}
			} else if len(src.Devices) < len(dst.Devices) {
				dst.Devices = (dst.Devices)[:len(src.Devices)]
			}
		} else {
			dst.Devices = make([]DeviceRequest, len(src.Devices))
		}
		deriveDeepCopy_16(dst.Devices, src.Devices)
	}
	if src.GenericResources == nil {
		dst.GenericResources = nil
	} else {
		if dst.GenericResources != nil {
			if len(src.GenericResources) > len(dst.GenericResources) {
				if cap(dst.GenericResources) >= len(src.GenericResources) {
					dst.GenericResources = (dst.GenericResources)[:len(src.GenericResources)]
				} else {
					dst.GenericResources = make([]GenericResource, len(src.GenericResources))
				}
			} else if len(src.GenericResources) < len(dst.GenericResources) {
				dst.GenericResources = (dst.GenericResources)[:len(src.GenericResources)]
			}
		} else {
			dst.GenericResources = make([]GenericResource, len(src.GenericResources))
		}
		deriveDeepCopy_57(dst.GenericResources, src.GenericResources)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_51 recursively copies the contents of src into dst.
func deriveDeepCopy_51(dst, src []PlacementPreferences) {
	for src_i, src_value := range src {
		func() {
			field := new(PlacementPreferences)
			deriveDeepCopy_58(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_52 recursively copies the contents of src into dst.
func deriveDeepCopy_52(dst, src *ServiceVolumeBind) {
	dst.SELinux = src.SELinux
	dst.Propagation = src.Propagation
	dst.CreateHostPath = src.CreateHostPath
	dst.Recursive = src.Recursive
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_53 recursively copies the contents of src into dst.
func deriveDeepCopy_53(dst, src *ServiceVolumeVolume) {
	if src.Labels != nil {
		dst.Labels = make(map[string]string, len(src.Labels))
		deriveDeepCopy_4(dst.Labels, src.Labels)
	} else {
		dst.Labels = nil
	}
	dst.NoCopy = src.NoCopy
	dst.Subpath = src.Subpath
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_54 recursively copies the contents of src into dst.
func deriveDeepCopy_54(dst, src *ServiceVolumeTmpfs) {
	dst.Size = src.Size
	dst.Mode = src.Mode
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_55 recursively copies the contents of src into dst.
func deriveDeepCopy_55(dst, src *ServiceVolumeImage) {
	dst.SubPath = src.SubPath
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_56 recursively copies the contents of src into dst.
func deriveDeepCopy_56(dst, src []*IPAMPool) {
	for src_i, src_value := range src {
		if src_value == nil {
			dst[src_i] = nil
		} else {
			dst[src_i] = new(IPAMPool)
			deriveDeepCopy_59(dst[src_i], src_value)
		}
	}
}

// deriveDeepCopy_57 recursively copies the contents of src into dst.
func deriveDeepCopy_57(dst, src []GenericResource) {
	for src_i, src_value := range src {
		func() {
			field := new(GenericResource)
			deriveDeepCopy_60(field, &src_value)
			dst[src_i] = *field
		}()
	}
}

// deriveDeepCopy_58 recursively copies the contents of src into dst.
func deriveDeepCopy_58(dst, src *PlacementPreferences) {
	dst.Spread = src.Spread
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_59 recursively copies the contents of src into dst.
func deriveDeepCopy_59(dst, src *IPAMPool) {
	dst.Subnet = src.Subnet
	dst.Gateway = src.Gateway
	dst.IPRange = src.IPRange
	if src.AuxiliaryAddresses != nil {
		dst.AuxiliaryAddresses = make(map[string]string, len(src.AuxiliaryAddresses))
		deriveDeepCopy_4(dst.AuxiliaryAddresses, src.AuxiliaryAddresses)
	} else {
		dst.AuxiliaryAddresses = nil
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_60 recursively copies the contents of src into dst.
func deriveDeepCopy_60(dst, src *GenericResource) {
	if src.DiscreteResourceSpec == nil {
		dst.DiscreteResourceSpec = nil
	} else {
		dst.DiscreteResourceSpec = new(DiscreteGenericResource)
		deriveDeepCopy_61(dst.DiscreteResourceSpec, src.DiscreteResourceSpec)
	}
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}

// deriveDeepCopy_61 recursively copies the contents of src into dst.
func deriveDeepCopy_61(dst, src *DiscreteGenericResource) {
	dst.Kind = src.Kind
	dst.Value = src.Value
	if src.Extensions != nil {
		dst.Extensions = make(map[string]any, len(src.Extensions))
		src.Extensions.DeepCopy(dst.Extensions)
	} else {
		dst.Extensions = nil
	}
}
