// Copyright (c) 2011 GeometryFactory (France). All rights reserved.
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org)
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.1/Intersections_2/include/CGAL/Intersection_traits_2.h $
// $Id: include/CGAL/Intersection_traits_2.h 50cfbde3b84 $
// SPDX-License-Identifier: LGPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Philipp Möller

#ifndef CGAL_INTERSECTION_TRAITS_2_H
#define CGAL_INTERSECTION_TRAITS_2_H

#include <CGAL/Intersection_traits.h>
#include <CGAL/Bbox_2.h>

#include <variant>
#include <optional>
#include <vector>

namespace CGAL {

CGAL_INTERSECTION_TRAITS_2(Line_2, Line_2, Point_2, Line_2)

CGAL_INTERSECTION_TRAITS_2(Segment_2, Line_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Line_2, Segment_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Segment_2, Segment_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Ray_2, Line_2, Point_2, Ray_2)
CGAL_INTERSECTION_TRAITS_2(Line_2, Ray_2, Point_2, Ray_2)

CGAL_INTERSECTION_TRAITS_2(Ray_2, Segment_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Segment_2, Ray_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_3(Ray_2, Ray_2, Point_2, Segment_2, Ray_2)

CGAL_INTERSECTION_TRAITS_2(Triangle_2, Line_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Line_2, Triangle_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Triangle_2, Segment_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Segment_2, Triangle_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Triangle_2, Ray_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Ray_2, Triangle_2, Point_2, Segment_2)

template<typename K>
struct Intersection_traits<K, typename K::Triangle_2, typename K::Triangle_2>  {
  typedef typename
  std::variant< typename K::Point_2, typename K::Segment_2,
                  typename K::Triangle_2, typename std::vector< typename K::Point_2 > > variant_type;
  typedef typename std::optional< variant_type > result_type;
};


CGAL_INTERSECTION_TRAITS_2(Iso_rectangle_2, Line_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Line_2, Iso_rectangle_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Iso_rectangle_2, Segment_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Segment_2, Iso_rectangle_2, Point_2, Segment_2)

CGAL_INTERSECTION_TRAITS_2(Iso_rectangle_2, Ray_2, Point_2, Segment_2)
CGAL_INTERSECTION_TRAITS_2(Ray_2, Iso_rectangle_2, Point_2, Segment_2)

// undocumented

// Variants of one for backwards compatibility
template<typename K>
struct Intersection_traits<K, typename K::Iso_rectangle_2, typename K::Iso_rectangle_2>  {
  typedef typename std::variant<typename K::Iso_rectangle_2> variant_type;
  typedef std::optional<variant_type> result_type;
};


// Point_2 is special
template<typename K, typename B>
struct Intersection_traits<K, typename K::Point_2, B> {
  typedef typename std::variant<typename K::Point_2> variant_type;
  typedef std::optional<variant_type> result_type;
};

template<typename K, typename A>
struct Intersection_traits<K, A, typename K::Point_2> {
  typedef typename std::variant<typename K::Point_2> variant_type;
  typedef std::optional<variant_type> result_type;
};

template<typename K>
struct Intersection_traits<K, typename K::Point_2, typename K::Point_2> {
  typedef typename std::variant<typename K::Point_2> variant_type;
  typedef std::optional<variant_type> result_type;
};

template<typename K>
struct Intersection_traits<K, typename K::Iso_rectangle_2, typename K::Triangle_2>
{
  typedef typename std::variant<typename K::Segment_2, typename K::Triangle_2,
                                  typename K::Point_2,
                                  typename std::vector< typename K::Point_2 > > variant_type;
  typedef typename std::optional < variant_type > result_type;
};

template<typename K>
struct Intersection_traits<K, typename K::Triangle_2, typename K::Iso_rectangle_2>
  : public Intersection_traits<K, typename K::Iso_rectangle_2, typename K::Triangle_2> {};

template<typename K, class B>
struct Intersection_traits<K, CGAL::Bbox_2, B>  {
  typedef typename Intersection_traits<K,typename K::Iso_rectangle_2, B>::result_type result_type;
};

template<typename K, class A>
struct Intersection_traits<K, A, CGAL::Bbox_2>  {
  typedef typename Intersection_traits<K,typename K::Iso_rectangle_2, A>::result_type result_type;
};

template<typename K>
struct Intersection_traits<K, CGAL::Bbox_2, typename K::Point_2>  {
  typedef typename std::variant<typename K::Point_2> variant_type;
  typedef std::optional<variant_type> result_type;
};

template<typename K>
struct Intersection_traits<K, typename K::Point_2, CGAL::Bbox_2>  {
  typedef typename std::variant<typename K::Point_2> variant_type;
  typedef std::optional<variant_type> result_type;
};

} // namespace CGAL

#endif /* CGAL_INTERSECTION_TRAITS_2_H */

