//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Axis/Bin.cpp
//! @brief     Implements structs Bin1D, Bin1DCVector
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Base/Axis/Bin.h"
#include "Base/Vector/Direction.h"

bool BinContains(const Bin1D& bin, double value)
{
    if (bin.binSize() == 0.0)
        return false;
    double coordinate = (value - bin.m_lower) / bin.binSize();
    if (coordinate < 0.0)
        return false;
    if (coordinate >= 1.0)
        return false;
    return true;
}

//! creation on Bin1DKVector from alpha and phi bins
Bin1DKVector::Bin1DKVector(double wavelength, const Bin1D& alpha_bin, const Bin1D& phi_bin)
    : m_q_lower(), m_q_upper()
{
    m_q_lower = vecOfLambdaAlphaPhi(wavelength, alpha_bin.m_lower, phi_bin.m_lower);
    m_q_upper = vecOfLambdaAlphaPhi(wavelength, alpha_bin.m_upper, phi_bin.m_upper);
}

//! creation on Bin1DCVector from alpha and phi bins
Bin1DCVector::Bin1DCVector(double wavelength, const Bin1D& alpha_bin, const Bin1D& phi_bin)
    : m_q_lower(), m_q_upper()
{
    m_q_lower = vecOfLambdaAlphaPhi(wavelength, alpha_bin.m_lower, phi_bin.m_lower).complex();
    m_q_upper = vecOfLambdaAlphaPhi(wavelength, alpha_bin.m_upper, phi_bin.m_upper).complex();
}
