########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Monday 22 June 2009 13:08:37 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/Adt/Mapper/ADTFileNames.py,v 1.3 2010/07/15 23:45:39 jren Exp $
#
# $Id: ADTFileNames.py,v 1.3 2010/07/15 23:45:39 jren Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
class ADTFileNames(NetworkNode):
    """
    Node to make inputs for virtual screening.
    """
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]

    def __init__(self, constrkw = {},  name='ADTFileNames', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)

        ip = self.inputPortsDescr
        ip.append({'name': 'recpetor_obj', 'datatype': 'receptor'})

        op = self.outputPortsDescr
        op.append({'name': 'GPF_template', 'datatype': 'gpf_template'})
        op.append({'name': 'DPF_template', 'datatype': 'dpf_template'})
        op.append({'name': 'result_dir', 'datatype': 'string'})


        code = """def doit(self, receptor_obj):
        import os
        from AutoDockTools.VisionInterface.Adt.receptor import receptor
        from AutoDockTools.VisionInterface.Adt.dpf_template import dpf_template
        from AutoDockTools.VisionInterface.Adt.gpf_template import gpf_template

        receptor_id = receptor_obj.get_id()
        receptor_dir = receptor_obj.get_workdir() 

        GPF_template = gpf_template(receptor_dir + os.sep + receptor_id + '.gpf')
        DPF_template = dpf_template(receptor_dir + os.sep + receptor_id + '.dpf')
        result_dir = os.path.abspath(receptor_dir + os.sep + '..' + os.sep + receptor_id)

        print "-------------------------------------------------------"
        print "     INPUTS THAT WILL BE USED FOR VIRTUAL SCREENING    "
        print "GPF Template:                  " + GPF_template.fullpath
        print "DPF Template:                  " + DPF_template.fullpath
        print "Results will be downloaded to: " + result_dir
        print "-------------------------------------------------------"
        
        pass
        self.outputData(GPF_template=GPF_template, DPF_template=DPF_template, result_dir=result_dir)
"""
        self.configure(function=code)


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

