/*
 * unbound-fuzzme.c - parse a packet provided on stdin (for fuzzing).
 *
 */
#include "config.h"
#include "util/regional.h"
#include "util/module.h"
#include "util/config_file.h"
#include "iterator/iterator.h"
#include "iterator/iter_priv.h"
#include "iterator/iter_scrub.h"
#include "util/log.h"
#include "sldns/sbuffer.h"

int main(int argc, char **argv) {
  char buf[4096];
  log_init("/tmp/foo", 0, NULL);
  size_t nr;
  char *bin = buf;
  struct regional* reg;

  nr = read(0, buf, sizeof(buf));

  struct sldns_buffer *pkt = sldns_buffer_new(1);
  sldns_buffer_new_frm_data(pkt, bin, nr);

  reg = regional_create();

  struct msg_parse msg;
  struct edns_data edns;
  memset(&msg, 0, sizeof(struct msg_parse));
  memset(&edns, 0, sizeof(edns));
  if (parse_packet(pkt, &msg, reg) != LDNS_RCODE_NOERROR) {    
    goto out;
  }
  if (parse_extract_edns(&msg, &edns, reg) != LDNS_RCODE_NOERROR) {
    goto out;
  }


  struct query_info qinfo_out;
  memset(&qinfo_out, 0, sizeof(struct query_info));
  qinfo_out.qname = (unsigned char *) "\03nic\02de";
  uint8_t *peter = (unsigned char *) "\02de";   // zonename  
  struct module_env env;
  memset(&env, 0, sizeof(struct module_env));
  struct config_file cfg;
  memset(&cfg, 0, sizeof(struct config_file));
  cfg.harden_glue = 1;    // crashes now, want to remove that later
  env.cfg = &cfg;

  struct iter_env ie;
  memset(&ie, 0, sizeof(struct iter_env));

  struct iter_priv priv;
  memset(&priv, 0, sizeof(struct iter_priv));
  ie.priv = &priv;
  scrub_message(pkt, &msg, &qinfo_out, peter, reg, &env, &ie);   
out:
  regional_destroy(reg);
  sldns_buffer_free(pkt);
  return 0;
}
