/* --------------------------------------------------------------------------
 * module_backlight.c
 * This module contains the class backlight which will define the interface
 * to a LCD backlight controller. Below the module are the backlight drivers
 * which implement the interface to the specific hardware or kernel interface.
 *
 * Copyright 2002-2006 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * -------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "systems.h"

#include <pbb.h>

#include "gettext_macros.h"
#include "input_manager.h"
#include "class_backlight.h"
#include "driver_backlight_pmu.h"
#include "driver_backlight_sysfs.h"

struct class_backlight {
	struct driver_backlight *driver;
} modbase_backlight;

int
backlight_init ()
{
	struct class_backlight *base = &modbase_backlight;

	base->driver = NULL;

	register_function (QUERYQUEUE,  backlight_query);
	register_function (CONFIGQUEUE, backlight_config);
}

int
backlight_open (struct tagitem *taglist)
{
	struct class_backlight *base = &modbase_backlight;

	if (!base->driver) base->driver = driver_backlight_sysfs_init (taglist);
	if (!base->driver) base->driver = driver_backlight_pmu_init (taglist);

	if (base->driver)
		print_msg (PBB_INFO, _("Initialized: %s\n"), _(base->driver->name));
	else
		print_msg (PBB_WARN, _("No backlight driver available - check your Kernel configuration.\n"));

	return 0;
}

int
backlight_close ()
{
	struct class_backlight *base = &modbase_backlight;

	if (base->driver)
		base->driver->driver_exit();
	return 0;
}

int
backlight_exit ()
{
	return 0;
}

void
backlight_query (struct tagitem *taglist)
{
	backlight_handle_tags (MODE_QUERY, taglist);
}

void
backlight_config (struct tagitem *taglist)
{
	backlight_handle_tags (MODE_CONFIG, taglist);
}

void
backlight_handle_tags (int cfgure, struct tagitem *taglist)
{
	struct class_backlight *base = &modbase_backlight;

	if (!base->driver) return;

	while (taglist->tag != TAG_END) {
		switch (taglist->tag) {
		case TAG_BACKLIGHTMAX:     /* private tag */
			if (cfgure)	;
			else		taglist->data = base->driver->get_brightness_max();
			break;

		/* The following construct is necessary to allow the module_pmac to slip
		 * between the original caller and the hardware processing function. It is
		 * really a hack but there is no other way with the current program structure
		 * of pbbuttonsd.
		 */
#ifndef WITH_MODULE_PMAC
		case TAG_BACKLIGHTLEVEL:   /* private tag */
#endif
		case TAG_HW_BACKLIGHT:     /* private tag */
			if (cfgure)	base->driver->set_brightness(taglist->data);
			else		taglist->data = base->driver->get_brightness();
			break;
		}
		taglist++;
	}
}

