/*
 * Copyright (c) 1999, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javax.imageio.spi;

import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

/**
 * The service provider interface (SPI) for {@code ImageReader}s.
 * For more information on service provider classes, see the class comment
 * for the {@code IIORegistry} class.
 *
 * <p> Each {@code ImageReaderSpi} provides several types of information
 * about the {@code ImageReader} class with which it is associated.
 *
 * <p> The name of the vendor who defined the SPI class and a
 * brief description of the class are available via the
 * {@code getVendorName}, {@code getDescription},
 * and {@code getVersion} methods.
 * These methods may be internationalized to provide locale-specific
 * output.  These methods are intended mainly to provide short,
 * human-readable information that might be used to organize a pop-up
 * menu or other list.
 *
 * <p> Lists of format names, file suffixes, and MIME types associated
 * with the service may be obtained by means of the
 * {@code getFormatNames}, {@code getFileSuffixes}, and
 * {@code getMIMETypes} methods.  These methods may be used to
 * identify candidate {@code ImageReader}s for decoding a
 * particular file or stream based on manual format selection, file
 * naming, or MIME associations (for example, when accessing a file
 * over HTTP or as an email attachment).
 *
 * <p> A more reliable way to determine which {@code ImageReader}s
 * are likely to be able to parse a particular data stream is provided
 * by the {@code canDecodeInput} method.  This methods allows the
 * service provider to inspect the actual stream contents.
 *
 * <p> Finally, an instance of the {@code ImageReader} class
 * associated with this service provider may be obtained by calling
 * the {@code createReaderInstance} method.  Any heavyweight
 * initialization, such as the loading of native libraries or creation
 * of large tables, should be deferred at least until the first
 * invocation of this method.
 *
 * @see IIORegistry
 * @see javax.imageio.ImageReader
 *
 */
public abstract class ImageReaderSpi extends ImageReaderWriterSpi {

    /**
     * A single-element array, initially containing
     * {@code ImageInputStream.class}, to be returned from
     * {@code getInputTypes}.
     * @deprecated Instead of using this field, directly create
     * the equivalent array {@code { ImageInputStream.class }}.
     */
    @Deprecated
    public static final Class<?>[] STANDARD_INPUT_TYPE =
        { ImageInputStream.class };

    /**
     * An array of {@code Class} objects to be returned from
     * {@code getInputTypes}, initially {@code null}.
     */
    protected Class<?>[] inputTypes = null;

    /**
     * An array of strings to be returned from
     * {@code getImageWriterSpiNames}, initially
     * {@code null}.
     */
    protected String[] writerSpiNames = null;