/*
 * Copyright 2022 Richard Hughes <richard@hughsie.com>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <glib-object.h>

#define FU_WISTRON_DOCK_CMD_ICP_ENTER	     0x81
#define FU_WISTRON_DOCK_CMD_ICP_EXIT	     0x82
#define FU_WISTRON_DOCK_CMD_ICP_ADDRESS	     0x84
#define FU_WISTRON_DOCK_CMD_ICP_READBLOCK    0x85
#define FU_WISTRON_DOCK_CMD_ICP_WRITEBLOCK   0x86
#define FU_WISTRON_DOCK_CMD_ICP_MCUID	     0x87
#define FU_WISTRON_DOCK_CMD_ICP_BBINFO	     0x88 /* bb code information */
#define FU_WISTRON_DOCK_CMD_ICP_USERINFO     0x89 /* user code information */
#define FU_WISTRON_DOCK_CMD_ICP_DONE	     0x5A
#define FU_WISTRON_DOCK_CMD_ICP_ERROR	     0xFF
#define FU_WISTRON_DOCK_CMD_ICP_EXIT_WDRESET 0x01 /* exit ICP with watch dog reset */

#define FU_WISTRON_DOCK_CMD_DFU_ENTER		0x91
#define FU_WISTRON_DOCK_CMD_DFU_EXIT		0x92
#define FU_WISTRON_DOCK_CMD_DFU_ADDRESS		0x93
#define FU_WISTRON_DOCK_CMD_DFU_READIMG_BLOCK	0x94
#define FU_WISTRON_DOCK_CMD_DFU_WRITEIMG_BLOCK	0x95
#define FU_WISTRON_DOCK_CMD_DFU_VERIFY		0x96
#define FU_WISTRON_DOCK_CMD_DFU_COMPOSITE_VER	0x97
#define FU_WISTRON_DOCK_CMD_DFU_WRITE_WDFL_SIG	0x98
#define FU_WISTRON_DOCK_CMD_DFU_WRITE_WDFL_DATA 0x99
#define FU_WISTRON_DOCK_CMD_DFU_VERIFY_WDFL	0x9A
#define FU_WISTRON_DOCK_CMD_DFU_SERINAL_NUMBER	0x9B
#define FU_WISTRON_DOCK_CMD_DFU_DONE		0x5A
#define FU_WISTRON_DOCK_CMD_DFU_ERROR		0xFF

#define FU_WISTRON_DOCK_WDIT_SIZE   512	   /* bytes */
#define FU_WISTRON_DOCK_WDIT_TAG_ID 0x4954 /* 'IT' */

#define FU_WISTRON_DOCK_WDFL_SIG_SIZE  256  /* bytes */
#define FU_WISTRON_DOCK_WDFL_DATA_SIZE 1328 /* bytes */
