package ONVIF::PTZ::Types::WhiteBalanceOptions20;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %YrGain_of :ATTR(:get<YrGain>);
my %YbGain_of :ATTR(:get<YbGain>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        YrGain
        YbGain
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'YrGain' => \%YrGain_of,
        'YbGain' => \%YbGain_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::PTZ::Types::WhiteBalanceMode',
        'YrGain' => 'ONVIF::PTZ::Types::FloatRange',
        'YbGain' => 'ONVIF::PTZ::Types::FloatRange',
        'Extension' => 'ONVIF::PTZ::Types::WhiteBalanceOptions20Extension',
    },
    {

        'Mode' => 'Mode',
        'YrGain' => 'YrGain',
        'YbGain' => 'YbGain',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::WhiteBalanceOptions20

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
WhiteBalanceOptions20 from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * YrGain


=item * YbGain


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::WhiteBalanceOptions20
   Mode => $some_value, # WhiteBalanceMode
   YrGain =>  { # ONVIF::PTZ::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   YbGain =>  { # ONVIF::PTZ::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   Extension =>  { # ONVIF::PTZ::Types::WhiteBalanceOptions20Extension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

