/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Identity;
import Ice.NotRegisteredException;
import Ice.Object;
import IceInternal.Instance;
import IceUtil.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private Hashtable _servantMapMap = new Hashtable();

    public synchronized void addServant(Object object, Identity identity, String string) {
        Hashtable<String, Object> hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable<String, Object>)this._servantMapMap.get(identity)) == null) {
            hashtable = new Hashtable<String, Object>();
            this._servantMapMap.put(identity, hashtable);
        } else if (hashtable.containsKey(string)) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = this._instance.identityToString(identity);
            alreadyRegisteredException.kindOfObject = "servant";
            if (string.length() > 0) {
                alreadyRegisteredException.id = alreadyRegisteredException.id + " -f " + StringUtil.escapeString(string, "");
            }
            throw alreadyRegisteredException;
        }
        hashtable.put(string, object);
    }

    public synchronized Object removeServant(Identity identity, String string) {
        if (string == null) {
            string = "";
        }
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        Object object = null;
        if (hashtable == null || (object = (Object)hashtable.remove(string)) == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.id = this._instance.identityToString(identity);
            notRegisteredException.kindOfObject = "servant";
            if (string.length() > 0) {
                notRegisteredException.id = notRegisteredException.id + " -f " + StringUtil.escapeString(string, "");
            }
            throw notRegisteredException;
        }
        if (hashtable.isEmpty()) {
            this._servantMapMap.remove(identity);
        }
        return object;
    }

    public synchronized Hashtable removeAllFacets(Identity identity) {
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        if (hashtable == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.id = this._instance.identityToString(identity);
            notRegisteredException.kindOfObject = "servant";
            throw notRegisteredException;
        }
        this._servantMapMap.remove(identity);
        return hashtable;
    }

    public synchronized Object findServant(Identity identity, String string) {
        if (string == null) {
            string = "";
        }
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        Object object = null;
        if (hashtable != null) {
            object = (Object)hashtable.get(string);
        }
        return object;
    }

    public synchronized Hashtable findAllFacets(Identity identity) {
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        if (hashtable != null) {
            Hashtable hashtable2 = new Hashtable(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                java.lang.Object k = enumeration.nextElement();
                java.lang.Object v = hashtable.get(k);
                hashtable2.put(k, v);
            }
            return hashtable2;
        }
        return new Hashtable();
    }

    public synchronized boolean hasServant(Identity identity) {
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        return hashtable != null;
    }

    public ServantManager(Instance instance, String string) {
        this._instance = instance;
        this._adapterName = string;
    }

    public synchronized void destroy() {
        this._servantMapMap.clear();
        this._instance = null;
    }
}

