/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: quit_menu.c,v 1.1 2000/01/02 02:05:23 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "xracer.h"
#include "xracer-mode.h"
#include "xracer-menu.h"
#include "xracer-game.h"

/* Program-level menu initialization. */
void
xrQuitMenuInit ()
{
}

static const char *items[] = {
  "Yes, I give up",
  "No, take me back for more",
};

static void
yes ()
{
  exit (0);
}

static void
no ()
{
  xrEnterMenu (&xrStartMenu, 0);
}

static void (*actions[])(void) = {
  yes,
  no
};

struct xrMenu xrQuitMenu = {
  name: "quit menu",
  title: "Quit - are you sure?",
  nr_items: 2,
  items: items,
  actions: actions
};
