/*
 * Worldwide channel/frequency list
 *
 * Nathan Laredo (laredo@broked.net)
 * Minor additions by Wee Liang (wliang@tartarus.uwa.edu.au)
 *
 * Frequencies are given in kHz 
 */
#define NTSC_AUDIO_CARRIER	4500
#define PAL_AUDIO_CARRIER_I	6000
#define PAL_AUDIO_CARRIER_BGHN	5500
#define PAL_AUDIO_CARRIER_MN	4500
#define PAL_AUDIO_CARRIER_D	6500
#define SEACAM_AUDIO_DKK1L	6500
#define SEACAM_AUDIO_BG		5500
/* NICAM 728 32-kHz, 14-bit digital stereo audio is transmitted in 1ms frames
   containing 8 bits frame sync, 5 bits control, 11 bits additional data, and
   704 bits audio data.  The bit rate is reduced by transmitting only 10 bits
   plus parity of each 14 bit sample, the largest sample in a frame determines
   which 10 bits are transmitted.  The parity bits for audio samples also 
   specify the scaling factor used for that channel during that frame.  The
   companeded audio data is interleaved to reduce the influence of dropouts
   and the whole frame except for sync bits is scrambled for spectrum shaping.
   Data is modulated using QPSK, at below following subcarrier freqs */
#define NICAM728_PAL_BGH	5850
#define NICAM728_PAL_I		6552

/* COMPREHENSIVE LIST OF FORMAT BY COUNTRY
   (M) NTSC used in:
	Antigua, Aruba, Bahamas, Barbados, Belize, Bermuda, Bolivia, Burma,
	Canada, Chile, Colombia, Costa Rica, Cuba, Curacao, Dominican Republic,
	Ecuador, El Salvador, Guam Guatemala, Honduras, Jamaica, Japan,
	South Korea, Mexico, Montserrat, Myanmar, Nicaragua, Panama, Peru,
	Philippines, Puerto Rico, St Christopher and Nevis, Samoa, Suriname,
	Taiwan, Trinidad/Tobago, United States, Venezuela, Virgin Islands
   (B) PAL used in:
	Albania, Algeria, Australia, Austria, Bahrain, Bangladesh, Belgium,
	Bosnia-Herzegovinia, Brunei Darussalam, Cambodia, Cameroon, Croatia,
	Cyprus, Denmark, Egypt, Ethiopia, Equatorial Guinea, Finland, Germany,
	Ghana, Gibraltar, Greenland, Iceland, India, Indonesia, Israel, Italy,
	Jordan, Kenya, Kuwait, Liberia, Libya, Luxembourg, Malaysa, Maldives,
	Malta, Nepal, Netherlands, New Zeland, Nigeria, Norway, Oman, Pakistan,
	Papua New Guinea, Portugal, Qatar, Sao Tome and Principe, Saudi Arabia,
	Seychelles, Sierra Leone, Singapore, Slovenia, Somali, Spain,
	Sri Lanka, Sudan, Swaziland, Sweden, Switzeland, Syria, Thailand,
	Tunisia, Turkey, Uganda, United Arab Emirates, Yemen
   (N) PAL used in: (Combination N = 4.5MHz audio carrier, 3.58MHz burst)
	Argentina (Combination N), Paraguay, Uruguay
   (M) PAL (525/60, 3.57MHz burst) used in:
	Brazil
   (G) PAL used in:
	Albania, Algeria, Austria, Bahrain, Bosnia/Herzegovinia, Cambodia,
	Cameroon, Croatia, Cyprus, Denmark, Egypt, Ethiopia, Equatorial Guinea,
	Finland, Germany, Gibraltar, Greenland, Iceland, Israel, Italy, Jordan,
	Kenya, Kuwait, Liberia, Libya, Luxembourg, Malaysia, Monaco,
	Mozambique, Netherlands, New Zealand, Norway, Oman, Pakistan,
	Papa New Guinea, Portugal, Qatar, Romania, Sierra Leone, Singapore,
	Slovenia, Somalia, Spain, Sri Lanka, Sudan, Swaziland, Sweeden,
	Switzerland, Syria, Thailand, Tunisia, Turkey, United Arab Emirates,
	Yemen, Zambia, Zimbabwe
   (D) PAL used in:
	China, North Korea, Romania, Czech Republic
   (H) PAL used in:
	Belgium
   (I) PAL used in:
	Angola, Botswana, Gambia, Guinea-Bissau, Hong Kong, Ireland, Lesotho,
	Malawi, Nambia, Nigeria, South Africa, Tanzania, United Kingdom,
	Zanzibar
   (B) SECAM used in:
	Djibouti, Greece, Iran, Iraq, Lebanon, Mali, Mauritania, Mauritus,
	Morocco
   (D) SECAM used in:
	Afghanistan, Armenia, Azerbaijan, Belarus, Bulgaria,
	Estonia, Georgia, Hungary, Zazakhstan, Lithuania, Mongolia, Moldova,
	Poland, Russia, Slovak Republic, Ukraine, Vietnam
   (G) SECAM used in:
	Greecem Iran, Iraq, Mali, Mauritus, Morocco, Saudi Arabia
   (K) SECAM used in:
	Armenia, Azerbaijan, Bulgaria, Estonia, Georgia,
	Hungary, Kazakhstan, Lithuania, Madagascar, Moldova, Poland, Russia,
	Slovak Republic, Ukraine, Vietnam
   (K1) SECAM used in:
	Benin, Burkina Faso, Burundi, Chad, Cape Verde, Central African
	Republic, Comoros, Congo, Gabon, Madagascar, Niger, Rwanda, Senegal,
	Togo, Zaire
   (L) SECAM used in:
	France
*/
struct gentab {
	int cind;
	char *cname;
};

struct freqlist {
  char name[4];
  int freq[12];
};

struct freqlist tvtuner[] = {
/* CH	      US-TV	US-CATV	US-HRC	JP-TV	JP-CATV	EUROPE	EUR-E	ITALY	NZ	AU	UHF_GHI */
{"E2",	{     0,	0,	0,	0,	0,	48250,	0,	0,	0,	0,	0}},
{"E3",	{     0,	0,	0,	0,	0,	55250,	0,	0,	0,	0,	0}},
{"E4",	{     0,	0,	0,	0,	0,	62250,	0,	0,	0,	0,	0}},

{"S01",	{     0,	0,	0,	0,	0,	69250,	0,	0,	0,	0,	0}},
{"S02",	{     0,	0,	0,	0,	0,	76250,	0,	0,	0,	0,	0}},
{"S03",	{     0,	0,	0,	0,	0,	83250,	0,	0,	0,	0,	0}},

{"R1",	{     0,	0,	0,	0,	0,	0,	49750,	0,	0,	0,	0}},
{"R2",	{     0,	0,	0,	0,	0,	0,	59250,	0,	0,	0,	0}},
{"R3",	{     0,	0,	0,	0,	0,	0,	77250,	0,	0,	0,	0}},
{"R4",	{     0,	0,	0,	0,	0,	0,	84250,	0,	0,	0,	0}},
{"R5",	{     0,	0,	0,	0,	0,	0,	93250,	0,	0,	0,	0}},

{"SE1",	{     0,	0,	0,	0,	0,	105250,	105250,	0,	0,	0,	0}},
{"SE2",	{     0,	0,	0,	0,	0,	112250,	112250,	0,	0,	0,	0}},
{"SE3",	{     0,	0,	0,	0,	0,	119250,	119250,	0,	0,	0,	0}},
{"SE4",	{     0,	0,	0,	0,	0,	126250,	126250,	0,	0,	0,	0}},
{"SE5",	{     0,	0,	0,	0,	0,	133250,	133250,	0,	0,	0,	0}},
{"SE6",	{     0,	0,	0,	0,	0,	140250,	140250,	0,	0,	0,	0}},
{"SE7",	{     0,	0,	0,	0,	0,	147250,	147250,	0,	0,	0,	0}},
{"SE8",	{     0,	0,	0,	0,	0,	154250,	154250,	0,	0,	0,	0}},
{"SE9",	{     0,	0,	0,	0,	0,	161250,	161250,	0,	0,	0,	0}},
{"SE10",{     0,	0,	0,	0,	0,	168250,	168250,	0,	0,	0,	0}},

{"E5",	{     0,	0,	0,	0,	0,	175250,	0,	0,	0,	0,	0}},
{"E6",	{     0,	0,	0,	0,	0,	182250,	0,	0,	0,	0,	0}},
{"E7",	{     0,	0,	0,	0,	0,	189250,	0,	0,	0,	0,	0}},
{"E8",	{     0,	0,	0,	0,	0,	196250,	0,	0,	0,	0,	0}},
{"E9",	{     0,	0,	0,	0,	0,	203250,	0,	0,	0,	0,	0}},
{"E10",	{     0,	0,	0,	0,	0,	210250,	0,	0,	0,	0,	0}},
{"E11",	{     0,	0,	0,	0,	0,	217250,	0,	0,	0,	0,	0}},
{"E12",	{     0,	0,	0,	0,	0,	224250,	0,	0,	0,	0,	0}},

{"R6",	{     0,	0,	0,	0,	0,	0,	175250,	0,	0,	0,	0}},
{"R7",	{     0,	0,	0,	0,	0,	0,	183250,	0,	0,	0,	0}},
{"R8",	{     0,	0,	0,	0,	0,	0,	191250,	0,	0,	0,	0}},
{"R9",	{     0,	0,	0,	0,	0,	0,	199250,	0,	0,	0,	0}},
{"R10",	{     0,	0,	0,	0,	0,	0,	207250,	0,	0,	0,	0}},
{"R11",	{     0,	0,	0,	0,	0,	0,	215250,	0,	0,	0,	0}},
{"R12",	{     0,	0,	0,	0,	0,	0,	223250,	0,	0,	0,	0}},

{"SE11",{     0,	0,	0,	0,	0,	231250,	231250,	0,	0,	0,	0}},
{"SE12",{     0,	0,	0,	0,	0,	238250,	238250,	0,	0,	0,	0}},
{"SE13",{     0,	0,	0,	0,	0,	245250,	245250,	0,	0,	0,	0}},
{"SE14",{     0,	0,	0,	0,	0,	252250,	252250,	0,	0,	0,	0}},
{"SE15",{     0,	0,	0,	0,	0,	259250,	259250,	0,	0,	0,	0}},
{"SE16",{     0,	0,	0,	0,	0,	266250,	266250,	0,	0,	0,	0}},
{"SE17",{     0,	0,	0,	0,	0,	273250,	273250,	0,	0,	0,	0}},
{"SE18",{     0,	0,	0,	0,	0,	280250,	280250,	0,	0,	0,	0}},
{"SE19",{     0,	0,	0,	0,	0,	287250,	287250,	0,	0,	0,	0}},
{"SE20",{     0,	0,	0,	0,	0,	294250,	294250,	0,	0,	0,	0}},

{"S21",	{     0,	0,	0,	0,	0,	303250,	303250,	0,	0,	0,	0}},
{"S22",	{     0,	0,	0,	0,	0,	311250,	311250,	0,	0,	0,	0}},
{"S23",	{     0,	0,	0,	0,	0,	319250,	319250,	0,	0,	0,	0}},
{"S24",	{     0,	0,	0,	0,	0,	327250,	327250,	0,	0,	0,	0}},
{"S25",	{     0,	0,	0,	0,	0,	335250,	335250,	0,	0,	0,	0}},
{"S26",	{     0,	0,	0,	0,	0,	343250,	343250,	0,	0,	0,	0}},
{"S27",	{     0,	0,	0,	0,	0,	351250,	351250,	0,	0,	0,	0}},
{"S28",	{     0,	0,	0,	0,	0,	359250,	359250,	0,	0,	0,	0}},
{"S29",	{     0,	0,	0,	0,	0,	367250,	367250,	0,	0,	0,	0}},
{"S30",	{     0,	0,	0,	0,	0,	375250,	375250,	0,	0,	0,	0}},
{"S31",	{     0,	0,	0,	0,	0,	383250,	383250,	0,	0,	0,	0}},
{"S32",	{     0,	0,	0,	0,	0,	391250,	391250,	0,	0,	0,	0}},
{"S33",	{     0,	0,	0,	0,	0,	399250,	399250,	0,	0,	0,	0}},
{"S34",	{     0,	0,	0,	0,	0,	407250,	407250,	0,	0,	0,	0}},
{"S35",	{     0,	0,	0,	0,	0,	415250,	415250,	0,	0,	0,	0}},
{"S36",	{     0,	0,	0,	0,	0,	423250,	423250,	0,	0,	0,	0}},
{"S37",	{     0,	0,	0,	0,	0,	431250,	431250,	0,	0,	0,	0}},
{"S38",	{     0,	0,	0,	0,	0,	439250,	439250,	0,	0,	0,	0}},
{"S39",	{     0,	0,	0,	0,	0,	447250,	447250,	0,	0,	0,	0}},
{"S40",	{     0,	0,	0,	0,	0,	455250,	455250,	0,	0,	0,	0}},
{"S41",	{     0,	0,	0,	0,	0,	463250,	463250,	0,	0,	0,	0}},

{"0",	{     0,	0,	0,	0,	0,	0,	0,	0,	0,	46250,	45750}},
{"1",	{     0,	73250,	72000,	91250,	0,	0,	0,	0,	45250,	57250,	53750}},
{"2",	{ 55250,	55250,	54000,	97250,	0,	0,	0,	53750,	55250,	64250,	61750}},
{"3",	{ 61250,	61250,	60000,	103250,	0,	0,	0,	62250,	62250,	86250,	175250}},
{"4",	{ 67250,	67250,	66000,	171250,	0,	0,	0,	82250,	175250,	95250,	183250}},
{"5",	{ 77250,	77250,	78000,	177250,	0,	0,	0,	175250,	182250,	102250,	191250}},
{"5A",	{     0,	0,	138250,	0,	0,	0,	0,	0,	138250,	0}},
{"6",	{ 83250,	83250,	84000,	183250,	0,	0,	0,	183750,	189250,	175250,	199250}},
{"7",	{175250,	175250,	174000,	189250,	0,	0,	0,	192250,	196250,	182250,	207250}},
{"8",	{181250,	181250,	180000,	193250,	0,	0,	0,	201250,	203250,	189250,	215250}},
{"9",	{187250,	187250,	186000,	199250,	0,	0,	0,	210250,	210250,	196250,	0}},
{"10",	{193250,	193250,	192000,	205250,	0,	0,	0,	210250,	217250,	209250,	0}},
{"11",	{199250,	199250,	198000,	211250,	0,	0,	0,	217250,	0,	216250,	0}},
{"12",	{205250,	205250,	204000,	217250,	0,	0,	0,	224250,	0,	0,	0}},

{"13",	{211250,	211250,	210000,	0,	109250,	0,	0,	0,	0,	0,	0}},
{"14",	{471250,	121250,	120000,	0,	115250,	0,	0,	0,	0,	0,	0}},
{"15",	{477250,	127250,	126000,	0,	121250,	0,	0,	0,	0,	0,	0}},
{"16",	{483250,	133250,	132000,	0,	127250,	0,	0,	0,	0,	0,	0}},
{"17",	{489250,	139250,	138000,	0,	133250,	0,	0,	0,	0,	0,	0}},
{"18",	{495250,	145250,	144000,	0,	139250,	0,	0,	0,	0,	0,	0}},
{"19",	{501250,	151250,	150000,	0,	145250,	0,	0,	0,	0,	0,	0}},
{"20",	{507250,	157250,	156000,	0,	151250,	0,	0,	0,	0,	0,	0}},
 
{"21",	{513250,	163250,	162000,	0,	157250,	471250,	471250,	0,	0,	0,	471250}},
{"22",	{519250,	169250,	168000,	0,	165250,	479250,	479250,	0,	0,	0,	479250}},
{"23",	{525250,	217250,	216000,	0,	223250,	487250,	487250,	0,	0,	0,	487250}},
{"24",	{531250,	223250,	222000,	0,	231250,	495250,	495250,	0,	0,	0,	495250}},
{"25",	{537250,	229250,	228000,	0,	237250,	503250,	503250,	0,	0,	0,	503250}},
{"26",	{543250,	235250,	234000,	0,	243250,	511250,	511250,	0,	0,	0,	511250}},
{"27",	{549250,	241250,	240000,	0,	249250,	519250,	519250,	0,	0,	0,	519250}},
{"28",	{555250,	247250,	246000,	0,	253250,	527250,	527250,	0,	0,	527250,	527250}},
{"29",	{561250,	253250,	252000,	0,	259250,	535250,	535250,	0,	0,	534250,	535250}},
{"30",	{567250,	259250,	258000,	0,	265250,	543250,	543250,	0,	0,	541250,	543250}},
{"31",	{573250,	265250,	264000,	0,	271250,	551250,	551250,	0,	0,	548250,	551250}},
{"32",	{579250,	271250,	270000,	0,	277250,	559250,	559250,	0,	0,	555250,	559250}},
{"33",	{585250,	277250,	276000,	0,	283250,	567250,	567250,	0,	0,	562250,	567250}},
{"34",	{591250,	283250,	282000,	0,	289250,	575250,	575250,	0,	0,	569250,	575250}},
{"35",	{597250,	289250,	288000,	0,	295250,	583250,	583250,	0,	0,	576250,	583250}},
{"36",	{603250,	295250,	294000,	0,	301250,	591250,	591250,	0,	0,	0,	591250}},
{"37",	{609250,	301250,	300000,	0,	307250,	599250,	599250,	0,	0,	0,	599250}},
{"38",	{615250,	307250,	306000,	0,	313250,	607250,	607250,	0,	0,	0,	607250}},
{"39",	{621250,	313250,	312000,	0,	319250,	615250,	615250,	0,	0,	604250,	615250}},
{"40",	{627250,	319250,	318000,	0,	325250,	623250,	623250,	0,	0,	611250,	623250}},
{"41",	{633250,	325250,	324000,	0,	331250,	631250,	631250,	0,	0,	618250,	631250}},
{"42",	{639250,	331250,	330000,	0,	337250,	639250,	639250,	0,	0,	625250,	639250}},
{"43",	{645250,	337250,	336000,	0,	343250,	647250,	647250,	0,	0,	632250,	647250}},
{"44",	{651250,	343250,	342000,	0,	349250,	655250,	655250,	0,	0,	639250,	655250}},
{"45",	{657250,	349250,	348000,	663250,	355250,	663250,	663250,	0,	0,	646250,	663250}},
{"46",	{663250,	355250,	354000,	669250,	361250,	671250,	671250,	0,	0,	653250,	671250}},
{"47",	{669250,	361250,	360000,	675250,	367250,	679250,	679250,	0,	0,	660250,	679250}},
{"48",	{675250,	367250,	366000,	681250,	373250,	687250,	687250,	0,	0,	667250,	687250}},
{"49",	{681250,	373250,	372000,	687250,	379250,	695250,	695250,	0,	0,	674250,	695250}},
{"50",	{687250,	379250,	378000,	693250,	385250,	703250,	703250,	0,	0,	681250,	703250}},
{"51",	{693250,	385250,	384000,	699250,	391250,	711250,	711250,	0,	0,	688250,	711250}},
{"52",	{699250,	391250,	390000,	705250,	397250,	719250,	719250,	0,	0,	695250,	719250}},
{"53",	{705250,	397250,	396000,	711250,	403250,	727250,	727250,	0,	0,	702250,	727250}},
{"54",	{711250,	403250,	402000,	717250,	409250,	735250,	735250,	0,	0,	709250,	735250}},
{"55",	{717250,	409250,	408000,	723250,	415250,	743250,	743250,	0,	0,	716250,	743250}},
{"56",	{723250,	415250,	414000,	729250,	421250,	751250,	751250,	0,	0,	723250,	751250}},
{"57",	{729250,	421250,	420000,	735250,	427250,	759250,	759250,	0,	0,	730250,	759250}},
{"58",	{735250,	427250,	426000,	741250,	433250,	767250,	767250,	0,	0,	737250,	767250}},
{"59",	{741250,	433250,	432000,	747250,	439250,	775250,	775250,	0,	0,	744250,	775250}},
{"60",	{747250,	439250,	438000,	753250,	445250,	783250,	783250,	0,	0,	751250,	783250}},
{"61",	{753250,	445250,	444000,	759250,	451250,	791250,	791250,	0,	0,	758250,	791250}},
{"62",	{759250,	451250,	450000,	765250,	457250,	799250,	799250,	0,	0,	765250,	799250}},
{"63",	{765250,	457250,	456000,	0,	463250,	807250,	807250,	0,	0,	772250,	807250}},
{"64",	{771250,	463250,	462000,	0,	0,	815250,	815250,	0,	0,	779250,	815250}},
{"65",	{777250,	469250,	468000,	0,	0,	823250,	823250,	0,	0,	786250,	823250}},
{"66",	{783250,	475250,	474000,	0,	0,	831250,	831250,	0,	0,	793250,	831250}},
{"67",	{789250,	481250,	480000,	0,	0,	839250,	839250,	0,	0,	800250,	839250}},
{"68",	{795250,	487250,	486000,	0,	0,	847250,	847250,	0,	0,	807250,	847250}},
{"69",	{801250,	493250,	492000,	0,	0,	855250,	855250,	0,	0,	814250,	855250}},
 
{"70",	{807250,	499250,	498000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"71",	{813250,	505250,	504000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"72",	{819250,	511250,	510000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"73",	{825250,	517250,	516000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"74",	{831250,	523250,	522000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"75",	{837250,	529250,	528000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"76",	{843250,	535250,	534000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"77",	{849250,	541250,	540000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"78",	{855250,	547250,	546000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"79",	{861250,	553250,	552000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"80",	{867250,	559250,	558000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"81",	{873250,	565250,	564000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"82",	{879250,	571250,	570000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"83",	{885250,	577250,	576000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"84",	{     0,	583250,	582000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"85",	{     0,	589250,	588000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"86",	{     0,	595250,	594000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"87",	{     0,	601250,	600000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"88",	{     0,	607250,	606000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"89",	{     0,	613250,	612000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"90",	{     0,	619250,	618000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"91",	{     0,	625250,	624000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"92",	{     0,	631250,	630000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"93",	{     0,	637250,	636000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"94",	{     0,	643250,	642000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"95",	{     0,	91250,	900000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"96",	{     0,	97250,	960000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"97",	{     0,	103250,	102000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"98",	{     0,	109250,	108000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"99",	{     0,	115250,	114000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"100",	{     0,	649250,	648000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"101",	{     0,	655250,	654000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"102",	{     0,	661250,	660000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"103",	{     0,	667250,	666000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"104",	{     0,	673250,	672000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"105",	{     0,	679250,	678000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"106",	{     0,	685250,	684000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"107",	{     0,	691250,	690000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"108",	{     0,	697250,	696000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"109",	{     0,	703250,	702000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"110",	{     0,	709250,	708000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"111",	{     0,	715250,	714000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"112",	{     0,	721250,	720000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"113",	{     0,	727250,	726000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"114",	{     0,	733250,	732000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"115",	{     0,	739250,	738000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"116",	{     0,	745250,	744000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"117",	{     0,	751250,	750000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"118",	{     0,	757250,	756000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"119",	{     0,	763250,	762000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"120",	{     0,	769250,	768000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"121",	{     0,	775250,	774000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"122",	{     0,	781250,	780000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"123",	{     0,	787250,	786000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"124",	{     0,	793250,	792000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"125",	{     0,	799250,	798000,	0,	0,	0,	0,	0,	0,	0,	0}},
 
{"T7",	{     0,	8250,	7000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T8",	{     0,	14250,	13000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T9",	{     0,	20250,	19000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T10",	{     0,	26250,	25000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T11",	{     0,	32250,	31000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T12",	{     0,	38250,	37000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T13",	{     0,	44250,	43000,	0,	0,	0,	0,	0,	0,	0,	0}},
{"T14",	{     0,	50250,	49000,	0,	0,	0,	0,	0,	0,	0,	0}}
};

int CHAN_ENTRIES = sizeof(tvtuner)/sizeof(struct freqlist);
int CHAN_NAMES	 = 11;

struct gentab chan_names[] = {
		{ 0, "ntsc-bcast"	},
		{ 1, "ntsc-cable"	},
		{ 2, "ntsc-cable-hrc" 	},
		{ 3, "ntsc-bcast-jp"	},
		{ 4, "ntsc-cable-jp"	},
		{ 5, "pal-europe"	},
		{ 6, "pal-europe-east"	},
		{ 7, "pal-italy"	},
		{ 8, "pal-newzealand"	},
		{ 9, "pal-australia"	},
		{ 10, "pal-ireland"	},
		{ -1, NULL	}
};
