from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_MSVCRVER_TO_FULLVER = _Mock()

_START = _Mock()

_TABLE = _Mock()

_build_import_library_amd64 = _Mock()

_build_import_library_x86 = _Mock()

absolute_import = _Mock()

build_import_library = _Mock()

build_msvcr_library = _Mock()

check_embedded_msvcr_match_linked = _Mock()

configtest_name = _Mock()

distutils = _Mock()

division = _Mock()

dump_table = _Mock()

find_dll = _Mock()

find_python_dll = _Mock()

gen_lib_options = _Mock()

gen_preprocess_options = _Mock()

generate_def = _Mock()

generate_manifest = _Mock()

get_build_architecture = _Mock()

get_build_msvc_version = _Mock()

log = _Mock()

manifest_name = _Mock()

manifest_rc = _Mock()

msvc_manifest_xml = _Mock()

msvc_runtime_library = _Mock()

numpy = _Mock()

os = _Mock()

print_function = _Mock()

rc_name = _Mock()

re = _Mock()

subprocess = _Mock()

sys = _Mock()



class CompileError(_Mock):
  pass


class DistutilsExecError(_Mock):
  pass


class Mingw32CCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compiler_type = 'mingw32'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  exe_extension = '.exe'
  obj_extension = '.o'
  shared_lib_extension = '.dll'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class StrictVersion(_Mock):
  pass


class UnixCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compiler_type = 'unix'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class UnknownFileError(_Mock):
  pass


