from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ClassMcaTheory = _Mock()

ConcentrationsTool = _Mock()

ConcentrationsWidget = _Mock()

ConfigDict = _Mock()

Elements = _Mock()

ElementsInfo = _Mock()

FitParam = _Mock()

IconDict = _Mock()

McaAdvancedTable = _Mock()

McaCalWidget = _Mock()

PeakIdentifier = _Mock()

PyMcaDirs = _Mock()

PyMcaPrintPreview = _Mock()

QPyMcaMatplotlibSave1D = _Mock()

QtBlissGraph = _Mock()

QtMcaAdvancedFitReport = _Mock()

SubprocessLogWidget = _Mock()

XRFMCHelper = _Mock()

copy = _Mock()

encodings = _Mock()

main = _Mock()

numpy = _Mock()

os = _Mock()

qt = _Mock()

shutil = _Mock()

sys = _Mock()

tempfile = _Mock()

test = _Mock()

time = _Mock()

traceback = _Mock()

DEBUG = 0

MATPLOTLIB = _Mock()

QTVERSION = '4.8.6'

USE_BOLD_FONT = _Mock()

XRFMC_FLAG = _Mock()

class Line(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class McaAdvancedFit(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class McaGraphWindow(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QString(_Mock):
  pass
  KeepEmptyParts = 0
  NormalizationForm_C = 1
  NormalizationForm_D = 0
  NormalizationForm_KC = 3
  NormalizationForm_KD = 2
  SectionCaseInsensitiveSeps = 8
  SectionDefault = 0
  SectionIncludeLeadingSep = 2
  SectionIncludeTrailingSep = 4
  SectionSkipEmpty = 1
  SkipEmptyParts = 1

class SimpleThread(_Mock):
  pass
  HighPriority = 4
  HighestPriority = 5
  IdlePriority = 0
  InheritPriority = 7
  LowPriority = 2
  LowestPriority = 1
  NormalPriority = 3
  TimeCriticalPriority = 6

class Top(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

