(define (integrate-1Da L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db1 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db2 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db3 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db4 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db5 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db6 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db7 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db8 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-1Db9 L U F1 F2 F3 F4 F5 F6 F7 F8 F9)
 (let ((D (/ (- U L) 8.0)))
  (* (+ (* (F1 L) 0.5)
	(F2 (+ L D))
	(F3 (+ L (* 2.0 D)))
	(F4 (+ L (* 3.0 D)))
	(F5 (+ L (* 4.0 D)))
	(F6 (- U (* 3.0 D)))
	(F7 (- U (* 2.0 D)))
	(F8 (- U D))
	(* (F9 U) 0.5))
     D)))

(define (integrate-2D L1 U1 L2 U2
		      F11 F12 F13 F14 F15 F16 F17 F18 F19
		      F21 F22 F23 F24 F25 F26 F27 F28 F29
		      F31 F32 F33 F34 F35 F36 F37 F38 F39
		      F41 F42 F43 F44 F45 F46 F47 F48 F49
		      F51 F52 F53 F54 F55 F56 F57 F58 F59
		      F61 F62 F63 F64 F65 F66 F67 F68 F69
		      F71 F72 F73 F74 F75 F76 F77 F78 F79
		      F81 F82 F83 F84 F85 F86 F87 F88 F89
		      F91 F92 F93 F94 F95 F96 F97 F98 F99)
 (integrate-1Da
  L2 U2
  (lambda (y)
   (integrate-1Db1 L1 U1
		   (lambda (x) (F11 x y))
		   (lambda (x) (F12 x y))
		   (lambda (x) (F13 x y))
		   (lambda (x) (F14 x y))
		   (lambda (x) (F15 x y))
		   (lambda (x) (F16 x y))
		   (lambda (x) (F17 x y))
		   (lambda (x) (F18 x y))
		   (lambda (x) (F19 x y))))
  (lambda (y)
   (integrate-1Db2 L1 U1
		   (lambda (x) (F21 x y))
		   (lambda (x) (F22 x y))
		   (lambda (x) (F23 x y))
		   (lambda (x) (F24 x y))
		   (lambda (x) (F25 x y))
		   (lambda (x) (F26 x y))
		   (lambda (x) (F27 x y))
		   (lambda (x) (F28 x y))
		   (lambda (x) (F29 x y))))
  (lambda (y)
   (integrate-1Db3 L1 U1
		   (lambda (x) (F31 x y))
		   (lambda (x) (F32 x y))
		   (lambda (x) (F33 x y))
		   (lambda (x) (F34 x y))
		   (lambda (x) (F35 x y))
		   (lambda (x) (F36 x y))
		   (lambda (x) (F37 x y))
		   (lambda (x) (F38 x y))
		   (lambda (x) (F39 x y))))
  (lambda (y)
   (integrate-1Db4 L1 U1
		   (lambda (x) (F41 x y))
		   (lambda (x) (F42 x y))
		   (lambda (x) (F43 x y))
		   (lambda (x) (F44 x y))
		   (lambda (x) (F45 x y))
		   (lambda (x) (F46 x y))
		   (lambda (x) (F47 x y))
		   (lambda (x) (F48 x y))
		   (lambda (x) (F49 x y))))
  (lambda (y)
   (integrate-1Db5 L1 U1
		   (lambda (x) (F51 x y))
		   (lambda (x) (F52 x y))
		   (lambda (x) (F53 x y))
		   (lambda (x) (F54 x y))
		   (lambda (x) (F55 x y))
		   (lambda (x) (F56 x y))
		   (lambda (x) (F57 x y))
		   (lambda (x) (F58 x y))
		   (lambda (x) (F59 x y))))
  (lambda (y)
   (integrate-1Db6 L1 U1
		   (lambda (x) (F61 x y))
		   (lambda (x) (F62 x y))
		   (lambda (x) (F63 x y))
		   (lambda (x) (F64 x y))
		   (lambda (x) (F65 x y))
		   (lambda (x) (F66 x y))
		   (lambda (x) (F67 x y))
		   (lambda (x) (F68 x y))
		   (lambda (x) (F69 x y))))
  (lambda (y)
   (integrate-1Db7 L1 U1
		   (lambda (x) (F71 x y))
		   (lambda (x) (F72 x y))
		   (lambda (x) (F73 x y))
		   (lambda (x) (F74 x y))
		   (lambda (x) (F75 x y))
		   (lambda (x) (F76 x y))
		   (lambda (x) (F77 x y))
		   (lambda (x) (F78 x y))
		   (lambda (x) (F79 x y))))
  (lambda (y)
   (integrate-1Db8 L1 U1
		   (lambda (x) (F81 x y))
		   (lambda (x) (F82 x y))
		   (lambda (x) (F83 x y))
		   (lambda (x) (F84 x y))
		   (lambda (x) (F85 x y))
		   (lambda (x) (F86 x y))
		   (lambda (x) (F87 x y))
		   (lambda (x) (F88 x y))
		   (lambda (x) (F89 x y))))
  (lambda (y)
   (integrate-1Db9 L1 U1
		   (lambda (x) (F91 x y))
		   (lambda (x) (F92 x y))
		   (lambda (x) (F93 x y))
		   (lambda (x) (F94 x y))
		   (lambda (x) (F95 x y))
		   (lambda (x) (F96 x y))
		   (lambda (x) (F97 x y))
		   (lambda (x) (F98 x y))
		   (lambda (x) (F99 x y))))))

(define (zark U V)
 (integrate-2D 0.0 U 0.0 V
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))
	       (lambda (X Y) (* X Y))))

(define (r-total N)
 (do ((I 1 (+ I 1))
      (Sum 0.0 (+ Sum (zark (* I 1.0) (* I 2.0)))))
   ((> I N) Sum)))

(define (i-total N)
 (do ((I 1 (+ I 1))
      (Sum 0.0 (+ Sum (let ((I2 (* (* I I) 1.0))) (* I2 I2)))))
   ((> I N) Sum)))

(define (error-sum-of-squares N)
 (do ((I 1 (+ I 1))
      (Sum 0.0 (+ Sum (let ((E (- (r-total I) (i-total I)))) (* E E)))))
   ((> I N) Sum)))

(begin (display (error-sum-of-squares 1000)) (newline))
