var categ = [
  "Nuclear Engineering",
  "Computational Electromagnetics, Electronics, Photonics",
  "Plasma Physics",
  "Astrophysics",
  "Computational Physics, Materials Science, Electronic Structure",
  "Acoustics",
  "Computational Fluid Dynamics",
  "Earth Sciences, Oceanology, Hydrology, Geophysics",
  "Bioengineering, Computational Neuroscience, Genomics, Molecular Dynamics",
  "Structural Analysis, Mechanical Engineering",
  "Information Retrieval, Machine Learning, Graph Algorithms, Complex Networks",
  "Visualization, Computer Graphics, Image Processing",
  "PDE's, Numerical Methods",
  "Dynamical Systems, Model Reduction, Inverse Problems"
];

var nucl=0, elem=1, plas=2, astr=3, phys=4, aco=5, cfd=6, geo=7, bio=8, stru=9, info=10, visu=11, pde=12, dyn=13;

var probtype = [
  "Hermitian Eigenvalue Problem",
  "Non-Hermitian Eigenvalue Problem",
  "Structured Eigenvalue Problem",
  "Polynomial Eigenvalue Problem",
  "General Nonlinear Eigenvalue Problem",
  "Singular Value Decomposition",
  "Matrix Function",
  "Linear Matrix Equation"
];

var epsh=0, epsnh=1, epss=2, pep=3, nep=4, svd=5, mfn=6, lme=7, unk=8;

function categword(i) {
  var words = categ[i].split(" ");
  if (words[0] == "Computational") return words[1].replace(","," ").trim();
  else return words[0].replace(","," ").trim();
}

function probword(i) {
  var words = probtype[i].split(" ");
  return words[0];
}

function showapplication(i) {
  var url;
  var author = apps[i].aut;
  if (author.indexOf("et al")<0) {
    var idx = author.indexOf(" and ");
    if (idx==-1) {
      idx = author.indexOf(", ");
      if (idx>-1 && author.lastIndexOf(", ")==idx) author = author.replace(", "," and ");
    }
    if (idx>-1 && author.lastIndexOf(" and ")!=idx) author = author.slice(0,idx)+" et al.";
  }
  document.write('<li class="reference">'+author+', <em>'+apps[i].tit+'</em>, ');
  if ("pro" in apps[i]) document.write('Proceedings of '+apps[i].pro+', ');
  else if ("boo" in apps[i]) document.write('in '+apps[i].boo+', pp. '+apps[i].pag+', ');
  else if ("arx" in apps[i] && !("jou" in apps[i])) document.write('arXiv preprint, ');
  else if ("trx" in apps[i] && !("jou" in apps[i])) document.write('TechRxiv preprint, ');
  else {
    if (apps[i].jou == "TR") document.write('Tech. Rep., ');
    else if (apps[i].jou == "PP") document.write('preprint, ');
    else if (apps[i].jou == "PD") document.write('PhD thesis, ');
    else if (apps[i].jou == "MS") document.write('MSc thesis, ');
    else {
      document.write(apps[i].jou+' ');
      if (apps[i].num == "IP") document.write('(in press), ');
      else document.write(apps[i].num+', '+apps[i].pag+', ');
    }
  }
  document.write(apps[i].yr+'.\n');
  if ("doi" in apps[i]) {
    url = "https://doi.org/"+apps[i].doi;
    document.write('<a href="'+url+'" target="_blank">[DOI]</a> ');
  }
  if ("arx" in apps[i]) {
    url = "http://arxiv.org/abs/"+apps[i].arx;
    document.write('<a href="'+url+'" target="_blank">[arXiv]</a> ');
  }
  if ("trx" in apps[i]) {
    url = "https://doi.org/10.36227/techrxiv."+apps[i].trx;
    document.write('<a href="'+url+'" target="_blank">[TechRxiv]</a> ');
  }
  if ("url" in apps[i]) {
    url = apps[i].url;
    document.write('<a href="'+url+'" target="_blank">[URL]</a>');
  }
}

function listapps(cat) {
  var url;
  for (var i=0;i<apps.length;i++) {
    if (apps[i].cat == cat) {
      showapplication(i);
    }
  }
}

function listappsbyprob(cla) {
  var url;
  apps.sort(function (a,b) {
    return a.yr-b.yr;
  });
  for (var i=0;i<apps.length;i++) {
    if (apps[i].cla == cla || (cla == unk && !('cla' in apps[i]))) {
      showapplication(i);
    }
  }
}

function toggleview(fromID,toID) {
  if (document.getElementById(fromID)) {
    if (document.getElementById(fromID).style.display != 'none') {
      document.getElementById(fromID).style.display = 'none';
    }
  }
  if (document.getElementById(toID)) {
    if (document.getElementById(toID).style.display != 'block') {
      document.getElementById(toID).style.display = 'block';
    }
  }
}

function countapps(cat) {
  var k = 0;
  for (var i=0;i<apps.length;i++) {
    if (apps[i].cat == cat) k++;
  }
  return k;
}

function countprob(cla) {
  var k = 0;
  for (var i=0;i<apps.length;i++) {
    if (apps[i].cla == cla || (cla == unk && !('cla' in apps[i]))) k++;
  }
  return k;
}

var apps = [
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2007.06.007",
   tit: "Simulating control rod and fuel assembly motion using moving meshes",
   aut: "D. Gilbert et al.",
   jou: "Ann. Nucl. Energy",
   num: "35(2)",
   pag: "291-303",
   yr : 2008
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.2172/944884",
   tit: "High-order spatio-temporal schemes for coupled, multi-physics reactor simulations",
   aut: "V. S. Mahadevan and J. C. Ragusa",
   jou: "TR",
   yr : 2008
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://mathematicsandcomputation.cowhosting.net/MC09/pdfs/201961.pdf",
   tit: "Verification of multiphysics software: space and time convergence studies for nonlinearly coupled applications",
   aut: "V. Mahadevan et al.",
   pro: "M&amp;C",
   yr : 2009
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/18811248.2010.9711641",
   tit: "3D alpha modes of a nuclear power reactor",
   aut: "G. Verd&uacute; et al.",
   jou: "J. Nucl. Sci. Technol.",
   num: "47",
   pag: "501-514",
   yr : 2010
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.2172/992636",
   tit: "Neutronic / thermalhydraulic coupling techniques for sodium cooled fast reactor simulations",
   aut: "J. Ragusa et al.",
   jou: "TR",
   yr : 2010
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.pnucene.2011.10.013",
   tit: "A verification exercise in multiphysics simulations for coupled reactor physics calculations",
   aut: "V. S. Mahadevan et al.",
   jou: "Progress in Nuclear Energy",
   num: "55",
   pag: "12-32",
   yr : 2012
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1155/2013/641863",
   tit: "Unstructured grids and the multigroup neutron diffusion equation",
   aut: "G. Theler",
   jou: "Science and Technology of Nuclear Installations",
   num: "v.2013",
   pag: "ID 641863",
   yr : 2013
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://hdl.handle.net/10589/88504",
   tit: "Numerical investigation of buoyant flows in tight lattice fuel bundles",
   aut: "G. Pitton",
   jou: "PD",
   yr : 2013
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1155/2014/913043",
   tit: "Resolution of the generalized eigenvalue problem in the neutron diffusion equation discretized by the Finite Volume Method",
   aut: "&Aacute;. Bernal et al.",
   jou: "Abstract and Applied Analysis",
   num: "v.2014",
   pag: "913043",
   yr : 2014
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2014.02.002",
   tit: "Solving eigenvalue response matrix equations with nonlinear techniques",
   aut: "J. A. Roberts and B. Forget",
   jou: "Ann. Nucl. Energy",
   num: "69",
   pag: "97-107",
   yr : 2014
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://dspace.mit.edu/handle/1721.1/87497",
   tit: "The &quot;virtual density&quot; theory of neutronics",
   aut: "M. W. Reed",
   jou: "PD",
   yr : 2014
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://www.cimec.org.ar/ojs/index.php/mc/article/view/4907",
   tit: "On the design basis of a new core-level neutronic code written from scratch",
   aut: "G. Theler",
   jou: "Mec&aacute;nica Computacional",
   num: "Vol XXXIII",
   pag: "3169-3194",
   yr : 2014
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2014.05.026",
   tit: "Solution of the Lambda modes problem of a nuclear power reactor using an h-p finite element method",
   aut: "A. Vidal-Ferr&agrave;ndiz et al.",
   jou: "Ann. Nucl. Energy",
   num: "72",
   pag: "338-349",
   yr : 2014
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.cam.2015.03.040",
   tit: "Moving meshes to solve the time-dependent neutron diffusion equation in hexagonal geometry",
   aut: "A. Vidal-Ferr&agrave;ndiz et al.",
   jou: "J. Comput. Appl. Math.",
   num: "291",
   pag: "197-208",
   yr : 2016
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2015.09.002",
   tit: "A multi-physics reduced order model for the analysis of Lead Fast Reactor single channel",
   aut: "A. Sartori et al.",
   jou: "Ann. Nucl. Energy.",
   num: "87(2)",
   pag: "198-208",
   yr : 2016
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00223131.2015.1102661",
   tit: "Development of a finite volume inter-cell polynomial expansion method for the neutron diffusion equation",
   aut: "&Aacute;. Bernal et al.",
   jou: "J. Nucl. Sci. Technol.",
   num: "53(8)",
   pag: "1212-1223",
   yr : 2016
  },
  {cat: nucl,
   cla: epsh,
   doi: "10.1103/PhysRevC.93.054611",
   tit: "Fission fragment charge and mass distributions in <sup>239</sup>Pu(n,f) in the adiabatic nuclear energy density functional theory",
   aut: "D. Regnier et al.",
   jou: "Phys. Rev. C",
   num: "93",
   pag: "054611",
   yr : 2016
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.4995/Thesis/10251/65353",
   tit: "Approximation of the neutron diffusion equation on hexagonal geometries using a h-p finite element method",
   aut: "R. Fayez Moustafa",
   jou: "PD",
   yr : 2016
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2016.06.023",
   tit: "Assembly discontinuity factors for the neutron diffusion equation discretized with the finite volume method. Application to BWR",
   aut: "&Aacute;. Bernal et al.",
   jou: "Ann. Nucl. Energy",
   num: "97",
   pag: "76-85",
   yr : 2016
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.cam.2016.02.056",
   tit: "Schwarz type preconditioners for the neutron diffusion equation",
   aut: "A. Vidal-Ferr&agrave;ndiz et al.",
   jou: "J. Comput. Appl. Math.",
   num: "309",
   pag: "563-574",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2016.09.021",
   tit: "Spectral properties of dynamic processes in a nuclear reactor",
   aut: "A. V. Avvakumov et al.",
   jou: "Ann. Nucl. Energy",
   num: "99",
   pag: "68-79",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00223131.2017.1344577",
   tit: "A Krylov-Schur solution of the eigenvalue problem for the neutron diffusion equation discretized with the Raviart-Thomas method",
   aut: "&Aacute;. Bernal et al.",
   jou: "J. Nucl. Sci. Technol.",
   num: "54(10)",
   pag: "1085-1094",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2017.08.018",
   tit: "Spatial modes for the neutron diffusion equation and their computation",
   aut: "A. Carre&ntilde;o et al.",
   jou: "Ann. Nucl. Energy",
   num: "110",
   pag: "1010-1022",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00223131.2017.1359120",
   tit: "Multigroup Neutron Diffusion Equation with the Finite Volume Method in reactors using MOX fuels",
   aut: "&Aacute;. Bernal et al.",
   jou: "J. Nucl. Sci. Technol.",
   num: "54(11)",
   pag: "1251-1260",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://ansannual.org/wp-content/data/polopoly_fs/1.3584300.1494346998!/fileserver/file/768242/filename/214.pdf",
   tit: "Calculation of higher eigenpairs of the transport equation using IRAM based on domain decomposition",
   aut: "W. Wu et al.",
   pro: "ANS Annual Meeting",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1007/978-3-319-73441-5_47",
   tit: "Solution of the 3D neutron diffusion benchmark by FEM",
   aut: "A. V. Avvakumov et al.",
   pro: "LSSC",
   yr : 2017
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.pnucene.2018.02.027",
   arx: "1706.05226",
   tit: "State change modal method for numerical simulation of dynamic processes in a nuclear reactor",
   aut: "A. V. Avvakumov et al.",
   jou: "Prog. Nucl. Energy",
   num: "106",
   pag: "240-261",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2017.09.028",
   tit: "&quot;Virtual density&quot; and traditional boundary perturbation theories: Analytic equivalence and numeric comparison",
   aut: "M. Reed et al.",
   jou: "Ann. Nucl. Energy",
   num: "112",
   pag: "531-548",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2017.09.023",
   tit: "The &quot;virtual density&quot; theory of neutronics",
   aut: "M. Reed et al.",
   jou: "Ann. Nucl. Energy",
   num: "112",
   pag: "549-596",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2017.12.002",
   tit: "Numerical analysis of the 2D C5G7 MOX benchmark using P<sub>L</sub> equations and a nodal collocation method",
   aut: "M. T. Capilla et al.",
   jou: "Ann. Nucl. Energy",
   num: "114",
   pag: "32-41",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2018.01.021",
   tit: "Coupled unstructured fine-mesh neutronics and thermal-hydraulics methodology using open software: A proof-of-concept",
   aut: "V. Vasconcelos et al.",
   jou: "Ann. Nucl. Energy",
   num: "115",
   pag: "173-185",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.pnucene.2018.02.006",
   tit: "Calculation of multiple eigenvalues of the neutron diffusion equation discretized with a parallelized finite volume method",
   aut: "A. Bernal et al.",
   jou: "Prog. Nucl. Energy",
   num: "105",
   pag: "271-278",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   url: "http://hdl.handle.net/10251/98522",
   tit: "Development of a finite element method for neutron transport equation approximations",
   aut: "A. Vidal Ferr&agrave;ndiz",
   jou: "PD",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1007/978-3-319-93701-4_65",
   tit: "Optimized eigenvalue solvers for the neutron transport equation",
   aut: "A. Vidal-Ferr&agrave;ndiz et al.",
   pro: "ICCS",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.4995/Thesis/10251/112422",
   tit: "Development of a 3D modal neutron code with the Finite Volume Method for the diffusion and discrete ordinates transport equations. Application to nuclear safety analyses",
   aut: "A. Bernal",
   jou: "PD",
   yr : 2018
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.3390/mca24010009",
   tit: "Block preconditioning matrices for the Newton method to compute the dominant &lambda;-modes associated with the neutron diffusion equation",
   aut: "A. Carre&ntilde;o, L. Bergamaschi, A. Martinez, A. Vidal-Ferrandiz, D. Ginestar, G. Verdu",
   jou: "Math. Comput. Appl.",
   num: "24(1)",
   pag: "9",
   yr : 2019
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.pnucene.2019.03.040",
   tit: "Modal methods for the neutron diffusion equation using different spatial modes",
   aut: "A. Carre&ntilde;o, A. Vidal-Ferrandiz, D. Ginestar, G. Verdu",
   jou: "Prog. Nucl. Energy",
   num: "115",
   pag: "181-193",
   yr : 2019
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1299/jsmeicone.2019.27.1613",
   tit: "Application of Newton based methods in steady diffusion problem for HTR-PM",
   aut: "Y. Wu, Y. Wang, J. Niu, J. Guo, F. Li",
   pro: "ICONE27",
   yr : 2019
  },
  {cat: nucl,
   cla: epsnh,
   arx: "1903.11502",
   tit: "Numerical modeling of neutron transport in SP3 approximation by finite element method",
   aut: "A. V. Avvakumov, V. F. Strizhov, P. N. Vabishchevich, A. O. Vasilev",
   yr : 2019
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2019.107077",
   tit: "Calculation of &lambda; modes of the multi-group neutron transport equation using the discrete ordinates and Finite Difference Method",
   aut: "S. Morat&oacute;, &Aacute;. Bernal, R. Mir&oacute;, J. E. Roman, G. Verd&uacute;",
   jou: "Ann. Nucl. Energy",
   num: "137",
   pag: "107077",
   yr : 2020
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.4995/Thesis/10251/144771",
   tit: "Integration methods for the time dependent neutron diffusion equation and other approximations of the neutron transport equation",
   aut: "A. Carre&ntilde;o",
   jou: "PD",
   yr : 2020
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1007/s41365-020-00781-y",
   tit: "Calculation of effective point reactor kinetic parameters combined with the Galerkin finite element method",
   aut: "B.-X. Yuan, W.-K. Yang, S.-B. Zhang, J.-X. Wei, Y.-J. Ying",
   jou: "Nucl. Sci. Tech.",
   num: "31",
   pag: "69",
   yr : 2020
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.4995/Thesis/10251/159271",
   tit: "Contributions to solve the multi-group neutron transport equation with different angular approaches",
   aut: "S. Morat&oacute;",
   jou: "PD",
   yr : 2020
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1137/19M1249060",
   tit: "A highly parallel multilevel Newton--Krylov--Schwarz method with subspace-based coarsening and partition-based balancing for the multigroup neutron transport equation on three-dimensional unstructured meshes",
   aut: "F. Kong, Y. Wang, D. Gaston, C. J. Permann, A. E. Slaughter, A. D. Lindsay, M. D. DeHart, R. C. Martineau",
   jou: "SIAM J. Sci. Comput.",
   num: "42(5)",
   pag: "C193-C220",
   yr : 2020
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/23324309.2020.1856879",
   tit: "Eigenvalue formulations for the P<sub>N</sub> approximation to the neutron transport equation",
   aut: "N. Abrate, M. Burrone, S. Dulla, P. Ravetto, P. Saracco",
   jou: "J. Comput. Theor. Transport",
   num: "50",
   pag: "407-429",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2020.108074",
   tit: "Lambda modes comparison for different approximations of the neutron transport equation: Diffusion, SN and SP3",
   aut: "S. Morat&oacute;, B. Kochunas, R. Mir&oacute;, G. Verd&uacute;, E. W. Larsen, T. Downar",
   jou: "Ann. Nucl. Energy",
   num: "154",
   pag: "108074",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1051/epjconf/202124702023",
   tit: "A simplified two-node coarse-mesh finite difference method for pin-wise calculation with SP3",
   aut: "W. Zhao et al.",
   jou: "EPJ Web of Conferences",
   num: "247",
   pag: "02023",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.net.2021.06.010",
   tit: "Time-dependent simplified spherical harmonics formulations for a nuclear reactor system",
   aut: "A. Carre&ntilde;o, A. Vidal-Ferrandiz, D. Ginestar, G. Verdu",
   jou: "Nucl. Eng. Tech.",
   num: "53(12)",
   pag: "3861-3878",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00295450.2020.1843348",
   tit: "Rattlesnake: a MOOSE-based multiphysics multischeme radiation transport application",
   aut: "Y. Wang, S. Schunert, J. Ortensi, V. Laboure, M. DeHart, Z. Prince, F. Kong, J. Harter, P. Balestra, F. Gleicher",
   jou: "Nucl. Tech.",
   num: "207(7)",
   pag: "1047-1072",
   yr : 2021
  },
  {cat: nucl,
   cla: svd,
   doi: "10.3390/en14051350",
   tit: "Reduced-order modelling applied to the multigroup neutron diffusion equation using a nonlinear interpolation method for control-rod movement",
   aut: "C. E. Heaney, A. G. Buchan, C. C.  Pain, S. Jewer",
   jou: "Energies",
   num: "14",
   pag: "1350",
   yr : 2021
  },
  {cat: nucl,
   cla: epsh,
   url: "https://www.researchgate.net/publication/352363237",
   doi: "10.1007/978-981-16-0182-8_29",
   tit: "Automated modeling of swaged Reissner-Mindlin plates using FEniCS",
   aut: "G. Verma, S. Sengupta, S. Mammen, S. Bhattacharya",
   boo: "Next Generation Materials and Processing Technologies",
   pag: "385-395",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   url: "https://inldigitallibrary.inl.gov/sites/sti/sti/Sort_50897.pdf",
   tit: "Performance improvements to the Griffin transport solvers",
   aut: "Y. Wang et al.",
   jou: "TR",
   yr : 2021
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2021.108849",
   tit: "A nodal method based on CMFD for pin-by-pin SP3 calculation",
   aut: "W. Zhao et al.",
   jou: "Ann. Nucl. Energy",
   num: "167",
   pag: "108849",
   yr : 2022
  },
  {cat: nucl,
   cla: epsnh,
   url: "https://hdl.handle.net/2097/42008",
   tit: "On model-order reduction in neutronic systems via POD-Galerkin projection",
   aut: "R. Elzohery",
   jou: "PD",
   yr : 2022
  },
  {cat: nucl,
   cla: epsnh,
   url: "https://www.lib.ncsu.edu/resolver/1840.20/39687",
   tit: "Multiphysics modeling of microreactors with unstructured mesh neutron transport and exascale computing architectures",
   aut: "W. C. Dawn",
   jou: "PD",
   yr : 2022
  },
  {cat: nucl,
   cla: epsnh,
   url: "https://www.proquest.com/openview/6869906cc22cff5c58c7de2e9bb2a0be",
   tit: "Reduced-order modeling of neutron transport by proper generalized decomposition",
   aut: "K. A. Dominesey",
   jou: "PD",
   yr : 2022
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1115/1.4055379",
   tit: "Solution of neutron diffusion problems by Discontinuous Galerkin Finite Element Method with consideration of discontinuity factors",
   aut: "L. Wanai, G. Helin, Z. Chunyu",
   jou: "ASME J. Nuclear Rad. Sci.",
   num: "9(3)",
   pag: "031503",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2022.109674",
   tit: "A non-intrusive reduced order model for the characterisation of the spatial power distribution in large thermal reactors",
   aut: "N. Abrate, S. Dulla, N. Pedroni",
   jou: "Ann. Nucl. Energy",
   num: "184",
   pag: "109674",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00295639.2022.2134685",
   tit: "A generalized eigenvalue formulation for core-design applications",
   aut: "N. Abrate, S. Dulla, P. Ravetto, P. Saracco",
   jou: "Nucl. Sci. Engin.",
   num: "197",
   pag: "8",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.jcp.2023.112137",
   tit: "Reduced-order modeling of neutron transport eigenvalue problems separated in energy by Proper Generalized Decomposition",
   aut: "K. A. Dominesey, W. Ji",
   jou: "J. Comput. Phys.",
   num: "486",
   pag: "112137",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2023.110024",
   tit: "Strengths and weaknesses of the modal expansion method for perturbations calculations in nuclear reactor physics",
   aut: "T. Sauzedde, P. Archier, F. Nguyen",
   jou: "Ann. Nucl. Energy",
   num: "193",
   pag: "110024",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2023.110239",
   tit: "FEMFFUSION and its verification using the C5G7 benchmark",
   aut: "Y. Fontenla, A. Vidal-Ferrandiz, A. Carre&ntilde;o, D. Ginestar, G. Verdu",
   jou: "Ann. Nucl. Energy",
   num: "196",
   pag: "110239",
   yr : 2023
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2023.110291",
   tit: "Deterministic neutron transport and burnup code coupling assessment",
   aut: "A. Vivancos, R. Mir&oacute;, T. Barrachina, &Aacute;. Bernal, G. Verd&uacute;",
   jou: "Ann. Nucl. Energy",
   num: "198",
   pag: "110291",
   yr : 2024
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2024.110675",
   tit: "Development of a diffusive simplified double P<sub>N</sub> approximation to the neutron transport equation",
   aut: "A. Carre&ntilde;o, A. Vidal-Ferrandiz, D. Ginestar, G. Verdu",
   jou: "Ann. Nucl. Energy",
   num: "207",
   pag: "110675",
   yr : 2024
  },
  {cat: nucl,
   cla: epsnh,
   url: "https://inldigitallibrary.inl.gov/sites/sti/sti/Sort_70701.pdf",
   tit: "Initial demonstration of new Griffin technologies for simulating the running-in phase of pebble-bed reactors",
   aut: "J. Hanophy, H. Park, V. Laboure, Y. S. Junt, S. Schunert, Y. Wang, J. Ortensi",
   jou: "TR",
   yr : 2024
  },
  {cat: nucl,
   url: "https://ricabib.cab.cnea.gov.ar/1272",
   tit: "Transporte de neutrones en la nube",
   aut: "G. Theler",
   jou: "PD",
   yr : 2024
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1016/j.anucene.2024.110917",
   tit: "Griffin: A MOOSE-based reactor physics application for multiphysics simulation of advanced nuclear reactors",
   aut: "Y. Wang et al.",
   jou: "Ann. Nucl. Energy",
   num: "211",
   pag: "110917",
   yr : 2024
  },
  {cat: nucl,
   url: "https://escholarship.org/uc/item/25b500p4",
   tit: "Identification of the operational conditions and limits of TRISO fuel particles in pebble bed reactors",
   aut: "T. Siaraferas",
   jou: "PD",
   yr : 2024
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.32523/2306-6172-2025-13-1-154-168",
   tit: "A multiscale model reduction procedure for neutron transport problems",
   aut: "D. A. Spiridonov",
   jou: "Eurasian J. Math. Comput. Appl.",
   num: "13(1)",
   pag: "154-168",
   yr : 2025
  },
  {cat: nucl,
   cla: epsnh,
   doi: "10.1080/00295639.2025.2561327",
   tit: "INSL-FLASH: A fission response function based low-cost adaptive reactor physics code for high-fidelity simulation",
   aut: "D. He et al",
   jou: "Nucl. Sci. Engin.",
   num: "IP",
   yr : 2025
  },
  {cat: nucl,
   cla: epsnh,
   arx: "2510.05368",
   tit: "Finite element analysis of an eigenvalue problem arising from neutron transport",
   aut: "N. A. Barnafi, F. Lepe, F. Muñoz Riquelme",
   yr : 2025
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1016/j.spmi.2007.03.011",
   tit: "TiberCAD: A new multiscale simulator for electronic and optoelectronic devices",
   aut: "M. Auf der Maur et al.",
   jou: "Superlattices and Microstructures",
   num: "41",
   pag: "381-385",
   yr : 2007
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1109/JLT.2008.917039",
   tit: "Analysis of the TE-pass or TM-pass metal-clad polarizer with a resonant buffer layer",
   aut: "G. Li and A. Xu",
   jou: "J. Lightwave Tech.",
   num: "26(10)",
   pag: "1234-1241",
   yr : 2008
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1364/OE.16.008532",
   tit: "Bend performance-enhanced photonic crystal fibers with anisotropic numerical aperture",
   aut: "B. G. Ward",
   jou: "Opt. Express",
   num: "16",
   pag: "8532-8548",
   yr : 2008
  },
  {cat: elem,
   cla: epsnh,
   url: "http://hdl.handle.net/10261/25847",
   tit: "Spatial structures and information processing in nonlinear optical cavities",
   aut: "A. Jacobo",
   jou: "PD",
   yr : 2009
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1109/ACTEA.2009.5227880",
   tit: "A software platform for nanoscale device simulation and visualization",
   aut: "M. Gayer and G. Iannaccone",
   pro: "ACTEA",
   yr : 2009
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1016/j.jcp.2010.08.003",
   tit: "Preconditioning bandgap eigenvalue problems in three-dimensional photonic crystals simulations",
   aut: "T.-M. Huang et al.",
   jou: "J. Comput. Phys.",
   num: "229(23)",
   pag: "8684-8703",
   yr : 2010
  },
  {cat: elem,
   cla: epsnh,
   url: "http://hal.archives-ouvertes.fr/tel-00567213",
   tit: "Design and numerical modelling of integrated optical components",
   aut: "W. Smigaj",
   jou: "PD",
   yr : 2010
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1364/OE.19.011852",
   tit: "Solid-core photonic bandgap fibers for cladding-pumped Raman amplification",
   aut: "B. Ward",
   jou: "Opt. Express",
   num: "19(12)",
   pag: "11852-11866",
   yr : 2011
  },
  {cat: elem,
   cla: pep,
   doi: "10.1364/OE.19.019027",
   url: "https://www.scribd.com/document/322444695/Complex-k-Band-Diagrams-of-3D-Metamaterial-photonic-Crystals",
   tit: "Complex <i>k</i> band diagrams of 3D metamaterial/photonic crystals",
   aut: "C. Fietz, Y. Urzhumov, G. Shvets",
   jou: "Opt. Express",
   num: "19(20)",
   pag: "19027-19041",
   yr : 2011
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1109/TED.2011.2114666",
   tit: "The multiscale paradigm in electronic device simulation",
   aut: "M. Auf der Maur et al.",
   jou: "IEEE T. Electron Dev.",
   num: "58(5)",
   pag: "1425-1432",
   yr : 2011
  },
  {cat: elem,
   cla: epsh,
   url: "http://accelconf.web.cern.ch/AccelConf/ICAP2012/papers/frsac2.pdf",
   tit: "Comparison of eigenvalue solvers for large sparse matrix pencils",
   aut: "F. Yaman el al.",
   pro: "ICAP",
   yr : 2012
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1364/OE.20.018238",
   tit: "Experimental verification of spoof surface plasmons in wire metamaterials",
   aut: "Y. Kushiyama el al.",
   jou: "Opt. Express",
   num: "20(16)",
   pag: "18238-18247",
   yr : 2012
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1137/120865914",
   tit: "Coupled mode equation modeling for out-of-plane gap solitons in 2D photonic crystals",
   aut: "T. Dohnal and W. D&ouml;rfler",
   jou: "Multiscale Model. Simul.",
   num: "11(1)",
   pag: "162-191",
   yr : 2013
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1007/s10915-012-9646-z",
   tit: "Computing extremal eigenvalues for three-dimensional photonic crystals with wave vectors near the Brillouin zone center",
   aut: "T.-M. Huang el al.",
   jou: "J. Sci. Comput.",
   num: "55(3)",
   pag: "529-551",
   yr : 2013
  },
  {cat: elem,
   cla: epsnh,
   url: "http://essay.utwente.nl/65072",
   tit: "Discontinuous Galerkin finite element methods for photonic crystals",
   aut: "F. Brink",
   jou: "MS",
   yr : 2013
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1002/mmce.20746",
   tit: "Application of a multiline material characterization method to inkjet printed electronics",
   aut: "H. P. Sillamp&auml;&auml; et al.",
   jou: "Int. J. RF and Microwave CAE",
   num: "24(2)",
   pag: "177-183",
   yr : 2014
  },
  {cat: elem,
   cla: epsnh,
   url: "https://pastel.archives-ouvertes.fr/tel-01080899/file/Nicolas_Bachelard_thesis.pdf",
   tit: "Control of passive and active open random media: theoretical and experimental investigations",
   aut: "N. Bachelard",
   jou: "PD",
   yr : 2014
  },
  {cat: elem,
   cla: epsh,
   arx: "1408.6003",
   tit: "3D full-band, atomistic quantum transport in n-Si junction less nanowire field-effect transistors",
   aut: "B. Bishnoi et al.",
   yr : 2014
  },
  {cat: elem,
   cla: pep,
   doi: "10.1002/jnm.1997",
   tit: "Numerical optimization of a waveguide transition using finite element beam propagation",
   aut: "W. D&ouml;rfler and S. Findeisen",
   jou: "Int. J. Numer. Model. El.",
   num: "28(2)",
   pag: "201-212",
   yr : 2015
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1021/nl503809c",
   tit: "Room temperature observation of quantum confinement in single InAs nanowires",
   aut: "E. Halpern et al.",
   jou: "Nano Lett.",
   num: "15(1)",
   pag: "481-485",
   yr : 2015
  },
  {cat: elem,
   cla: pep,
   url: "http://metaconferences.org/ocs/public/conferences/9/pdf/3395.pdf",
   tit: "Numerical modal analysis in dispersive and dissipative plasmonic structures",
   aut: "Y. Br&ucirc;l&eacute; et al.",
   pro: "META",
   yr : 2015
  },
  {cat: elem,
   cla: epsh,
   url: "http://in4.iue.tuwien.ac.at/pdfs/iwce/iwce18_2015/IWCE_2015_139-140.pdf",
   tit: "Low temperature electrostatic simulations of realistic large-scale structures",
   aut: "H. Sahasrabudhe el al.",
   pro: "IWCE",
   yr : 2015
  },
  {cat: elem,
   cla: epsnh,
   url: "http://hdl.handle.net/2268/192527",
   tit: "Efficient methods for large-scale time-harmonic wave simulations",
   aut: "N. Marsic",
   jou: "PD",
   yr : 2015
  },
  {cat: elem,
   cla: pep,
   doi: "10.1364/JOSAB.33.000691",
   tit: "Calculation and analysis of complex band structure in dispersive and dissipative two-dimensional photonic crystals",
   aut: "Y. Br&ucirc;l&eacute; et al.",
   jou: "J. Opt. Soc. Am. B",
   num: "33(4)",
   pag: "691-702",
   yr : 2016
  },
  {cat: elem,
   cla: pep,
   url: "https://nanophoton2016.sciencesconf.org/data/pages/book_nanophoton2016_en.pdf",
   tit: "Resonances in frequency dispersive electromagnetic structures: Auxiliary fields and numerical linearization",
   aut: "G. Dem&eacute;sy et al.",
   pro: "CompNano",
   yr : 2016
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1109/TED.2016.2616370",
   tit: "Finite element modeling of Fowler-Nordheim program-erase process in high-k interpoly dielectric flash memories",
   aut: "A. Mahajan et al.",
   jou: "IEEE Trans. Electron Devices",
   num: "63(12)",
   pag: "4729-4736",
   yr : 2016
  },
  {cat: elem,
   cla: epsnh,
   url: "http://tuprints.ulb.tu-darmstadt.de/6216/",
   tit: "Liquid crystals towards Terahertz: characterisation and tunable waveguide phase shifters for millimetre-wave and Terahertz beamsteering antennas",
   aut: "C. J. M. Weickhmann",
   jou: "PD",
   yr : 2017
  },
  {cat: elem,
   cla: pep,
   doi: "10.1117/12.2265036",
   tit: "Quasimode computation in structures including several dispersive materials",
   aut: "G. Dem&eacute;sy et al.",
   pro: "Metamaterials XI",
   yr : 2017
  },
  {cat: elem,
   cla: epsh,
   url: "https://www.proquest.com/openview/3944c5c12f31c7084084a18a8278a80b",
   tit: "Fast band-structure computation for phononic and electronic waves in crystals",
   aut: "D. Krattiger",
   jou: "PD",
   yr : 2017
  },
  {cat: elem,
   cla: pep,
   doi: "10.1109/TED.2017.2757018",
   tit: "Finite-element modeling of retention in nanocrystal flash memories with high-k interpoly dielectric stack",
   aut: "R. Solanki et al.",
   jou: "IEEE Trans. Electron Devices",
   num: "64(12)",
   pag: "4897-4903",
   yr : 2017
  },
  {cat: elem,
   cla: epsnh,
   url: "http://www.dbpia.co.kr/Article/NODE07252707",
   tit: "A study on the eigen-modes of square PCF depending on wave numbers",
   aut: "Y. M. Kim",
   jou: "IEIE Trans. Smart Proc. Comput.",
   num: "6(5)",
   pag: "oct",
   yr : 2017
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1088/1367-2630/aab6fd",
   tit: "Modal analysis of the ultrahigh finesse Haroche QED cavity",
   aut: "N. Marsic et al.",
   jou: "New J. Phys.",
   num: "20(4)",
   pag: "043058",
   yr : 2018
  },
  {cat: elem,
   cla: epsh,
   doi: "10.1016/j.apm.2018.03.019",
   tit: "Nested 2D finite-element function-spaces formulation for the mode-matching problem of arbitrary cross-section waveguide devices",
   aut: "J. C&oacute;rcoles et al.",
   jou: "Appl. Math. Model.",
   num: "60",
   pag: "286-299",
   yr : 2018
  },
  {cat: elem,
   cla: nep,
   arx: "1807.02355",
   doi: "10.1364/OL.43.005813",
   tit: "Photonics in highly dispersive media: The exact modal expansion",
   aut: "F. Zolla, A. Nicolet, G. Dem&eacute;sy.",
   jou: "Opt. Lett.",
   num: "43",
   pag: "5813-5816",
   yr : 2018
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1364/LAOP.2018.Tu4A.22",
   tit: "Development of high-order H(curl; &Omega;)-conforming approximation spaces for photonic waveguide analysis",
   aut: "F. T. Orlandini et al.",
   pro: "LAOP",
   yr : 2018
  },
  {cat: elem,
   cla: pep,
   doi: "10.1109/SISPAD.2018.8551637",
   tit: "Modeling and finite element simulation of gate leakage in cylindrical GAA nanowire FETs",
   aut: "A. Mahajan et al.",
   pro: "SISPAD",
   yr : 2018
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1063/1.5052270",
   tit: "Cavity electrodynamics with Hermite interpolation: Role of symmetry and degeneracies",
   aut: "S. Pandey et al.",
   jou: "J. Appl. Phys.",
   num: "124",
   pag: "213106",
   yr : 2018
  },
  {cat: elem,
   cla: epsnh,
   url: "http://repositorio.unicamp.br/jspui/handle/REPOSIP/332927",
   tit: "A study on the construction of H(curl; &Omega;)-conforming elements and their application on waveguide problems",
   aut: "F. T. Orlandini",
   jou: "MS",
   yr : 2018
  },
  {cat: elem,
   cla: nep,
   arx: "1811.11751",
   doi: "10.1364/JOSAA.36.000686",
   tit: "Quasinormal mode solvers for resonators with dispersive materials",
   aut: "P. Lalanne et al.",
   jou: "J. Opt. Soc. Am. A",
   num: "36",
   pag: "686",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   arx: "1812.02212",
   doi: "10.1117/12.2509738",
   tit: "Fully tensorial elastic-wave mode solver for stimulated Brillouin scattering simulations in integrated photonics",
   aut: "M. Malinowski and S. Fathpour",
   pro: "SPIE 10912, Physics and Simulation of Optoelectronic Devices XXVII",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1016/j.cam.2018.11.004",
   tit: "Modelling the propagation of electromagnetic waves across complex metamaterials in closed structures",
   aut: "J. V. Balbastre and L. Nu&ntilde;o",
   jou: "J. Comput. Appl. Math.",
   num: "352",
   pag: "40-49",
   yr : 2019
  },
  {cat: elem,
   cla: pep,
   doi: "10.1016/j.wavemoti.2019.02.001",
   tit: "Inverse metamaterial design for controlling band gaps in scalar wave problems",
   aut: "H. Goh and L. F. Kallivokas",
   jou: "Wave Motion",
   num: "88",
   pag: "85-105",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.11648/j.jeee.20190701.15",
   tit: "A study on the contribution of a buffer coated with a perfect conductor to constructing eigenmodes in square HAPCF",
   aut: "Y. M. Kim",
   jou: "J. Elec. Electron. Engin.",
   num: "7(1)",
   pag: "36-41",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1109/JQE.2019.2907368",
   tit: "Fully-tensorial modeling of stimulated Brillouin scattering in photonic waveguides",
   aut: "M. Malinowski and S. Fathpour",
   jou: "IEEE J. Quantum Elec.",
   num: "55(3)",
   pag: "1-7",
   yr : 2019
  },
  {cat: elem,
   cla: nep,
   doi: "10.1117/12.2520731",
   tit: "The exact dispersive quasi-normal mode (DQNM) expansion for photonic structures with highly dispersive media in unbounded geometries",
   aut: "M. D. Truong, G. Dem&eacute;sy, F. Zolla, A. Nicolet",
   pro: "Metamaterials XII",
   yr : 2019
  },
  {cat: elem,
   cla: epsh,
   url: "https://ieeexplore.ieee.org/abstract/document/8740220",
   tit: "Algorithmic implementation of a hybrid 2D finite element - mode matching method based on nested function spaces",
   aut: "J. C&oacute;rcoles, J. A. Ruiz-Cruz, R. V. Haro-Baez",
   pro: "13th European Conference on Antennas and Propagation",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   url: "https://escholarship.org/uc/item/0rk5k87g",
   tit: "A hierarchical approach to the design and optimization of photonics",
   aut: "A. Michaels",
   jou: "PD",
   yr : 2019
  },
  {cat: elem,
   cla: pep,
   doi: "10.1061/(ASCE)EM.1943-7889.0001688",
   tit: "Group velocity-driven inverse metamaterial design",
   aut: "H. Goh and L. F. Kallivokas",
   jou: "J. Eng. Mech.",
   num: "145(12)",
   pag: "04019094",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   url: "http://hdl.handle.net/10486/688659",
   tit: "Contribution to the efficient modeling and design of passive waveguide devices through methods based on modal decompositions of electromagnetic fields in unconventional geometries",
   aut: "A. Mor&aacute;n L&oacute;pez",
   jou: "PD",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1109/OMN.2019.8925157",
   tit: "A high-precision FEM scheme for modal analysis of photonic waveguides using high-order edge elements",
   aut: "F. T. Orlandini, P. R. B. Devloo, H. E. Hernandez-Figueroa, L. P. de Oliveira",
   pro: "Int. Conf. Optical MEMS and Nanophotonics",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   url: "https://stars.library.ucf.edu/etd/6526",
   tit: "Third-order optical nonlinearities for integrated microwave photonics applications",
   aut: "M. Malinowski",
   jou: "PD",
   yr : 2019
  },
  {cat: elem,
   cla: nep,
   doi: "10.1109/COMPUMAG45669.2019.9032834",
   tit: "Dispersive Quasi-Normal Mode (DQNM) expansion in open and periodic nanophotonic structures",
   aut: "M. D. Truong, G. Dem&eacute;sy, F. Zolla, A. Nicolet",
   pro: "COMPUMAG",
   yr : 2019
  },
  {cat: elem,
   cla: epsnh,
   arx: "1912.04409",
   tit: "Electromagnetic calculations for multiscale and multiphysics simulations: a new perspective",
   aut: "D. N. Pham, S. Bharadwaj, L. R. Ram-Mohan",
   yr : 2019
  },
  {cat: elem,
   cla: nep,
   arx: "1807.01658",
   doi: "10.1142/9789813270329_0004",
   tit: "Electromagnetic waves in photonic crystals: laws of dispersion, causality and analytical properties",
   aut: "B. Gralak, M. Cassier, G. Dem&eacute;sy, S. Guenneau",
   boo: "Compendium on Electromagnetic Analysis",
   pag: "205-241",
   yr : 2020
  },
  {cat: elem,
   cla: nep,
   arx: "1802.02363",
   doi: "10.1016/j.cpc.2020.107509",
   tit: "Non-linear eigenvalue problems with GetDP and SLEPc: Eigenmode computations of frequency-dispersive photonic open structures",
   aut: "G. Dem&eacute;sy, A. Nicolet, B. Gralak, C. Geuzaine, C. Campos, J. E. Roman",
   jou: "Comput. Phys. Commun.",
   num: "257",
   pag: "107509",
   yr : 2020
  },
  {cat: elem,
   cla: nep,
   arx: "1907.11540",
   doi: "10.1364/JOSAA.390480",
   tit: "Discontinuities in photonic waveguides: Rigorous Maxwell-based 3D modeling with the finite element method",
   aut: "G. Dem&eacute;sy and G. Renversez",
   jou: "J. Opt. Soc. Am. A",
   num: "37(6)",
   pag: "1025-1033",
   yr : 2020
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1088/1674-1056/abaed6",
   tit: "Modes decomposition in Particle-in-Cell software CEMPIC",
   aut: "A. Fang et al.",
   jou: "Chinese Physics B",
   num: "29(10)",
   pag: "100205",
   yr : 2020
  },
  {cat: elem,
   cla: nep,
   arx: "2007.00470",
   doi: "10.1364/OE.401742",
   tit: "Continuous family of exact Dispersive Quasi-Normal Modal (DQNM) expansions for dispersive photonic structures",
   aut: "M. D. Truong, A. Nicolet, G. Dem&eacute;sy, F. Zolla",
   jou: "Opt. Express",
   num: "28",
   pag: "29016-29032",
   yr : 2020
  },
  {cat: elem,
   cla: nep,
   arx: "2009.01307",
   tit: "Theory and numerical modeling of photonic resonances: Quasinormal modal expansion - applications in electromagnetics",
   aut: "M. D. Truong",
   jou: "PD",
   yr : 2020
  },
  {cat: elem,
   cla: pep,
   arx: "2003.06531",
   doi: "10.1016/j.jcp.2020.109871",
   tit: "Nonlinear eigenvalue problems for coupled Helmholtz equations modeling gradient-index graphene waveguides",
   aut: "J. H. Song, M. Maier, M. Luskin",
   jou: "J. Comput. Phys.",
   num: "423",
   pag: "109871",
   yr : 2020
  },
  {cat: elem,
   cla: pep,
   url: "https://hal.inria.fr/hal-03081151",
   tit: "Improvement of the modal expansion of electromagnetic fields through interpolation",
   aut: "M. Durufl&eacute;, A. Gras, P. Lalanne",
   jou: "TR",
   yr : 2020
  },
  {cat: elem,
   cla: epsnh,
   url: "https://www.proquest.com/openview/1b8a585c7a4ef7c64f373d25bf77e4e8",
   tit: "Efficient Schr&ouml;dinger-Poisson solvers for quasi 1D systems that utilize PETSc and SLEPc",
   aut: "P. K. R. Baikadi",
   jou: "MS",
   yr : 2020
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1098/rspa.2021.0609",
   arx: "2009.12166",
   tit: "Lorentz resonance in the homogenization of plasmonic crystals",
   aut: "W. Li, R. Lipton, M. Maier",
   jou: "P. R. Soc. A",
   num: "477",
   pag: "2256",
   yr : 2021
  },
  {cat: elem,
   cla: nep,
   doi: "10.1364/OME.424011",
   tit: "High frequency meta-ferroelectrics by inverse design",
   aut: "B. Vial, Y. Hao",
   jou: "Opt. Mater. Express",
   num: "11(5)",
   pag: "1457-1469",
   yr : 2021
  },
  {cat: elem,
   cla: epsnh,
   url: "http://hdl.handle.net/1828/12866",
   tit: "A finite-element mode solver for microcavity and step-index fiber",
   aut: "J. Li",
   jou: "MS",
   yr : 2021
  },
  {cat: elem,
   cla: pep,
   doi: "10.1007/s10825-021-01766-9",
   tit: "Modeling of gate leakage in cylindrical gate-all-around transistors",
   aut: "R. Solanki, S. Minase, A. Mahajan, R. Patrikar",
   jou: "J. Comput. Electron.",
   num: "20",
   pag: "1694-1701",
   yr : 2021
  },
  {cat: elem,
   cla: pep,
   doi: "10.1109/TTHZ.2021.3125898",
   tit: "2D FEM formulation for closed waveguides with magnetically biased graphene sheets",
   aut: "G. Garcia-Contreras, J. C&oacute;rcoles, J. A. Ruiz-Cruz",
   jou: "IEEE T. Thz. Sci. Techn.",
   num: "12(1)",
   pag: "98-101",
   yr : 2022
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1109/TMTT.2022.3145357",
   tit: "Machine learning to predict quasi TE011 mode resonances in double-stacked dielectric cavities",
   aut: "C. Lewis et al",
   jou: "IEEE T. Micro. Theo. Techn.",
   num: "70(4)",
   pag: "2135-2146",
   yr : 2022
  },
  {cat: elem,
   cla: nep,
   doi: "10.1515/nanoph-2022-0041",
   tit: "Nanostructured In<sub>3</sub>SbTe<sub>2</sub> antennas enable switching from sharp dielectric to broad plasmonic resonances",
   aut: "A. Hessler, S. Wahl, P. T. Kristensen, M. Wuttig, K. Busch, T. Taubner",
   jou: "Nanophotonics",
   num: "11(17)",
   pag: "3871-3882",
   yr : 2022
  },
  {cat: elem,
   cla: epsnh,
   arx: "1407.8220",
   doi: "10.1364/OE.454493",
   tit: "Coalescence of Anderson-localized modes at an exceptional point in 2D random media",
   aut: "N. Bachelard, A. Schumer, B. Kumar, C. Garay, J. Arlandis, R. Touzani, and P. Sebbah",
   jou: "Opt. Express",
   num: "30(11)",
   pag: "18098-18107",
   yr : 2022
  },
  {cat: elem,
   cla: epsh,
   arx: "2210.05829",
   tit: "Multi-scale incoherent electronic transport properties in non-ideal CVD graphene devices",
   aut: "B. Bishnoi",
   yr : 2022
  },
  {cat: elem,
   cla: nep,
   doi: "10.1016/j.euromechsol.2022.104809",
   tit: "Physically agnostic quasi normal mode expansion in time dispersive structures: From mechanical vibrations to nanophotonic resonances",
   aut: "A. Nicolet, G. Dem&eacute;sy, F. Zolla, C. Campos, J. E. Roman, C. Geuzaine",
   jou: "Eur. J. Mech. A-Solids",
   num: "100",
   pag: "104809",
   yr : 2023
  },
  {cat: elem,
   cla: epsnh,
   url: "https://hal.inria.fr/hal-03043491",
   doi: "10.1137/20M1382064",
   tit: "Inversion of eddy-current signals using a level-set method and block Krylov solvers",
   aut: "L. Audibert, H. Girardon, H. Haddar, P. Jolivet",
   jou: "SIAM J. Sci. Comput.",
   num: "45(3)",
   pag: "B366--B389",
   yr : 2023
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1002/jnm.3073",
   tit: "Comparison of 2.5D finite element formulations with perfectly matched layers for solving open axisymmetric electromagnetic cavity problems",
   aut: "E. Schnaubelt, H. De Gersem, N. Marsic",
   jou: "Int. J. Numer. Model. El.",
   num: "36(3)",
   pag: "e3073",
   yr : 2023
  },
  {cat: elem,
   cla: epsnh,
   url: "https://www.lib.ncsu.edu/resolver/1840.20/40985",
   tit: "Development and validation of open source software for electromagnetics simulation and multiphysics coupling",
   aut: "C. T. Icenhour",
   jou: "PD",
   yr : 2023
  },
  {cat: elem,
   cla: nep,
   arx: "2306.17292",
   doi: "10.1364/JOSAA.499370",
   tit: "Dispersive perfectly matched layers and high-order absorbing boundary conditions for the electromagnetic quasinormal modes",
   aut: "G. Dem&eacute;sy, T. Wu, Y. Br&ucirc;l&eacute;, F. Zolla, A. Nicolet, P. Lalanne, B. Gralak",
   jou: "J. Opt. Soc. Am. A",
   num: "40(10)",
   pag: "1947-1958",
   yr : 2023
  },
  {cat: elem,
   cla: pep,
   arx: "2308.08559",
   doi: "10.1137/23M159648X",
   tit: "High-frequency homogenization for periodic dispersive media",
   aut: "M. Touboul, B. Vial, R. Assier, S. Guenneau, R. V. Craster",
   jou: "Multiscale Model. Simul.",
   num: "22(3)",
   pag: "1136-1168}",
   yr : 2024
  },
  {cat: elem,
   cla: pep,
   doi: "10.1038/s41567-023-02242-w",
   tit: "Coherent control of chaotic optical microcavity with reflectionless scattering modes",
   aut: "X. Jiang, S. Yin, H. Li et al.",
   jou: "Nat. Phys.",
   num: "20",
   pag: "109-115",
   yr : 2024
  },
  {cat: elem,
   cla: epsnh,
   url: " https://journalspress.com/LJER_Volume24/Study-of-the-Eigenmodes-of-an-Optical-Waveguide-with-a-Refractive-Index-that-Varies-in-the-Radial-Direction-from-the-Central-Axis.pdf",
   tit: "Study of the eigenmodes of an optical waveguide with a refractive index that varies in the radial direction from the central axis",
   aut: "Y. M. Kim",
   jou: "London J. Engin. Res.",
   num: "24",
   pag: "5",
   yr : 2024
  },
  {cat: elem,
   cla: epsnh,
   arx: "2407.11703",
   tit: "Numerical eigenvalue optimization by shape-variations for Maxwell's eigenvalue problem",
   aut: "C. Herter, S. Sch&ouml;ps, W. Wollner",
   yr : 2024
  },
  {cat: elem,
   cla: epsnh,
   url: "https://www.diva-portal.org/smash/record.jsf?pid=diva2%3A1905672",
   tit: "Cut finite element method for Maxwell's equations",
   aut: "S. Myrb&auml;ck, E. Nilsson, S. Zahedi",
   jou: "PP",
   yr : 2024
  },
  {cat: elem,
   cla: pep,
   doi: "10.1063/5.0221393",
   tit: "Analysis of guided and leaky modes of planar optical waveguides using transparent boundary conditions",
   aut: "X. Zang, A. Shevchenko",
   jou: "APL Photonics",
   num: "9",
   pag: "116105",
   yr : 2024
  },
  {cat: elem,
   cla: epsnh,
   arx: "2407.21766",
   doi: "10.1007/s00366-024-02101-z",
   tit: "A waveguide port boundary condition based on approximation space restriction for finite element analysis",
   aut: "F. T. Orlandini, P. R. B. Devloo, H. E. Hernandez-Figueroa",
   jou: "Engin. Comput.",
   num: "41",
   pag: "2119-2136",
   yr : 2025
  },
  {cat: elem,
   cla: pep,
   arx: "2507.02784",
   tit: "Quasinormal modes of Floquet media slabs",
   aut: "B. Vial, R. V. Craster",
   yr : 2025
  },
  {cat: elem,
   cla: epsnh,
   doi: "10.1021/acsphotonics.5c01294",
   tit: "Photonic eigenmodes of 2D cylindrical cholesteric liquid crystal resonators",
   aut: "U. Mur, J. Zaplotnik, M. Horvat, I. Musevic, M. Ravnik",
   jou: "ACS Photonics",
   num: "12",
   pag: "5572–5585",
   yr : 2025
  },
  {cat: plas,
   cla: epsnh,
   url: "http://www.lle.rochester.edu/media/publications/documents/theses/Guazzotto.pdf",
   tit: "Equilibrium and stability of tokamak plasmas with arbitrary flow",
   aut: "L. Guazzotto",
   jou: "PD",
   yr : 2005
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.2909618",
   tit: "Exceptional points in linear gyrokinetics",
   aut: "M. Kammerer et al.",
   jou: "Phys. Plasmas",
   num: "15",
   pag: "052102",
   yr : 2008
  },
  {cat: plas,
   cla: epsnh,
   url: "http://www.ipp.mpg.de/~fsj/PAPERS_1/merz.pdf",
   tit: "Gyrokinetic simulation of multimode plasma turbulence",
   aut: "F. Merz",
   jou: "PD",
   yr : 2009
  },
  {cat: plas,
   cla: epsnh,
   url: "https://www.deutsche-digitale-bibliothek.de/binary/LYCENNWEYVGKHTQU7OF7DSQ45U62YUJD/full/1.pdf",
   tit: "Multiscale effects in plasma microturbulence",
   aut: "T. G&ouml;rler",
   jou: "PD",
   yr : 2009
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.parco.2009.12.001",
   tit: "Fast eigenvalue calculations in a massively parallel plasma turbulence code",
   aut: "J. E. Roman et al.",
   jou: "Parallel Comput.",
   num: "36(5-6)",
   pag: "339-358",
   yr : 2010
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.3509106",
   tit: "Gyrokinetic simulations of mesoscale energetic particle driven Alfv&eacute;nic turbulent transport embedded in microturbulence",
   aut: "E. M. Bass and R. E. Waltz",
   jou: "Phys. Plasmas",
   num: "17",
   pag: "112319",
   yr : 2010
  },
  {cat: plas,
   cla: epsnh,
   url: "http://www-pub.iaea.org/mtcd/meetings/PDFplus/2010/cn180/cn180_papers/thw_p4-01.pdf",
   tit: "Gyrokinetic simulations of energetic particle-driven TAE/EPM transport embedded in ITG/TEM microturbulence",
   aut: "E. M. Bass and R. E. Waltz",
   pro: "23rd IAEA Fusion Energy Conference",
   yr : 2010
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.5075/epfl-thesis-4684",
   tit: "Local and global Eulerian gyrokinetic simulations of microturbulence in realistic geometry with applications to the TCV tokamak",
   aut: "X. Lapillonne",
   jou: "PD",
   yr : 2010
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/0741-3335/53/5/054011",
   tit: "Non-linear gyrokinetic simulations of microturbulence in TCV electron internal transport barriers",
   aut: "X. Lapillonne et al.",
   jou: "Plasma Phys. Control. Fusion",
   num: "53",
   pag: "054011",
   yr : 2011
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1002/cpe.1740",
   tit: "Computing subdominant unstable modes of turbulent plasma with a parallel Jacobi-Davidson eigensolver",
   aut: "E. Romero and J. E. Roman",
   jou: "Concurr. Comp.-Pract. E.",
   num: "23",
   pag: "2179-2191",
   yr : 2011
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.cpc.2011.04.007",
   tit: "Linear eigenvalue code for edge plasma in full tokamak X-point geometry",
   aut: "D. A. Baver et al.",
   jou: "Comput. Phys. Commun.",
   num: "182(8)",
   pag: "1610-1620",
   yr : 2011
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.jcp.2011.05.034",
   tit: "The global version of the gyrokinetic turbulence code GENE",
   aut: "T. G&ouml;rler et al.",
   jou: "J. Comput. Phys.",
   num: "230(18)",
   pag: "7053-7071",
   yr : 2011
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.cpc.2011.12.018",
   tit: "Multi-dimensional gyrokinetic parameter studies based on eigenvalue computations",
   aut: "F. Merz et al.",
   jou: "Comput. Phys. Commun.",
   num: "183(4)",
   pag: "922-930",
   yr : 2012
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/0029-5515/52/4/043006",
   tit: "Linear properties of reversed shear Alfv&eacute;n eigenmodes in the DIII-D tokamak",
   aut: "W. Deng et al.",
   jou: "Nucl. Fusion",
   num: "52",
   pag: "043006",
   yr : 2012
  },
  {cat: plas,
   cla: epsnh,
   url: "http://meeting.aps.org/Meeting/DPP12/Event/175731",
   tit: "Upgrades to the ArbiTER edge plasma eigenvalue code",
   aut: "D. A. Baver et al.",
   pro: "54th Annual Meeting of the APS Division of Plasma Physics",
   yr : 2012
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4769115",
   tit: "A computational approach to continuum damping of Alfv&eacute;n waves in two and three-dimensional geometry",
   aut: "A. K&ouml;nies and R. Kleiber",
   jou: "Phys. Plasmas",
   num: "19",
   pag: "122111",
   yr : 2012
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4773177",
   tit: "Gyrokinetic simulation of global and local Alfv&eacute;n eigenmodes driven by energetic particles in a DIII-D discharge",
   aut: "E. M. Bass and R. E. Waltz",
   jou: "Phys. Plasmas",
   num: "20",
   pag: "012508",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4789448",
   tit: "Magnetic stochasticity and transport due to nonlinearly excited subdominant microtearing modes",
   aut: "D. R. Hatch et al.",
   jou: "Phys. Plasmas",
   num: "20",
   pag: "012307",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.procs.2013.05.208",
   tit: "The sparse grid combination technique for computing eigenvalues in linear gyrokinetics",
   aut: "C. Kowitz and M. Hegland",
   jou: "Procedia Computer Science",
   num: "18",
   pag: "449-458",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4819033",
   tit: "The effect of weak collisionality on damped modes and its contribution to linear mode coupling in gyrokinetic simulation",
   aut: "P. P. Hilscher et al.",
   jou: "Phys. Plasmas",
   num: "20",
   pag: "082127",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1585/pfr.8.1303151",
   tit: "Role of stable modes in the ITG-driven instability in a mode-coupled system",
   aut: "P. P. Hilscher et al.",
   jou: "Plasma and Fusion Research: Letters",
   num: "8",
   pag: "1303151",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   url: "http://hdl.handle.net/2433/180447",
   tit: "Study of multi-scale interaction and dissipation based on gyro-kinetic model in fusion plasmas",
   aut: "P. P. Hilscher",
   jou: "PD",
   yr : 2013
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.cpc.2014.03.024",
   tit: "Towards optimal explicit time-stepping schemes for the gyrokinetic equations",
   aut: "H. Doerk and F. Jenko",
   jou: "Comput. Phys. Commun.",
   num: "185(7)",
   pag: "1938-1946",
   yr : 2014
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/0029-5515/55/1/012002",
   tit: "Effect of turbulence on electron cyclotron current drive and heating in ITER",
   aut: "F. J. Casson",
   jou: "Nucl. Fusion",
   num: "55",
   pag: "012002",
   yr : 2015
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1103/PhysRevLett.114.095003",
   tit: "Universal instability for wavelengths below the ion Larmor scale",
   aut: "M. Landreman et al.",
   jou: "Phys. Rev. Lett.",
   num: "114",
   pag: "095003",
   yr : 2015
  },
  {cat: plas,
   cla: epsnh,
   url: "http://www.lodestar.com/LRCreports/ArbiTER_Phase_II_Final_Report_LRC-15-159.pdf",
   tit: "ArbiTER: a flexible eigenvalue solver for edge fusion plasma applications",
   aut: "D. A. Baver et al.",
   jou: "TR",
   yr : 2015
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.4208/cicp.191214.021015a",
   tit: "Eigenvalue solver for fluid and kinetic plasma models in arbitrary magnetic topology",
   aut: "D. A. Baver et al.",
   jou: "Comm. Comput. Phys.",
   num: "20(1)",
   pag: "136-155",
   yr : 2016
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4942539",
   tit: "Linear multispecies gyrokinetic flux tube benchmarks in shaped tokamak plasmas",
   aut: "G. Merlo et al.",
   jou: "Phys. Plasmas",
   num: "23",
   pag: "032104",
   yr : 2016
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.4972137",
   tit: "Linear global gyrokinetic simulations of toroidal Alfven eigenmodes in KSTAR plasmas",
   aut: "M. Shahzad et al.",
   jou: "Phys. Plasmas",
   num: "23",
   pag: "122511",
   yr : 2016
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/0029-5515/57/1/016032",
   tit: "CASTOR3D: linear stability studies for 2D and 3D tokamak equilibria",
   aut: "E. Strumberger and S. G&uuml;nter",
   jou: "Nucl. Fusion",
   num: "57",
   pag: "016032",
   yr : 2017
  },
  {cat: plas,
   cla: epsnh,
   url: "http://ocs.ciemat.es/EPS2018PAP/pdf/P1.1044.pdf",
   tit: "Progress in the modelling of 3-D effects on MHD stability with the PB3D numerical code and implications for ITER",
   aut: "T. Weyens et al.",
   pro: "45th EPS Conference on Plasma Physics",
   yr : 2018
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/1741-4326/aae49f",
   tit: "Divertor leg filaments in NSTX-U",
   aut: "F. Scotti et al.",
   jou: "Nucl. Fusion",
   num: "58",
   pag: "126028",
   yr : 2018
  },
  {cat: plas,
   cla: mfn,
   doi: "10.1017/S0022377818001022",
   tit: "Stellarator microinstabilities and turbulence at low magnetic shear",
   aut: "B. J. Faber et al.",
   jou: "J. Plasma Phys.",
   num: "84(5)",
   pag: "905840503",
   yr : 2018
  },
  {cat: plas,
   cla: mfn,
   doi: "10.1088/1361-6587/aaf8c1",
   tit: "On microinstabilities and turbulence in steep-gradient regions of fusion devices",
   aut: "M. J. Pueschel et al.",
   jou: "Plasma Phys. Contr. Fusion",
   num: "61",
   pag: "3",
   yr : 2019
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/1.5065390",
   tit: "Penetration of filamentary structures into the divertor region of spherical tokamaks",
   aut: "D. A. Baver and J. R. Myra",
   jou: "Phys. Plasmas",
   num: "26",
   pag: "022505",
   yr : 2019
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/1741-4326/ab314b",
   tit: "Linear stability studies for a quasi-axisymmetric stellarator configuration including effects of parallel viscosity, plasma flow, and resistive walls",
   aut: "E. Strumberger and S. G&uuml;nter",
   jou: "Nucl. Fusion",
   num: "59(10)",
   pag: "106008",
   yr : 2019
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1016/j.cpc.2020.107360",
   tit: "Multi-species collisions for delta-f gyrokinetic simulations: Implementation and verification with GENE",
   aut: "P. Crandall, D. Jarema, H. Doerk, Q. Pan, G. Merlo, T. G&ouml;rler, A. Ba&ntilde;&oacute;n Navarro, D. Told, M. Maurer, F. Jenko",
   jou: "Comput. Phys. Commun.",
   num: "255",
   pag: "107360",
   yr : 2020
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1063/5.0063766",
   url: "http://www.lodestar.com/LRCreports/Baver_PFR_instabilities_LRC-21-189.pdf",
   tit: "Comparison of private flux region instability in conventional and super-X divertor configurations",
   aut: "D. A. Baver, J. R. Myra, F. Militello, D. Moulton",
   jou: "Phys. Plasmas",
   num: "28",
   pag: "112510",
   yr : 2021
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1017/S0022377822000745",
   tit: "Influence of magnetic configuration properties on kinetic ballooning modes in W7-X",
   aut: "K. Aleynikova, A. Zocco, J. Geiger",
   jou: "J. Plasma Phys.",
   num: "88(4)",
   pag: "905880411",
   yr : 2022
  },
  {cat: plas,
   cla: epsnh,
   arx: "2306.03694",
   doi: "10.1103/PhysRevLett.131.185101",
   tit: "Enhanced transport at high plasma pressure and subthreshold kinetic ballooning modes in Wendelstein 7-X",
   aut: "P. Mulholland, K. Aleynikova, B. J. Faber, M. J. Pueschel, J. H. E. Proll, C. C. Hegna, P. W. Terry, C. Nuhrenberg",
   jou: "Phys. Rev. Lett.",
   num: "131",
   pag: "185101",
   yr : 2023
  },
  {cat: plas,
   cla: epsnh,
   arx: "2211.12163",
   doi: "10.1016/j.physd.2024.134270",
   tit: "Bifurcation analysis of a two-dimensional magnetic Rayleigh-B&eacute;nard problem",
   aut: "F. Laakmann, N. Boull&eacute;",
   jou: "Physica D",
   num: "467",
   pag: "134270",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/1741-4326/ad34e2",
   tit: "Shear Alfv&eacute;n waves within magnetic islands",
   aut: "A. K&ouml;nies, J. Cao, R. Kleiber",
   jou: "Nucl. Fusion",
   num: "64",
   pag: "054001",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   url: "https://hdl.handle.net/10016/43911",
   tit: "Analysis of the wave-plasma interaction in electrodeless plasma thrusters",
   aut: "P. Jim&eacute;nez",
   jou: "PD",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1134/S1063780X24600944",
   tit: "Gyrokinetic calculations of heat fluxes in the T-10 tokamak ohmic discharge",
   aut: "M. Yu. Isaev, O. Anuaruly, A. Yu. Kuyanov, D. B. Smirnov",
   jou: "Plasma Phys. Rep.",
   num: "50(8)",
   pag: "895--910",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   url: "https://pure.tue.nl/ws/portalfiles/portal/344535393/20241204_Snoep_e-mail.pdf",
   tit: "Reduced-order modeling for turbulent transport in the pedestal-forming region of tokamaks",
   aut: "G. Snoep",
   jou: "PD",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1017/S0022377824000837",
   tit: "Quasilinear modelling of collisional trapped electron modes",
   aut: "C. D. Stephens, J. Citrin, K. L. van de Plassche, C. Bourdelle, T. Tala, A. Salmi, F. Jenko",
   jou: "J. Plasma Phys.",
   num: "90",
   pag: "905900618",
   yr : 2024
  },
  {cat: plas,
   cla: epsnh,
   doi: "10.1088/1741-4326/ad90f2",
   tit: "Finite-beta turbulence in Wendelstein 7-X enhanced by sub-threshold kinetic ballooning modes",
   aut: "P. Mulholland, M. J. Pueschel, J. H. E. Proll, K. Aleynikova, B. J. Faber, P. W. Terry, C. C. Hegna, C. Nuhrenberg",
   jou: "Nucl. Fusion",
   num: "65",
   pag: "016022",
   yr : 2025
  },
  {cat: plas,
   cla: epsnh,
   arx: "2507.03245",
   tit: "Real-time prediction of plasma instabilities with sparse-grid-accelerated optimized dynamic mode decomposition",
   aut: "K. Gill, I.-G. Farcas, S. Glas, B. J. Faber",
   yr : 2025
  },
  {cat: plas,
   cla: epsnh,
   url: "https://conferences.iaea.org/event/392/contributions/35892",
   tit: "Gyrokinetic linear simulation of hot ion mode in Globus-M2 spherical tokamak",
   aut: "E. Kiselev et al",
   pro: "IAEA FEC",
   yr : 2025
  },
  {cat: astr,
   cla: epsnh,
   doi: "10.1103/PhysRevE.84.036321",
   tit: "Periodic magnetorotational dynamo action as a prototype of nonlinear magnetic-field generation in shear flows",
   aut: "J. Herault et al.",
   jou: "Phys. Rev. E",
   num: "84",
   pag: "036321",
   yr : 2011
  },
  {cat: astr,
   cla: epsnh,
   doi: "10.1017/jfm.2013.317",
   tit: "Global bifurcations to subcritical magnetorotational dynamo action in Keplerian shear flow",
   aut: "A. Riols et al.",
   jou: "J. Fluid Mech.",
   num: "731",
   pag: "1-45",
   yr : 2013
  },
  {cat: astr,
   cla: epsh,
   doi: "10.18419/opus-5202",
   tit: "B-Spline Ansatz f&uuml;r die Berechnung des Motional Stark Effekts",
   aut: "T. G&ouml;ttler",
   jou: "PD",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/1742-6596/16/1/033",
   tit: "Advanced software for the calculation of thermochemistry, kinetics, and dynamics",
   aut: "D. M. Medvedev et al.",
   jou: "J. Phys.: Conf. Ser.",
   num: "16",
   pag: "247-251",
   yr : 2005
  },
  {cat: phys,
   cla: epsh,
   url: "http://wissrech.ins.uni-bonn.de/research/pub/hamaekers/GriebelHamaekersINSpreprint0603.pdf",
   tit: "A wavelet based sparse grid method for the electronic Schr&ouml;dinger equation",
   aut: "M. Griebel and J. Hamaekers",
   pro: "International Congress of Mathematicians",
   yr : 2006
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.75.023620",
   tit: "Rapidly rotating boson molecules with long or short range repulsion: an exact diagonalization study",
   aut: "L. O. Baksmaty et al.",
   jou: "Phys. Rev. A",
   num: "75",
   pag: "023620",
   yr : 2007
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1051/m2an:2007015",
   tit: "Sparse grids for the Schr&ouml;dinger equation",
   aut: "M. Griebel and J. Hamaekers",
   jou: "ESAIM-Math. Model. Numer. Anal.",
   num: "41(2)",
   pag: "215-247",
   yr : 2007
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.aop.2007.12.009",
   tit: "Spectrum of the non-abelian phase in Kitaev's honeycomb lattice model",
   aut: "V. Lahtinen et al.",
   jou: "Ann. Phys.",
   num: "323(9)",
   pag: "2286-2310",
   yr : 2008
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.jcp.2008.06.008",
   tit: "A stabilized stochastic finite element second-order projection method for modeling natural convection in random porous media",
   aut: "X. Ma and N. Zabaras",
   jou: "J. Comp. Phys.",
   num: "227(18)",
   pag: "8448-8471",
   yr : 2008
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.78.155330",
   tit: "Chiral two-dimensional electron gas in a periodic magnetic field: Persistent current and quantized anomalous Hall effect",
   aut: "M. Taillefumier et al.",
   jou: "Phys. Rev. B",
   num: "78",
   pag: "155330",
   yr : 2008
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.79.022507",
   tit: "Discrete sets of Sturmian functions applied to two-electron atoms",
   aut: "J. M. Randazzo et al.",
   jou: "Phys. Rev. A",
   num: "79",
   pag: "022507",
   yr : 2009
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1021/jp9040869",
   tit: "Theory of hyperspherical Sturmians for three-body reactions",
   aut: "G. Gasaneo et al.",
   jou: "J. Phys. Chem. A",
   num: "113(52)",
   pag: "14573-14582",
   yr : 2009
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.aop.2009.06.001",
   tit: "Valence bond states: link models",
   aut: "E. Rico et al.",
   jou: "Ann. Phys.",
   num: "324(9)",
   pag: "1875-1896",
   yr : 2009
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1016/j.matcom.2009.06.011",
   tit: "Numerical exploration of vortex matter in Bose-Einstein condensates",
   aut: "L. O. Baksmaty et al.",
   jou: "Math. Comput. Simulat.",
   num: "80(1)",
   pag: "131-138",
   yr : 2009
  },
  {cat: phys,
   cla: epsh,
   url: "http://www.researchgate.net/publication/242380142",
   tit: "Tensor product multiscale many-particle spaces with finite-order weights for the electronic Schr&ouml;dinger equation",
   aut: "J. Hamaekers",
   jou: "PD",
   yr : 2009
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2009.06.010",
   tit: "Solving the vibrational Schr&ouml;dinger equation on an arbitrary multidimensional potential energy surface by the finite element method",
   aut: "D. Xu et al.",
   jou: "Comput. Phys. Commun.",
   num: "180(11)",
   pag: "2079-2094",
   yr : 2009
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1524/zpch.2010.6122",
   tit: "Tensor product multiscale many-particle spaces with finite-order weights for the electronic Schr&ouml;dinger equation",
   aut: "M. Griebel and J. Hamaekers",
   jou: "Z. Phys. Chem.",
   num: "224(3-4)",
   pag: "527-543",
   yr : 2010
  },
  {cat: phys,
   cla: pep,
   doi: "10.1016/j.jcp.2009.12.024",
   tit: "A parallel additive Schwarz preconditioned Jacobi-Davidson algorithm for polynomial eigenvalue problems in quantum dot simulation",
   aut: "F.-N. Hwang et al.",
   jou: "J. Comput. Phys.",
   num: "229(8)",
   pag: "2932-2947",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevC.81.054312",
   tit: "Collective nuclear excitations with Skyrme-second random-phase approximation",
   aut: "D. Gambacurta et al.",
   jou: "Phys. Rev. C",
   num: "81(5)",
   pag: "054312",
   yr : 2010
  },
  {cat: phys,
   cla: pep,
   url: "http://journal.taiwanmathsoc.org.tw/index.php/TJM/article/view/347",
   tit: "An efficiency study of polynomial eigenvalue problem solvers for quantum dot simulations",
   aut: "T.-M. Huang et al.",
   jou: "Taiwanese J. Math.",
   num: "14(3A)",
   pag: "999-1021",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/0253-6102/53/6/04",
   tit: "Strategies for h-adaptive refinement for a finite element treatment of harmonic oscillator Schr&ouml;dinger eigenproblem",
   aut: "T. D. Young and R. Armiento",
   jou: "Commun. Theor. Phys.",
   num: "53(6)",
   pag: "1017",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.physe.2010.01.010",
   tit: "Quantum control of interacting bosons in periodic optical lattice",
   aut: "A. Roy and L. E. Reichl",
   jou: "Physica E",
   num: "42(5)",
   pag: "1627-1632",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2010.09.007",
   tit: "Parallel implementation of the MAGPACK package for the analysis of high-nuclearity spin clusters",
   aut: "E. Ramos et al.",
   jou: "Comput. Phys. Commun.",
   num: "181(12)",
   pag: "1929-1940",
   yr : 2010
  },
  //{cat: phys,
  // cla: epsh,
  // url: "http://www.vsc.ac.at/fileadmin/user_upload/vsc/reports/TU-p70072-Rotter-Report.pdf",
  // tit: "Nonlinear interactions in microlasers",
  // aut: "M. Liertzer and S. Rotter",
  // jou: "TR",
  // yr : 2010
  //},
  {cat: phys,
   cla: epsh,
   url: "http://hss.ulb.uni-bonn.de/2011/2618/2618.htm",
   tit: "The formation of the concertina pattern: experiments, analysis, and numerical simulations",
   aut: "J. Steiner",
   jou: "PD",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   url: "http://eprints.nuim.ie/2525",
   tit: "Numerical investigation of exotic phases in quantum lattice models",
   aut: "N. Moran",
   jou: "PD",
   yr : 2010
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2010.12.051",
   tit: "Diagonalisation of quantum observables on regular lattices and general graphs",
   aut: "N. Moran et al.",
   jou: "Comput. Phys. Commun.",
   num: "182(4)",
   pag: "1083-1092",
   yr : 2011
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1109/TNANO.2011.2166164",
   tit: "NEMO5: A parallel multiscale nanoelectronics modeling tool",
   aut: "S. Steiger et al.",
   jou: "IEEE T. Nanotechnol.",
   num: "10(6)",
   pag: "1464-1474",
   yr : 2011
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/1742-6596/281/1/012015",
   tit: "A qualitative semi-classical treatment of an isolated semi-polar quantum dot",
   aut: "T. D. Young",
   jou: "J. Phys.: Conf. Ser.",
   num: "281",
   pag: "012015",
   yr : 2011
  },
  {cat: phys,
   cla: epsh,
   url: "https://hal.archives-ouvertes.fr/tel-00652733",
   tit: "Etude th&eacute;orique des propri&eacute;t&eacute;s thermiques et thermoelectriques des nanorubans de graph&egrave;ne",
   aut: "F. Mazzamuto",
   jou: "PD",
   yr : 2011
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/1367-2630/14/7/073002",
   tit: "Supersymmetric lattice fermions on the triangular lattice: Superfrustration and criticality",
   aut: "L. Huijse et al.",
   jou: "New J. Phys.",
   num: "14",
   pag: "073002",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.86.045105",
   tit: "Cluster dynamical mean field theory of quantum phases on a honeycomb lattice",
   aut: "R.-Q. He and Z.-Y. Lu",
   jou: "Phys. Rev. B",
   num: "86(4)",
   pag: "045105",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1140/epjd/e2011-20653-6",
   tit: "UKRmol: a low-energy electron- and positron-molecule scattering suite",
   aut: "J. M. Carr et al.",
   jou: "Eur. Phys. J. D",
   num: "66(2)",
   pag: "58",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/0953-4075/45/10/105602",
   tit: "Laser-controlled vibrational heating and cooling of oriented H<sub>2</sub><sup>+</sup> molecules",
   aut: "T. Niederhausen et al.",
   jou: "J. Phys. B: At. Mol. Opt. Phys.",
   num: "45",
   pag: "105602",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   url: "http://in4.iue.tuwien.ac.at/pdfs/sispad2012/P-18.pdf",
   tit: "NEMO5, a parallel, multiscale, multiphysics nanoelectronics modeling tool",
   aut: "J. M. Sellier et al.",
   pro: "SISPAD",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.jcp.2012.04.036",
   tit: "Higher-order adaptive finite-element methods for Kohn-Sham density functional theory",
   aut: "P. Motamarri et al.",
   jou: "J. Comput. Phys.",
   num: "231(20)",
   pag: "6596-6621",
   yr : 2012
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.chemphys.2012.03.012",
   tit: "Time-depedent formalism of double ionization of multielectron atomic targets",
   aut: "F. L. Yip et al.",
   jou: "Chem. Phys.",
   num: "414",
   pag: "112-120",
   yr : 2013
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2012.08.011",
   tit: "Parallel finite element density functional computations exploiting grid refinement and subspace recycling",
   aut: "T. D. Young et al.",
   jou: "Comput. Phys. Commun.",
   num: "184(1)",
   pag: "66-72",
   yr : 2013
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.110.087201",
   tit: "Correlation-mediated processes for electron-induced switching between N&eacute;el states of Fe antiferromagnetic chains",
   aut: "J.-P. Gauyacq et al.",
   jou: "Phys. Rev. Lett.",
   num: "110(8)",
   pag: "087201",
   yr : 2013
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1137/120877374",
   tit: "Adaptive finite element method assisted by stochastic simulation of chemical systems",
   aut: "S. L. Cotter et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "35(1)",
   pag: "B107-B131",
   yr : 2013
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.87.053405",
   tit: "Photoionization of helium by attosecond pulses: Extraction of spectra from correlated wave functions",
   aut: "L. Argenti et al.",
   jou: "Phys. Rev. A",
   num: "87",
   pag: "053405",
   yr : 2013
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.87.062512",
   tit: "Electronic flux densities in vibrating H<sub>2</sub><sup>+</sup> in terms of vibronic eigenstates",
   aut: "J. F. Perez-Torres",
   jou: "Phys. Rev. A",
   num: "87",
   pag: "062512",
   yr : 2013
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.113.063004",
   tit: "Interaction effects on dynamical localization in driven helium",
   aut: "F. J&ouml;rder",
   jou: "Phys. Rev. Lett.",
   num: "113",
   pag: "063004",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1007/JHEP04(2014)085",
   tit: "A first look at Bottomonium melting via a stochastic potential",
   aut: "A. Rothkopf",
   jou: "J. High Energy Phys.",
   num: "2014",
   pag: "85",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.ideals.illinois.edu/bitstream/handle/2142/46582/Seth_Watts.pdf",
   tit: "Design of meta-materials with novel thermoelastic properties",
   aut: "S. Watts",
   jou: "PD",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.90.085437",
   tit: "Electron states in a double quantum dot with broken axial symmetry",
   aut: "A. Gawarecki et al.",
   jou: "Phys. Rev. B",
   num: "90",
   pag: "085437",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1021/ct500661t",
   tit: "Free energies of quantum particles: the coupled-perturbed quantum umbrella sampling method",
   aut: "W. J. Glover et al.",
   jou: "J. Chem. Theory Comput.",
   num: "10(10)",
   pag: "4661-4671",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   url: "http://deepblue.lib.umich.edu/bitstream/handle/2027.42/110475/phanim_1.pdf",
   tit: "Large-scale real-space Kohn-Sham density functional theory calculations using adaptive finite-element discretization",
   aut: "P. Motamarri",
   jou: "PD",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   url: "http://elib.suub.uni-bremen.de/edocs/00103899-1.pdf",
   tit: "From structure to spectra: tight-binding theory of InGaAs quantum dots",
   aut: "E. Goldmann",
   jou: "PD",
   yr : 2014
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1126/science.1257050",
   tit: "Ab initio calculation of the neutron-proton mass difference",
   aut: "Sz. Borsanyi et al.",
   jou: "Science",
   num: "347",
   pag: "1452-1455",
   yr : 2015
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1088/0953-4075/48/2/025001",
   tit: "Extracting partial decay rates of helium from complex rotation: autoionizing resonances of the one-dimensional configurations",
   aut: "K. Zimmermann et al.",
   jou: "J. Phys. B: At. Mol. Opt. Phys.",
   num: "48",
   pag: "025001",
   yr : 2015
  },
  {cat: phys,
   cla: mfn,
   doi: "10.1016/j.cpc.2014.09.011",
   tit: "pyCTQW: A continuous-time quantum walk simulator on distributed memory computers",
   aut: "J. A. Izaac and J. B. Wang",
   jou: "Comput. Phys. Commun.",
   num: "186",
   pag: "81-92",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.91.081103",
   tit: "Many-body localization edge in the random-field Heisenberg chain",
   aut: "D. J. Luitz et al.",
   jou: "Phys. Rev. B",
   num: "91",
   pag: "081103",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.comptc.2015.03.011",
   tit: "Extended H&uuml;ckel and Slater's rule initial guess for real space grid-based Density Functional Theory",
   aut: "M. Lee et al.",
   jou: "Comput. Theor. Chem.",
   num: "1062",
   pag: "24-29",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   url: "http://geb.uni-giessen.de/geb/volltexte/2015/11607",
   tit: "Light tetraquarks and mesons in a DSE/BSE approach",
   aut: "W. Heupel",
   jou: "PD",
   yr : 2015
  },
  {cat: phys,
   cla: pep,
   doi: "10.1103/PhysRevA.92.013847",
   tit: "Steady-state ab initio laser theory for fully or nearly degenerate cavity modes",
   aut: "S. Burkhardt et al.",
   jou: "Phys. Rev. A",
   num: "92",
   pag: "013847",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.92.013426",
   tit: "Energy- and angle-resolved ionization of H<sub>2</sub><sup>+</sup> interacting with xuv subfemtosecond laser pulses",
   aut: "R. E. F. Silva et al.",
   jou: "Phys. Rev. A",
   num: "92",
   pag: "013426",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.92.053404",
   tit: "Two-photon double ionization of atomic beryllium with ultrashort laser pulses",
   aut: "F. L. Yip et al.",
   jou: "Phys. Rev. A",
   num: "92",
   pag: "053404",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevD.92.114505",
   tit: "Fluctuations and correlations in high temperature QCD",
   aut: "R. Bellwied et al.",
   jou: "Phys. Rev. D",
   num: "92",
   pag: "114505",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1063/1.4937243",
   tit: "An efficient numerical discretization method for the study of the H<sub>2</sub><sup>+</sup> in intense laser fields",
   aut: "G.-Z. Kiss et al.",
   jou: "AIP Conf. Proc.",
   num: "1694",
   pag: "020017",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   arx: "1508.01523",
   tit: "The many faces of quantum kagome materials: Interplay of further-neighbour exchange and Dzyaloshinskii-Moriya interaction",
   aut: "T. F. Seman et al.",
   yr : 2015
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/nme.5140",
   tit: "On the adaptive finite element analysis of the Kohn-Sham equations: methods, algorithms, and implementation",
   aut: "D. Davydov et al.",
   jou: "Int. J. Numer. Meth. Engrg.",
   num: "106(11)",
   pag: "863-888",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2015.11.013",
   tit: "FELIX-1.0: A finite element solver for the time dependent generator coordinate method with the Gaussian overlap approximation",
   aut: "D. Regnier et al.",
   jou: "Comput. Phys. Commun.",
   num: "200",
   pag: "350-363",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.jcp.2015.11.024",
   tit: "Galerkin method for unsplit 3-D Dirac equation using atomically/kinetically balanced B-spline basis",
   aut: "F. Fillion-Gourdeau et al.",
   jou: "J. Comput. Phys.",
   num: "307",
   pag: "122-145",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/jcc.24254",
   tit: "Shift-and-invert parallel spectral transformation eigensolver: Massively parallel performance for density-functional based tight-binding",
   aut: "M. Ke&ccedil;eli et al.",
   jou: "J. Comput. Chem.",
   num: "37(4)",
   pag: "448-459",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.93.060201",
   tit: "Extended slow dynamical regime close to the many-body localization transition",
   aut: "D. J. Luitz et al.",
   jou: "Phys. Rev. B",
   num: "93",
   pag: "060201",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.3390/cryst6040039",
   tit: "High-spin chains and crowns from double-exchange mechanism",
   aut: "V. G. Chilkuri et al.",
   jou: "Crystals",
   num: "6(4)",
   pag: "39",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.116.196804",
   tit: "Three-particle correlation from a many-body perspective: trions in a carbon nanotube",
   aut: "T. Deilmann et al.",
   jou: "Phys. Rev. Lett.",
   num: "116",
   pag: "196804",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1021/acs.jpcb.6b02021",
   tit: "Atomic spectral methods for ab initio molecular electronic energy surfaces: transitioning from small-molecule to biomolecular-suitable approaches",
   aut: "J. D. Mills et al.",
   jou: "J. Phys. Chem. B",
   num: "120(33)",
   pag: "8321-8337",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.93.134201",
   tit: "Long tail distributions near the many body localization transition",
   aut: "D. J. Luitz",
   jou: "Phys. Rev. B",
   num: "93",
   pag: "134201",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1021/acs.jpca.6b09623",
   tit: "Towards the full quantum dynamical description of photon induced processes in D<sub>2</sub><sup>+</sup>",
   aut: "A. T&oacute;th et al.",
   jou: "J. Phys. Chem. A",
   num: "120",
   pag: "9411-9421",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1007/s00601-016-1075-3",
   tit: "Nonperturbative true muonium on the light front with TMSWIFT",
   aut: "H. Lamm and R. F. Lebed",
   jou: "Few-Body Syst.",
   num: "57(8)",
   pag: "663-667",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.93.235149",
   tit: "Energy projection and modified Laughlin states",
   aut: "M. Fremling et al.",
   jou: "Phys. Rev. B",
   num: "93",
   pag: "235149",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.93.224205",
   tit: "Spin transport of weakly disordered Heisenberg chain at infinite temperature",
   aut: "I. Khait et al.",
   jou: "Phys. Rev. B",
   num: "93",
   pag: "224205",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/srep32653",
   tit: "Even harmonic generation in isotropic media of dissociating homonuclear molecules",
   aut: "R. E. F. Silva et al.",
   jou: "Scientific Reports",
   num: "6",
   pag: "32653",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1063/1.4952414",
   tit: "Adaptive vibrational configuration interaction (A-VCI): a posteriori error estimation to efficiently compute anharmonic IR spectra",
   aut: "R. Garnier et al.",
   jou: "J. Chem. Phys.",
   num: "144",
   pag: "204123",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.117.160601",
   tit: "Power-law entanglement spectrum in many-body localized phases",
   aut: "M. Serbyn et al.",
   jou: "Phys. Rev. Lett.",
   num: "117",
   pag: "160601",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.94.184202",
   tit: "Bimodal entanglement entropy distribution in the many-body localization transition",
   aut: "X. Yu et al.",
   jou: "Phys. Rev. B",
   num: "94",
   pag: "184202",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevD.94.016004",
   tit: "High resolution nonperturbative light-front simulations of the true muonium atom",
   aut: "H. Lamm and R. F. Lebed",
   jou: "Phys. Rev. D",
   num: "94",
   pag: "016004",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   arx: "1606.07494",
   tit: "Lattice QCD for cosmology",
   aut: "Sz. Borsanyi et al.",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.117.170404",
   tit: "Anomalous thermalization in ergodic systems",
   aut: "D. J. Luitz and Y. Bar Lev",
   jou: "Phys. Rev. Lett.",
   num: "117",
   pag: "170404",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   url: "https://repository.asu.edu/attachments/170366/content/Lamm_asu_0010E_15783.pdf",
   tit: "True Muonium on the light front",
   aut: "H. Lamm",
   jou: "PD",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.117.096405",
   tit: "Fermionic symmetry-protected topological phase in a two-dimensional Hubbard model",
   aut: "C.-C. Chen et al.",
   jou: "Phys. Rev. Lett.",
   num: "117",
   pag: "096405",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   url: "http://digitalcommons.utep.edu/dissertations/AAI10151311",
   tit: "Sparse matrix diagonalization in the NRLMOL electronic structure code",
   aut: "M. M. Hassan",
   jou: "MS",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   arx: "1612.02305",
   tit: "On the h-adaptive PUM and the hp-adaptive FEM approaches applied to PDEs in quantum mechanics",
   aut: "D. Davydov et al.",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   url: "http://arxiv.org/abs/1705.06590",
   tit: "Study of diatomic molecules under short intense laser pulses",
   aut: "R. E. Ferreira da Silva",
   jou: "PD",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.researchgate.net/publication/305651282_FEM_modelling_of_Dirac's_equation",
   tit: "FEM modelling of Dirac's equation",
   aut: "P. Gono",
   jou: "PD",
   yr : 2016
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/nature20115",
   tit: "Calculation of the axion mass based on high-temperature lattice quantum chromodynamics",
   aut: "S. Borsanyi et al.",
   jou: "Nature",
   num: "539",
   pag: "69-71",
   yr : 2016
  },
  {cat: phys,
   cla: mfn,
   doi: "10.1103/PhysRevLett.119.260401",
   arx: "1612.07173",
   tit: "Observation of slow dynamics near the many-body localization transition in one-dimensional quasiperiodic systems",
   aut: "H. P. L&uuml;schen et al.",
   jou: "Phys. Rev. Lett.",
   num: "119",
   pag: "260401",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.96.104201",
   tit: "Thouless energy and multifractality across the many-body localization transition",
   aut: "M. Serbyn et al.",
   jou: "Phys. Rev. B",
   num: "96",
   pag: "104201",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.95.035132",
   tit: "Many-body localization in the presence of a small bath",
   aut: "K. Hyatt et al.",
   jou: "Phys. Rev. B",
   num: "95",
   pag: "035132",
   yr : 2017
  },
  {cat: phys,
   cla: mfn,
   doi: "10.1103/PhysRevB.96.020406",
   tit: "Information propagation in isolated quantum systems",
   aut: "D. J. Luitz and Y. Bar Lev",
   jou: "Phys. Rev. B",
   num: "96",
   pag: "020406",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.95.235307",
   tit: "Localization dynamics of excitons in disordered semiconductor quantum wells",
   aut: "R. Singh et al.",
   jou: "Phys. Rev. B",
   num: "95",
   pag: "235307",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   url: "http://www.theses.fr/2017SACLS113",
   tit: "Description de la dynamique de la fission dans le formalisme de la m&eacute;thode de la coordonn&eacute;e g&eacute;n&eacute;ratrice d&eacute;pendante du temps",
   aut: "M. Verri&egrave;re",
   jou: "PD",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.96.022503",
   tit: "Electronic-nuclear entanglement in H<sub>2</sub><sup>+</sup>: Schmidt decomposition of non-Born-Oppenheimer wave functions expanded in nonorthogonal basis sets",
   aut: "J. L. Sanz-Vicario et al.",
   jou: "Phys. Rev. A",
   num: "96",
   pag: "022503",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2017.07.023",
   tit: "A parallel algorithm for Hamiltonian matrix construction in electron-molecule collision calculations: MPI-SCATCI",
   aut: "A. F. Al-Refaie and J. Tennyson",
   jou: "Comput. Phys. Commun.",
   num: "221",
   pag: "53-62",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1021/acs.nanolett.7b03111",
   tit: "Huge trionic effects in graphene nanoribbons",
   aut: "T. Deilmann  and M. Rohlfing",
   jou: "Nano Lett.",
   num: "17(11)",
   pag: "6833-6837",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1209/0295-5075/119/34004",
   arx: "1706.04393",
   tit: "Coherent modes of X-ray beams emitted by undulators in new storage rings",
   aut: "M. Glass and M. Sanchez del Rio",
   jou: "EPL",
   num: "119(3)",
   pag: "34004",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   url: "https://tel.archives-ouvertes.fr/tel-01646867",
   tit: "Statistical optics for synchrotron emission: numerical calculation of coherent modes",
   aut: "M. Glass",
   jou: "PD",
   yr : 2017
  },
  {cat: phys,
   cla: mfn,
   arx: "1706.09429",
   doi: "10.21468/SciPostPhys.3.4.029",
   tit: "Absence of dynamical localization in interacting driven systems",
   aut: "D. J. Luitz et al.",
   jou: "SciPost Phys.",
   num: "3",
   pag: "029",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.96.195305",
   tit: "Removal of accidental degeneracy in semiconductor quantum dots",
   aut: "S. Bharadwaj et al.",
   jou: "Phys. Rev. B",
   num: "96",
   pag: "195305",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   arx: "1707.01079",
   doi: "10.1038/s41598-017-16178-8",
   tit: "PsiQuaSP - A library for efficient computation of symmetric open quantum systems",
   aut: "M. Gegg and M. Richter",
   jou: "Scientific Reports",
   num: "7",
   pag: "16304",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.14279/depositonce-6526",
   tit: "Identical emitters, collective effects and dissipation in quantum optics",
   aut: "M. Gegg",
   jou: "PD",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1063/1.5017430",
   tit: "Efficient numerical method for investigating diatomic molecules with single active electron subjected to intense and ultrashort laser fields",
   aut: "G. Z. Kiss et al.",
   jou: "AIP Conf. Proc.",
   num: "1916",
   pag: "020010",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41467-017-02286-6",
   tit: "Diversity of trion states and substrate effects in the optical properties of an MoS<sub>2</sub> monolayer",
   aut: "M. Dr&uuml;ppel et al.",
   jou: "Nature Comm.",
   num: "8",
   pag: "2117",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41467-017-01298-6",
   tit: "Exciton fission in monolayer transition metal dichalcogenide semiconductors",
   aut: "A. Steinhoff et al.",
   jou: "Nature Comm.",
   num: "8",
   pag: "1166",
   yr : 2017
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.97.201105",
   arx: "1704.00738",
   tit: "Many-body localization transition: Schmidt gap, entanglement length, and scaling",
   aut: "J. Gray et al.",
   jou: "Phys. Rev. B",
   num: "97",
   pag: "201105",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.97.085302",
   arx: "1705.07005",
   tit: "Optimization of edge state velocity in the integer quantum Hall regime",
   aut: "H. Sahasrabudhe et al.",
   jou: "Phys. Rev. B",
   num: "97",
   pag: "085302",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.21468/SciPostPhys.4.1.002",
   arx: "1707.06759",
   tit: "Many-body localization of spinless fermions with attractive interactions in one dimension",
   aut: "S.-H. Lin et al.",
   jou: "SciPost Phys.",
   num: "4",
   pag: "002",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/1367-2630/aa9cdd",
   arx: "1705.02889",
   tit: "Superradiant to subradiant phase transition in the open system Dicke model: Dark state cascades",
   aut: "M. Gegg et al.",
   jou: "New J. Phys.",
   num: "20",
   pag: "013006",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/qua.25638",
   tit: "General build up of K<sub>+</sub> basis and K<sub>+</sub><sup>2</sup> matrix in the diagonalization approach. Determination of Kramers configuration state functions",
   aut: "M. Gall et al.",
   jou: "Int. J. Quantum Chem.",
   num: "",
   pag: "e25638",
   yr : 2018
  },
  //{cat: phys,
  // cla: epsh,
  // url: "http://users.wpi.edu/~spandey2/docs/jascome.pdf",
  // tit: "Modeling of 3D semiconductor quantum dots in a parallel computing environment",
  // aut: "L. R. Ram-Mohan et al.",
  // jou: "TR",
  // yr : 2018
  //},
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/20.500.11767/68070",
   tit: "Large-scale implementation of the density matrix renormalization group algorithm",
   aut: "J. Vance",
   jou: "MS",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevE.97.052105",
   tit: "Ordering statistics of four random walkers on a line",
   aut: "B. Helenbrook and D. ben-Avraham",
   jou: "Phys. Rev. E.",
   num: "97",
   pag: "052105",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.97.054304",
   tit: "Anyonic self-induced disorder in a stabilizer code: Quasi many-body localization in a translational invariant model",
   aut: "H. Yarloo et al.",
   jou: "Phys. Rev. B",
   num: "97",
   pag: "054304",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "https://epub.uni-regensburg.de/37305",
   tit: "Localization, dualization, and magnetic fields in strongly coupled quantum field theories",
   aut: "J. Wellnhofer",
   jou: "PD",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/d5acd452ad6bea7f1dfa7b9270a56c3d",
   tit: "Abandoning the absolute: topological phenomena in molecular and condensed systems",
   aut: "L. F. Muechler",
   jou: "PD",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1801.03243",
   tit: "Spectra of gauge code Hamiltonians",
   aut: "S. Burton",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1801.04225",
   doi: "10.1038/s41567-018-0282-x",
   tit: "Biexciton fine structure in monolayer transition metal dichalcogenides",
   aut: "A. Steinhoff et al.",
   jou: "Nature Physics",
   num: "",
   pag: "oct",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1801.09596",
   doi: "10.1016/j.cma.2018.07.042",
   tit: "Orbital-enriched flat-top partition of unity method for the Schr&ouml;dinger eigenproblem",
   aut: "C. Albrecht et al.",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "342",
   pag: "224-239",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1803.05395",
   doi: "10.21468/SciPostPhys.5.5.045",
   tit: "Shift-invert diagonalization of large many-body localizing spin chains",
   aut: "F. Pietracaprina et al.",
   jou: "SciPost Phys.",
   num: "5",
   pag: "045",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.97.245427",
   arx: "1803.05483",
   tit: "Inter- and intra-layer excitons in MoS<sub>2</sub>/WS<sub>2</sub> and MoSe<sub>2</sub>/WSe<sub>2</sub> heterobilayers",
   aut: "E. Torun et al.",
   jou: "Phys. Rev. B",
   num: "97",
   pag: "245427",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1806.08316",
   doi: "10.1103/PhysRevB.98.161122",
   tit: "Detection and characterization of many-body localization in central spin models",
   aut: "D. Hetterich et al.",
   jou: "Phys. Rev. B",
   num: "98",
   pag: "161122",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1806.10933",
   doi: "10.1103/PhysRevB.98.155134",
   tit: "Quantum scarred eigenstates in a Rydberg atom chain: entanglement, breakdown of thermalization, and stability to perturbations",
   aut: "C. J. Turner et al.",
   jou: "Phys. Rev. B",
   num: "98",
   pag: "155134",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "http://www.ilasl.org/index.php/Incontri/article/view/378",
   tit: "Thermal properties of TPD-based organic glasses",
   aut: "R. Dettori and L. Colombo",
   jou: "Incontri di Studio",
   num: "(Istituto Lombardo, Accademia di Scienze e Lettere)",
   pag: "Aspetti della Moderna Triade Calore-Elettricit&agrave;-Meccanica",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/jcc.25350",
   tit: "SIESTA-SIPs: Massively parallel spectrum-slicing eigensolver for an ab initio molecular dynamics package",
   aut: "M. Ke&ccedil;eli et al.",
   jou: "J. Comput. Chem.",
   num: "39(22)",
   pag: "1806-1814",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.21105/joss.00819",
   tit: "quimb: A python package for quantum information and many-body calculations",
   aut: "J. Gray",
   jou: "J. Open Source Soft.",
   num: "3(29)",
   pag: "819",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.98.043434",
   tit: "Angular momentum distribution in Rydberg states excited by a strong laser pulse",
   aut: "J. Venzke et al.",
   jou: "Phys. Rev. A",
   num: "98",
   pag: "043434",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/1367-2630/aaf196",
   tit: "A pump-probe scheme with a single chirped pulse to image electron and nuclear dynamics in molecules",
   aut: "D. Jelovina et al.",
   jou: "New J. Phys.",
   num: "20(12)",
   pag: "123004",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   arx: "1812.05943",
   tit: "Fiend-Finite element quantum dynamics",
   aut: "J. Solanp&auml;&auml;, E. R&auml;s&auml;nen",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/20.500.11767/86168",
   tit: "Large-scale exact diagonalization of spin models with non-Abelian symmetries for the study of many-body localization",
   aut: "R. K. Panda",
   jou: "MS",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/20.500.11767/86166",
   tit: "Massively parallel approaches to frustrated quantum magnets",
   aut: "A. M. Foggia",
   jou: "MS",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "http://dx.doi.org/10.14279/depositonce-6882",
   tit: "Theory of multidimensional spectroscopy and excitation transfer processes in nanostructures",
   aut: "J. F. Specht",
   jou: "PD",
   yr : 2018
  },
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/11584/254639",
   tit: "Thermal properties of TPD-based organic glasses",
   aut: "R. Dettori, L. Colombo",
   boo: "Incontri di Studio",
   pag: "49-76",
   yr : 2018
  },
  {cat: phys,
   cla: mfn,
   arx: "1708.01620",
   doi: "10.1103/PhysRevResearch.1.033202",
   tit: "Exponentially slow heating in short and long-range interacting Floquet systems",
   aut: "F. Machado et al.",
   jou: "Phys. Rev. Research",
   num: "1",
   pag: "033202",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1810.08209",
   doi: "10.1103/PhysRevB.99.165137",
   tit: "Investigating many-body mobility edges in isolated quantum systems",
   aut: "X. B. Wei, C. Cheng, G. Xianlong, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "99",
   pag: "165137",
   yr : 2019
  },
  {cat: phys,
   cla: mfn,
   arx: "1811.01912",
   doi: "10.21468/SciPostPhys.6.4.050",
   tit: "Many-body localization in a quasiperiodic Fibonacci chain",
   aut: "N. Mac&eacute;, N. Laflorencie, F. Alet",
   jou: "SciPost Phys.",
   num: "6",
   pag: "050",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1810.08434",
   doi: "10.1103/PhysRevB.99.054403",
   tit: "Emergent statistical bubble localization in a Z<sub>2</sub> lattice gauge theory",
   aut: "H. Yarloo et al.",
   jou: "Phys. Rev. B",
   num: "99",
   pag: "054403",
   yr : 2019
  },
  {cat: phys,
   cla: mfn,
   arx: "1704.02770",
   doi: "10.1016/j.cpc.2018.08.010",
   tit: "Massively parallel implementation and approaches to simulate quantum dynamics using Krylov subspace techniques",
   aut: "M. Brenes et al.",
   jou: "Comput. Phys. Commun.",
   num: "235",
   pag: "477-488",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   url: "https://scholar.colorado.edu/honr_theses/1759/",
   tit: "Selection rules and population trapping in Rydberg states in strong field interactions",
   aut: "Z. Xue",
   jou: "MS",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/10919/87436",
   tit: "Exact diagonalization study of strongly correlated topological quantum states",
   aut: "M. Chen",
   jou: "PD",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   url: "http://discovery.ucl.ac.uk/id/eprint/10067195",
   tit: "Many-body entanglement in classical & quantum simulators",
   aut: "J. Gray",
   jou: "PD",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   doi: "10.3846/mma.2019.017",
   tit: "Numerical simulation of charged fullerene spectrum",
   aut: "R. Arutyunyan, Y. Obukhov, P. Vabishchevich",
   jou: "Math. Model. Anal.",
   num: "24(2)",
   pag: "263-275",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.122.187401",
   tit: "Exciton-phonon coupling in the ultraviolet absorption and emission spectra of bulk hexagonal boron nitride",
   aut: "F. Paleari, H. P. C. Miranda, A. Molina-S&aacute;nchez, L. Wirtz",
   jou: "Phys. Rev. Lett.",
   num: "122",
   pag: "187401",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   url: "http://urn.fi/URN:ISBN:978-952-03-1141-4",
   tit: "Optimization of ultrafast strong-field phenomena",
   aut: "J. Solanp&auml;&auml;",
   jou: "PD",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   url: "https://tel.archives-ouvertes.fr/tel-01664052",
   tit: "Statistical optics for synchrotron emission: numerical calculation of coherent modes",
   aut: "M. Glass",
   jou: "PD",
   yr : 2019
  },
  {cat: phys,
   cla: epsnh,
   arx: "1901.03922",
   doi: "10.1103/PhysRevA.99.053619",
   tit: "Nonlinear waves in an experimentally motivated ring-shaped Bose-Einstein condensate setup",
   aut: "M. Haberichter, P. G. Kevrekidis, R. Carretero-Gonzalez, M. Edwards",
   jou: "Phys. Rev. A",
   num: "99",
   pag: "053619",
   yr : 2019
  },
  {cat: phys,
   cla: epss,
   arx: "1902.03837",
   doi: "10.1088/1361-648X/ab15d0",
   tit: "Many-body perturbation theory calculations using the yambo code",
   aut: "D. Sangalli et al.",
   jou: "J. Phys.: Condens. Matter",
   num: "31",
   pag: "325902",
   yr : 2019
  },
  {cat: phys,
   cla: mfn,
   url: "http://resolver.caltech.edu/CaltechTHESIS:05292019-112014488",
   tit: "Numerical methods for many-body quantum dynamics",
   aut: "C. D. White",
   jou: "PD",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.100.045205",
   tit: "Plasmon dispersion in graphite: A comparison of current ab initio methods",
   aut: "S. M. Anderson, B. S. Mendoza, G. Fugallo, F. Sottile",
   jou: "Phys. Rev. B",
   num: "100",
   pag: "045205",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1811.01346",
   doi: "10.1103/PhysRevB.100.115310",
   tit: "Excitonic complexes in MOCVD-grown InGaAs/GaAs quantum dots emitting at telecom wavelengths",
   aut: "P. Mrowinski et al.",
   jou: "Phys. Rev. B",
   num: "100",
   pag: "115310",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41467-019-11225-6",
   tit: "Uniaxial transition dipole moments in semiconductor quantum rings caused by broken rotational symmetry",
   aut: "N. F. Hartmann, M. Otten, I. Fedin, D. Talapin, M. Cygorek, P. Hawrylak, M. Korkusinski, S. Gray, A. Hartschuh, X. Ma",
   jou: "Nature Comm.",
   num: "10",
   pag: "3253",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1902.00357",
   doi: "10.21468/SciPostPhys.7.1.008",
   tit: "Many-body localization in presence of cavity mediated long-range interactions",
   aut: "P. Sierant, K. Biedro&nacute;, G. Morigi, J. Zakrzewski",
   jou: "SciPost Phys.",
   num: "7",
   pag: "008",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevMaterials.3.103802",
   tit: "Elastodiffusion and cluster mobilities using kinetic Monte Carlo simulations: Fast first-passage algorithms for reversible diffusion processes",
   aut: "M. Ath&egrave;nes, S. Kaur, G. Adjanor, T. Vanacker, T. Jourdan",
   jou: "Phys. Rev. Materials",
   num: "3",
   pag: "103802",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1906.10701",
   doi: "10.21468/SciPostPhys.7.5.064",
   tit: "Statistics of correlation functions in the random Heisenberg chain",
   aut: "L. Colmenarez, P. A. McClarty, M. Haque, D. J. Luitz",
   jou: "SciPost Phys.",
   num: "7",
   pag: "064",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1904.13165",
   doi: "10.1103/PhysRevB.100.224202",
   tit: "Neural network setups for a precise detection of the many-body localization transition: finite-size scaling and limitations",
   aut: "H. Th&eacute;veniaut and F. Alet",
   jou: "Phys. Rev. B",
   num: "100",
   pag: "224202",
   yr : 2019
  },
  {cat: phys,
   cla: mfn,
   doi: "10.1016/j.jcp.2019.06.020",
   tit: "A simple pseudospectral method for the computation of the time-dependent Dirac equation with Perfectly Matched Layers",
   aut: "X. Antoine and E. Lorin",
   jou: "J. Comput. Phys.",
   num: "395",
   pag: "583-601",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1908.02761",
   tit: "Scale invariant entanglement negativity at the many-body localization transition",
   aut: "J. Gray, A. Bayat, A. Pal, S. Bose",
   yr : 2019
  },
  {cat: phys,
   cla: epsh,
   arx: "1902.04091",
   doi: "10.1103/PhysRevResearch.2.033154",
   tit: "Transition to a many-body localized regime in a two-dimensional disordered quantum dimer model",
   aut: "H. Th&eacute;veniaut, Z. Lan, G. Meyer, F. Alet",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "033154",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1904.00480",
   doi: "10.1126/sciadv.abb5915",
   tit: "Non-adiabatic effects in exciton-mediated Raman scattering from first principles",
   aut: "S. Reichardt and L. Wirtz",
   jou: "Sci. Adv.",
   num: "6",
   pag: "eabb5915",
   yr : 2020
  },
  {cat: phys,
   cla: mfn,
   arx: "1902.01859",
   doi: "10.1103/PhysRevLett.125.030601",
   tit: "Emergent hydrodynamics in nonequilibrium quantum systems",
   aut: "B. Ye, F. Machado, C. D. White, R. S. K. Mong, N. Y. Yao",
   jou: "Phys. Rev. Lett.",
   num: "125",
   pag: "030601",
   yr : 2020
  },
  {cat: phys,
   cla: mfn,
   arx: "1908.10371",
   doi: "10.1103/PhysRevX.10.021046",
   tit: "Prethermalization without temperature",
   aut: "D. J. Luitz, R. Moessner, S. L. Sondhi, V. Khemani",
   jou: "Phys. Rev. X",
   num: "10",
   pag: "021046",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1909.06380",
   doi: "10.21468/SciPostPhysCore.2.2.006",
   tit: "Multifractality and its role in anomalous transport in the disordered XXZ spin-chain",
   aut: "D. J. Luitz, I. Khaymovich, Y. Bar Lev",
   jou: "SciPost Phys. Core",
   num: "2",
   pag: "006",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1912.13403",
   doi: "10.1016/j.cpc.2020.107459",
   tit: "ELSI-An Open Infrastructure for Electronic Structure Solvers",
   aut: "V. Yu et al.",
   jou: "Comput. Phys. Commun.",
   num: "256",
   pag: "107459",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1907.09512",
   doi: "10.1103/PhysRevB.101.035401",
   tit: "Effect of valley, spin, and band nesting on the electronic properties of gated quantum dots in a single layer of transition metal dichalcogenides",
   aut: "M. Bieniek, L. Szulakowska, P. Hawrylak",
   jou: "Phys. Rev. B",
   num: "101",
   pag: "035401",
   yr : 2020
  },
  {cat: phys,
   cla: epsnh,
   arx: "1912.07451",
   doi: "10.3390/particles3010007",
   tit: "The Dirac spectrum and the BEC-BCS crossover in QCD at nonzero isospin asymmetry",
   aut: "B. B. Brandt, F. Cuteri, G. Endrodi, S. Schmalzbauer",
   jou: "Particles",
   num: "3(1)",
   pag: "80-86",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1910.08528",
   doi: "10.1103/PhysRevB.101.075307",
   tit: "Atomistic theory of electronic and optical properties of InAsP/InP nanowire quantum dots",
   aut: "M. Cygorek, M. Korkusinski, P. Hawrylak",
   jou: "Phys. Rev. B",
   num: "101",
   pag: "075307",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1908.01818",
   doi: "10.1103/PhysRevResearch.2.013173",
   tit: "Subradiant bound dimer excited states of emitter chains coupled to a one dimensional waveguide",
   aut: "Y.-X. Zhang, C. Yu, K. M&oslash;lmer",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "013173",
   yr : 2020
  },
  {cat: phys,
   cla: mfn,
   arx: "1908.07530",
   doi: "10.1103/PhysRevX.10.011043",
   tit: "Long-range prethermal phases of non-equilibrium matter",
   aut: "F. Machado, D. V. Else, G. D. Kahanamoku-Meyer, C. Nayak, N. Y. Yao",
   jou: "Phys. Rev. X",
   num: "10",
   pag: "011043",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1911.07882",
   doi: "10.1209/0295-5075/128/67003",
   tit: "Can we study the many-body localisation transition?",
   aut: "R. K. Panda, A. Scardicchio, M. Schulz, S. R. Taylor, M. Znidaric",
   jou: "Europhys. Lett.",
   num: "128",
   pag: "67003",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1908.03018",
   doi: "10.1016/j.cpc.2019.107092",
   tit: "UKRmol+: a suite for modelling of electronic processes in molecules interacting with electrons, positrons and photons using the R-matrix method",
   aut: "Z. Ma&scaron;&itilde;n, J. Benda, J. D. Gorfinkiel, A. G. Harvey, J. Tennyson",
   jou: "Comput. Phys. Commun.",
   num: "249",
   pag: "107092",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "1903.10959",
   doi: "10.1016/j.cpc.2019.07.016",
   tit: "DFT-FE--A massively parallel adaptive finite-element code for large-scale density functional theory calculations",
   aut: "P. Motamarri, S. Das, S. Rudraraju, K. Ghosh, D. Davydov, V. Gavini",
   jou: "Comput. Phys. Commun.",
   num: "246",
   pag: "106853",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1063/1.5143190",
   tit: "DFTB+, a software package for efficient approximate density functional theory based atomistic simulations",
   aut: "B. Hourahine et al.",
   jou: "J. Chem. Phys.",
   num: "152",
   pag: "124101",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.101.115141",
   arx: "2001.05143",
   tit: "Doping and temperature evolution of pseudogap and spin-spin correlations in the two-dimensional Hubbard model",
   aut: "V. I. Kuz'min, M. A. Visotin, S. V. Nikolaev, S. G. Ovchinnikov",
   jou: "Phys. Rev. B",
   num: "101",
   pag: "115141",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1140/epjd/e2020-100273-9",
   tit: "Photoelectron holography of the H<sub>2</sub><sup>+</sup> molecule",
   aut: "G. Zsolt Kiss, S. Borbely, A. Toth, L. Nagy",
   jou: "Eur. Phys. J. D",
   num: "74",
   pag: "128",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "2003.06738",
   doi: "10.1103/PhysRevResearch.2.033024",
   tit: "Magnetic-field-induced tunability of spin Hamiltonians: resonances and Efimov states in Yb<sub>2</sub>Ti<sub>2</sub>O<sub>7</sub>",
   aut: "Y. Kato, S.-S. Zhang, Y. Nishida, C. D. Batista",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "033024",
   yr : 2020
  },
  {cat: phys,
   cla: epsnh,
   arx: "2004.10446",
   doi: "10.1103/PhysRevA.102.053307",
   tit: "Deflation-based identification of nonlinear excitations of the 3D Gross-Pitaevskii equation",
   aut: "N. Boull&eacute;, E. G. Charalampidis, P. E. Farrell, P. G. Kevrekidis",
   jou: "Phys. Rev. A",
   num: "102",
   pag: "053307",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "2005.05756",
   doi: "10.1063/5.0012901",
   tit: "The CECAM Electronic Structure Library and the modular software development paradigm",
   aut: "M. J. T. Oliveira et al.",
   jou: "J. Chem. Phys.",
   num: "153",
   pag: "024117",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "2006.12076",
   doi: "10.1103/PhysRevB.102.054204",
   tit: "Statistically related many-body localization in one-dimensional anyon Hubbard model",
   aut: "G.-Q. Zhang, D.-W. Zhang, Z. Li, Z. D. Wang, S.-L. Zhu",
   jou: "Phys. Rev. B",
   num: "102",
   pag: "054204",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.20381/ruor-25208",
   tit: "Electron-electron interactions and optical properties of two-dimensional nanocrystals",
   aut: "L. Szulakowska",
   jou: "PD",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1088/2053-1583/abc7f8",
   tit: "Thermal transport in amorphous graphene with varying structural quality",
   aut: "A. Antidormi, L. Colombo, S. Roche",
   jou: "2D Mater.",
   num: "8(1)",
   pag: "015028",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   url: "http://www.scl.rs/theses/phd-zbodroski.pdf",
   tit: "Development of serial and parallel algorithms for computing the electronic structure of materials using the charge patching method",
   aut: "&Zcaron;. Bodro&scaron;ki",
   jou: "PD",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1039/D0CP05060A",
   tit: "Influence of the Coriolis effect on the properties of scattering resonances in symmetric and asymmetric isotopomers of ozone",
   aut: "I. Gayday, E. Grushnikova, D. Babikov",
   jou: "Phys. Chem. Chem. Phys.",
   num: "22",
   pag: "27560",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.102.224309",
   arx: "2007.14982",
   tit: "Homogeneous Floquet time crystal from weak ergodicity breaking",
   aut: "H. Yarloo, A. E. Kopaei, A. Langari",
   jou: "Phys. Rev. B",
   num: "102",
   pag: "224309",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   arx: "2009.01711",
   doi: "10.1103/PhysRevResearch.2.043425",
   tit: "Quantum half-orphans in kagom&eacute; antiferromagnets",
   aut: "P. Patil, F. Alet, S. Capponi, K. Damle",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "043425",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevResearch.2.033154",
   tit: "Transition to a many-body localized regime in a two-dimensional disordered quantum dimer model",
   aut: "H. Th&eacute;veniaut, Z. Lan, G. Meyer, F. Alet",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "033154",
   yr : 2020
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevResearch.2.042031",
   tit: "Scaling up the Anderson transition in random-regular graphs",
   aut: "M. Pino",
   jou: "Phys. Rev. Research",
   num: "2",
   pag: "042031",
   yr : 2020
  },
  {cat: phys,
   cla: epsnh,
   arx: "2004.04406",
   doi: "10.1016/j.jcp.2020.109917",
   tit: "Trace preserving quantum dynamics using a novel reparametrization-neutral summation-by-parts difference operator",
   aut: "O. Alund, Y. Akamatsu, F. Laur&eacute;n, T. Miura, J. Nordstr&ouml;m, A. Rothkopf",
   jou: "J. Comput. Phys.",
   num: "425",
   pag: "109917",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2008.07542",
   doi: "10.1088/2053-1583/ac3259",
   tit: "Incommensurability-induced sub-ballistic narrow-band-states in twisted bilayer graphene",
   aut: "M. Gon&ccedil;alves, H. Z. Olyaei, B. Amorim, R. Mondaini, P. Ribeiro, E. V. Castro",
   jou: "2D Mater.",
   num: "9(1)",
   pag: "011001",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2012.04320",
   doi: "10.1103/PhysRevB.104.045303",
   tit: "Vibrational and vibronic structure of isolated point defects: the nitrogen-vacancy center in diamond",
   aut: "L. Razinkovas, M. W. Doherty, N. B. Manson, C. G. Van de Walle, A. Alkauskas",
   jou: "Phys. Rev. B",
   num: "104",
   pag: "045303",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2012.09892",
   doi: "10.1103/PhysRevB.103.195141",
   tit: "Post quench entropy growth in a chiral clock model",
   aut: "N. Nishad, M. Santhosh, G. J. Sreejith",
   jou: "Phys. Rev. B",
   num: "103",
   pag: "195141",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2002.12347",
   doi: "10.1038/s41586-021-03418-1",
   tit: "Leading hadronic contribution to the muon magnetic moment from lattice QCD",
   aut: "Sz. Borsanyi et al.",
   jou: "Nature",
   num: "593",
   pag: "51-55",
   yr : 2021
  },
  {cat: phys,
   cla: mfn,
   arx: "2011.09814",
   doi: "10.1103/PhysRevD.103.094502",
   tit: "Thermalization of Yang-Mills theory in a (3+1)dimensional small lattice",
   aut: "T. Hayata, Y. Hidaka",
   jou: "Phys. Rev. D",
   num: "103",
   pag: "094502",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.126.150601",
   arx: "2009.05295",
   tit: "Chaos and ergodicity across the energy spectrum of interacting bosons",
   aut: "L. Pausch, E. G. Carnio, A. Rodr&iacute;guez, A. Buchleitner",
   jou: "Phys. Rev. Lett.",
   num: "126",
   pag: "150601",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2010.12594",
   doi: "10.1103/PhysRevLett.126.136601",
   tit: "Exactly solvable model for strongly interacting electrons in a magnetic field",
   aut: "A. Anand, J. K. Jain, G. J. Sreejith",
   jou: "Phys. Rev. Lett.",
   num: "126",
   pag: "136601",
   yr : 2021
  },
  {cat: phys,
   cla: mfn,
   doi: "10.1103/PhysRevLett.126.030602",
   tit: "Many-body chaos in the Sachdev-Ye-Kitaev model",
   aut: "B. Kobrin, Z. Yang, G. D. Kahanamoku-Meyer, C. T. Olund, J. E. Moore, D. Stanford, N. Y. Yao",
   jou: "Phys. Rev. Lett.",
   num: "126",
   pag: "030602",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2012.03537",
   doi: "10.1103/PhysRevD.103.054505",
   tit: "Clear correlation between monopoles and the chiral condensate in SU(3) QCD",
   aut: "H. Ohata, H. Suganuma",
   jou: "Phys. Rev. D",
   num: "103",
   pag: "054505",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2001.03158",
   doi: "10.1007/JHEP02(2021)034",
   tit: "Entanglement and confinement in coupled quantum systems",
   aut: "F. Alet, M. Hanada, A. Jevicki, C. Peng",
   jou: "J. High Energy Phys.",
   num: "2021",
   pag: "34",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2005.10233",
   doi: "10.21468/SciPostPhys.10.2.044",
   tit: "Probing many-body localization in a disordered quantum dimer model on the honeycomb lattice",
   aut: "F. Pietracaprina, F. Alet",
   jou: "SciPost Phys.",
   num: "10",
   pag: "044",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2009.00239",
   doi: "10.1103/PhysRevB.103.035125",
   tit: "Interplay of local order and topology in the extended Haldane-Hubbard model",
   aut: "C. Shao, E. V. Castro, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "103",
   pag: "035125",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s42005-021-00563-x",
   tit: "Biexcitons fine structure and non-equilibrium effects in transition metal dichalcogenides monolayers from first principles",
   aut: "A. Torche, G. Bester",
   jou: "Comm. Phys.",
   num: "4",
   pag: "67",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   url: "https://epublications.marquette.edu/dissertations_mu/1066",
   tit: "Toward understanding the origin of mass-independent fractionation in sulfur allotropes and in ozone",
   aut: "I. Gayday",
   jou: "PD",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.3390/nano11051258",
   tit: "Spin-resolved quantum scars in confined spin-coupled two-dimensional electron gas",
   aut: "M. Berger, D. Schulz, J. Berakdar",
   jou: "Nanomaterials",
   num: "11(5)",
   pag: "1258",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/63cd45cbe4ab6037c0404807ba3ce225",
   tit: "Theoretical studies on imaging of electron motion and excitation on ultrafast time scales",
   aut: "J. Venzke",
   jou: "PD",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2021.108084",
   tit: "SpectrumSDT: A program for parallel calculation of coupled rotational-vibrational energies and lifetimes of bound states and scattering resonances in triatomic systems",
   aut: "I. Gayday, A. Teplukhin, J. Moussa, D. Babikov",
   jou: "Comput. Phys. Commun.",
   num: "267",
   pag: "108084",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/adma.202008708",
   tit: "Strong suppression of thermal conductivity in the presence of long terminal Alkyl chains in low-disorder molecular semiconductors",
   aut: "E. Selezneva, A. Vercouter, G. Schweicher, V. Lemaur, K. Broch, A. Antidormi, K. Takimiya, V. Coropceanu, J.-L. Br&eacute;das, C. Melis, J. Cornil, H. Sirringhaus",
   jou: "Adv. Mater.",
   num: "33(37)",
   pag: "2008708",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2101.05432",
   doi: "10.1007/JHEP10(2021)096",
   tit: "Exact symmetries and threshold states in two-dimensional models for QCD",
   aut: "R. Dempsey, I. R. Klebanov, S. S. Pufu",
   jou: "J. High Energ. Phys.",
   num: "96",
   pag: "",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1039/D1SC01262B",
   tit: "Unraveling the effect of defects, domain size, and chemical doping on photophysics and charge transport in covalent organic frameworks",
   aut: "R. Ghosh, F. Paesani",
   jou: "Chem. Sci.",
   num: "12",
   pag: "8373-8384",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2103.03015",  // https://www.researchgate.net/publication/349826612
   doi: "10.1063/5.0056303",
   tit: "A theory of localized excitations in supercooled liquids",
   aut: "M. R. Hasyim, K. K. Mandadapu",
   jou: "J. Chem. Phys.",
   num: "155",
   pag: "044504",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2107.10056",
   doi: "10.1103/PhysRevB.104.195117",
   tit: "Interplay of interactions, disorder and topology in the Haldane-Hubbard model",
   aut: "T.-C. Yi, S. Hu, E. V. Castro, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "104",
   pag: "195117",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   url: "https://doi.org/10.33774/chemrxiv-2021-tb31g",
   doi: "10.1021/acs.jpclett.1c02454",
   tit: "Topology-mediated enhanced polaron coherence in covalent organic frameworks",
   aut: "R. Ghosh, F. Paesani",
   jou: "J. Phys. Chem. Lett.",
   num: "12",
   pag: "9442-9448",
   yr : 2021
  },
  {cat: phys,
   cla: mfn,
   arx: "2108.08808",
   doi: "10.1007/JHEP11(2021)015",
   tit: "Sparse SYK and traversable wormholes",
   aut: "E. Caceres, A. Misobuchi, R. Pimentel",
   jou: "J. High Energy Phys.",
   num: "2021",
   pag: "015",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.104.063102",
   tit: "Strong-field control by reverse engineering",
   aut: "A. T&oacute;th, A. Csehi",
   jou: "Phys. Rev. A",
   num: "104",
   pag: "063102",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1063/5.0067855",
   url: "https://doi.org/10.33774/chemrxiv-2021-pk7m6-v3",
   tit: "Flexible boundary layer using exchange for embedding theories. I. Theory and implementation",
   aut: "Z. Shen, W. J. Glover",
   jou: "J. Chem. Phys.",
   num: "155",
   pag: "224112",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.15388/vu.thesis.263",
   tit: "Vibrational properties and photoionization of color centers in diamond: theory and ab initio calculations",
   aut: "L. Razinkovas",
   jou: "PD",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2109.06236",
   doi: "10.1088/1367-2630/ac3c0d",
   tit: "Chaos in the Bose-Hubbard model and Random Two-Body Hamiltonians",
   aut: "L. Pausch, E. G. Carnio, A. Buchleitner, A. Rodr&iacute;guez",
   jou: "New J. Phys.",
   num: "23",
   pag: "123036",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.126.100604",
   tit: "Emergent ergodicity at the transition between many-body localized phases",
   aut: "R. Sahay, F. Machado, B. Ye, C. R. Laumann, N. Y. Yao",
   jou: "Phys. Rev. Lett.",
   num: "126",
   pag: "100604",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   url: "http://urn.fi/URN:NBN:fi:jyu-202111195725",
   tit: "A software for simulating dispersive properties of multilayered phononic crystal membranes",
   aut: "P. Lappalainen",
   jou: "MS",
   yr : 2021
  },
  {cat: phys,
   cla: epsnh,
   arx: "2111.11544",
   tit: "Master-field simulations of QCD",
   aut: "P. Fritzsch, J. Bulava, M. C&egrave;, A. Francis, M. L&uuml;scher, A. Rago",
   yr : 2021
  },
  {cat: phys,
   cla: epsnh,
   arx: "2112.11113",
   tit: "Searching for the BCS phase at nonzero isospin asymmetry",
   aut: "B. B. Brandt, F. Cuteri, G. Endr&odblac;di",
   yr : 2021
  },
  {cat: phys,
   cla: epsh,
   arx: "2102.00010",
   doi: "10.1103/PhysRevX.12.031013",
   tit: "Many-body quantum teleportation via operator spreading in the traversable wormhole protocol",
   aut: "T. Schuster, B. Kobrin, P. Gao, I. Cong, E. T. Khabiboulline, N. M. Linke, M. D. Lukin, C. Monroe, B. Yoshida, N. Y. Yao",
   jou: "Phys. Rev. X",
   num: "12",
   pag: "031013",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2101.04934",
   doi: "10.1103/PhysRevB.105.125127",
   tit: "O(N) ab initio calculation scheme for large-scale Moir&eacute; structures",
   aut: "T. Zhang, N. Regnault, B. A. Bernevig, X. Dai, H. Weng",
   jou: "Phys. Rev. B",
   num: "105",
   pag: "125127",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2008.11173",
   doi: "10.1103/PhysRevX.12.011006",
   tit: "Probing symmetries of quantum many-body systems through gap ratio statistics",
   aut: "O. Giraud, N. Mac&eacute;, &Eacute;. Vernier, F. Alet",
   jou: "Phys. Rev. X",
   num: "12",
   pag: "011006",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2109.13372",
   doi: "10.1103/PhysRevD.105.016020",
   tit: "Critical coupling for two-dimensional &phi;<sup>4</sup> theory in discretized light-cone quantization",
   aut: "J. P. Vary, M. Huang, S. Jawadekar, M. Sharaf, A. Harindranath, D. Chakrabarti",
   jou: "Phys. Rev. D",
   num: "105",
   pag: "016020",
   yr : 2022
  },
  {cat: phys,
   cla: mfn,
   arx: "2112.01994",
   doi: "10.1016/j.jcp.2022.110987",
   tit: "Absorption kinetics of vacancies by cavities in Aluminum: numerical characterization of sink strengths and first-passage statistics through Krylov subspace projection and eigenvalue deflation",
   aut: "S. Kaur, M. Ath&egrave;nes, J. Creuze",
   jou: "J. Comput. Phys.",
   num: "454",
   pag: "110987",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41377-021-00700-9",
   tit: "Modeling electronic and optical properties of III-V quantum dots-selected recent developments",
   aut: "A. Mittelst&auml;dt, A. Schliwa, P. Klenovsk&yacute;",
   jou: "Light. Sci. Appl.",
   num: "11",
   pag: "17",
   yr : 2022
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1103/PhysRevMaterials.6.026001",
   tit: "Surface termination dependence of electronic and optical properties in Ti2CO2 MXene monolayers",
   aut: "Z. Kandemir, E. Torun, F. Paleari, C. Yelgel, C. Sevik",
   jou: "Phys. Rev. Materials",
   num: "6",
   pag: "026001",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41598-022-07259-4",
   tit: "Ultrafast plasmonic photoemission in the single-cycle and few-cycle regimes",
   aut: "G. Zs Kiss, P. F&ouml;ldi, P. Dombi",
   jou: "Sci. Rep.",
   num: "12",
   pag: "3932",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2112.06468",
   doi: "10.1103/PhysRevB.105.165432",
   tit: "Ergodic and nonergodic phases in a one-dimensional clean Jaynes-Cummings-Hubbard system with detuning",
   aut: "J.-L. Ma, Q. Li, L. Tan",
   jou: "Phys. Rev. B",
   num: "105",
   pag: "165432",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2201.10246",
   doi: "10.1103/PhysRevA.106.L031301",
   tit: "Topological molecules and topological localization of a Rydberg electron on a classical orbit",
   aut: "A. E. Kopaei, X. Tian, K. Giergiel, K. Sacha",
   jou: "Phys. Rev. A",
   num: "106",
   pag: "L031301",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2203.07820",
   doi: "10.1016/j.cpc.2022.108473",
   tit: "DFT-FE 1.0 : A massively parallel hybrid CPU-GPU density functional theory code using finite-element discretization",
   aut: "S. Das, P. Motamarri, V. Subramanian, D. M. Rogers, V. Gavini",
   jou: "Comput. Phys. Commun.",
   num: "280",
   pag: "108473",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2205.04209",
   doi: "10.1088/1751-8121/ac7e0b",
   tit: "Optimal route to quantum chaos in the Bose-Hubbard model",
   aut: "L. Pausch, A. Buchleitner, E. G. Carnio, A. Rodriguez",
   jou: "J. Phys. A: Math. Theor.",
   num: "55",
   pag: "324002",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41524-022-00857-w",
   tit: "Scanning tunneling microscopy of buried dopants in silicon: images and their uncertainties",
   aut: "P. T. Rozanski G. W. Bryant, M. Zieli&nacute;ski",
   jou: "npj Comput. Mater.",
   num: "8",
   pag: "182",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2205.10349",
   doi: "10.1007/JHEP09(2022)200",
   tit: "The complex heavy-quark potential in an anisotropic quark-gluon plasma - Statics and dynamics",
   aut: "L. Dong, Y. Guo, A. Islam, A. Rothkopf, M. Strickland",
   jou: "J. High Energy Phys.",
   num: "2022",
   pag: "200",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1107/S1600577522008736",
   tit: "A fast and lightweight tool for partially coherent beamline simulations in fourth-generation storage rings based on coherent mode decomposition",
   aut: "M. Sanchez del Rio, R. Celestre, J. Reyes-Herrera, P. Brumund, M. Cammarata",
   jou: "J. Synchrotron Rad.",
   num: "29",
   pag: "6",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1209/0295-5075/ac9e72",
   tit: "Perturbation theory without power series: Iterative construction of non-analytic operator spectra",
   aut: "M. Smerlak",
   jou: "EPL",
   num: "140",
   pag: "32001",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   arx: "2206.05308",
   doi: "10.1103/PhysRevResearch.4.043133",
   tit: "Discrete chiral symmetry and mass shift in lattice Hamiltonian approach to Schwinger model",
   aut: "R. Dempsey, I. R. Klebanov, S. S. Pufu, B. Zan",
   jou: "Phys. Rev. Research",
   num: "4",
   pag: "043133",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.106.245117",
   arx: "2208.04474",
   tit: "Charge excitations across a superconductor-insulator transition",
   aut: "X. Jin, Y. Liu, R. Mondaini, M. Rigol",
   jou: "Phys. Rev. B",
   num: "106",
   pag: "245117",
   yr : 2022
  },
  {cat: phys,
   cla: mfn,
   url: "https://escholarship.org/uc/item/1v3702xn",
   tit: "Out-of-equilibrium dynamics and phases of matter in Atomic, Molecular and Optical systems",
   aut: "F. Leal Machado",
   jou: "PD",
   yr : 2022
  },
  {cat: phys,
   cla: mfn,
   url: "https://nbn-resolving.org/urn:nbn:de:bsz:14-qucosa2-825994",
   tit: "Fast, slow and super slow quantum thermalization",
   aut: "L. Colmenarez",
   jou: "PD",
   yr : 2022
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1051/epjconf/202227402007",
   tit: "Study of hadron masses with Faddeev-Popov eigenmode projection in the Coulomb gauge",
   aut: "H. Ohata, H. Suganuma",
   jou: "EPJ Web of Conferences",
   num: "274",
   pag: "02007",
   yr : 2022
  },
  {cat: phys,
   cla: mfn,
   arx: "2208.12272",
   doi: "10.1103/PhysRevLett.131.160402",
   tit: "Operator growth in open quantum systems",
   aut: "T. Schuster, N. Y. Yao",
   jou: "Phys. Rev. Lett.",
   num: "131",
   pag: "160402",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2208.01054",
   doi: "10.1103/PhysRevB.108.L100202",
   tit: "Mobility edges through inverted quantum many-body scarring",
   aut: "N. S. Srivatsa, H. Yarloo, R. Moessner, A. E. B. Nielsen",
   jou: "Phys. Rev. B",
   num: "108",
   pag: "L100202",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   arx: "2206.01119",
   doi: "10.1103/PhysRevB.108.064514",
   tit: "Superconducting phases of the square-lattice extended Hubbard model",
   aut: "W.-C. Chen, Y. Wang, C.-C. Chen",
   jou: "Phys. Rev. B",
   num: "108",
   pag: "064514",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2205.14614",
   doi: "10.21468/SciPostPhys.15.2.045",
   tit: "Universality in Anderson localization on random graphs with varying connectivity",
   aut: "P. Sierant, M. Lewenstein, A. Scardicchio",
   jou: "SciPost Phys.",
   num: "15",
   pag: "045",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2210.10895",
   doi: "10.1007/JHEP04%282023%29107",
   tit: "Adjoint Majorana QCD<sub>2</sub> at finite N",
   aut: "R. Dempsey, I. R. Klebanov, L. L. Lin, S. S. Pufu",
   jou: "J. High Energy Phys.",
   num: "2023",
   pag: "107",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   arx: "2210.11485",
   doi: "10.1038/s41467-023-39115-y",
   tit: "Coherent dynamics of strongly interacting electronic spin defects in hexagonal boron nitride",
   aut: "R. Gong, G. He, X. Gao, P. Ju, Z. Liu, B. Ye, E. A. Henriksen, T. Li, C. Zu",
   jou: "Nature Comm.",
   num: "14",
   pag: "3299",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2204.07528",
   doi: "10.1073/pnas.2209144120",
   tit: "Inherent-state melting and the onset of glassy dynamics in two-dimensional supercooled liquids",
   aut: "D. Fraggedakis, M. R. Hasyim, K. K. Mandadapu",
   jou: "PNAS",
   num: "120(14)",
   pag: "e2209144120",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2212.05615",
   doi: "10.1021/acs.nanolett.2c04724",
   tit: "Intrinsic control of interlayer exciton generation in van der Waals materials via Janus layers",
   aut: "E. Torun, F. Paleari, M. V. Milosevic, L. Wirtz, C. Sevik",
   jou: "Nano Lett.",
   num: "23(8)",
   pag: "3159-3166",
   yr : 2023
  },
  {cat: phys,
   cla: epsnh,
   arx: "2208.05703",
   doi: "10.1103/PhysRevA.107.012813",
   tit: "Two-component three-dimensional atomic Bose-Einstein condensates supporting complex stable patterns",
   aut: "N. Boull&eacute;, I. Newell, P. E. Farrell, P. G. Kevrekidis",
   jou: "Phys. Rev. A",
   num: "107",
   pag: "012813",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1039/D2SC03793A",
   tit: "Connecting the dots for fundamental understanding of structure-photophysics-property relationships of COFs, MOFs, and perovskites using a multiparticle Holstein formalism",
   aut: "R. Ghosh, F. Paesani",
   jou: "Chem. Sci.",
   num: "14",
   pag: "1040-1064",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2110.15853",
   doi: "10.1016/j.cpc.2022.108516",
   tit: "TTDFT: A GPU accelerated Tucker tensor DFT code for large-scale Kohn-Sham DFT calculations",
   aut: "C.-C. Lin, V. Gavini",
   jou: "Comput. Phys. Commun.",
   num: "282",
   pag: "108516",
   yr : 2023
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1007/s10915-022-02093-2",
   tit: "An efficient adaptive mesh redistribution method for nonlinear eigenvalue problems in Bose-Einstein condensates",
   aut: "H. Xie, M. Xie, X. Yin, G. Zhao",
   jou: "J. Sci. Comput.",
   num: "94",
   pag: "37",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1002/qute.202200160",
   tit: "Controllable spin-split phantom scars in quantum dots",
   aut: "M. Berger, J. Berakdar",
   jou: "Adv. Quantum Technol",
   num: "6(3)",
   pag: "2200160",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1209/0295-5075/acb9b7",
   tit: "Many-body localization in the random-field Heisenberg chain with Dzyaloshinskii-Moriya interaction",
   aut: "Y. Cao, N. Wu",
   jou: "Europhys. Lett.",
   num: "141",
   pag: "48001",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2023.108693",
   tit: "Exploiting underlying crystal lattice for efficient computation of Coulomb matrix elements in multi-million atoms nanostructures",
   aut: "P. T. Rozanski, M. Zielinski",
   jou: "Comput. Phys. Commun.",
   num: "287",
   pag: "108693",
   yr : 2023
  },
  {cat: phys,
   cla: epsnh,
   arx: "2303.01544",
   doi: "10.1038/s41563-023-01556-7",
   tit: "Exciton-assisted electron tunneling in van der Waals heterostructures",
   aut: "L. Wang, S. Papadopoulos, F. Iyikanat, J. Zhang, J. Huang, K. Watanabe, T. Taniguchi, M. Calame, M. L. Perrin, F. J. Garc&itilde;a de Abajo, L. Novotny",
   jou: "Nat. Mater.",
   num: "22",
   pag: "1094-1099",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   url: "https://doi.org/10.26434/chemrxiv-2023-32hnp",
   doi: "10.1021/acs.chemmater.3c00510",
   tit: "Engineering flat and dispersive bands in 2D layered COFs via interlayer stacking and donor-acceptor strategy",
   aut: "Y. Pan, C.-H. Ho, F. Paesani, R. Ghosh",
   jou: "Chem. Mater.",
   num: "35, 16",
   pag: "6235-6245",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.20381/ruor-29033",
   tit: "Electronic and optical properties of 2D materials",
   aut: "Y. Saleem",
   jou: "PD",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevA.107.053101",
   tit: "Role of dynamic Stark shifts in strong-field excitation and subsequent ionization",
   aut: "A. T&oacute;th, S. Borb&eacute;ly, Y. Zhou, A. Csehi",
   jou: "Phys. Rev. A",
   num: "107",
   pag: "053101",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   arx: "2305.07505",
   doi: "10.1007/JHEP11(2023)234",
   tit: "Sparse random matrices and Gaussian ensembles with varying randomness",
   aut: "T. Anegawa, N Iizuka, A. Mukherjee, S. Kumar Sake, S. P. Trivedi",
   jou: "J. High Energy Phys.",
   num: "2023",
   pag: "234",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   arx: "2305.18762",
   doi: "10.1103/PhysRevB.108.085134",
   tit: "Non-Hermitian Haldane-Hubbard model: effective description of one- and two-body dissipation",
   aut: "C. Wang, T.-C. Yi, J. Li, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "108",
   pag: "085134",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2306.09176",
   doi: "10.1063/5.0177082",
   tit: "Realization-dependent model of hopping transport in disordered media",
   aut: "A. Thayil, M. Filoche",
   jou: "Appl. Phys. Lett.",
   num: "123",
   pag: "252102",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   url: "https://nbi.ku.dk/english/theses/masters-theses/oliver-schwarze/Oliver_Schwarze.pdf",
   tit: "Finite element modeling of germanium spin devices",
   aut: "O. H. Schwarze",
   jou: "MS",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/d29126634c6710ff93a3ad11621ccb56",
   tit: "Strong-field interaction with bicircular and elliptically polarized laser pulses",
   aut: "Y. Gebre",
   jou: "PD",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   url: "https://escholarship.org/uc/item/6gb6v2j3",
   tit: "Exploring the limits of classical simulation: from computational many-body dynamics to quantum advantage",
   aut: "G. D. Kahanamoku-Meyer",
   jou: "PD",
   yr : 2023
  },
  {cat: phys,
   cla: mfn,
   arx: "2208.02254",
   doi: "10.1103/PhysRevResearch.5.043284",
   tit: "Learning quantum systems via out-of-time-order correlators",
   aut: "T. Schuster, M. Niu, J. Cotler, T. O'Brien, J. R. McClean, M. Mohseni",
   jou: "Phys. Rev. Research",
   num: "5",
   pag: "043284",
   yr : 2023
  },
  {cat: phys,
   cla: epsnh,
   arx: "2310.01204",
   doi: "10.1103/PhysRevLett.131.216401",
   tit: "Multichannel Dyson equation: coupling many-body Green's functions",
   aut: "G. Riva, P. Romaniello, J. Arjan Berger",
   jou: "Phys. Rev. Lett.",
   num: "131",
   pag: "216401",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.108.035131",
   tit: "Disorder in interacting quasi-one-dimensional systems: Flat and dispersive bands",
   aut: "M.-J. Liang, Y.-F. Yang, C. Cheng, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "108",
   pag: "035131",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   url: "http://hdl.handle.net/10183/271388",
   tit: "Quantum-corrected Monte Carlo device simulator for n-type tri-gate transistors",
   aut: "C. dos Santos Soares",
   jou: "PD",
   yr : 2023
  },
  {cat: phys,
   cla: epsh,
   arx: "2311.09334",
   doi: "10.1007/JHEP08(2024)009",
   tit: "Lattice Hamiltonian for adjoint QCD<sub>2</sub>",
   aut: "R. Dempsey, I. R. Klebanov, S. S. Pufu, B. T. Sogaard",
   jou: "J. High Energy Phys.",
   num: "2024",
   pag: "9",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2207.13299",
   doi: "10.1140/epja/s10050-024-01327-1",
   tit: "Remnants of quark model in lattice QCD simulation in the Coulomb gauge",
   aut: "H. Ohata, H. Suganuma",
   jou: "Eur. Phys. J. A",
   num: "60",
   pag: "97",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2311.07690",
   doi: "10.1103/PhysRevB.109.184204",
   tit: "Correlated volumes for extended wavefunctions on a random-regular graph",
   aut: "M. Pino, J. E. Roman",
   jou: "Phys. Rev. B",
   num: "109",
   pag: "184204",
   yr : 2024
  },
  {cat: phys,
   cla: epsnh,
   arx: "2304.13617",
   doi: "10.1103/PhysRevD.109.074512",
   tit: "QCD Anderson transition with overlap valence quarks on a twisted-mass sea",
   aut: "R. Kehr, D. Smith, L. von Smekal",
   jou: "Phys. Rev. D",
   num: "109",
   pag: "074512",
   yr : 2024
  },
  {cat: phys,
   cla: epsnh,
   arx: "2306.02385",
   doi: "10.1016/j.cpc.2024.109173",
   tit: "Low-mode deflation for twisted-mass and RHMC reweighting in lattice QCD",
   aut: "S. Kuberski",
   jou: "Comput. Phys. Commun.",
   num: "300",
   pag: "109173",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2312.14054",
   doi: "10.1103/PhysRevB.109.125308",
   tit: "Theory of interlayer exciton dynamics in two-dimensional transition metal dichalcogenide heterolayers under the influence of strain reconstruction and disorder",
   aut: "M. Richter",
   jou: "Phys. Rev. B",
   num: "109",
   pag: "125308",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1016/j.cpc.2024.109101",
   tit: "The QISG suite: high-performance codes for studying Quantum Ising Spin Glasses",
   aut: "M. Bernaschi, I. Gonzalez-Adalid Pemartin, V. Martin-Mayor, G. Parisi",
   jou: "Comput. Phys. Commun.",
   num: "298",
   pag: "109101",
   yr : 2024
  },
  {cat: phys,
   cla: mfn,
   url: "https://escholarship.org/uc/item/5m26g8h2",
   tit: "Applications of holography in quantum information dynamics: chaos, teleportation, and metrology",
   aut: "B. Kobryn",
   jou: "PD",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2403.00442",
   tit: "Ergodic and non-ergodic properties of disordered SU(3) chains",
   aut: "B. Dabholkar, F. Alet",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2403.09608",
   doi: "10.1103/PhysRevLett.133.116502",
   tit: "Interaction-driven instabilities in the random-field XXZ chain",
   aut: "J. Colbois, F. Alet, N. Laflorencie",
   jou: "Phys. Rev. Lett.",
   num: "133",
   pag: "116502",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1039/d3cp05949a",
   tit: "Optical spectra and exciton radiative lifetimes in bulk transition metal dichalcogenides",
   aut: "C. E. P. Villegas, E. Marinho Jr., P. Venezuela, A. R. Rocha",
   jou: "Phys. Chem. Chem. Phys.",
   num: "26",
   pag: "13251-13260",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2404.19249",
   tit: "A nonnested augmented subspace method for Kohn-Sham equation",
   aut: "G. Hu, H. Xie, F. Xu, G. Zhao",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   url: "http://fizyka.umk.pl/~mzielin/Machina.pdf",
   tit: "Double P dopants in Si: Wave functions and spatial metrology from STM images",
   aut: "P. T. Rozanski, G. W. Bryant, M. Zielinski",
   jou: "PP",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevB.109.245413",
   tit: "Strain and stacking registry effects on the hyperbolicity of exciton polaritons in few-layer black phosphorus",
   aut: "D. M. N. Thomen, C. Sevik, M. V. Milosevic, L. K. Teles, A. Chaves",
   jou: "Phys. Rev. B",
   num: "109",
   pag: "245413",
   yr : 2024
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1103/PhysRevMaterials.8.075201",
   tit: "Surface termination dependence of electronic and optical properties in Ti2CO2 MXene monolayers",
   aut: "Z. Kandemir, P. D'Amico, G. Sesti, C. Cardoso, M. V. Milosevic, C. Sevik",
   jou: "Phys. Rev. Materials",
   num: "8",
   pag: "075201",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41598-024-67903-z",
   tit: "Challenges to extracting spatial information about double P dopants in Si from STM images",
   aut: "P. T. R&oacute;&zdot;a&nacute;ski, G. W. Bryant, M. Zieli&nacute;ski",
   jou: "Sci. Rep.",
   num: "14",
   pag: "18062",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1145/3673038.3673098",
   tit: "PASCI: A scalable framework for heterogeneous parallel calculation of dynamical electron correlation",
   aut: "R. Jin, W. Liang, H. Zhang, Y. Song, Z. Luo, H. Ma, Y. Ma, Z. Jin",
   pro: "ICPP '24",
   pag: "1103-1113",
   yr : 2024
  },
  {cat: phys,
   cla: epsnh,
   arx: "2406.17543",
   doi: "10.1063/5.0225658",
   tit: "A microscopic approach to crystallization: challenging the classical/non-classical dichotomy",
   aut: "J. F. Lutsko, C. Schoonen",
   jou: "J. Chem. Phys.",
   num: "161",
   pag: "104502",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2406.19850",
   doi: "10.1103/PhysRevResearch.6.043173",
   tit: "Topologically protected quantized changes of the distance between atoms",
   aut: "A. E. Kopaei, K. Giergiel, K. Sacha",
   jou: "Phys. Rev. Research",
   num: "6",
   pag: "043173",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/000ae2be6b6e6e9769a7ff69137ed19f",
   tit: "Ab initio approaches to nuclear structure and scattering",
   aut: "M. A. Sharaf",
   jou: "PD",
   yr : 2024
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1103/PhysRevB.110.115140",
   tit: "Derivation and analysis of the multichannel Dyson equation",
   aut: "G. Riva, P. Romaniello, J. Arjan Berger",
   jou: "Phys. Rev. B",
   num: "110",
   pag: "115140",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/PhysRevLett.133.183401",
   tit: "Quantum nonlinear optics on the edge of a few-particle fractional quantum Hall fluid in a small lattice",
   aut: "A. Nardin, D. de Bernardis, R. O. Umucal&imath;lar, L. Mazza, M. Rizzi, I. Carusotto",
   jou: "Phys. Rev. Lett.",
   num: "133",
   pag: "183401",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   url: "https://hdl.handle.net/10388/16070",
   tit: "Computation of X-ray absorption spectra using a double cluster model",
   aut: "M. Abdollahzadehzare",
   jou: "MS",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   url: "https://urn.kb.se/resolve?urn=urn:nbn:se:uu:diva-539431",
   tit: "Numerical investigation of vortices' formation in the rotating Bose-Einstein condensates",
   aut: "C. Pilichos",
   jou: "MS",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2410.10325",
   doi: "10.1103/PhysRevB.110.214210",
   tit: "Statistics of systemwide correlations in the random-field XXZ chain: Importance of rare events in the many-body localized phase",
   aut: "J. Colbois, F. Alet, N. Laflorencie",
   jou: "Phys. Rev. B",
   num: "110",
   pag: "214210",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   doi: "10.3390/atoms12110057",
   tit: "Excitation of Helium by proton and antiproton impact",
   aut: "Z. Balint, S. Borbely, L. Nagy",
   jou: "Atoms",
   num: "12(11)",
   pag: "57",
   yr : 2024
  },
  {cat: phys,
   cla: epsh,
   arx: "2410.12430",
   doi: "10.1103/gcwf-jdlr",
   tit: "Renormalization-group analysis of the many-body localization transition in the random-Field XXZ chain",
   aut: "J. Niedda, G. B. Testasecca, G. Magnifico, F. Balducci, C. Vanoni, A. Scardicchio",
   jou: "Phys. Rev. B",
   num: "112",
   pag: "144201",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2409.19164",
   doi: "10.1007/JHEP06(2025)260",
   tit: "More about the lattice Hamiltonian for adjoint QCD<sub>2</sub>",
   aut: "R. Dempsey, S. S. Pufu, B. T. Sogaard, I. R. Klebanov",
   jou: "J. High Energy Phys.",
   num: "2025",
   pag: "260",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2411.10247",
   doi: "10.1103/PhysRevB.111.L180202",
   tit: "Anderson localization induced by structural disorder",
   aut: "S. Bhattacharjee, P. Sierant, M. Dudynski, J, Wehr, J. Zakrzewski, M. Lewenstein",
   jou: "Phys. Rev. B",
   num: "111",
   pag: "L180202",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2411.07969",
   doi: "10.1007/JHEP04(2025)098",
   tit: "The hadronic vacuum polarization contribution to the muon g-2 at long distances",
   aut: "D. Djukanovic, G. von Hippel, S. Kuberski, H. B. Meyer, N. Miller, K. Ottnad, J. Parrino, A. Risch, H. Wittig",
   jou: "J. High Energy Phys.",
   num: "2025",
   pag: "98",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2409.08320",
   doi: "10.1038/s42005-025-02039-8",
   tit: "Hilbert space fragmentation at the origin of disorder-free localization in the lattice Schwinger model",
   aut: "J. Jeyaretnam, T. Bhore, J. J. Osborne, J. C. Halimeh, Z. Papic",
   jou: "Commun. Phys.",
   num: "8",
   pag: "172",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2407.14591",
   doi: "10.21468/SciPostPhysCodeb.48",
   tit: "DanceQ: High-performance library for number conserving bases",
   aut: "R. Sch&auml;fer, D. J. Luitz",
   jou: "SciPost Phys. Codebases",
   num: "48",
   pag: "",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2410.10571",
   doi: "10.1103/PhysRevResearch.7.L012031",
   tit: "Propagation of two-particle correlations across the chaotic phase for interacting bosons",
   aut: "O. Due&ntilde;as, D. Pe&ntilde;a, A. Rodr&itilde;guez",
   jou: "Phys. Rev. Research",
   num: "7",
   pag: "L012031",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   arx: "2404.00956",
   doi: "10.1016/j.cpc.2024.109378",
   tit: "Parallel finite-element codes for the Bogoliubov-de Gennes stability analysis of Bose-Einstein condensates",
   aut: "G. Sadaka, P. Jolivet, E. G. Charalampidis, I. Danaila",
   jou: "Comput. Phys. Commun.",
   num: "306",
   pag: "109378",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2501.01590",
   doi: "10.1103/PhysRevB.111.075166",
   tit: "Weyl semimetallic, N&eacute;el, spiral, and vortex states in the Rashba-Hubbard model",
   aut: "S. dos Anjos Sousa-J&uacute;nior, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "111",
   pag: "075166",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2501.06563",
   doi: "10.1103/64m5-m9ty",
   tit: "Scaling analysis and renormalization group on the mobility edge in the quantum random energy model",
   aut: "F. Balducci, G. Bracci Testasecca, J. Niedda, A. Scardicchio, C. Vanoni",
   jou: "Phys. Rev. B",
   num: "111",
   pag: "214206",
   yr : 2025
  },
  {cat: phys,
   cla: svd,
   arx: "2502.05051",
   tit: "Pion condensation at non-zero isospin chemical potential with Wilson fermions",
   aut: "R. F. Basta, B. B. Brandt, F. Cuteri, G. Endr&ouml;di, O. Philipsen",
   yr : 2025
  },
  {cat: phys,
   cla: epss,
   arx: "2502.06598",
   tit: "Magnons in chromium trihalides from ab initio Bethe-Salpeter equation",
   aut: "A. Esquembre-Kucukalic, K. B. Le, A. Garcia-Cristobal, M. Bernardi, D. Sangalli, A. Molina-Sanchez",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   doi: "10.22323/1.466.0189",
   tit: "QCD Anderson transition with overlap valence quarks on a twisted-mass sea",
   aut: "R. Kehr, L. von Smekal",
   pro: "LATTICE2024",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.22323/1.466.0284",
   tit: "Deflation and polynomial preconditioning in the application of the overlap operator at nonzero chemical potential",
   aut: "G. Ramirez-Hidalgo, J. Finkenrath",
   pro: "LATTICE2024",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   url: "https://dr.lib.iastate.edu/handle/20.500.12876/2vaZVG8r",
   tit: "Study of critical coupling and zero mode contribution in Discrete Light Front Quantization for (1+1) dimensional &phi;<sup>4</sup> theory",
   aut: "S. Jawadekar",
   jou: "PD",
   yr : 2025
  },
  {cat: phys,
   cla: mfn,
   arx: "2502.16219",
   tit: "Scaling of many-body localization transitions: Quantum dynamics in Fock space and real space",
   aut: "T. Scoquart, I. V. Gornyi, A. D. Mirlin",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2503.01989",
   tit: "Entanglement dynamics of many-body quantum states with evolving system conditions",
   aut: "D. Shekhar, P. Shukla",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2503.02294",
   tit: "Light control of triplet pairing in correlated electrons with mixed-sign interactions",
   aut: "Z. Shen, C. Xie, W.-C. Chen, Y. Wang",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1038/s41699-025-00532-w",
   tit: "Beyond the K-valley: exploring unique trion states in indirect band gap monolayer WSe<sub>2</sub>",
   aut: "C. E. M&oslash;rch Nielsen, F. Fischer, G. Bester",
   jou: "npj 2D Mater Appl.",
   num: "9",
   pag: "11",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2406.09985",
   doi: "10.1103/PhysRevB.111.104202",
   tit: "Spectral and entanglement properties of the random exchange Heisenberg chain",
   aut: "Y. Gao, R. A. R&ouml;mer",
   jou: "Phys. Rev. B",
   num: "111",
   pag: "104202",
   yr : 2025
  },
  {cat: phys,
   cla: epss,
   arx: "2504.10096",
   tit: "Performances in solving the Bethe-Salpeter equation with the Yambo code",
   aut: "P. Milev, B. Mellado-Pinto, M. Nalabothula, A. Esquembre-Kucukalic, F. Alvarruiz, E. Ramos, L. Wirtz, J. E. Roman, D. Sangalli",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2504.10566",
   tit: "Cat states carrying long-range correlations in the many-body localized phase",
   aut: "N. Laflorencie, J. Colbois, F. Alet",
   yr : 2025
  },
  {cat: phys,
   cla: epss,
   doi: "10.1021/acs.jpcc.5c00855",
   tit: "Optical properties of single layer Cu<sub>2</sub>WSe<sub>4</sub> from the ab initio Bethe–Salpeter equation method",
   aut: "T. Ouahrani, A. Esquembre Kucukalic, R. M. Boufatah",
   jou: "J. Phys. Chem. C",
   num: "129(17)",
   pag: "8361-8371",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   arx: "2505.00964",
   tit: "Non-Hermitian Haldane-Hubbard model: effective description of an open system with balanced gain and loss",
   aut: "T.-C. Yi, R. Mondaini",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   arx: "2501.04176",
   doi: "10.1103/PhysRevB.111.195133",
   tit: "Multichannel Dyson equation for even- and odd-order Green's functions: application to double excitations",
   aut: "G. Riva, T. Fischer, S. Paggi, J. A. Berger, P. Romaniello",
   jou: "Phys. Rev. B",
   num: "111",
   pag: "195133",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   doi: "10.1103/vv47-k25m",
   tit: "Characterization of the chaotic phase in the tilted Bose-Hubbard model",
   aut: "P. Mart&iacute;n Clavero, A. Rodr&iacute;guez",
   jou: "Phys. Rev. E",
   num: "111",
   pag: "064214",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.1103/1xnb-s8w6",
   tit: "Topological and Mott phases driven by gain and loss in a correlated Chern insulator",
   aut: "T.-C. Yi, R. Mondaini",
   jou: "Phys. Rev. B",
   num: "112",
   pag: "045120",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   arx: "2507.12437",
   tit: "Ground and excited-state properties of the extended Hubbard dimer from the multichannel Dyson equation",
   aut: "S. Paggi, J. A. Berger, P. Romaniello",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   arx: "2508.05528",
   tit: "The use of open boundaries in stochastic hydrodynamic models of nucleation",
   aut: "J. F. Lutsko",
   yr : 2025
  },
  {cat: phys,
   cla: mfn,
   arx: "2508.05971",
   tit: "Photodynamic melting of phase-reversed charge stripes and enhanced condensation",
   aut: "J. Sun, R. T. Scalettar, R. Mondaini",
   yr : 2025
  },
  {cat: phys,
   cla: pep,
   url: "https://www.proquest.com/openview/e3115d116394036009db442a198d7d99",
   tit: "Hot carrier solar cells: simulating the effect of hot phonons on carrier thermalization",
   aut: "I. Baranowski",
   jou: "PD",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2509.00498",
   tit: "&quot;One defect, one potential&quot; strategy for accurate machine learning prediction of defect phonons",
   aut: "J. Zhou, X. Li, M. Huang, S. Chen",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   arx: "2509.01625",
   tit: "Embodying computation in nonlinear perturbative metamaterials",
   aut: "S. Z. Fard, P. Tiso, P. Omidvar, M. Serra-Garcia",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/1b32d31ae327d581c2e8c5d691caf690",
   tit: "Polarization dynamics and macroscopic build-up in high harmonic generation in atomic systems",
   aut: "B. Ghomashi",
   jou: "PD",
   yr : 2025
  },
  {cat: phys,
   cla: epsnh,
   doi: "10.3929/ethz-c-000783366",
   tit: "Variance reduction in lattice determinations of the leading order hadronic vacuum polarisation contribution to the muon G-2",
   aut: "R. Gruber",
   jou: "PD",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.proquest.com/openview/88afe982becb05dcb265c3ccd9dc02be",
   tit: "Non-perturbative approaches to strongly-coupled gauge theory",
   aut: "S. R. Dempsey",
   jou: "PD",
   yr : 2025
  },
  {cat: phys,
   cla: epsh,
   url: "https://www.researchgate.net/publication/397004105_Long-range_resonances_in_quasiperiodic_many-body_localization",
   tit: "Long-range resonances in quasiperiodic many-body localization",
   aut: "A. Padhan, J. Colbois, F. Alet, N. Laflorencie",
   jou: "TR",
   yr : 2025
  },
  {cat: aco,
   cla: epsnh,
   url: "http://ricabib.cab.cnea.gov.ar/240",
   tit: "Interacci&oacute;n fluido estructura: elementos finitos en ac&uacute;stica, formulaci&oacute;n ALE y esquemas staggered",
   aut: "A. M. Castro",
   jou: "MS",
   yr : 2007
  },
  {cat: aco,
   cla: epsnh,
   url: "http://www.digibib.tu-bs.de/?docid=00022449",
   tit: "Numerische Untersuchung der akustischen Eigenschaften von trennenden und flankierenden Bauteilen",
   aut: "D. Clasen",
   jou: "PD",
   yr : 2008
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1016/j.cma.2008.11.009",
   tit: "Higher order finite and infinite elements for the solution of Helmholtz problems",
   aut: "J. Biermann et al.",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "198(13-14)",
   pag: "1171-1188",
   yr : 2009
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1090/S0025-5718-09-02227-3",
   tit: "The computation of resonances in open systems using a perfectly matched layer",
   aut: "S. Kim and J. E. Pasciak",
   jou: "Math. Comp.",
   num: "78",
   pag: "1375-1398",
   yr : 2009
  },
  {cat: aco,
   cla: epsnh,
   url: "http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/ETD-TAMU-2009-08-2931/KIM-DISSERTATION.pdf",
   tit: "Analysis of a PML method applied to computation of resonances in open systems and acoustic scattering problems",
   aut: "S. Kim",
   jou: "PD",
   yr : 2009
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1007/978-1-4419-9305-2_19",
   tit: "Globally enriched substructuring techniques for vibro-acoustic simulation",
   aut: "U. Tabak and D. J. Rixen",
   pro: "SEM Series, vol. 4",
   yr : 2011
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1142/S0218396X11004456",
   tit: "The finite strip method for acoustic and vibroacoustic problems",
   aut: "J. Poblet-Puig and A. Rodr&iacute;guez-Ferran",
   jou: "J. Comput. Acoustics",
   num: "19(4)",
   pag: "353-378",
   yr : 2011
  },
  {cat: aco,
   cla: pep,
   doi: "10.1016/j.compfluid.2010.11.020",
   tit: "A parallel polynomial Jacobi-Davidson approach for dissipative acoustic eigenvalue problems",
   aut: "T.-M. Huang et al.",
   jou: "Comput. &amp; Fluids",
   num: "45(1)",
   pag: "207-214",
   yr : 2011
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1016/j.jsv.2013.01.021",
   tit: "Discontinuous Galerkin method for the computation of acoustic modes in lined flow ducts with rigid splices",
   aut: "L. Pascal et al.",
   jou: "J. Sound Vib.",
   num: "332(13)",
   pag: "3270-3288",
   yr : 2013
  },
  {cat: aco,
   cla: epsnh,
   url: "http://www.theses.fr/2013ESAE0032",
   tit: "Acoustique modale et stabilit&eacute; lin&eacute;aire par une m&eacute;thode num&eacute;rique avanc&eacute;e. Cas d'un conduit trait&eacute; acoustiquement en pr&eacute;sence d'un &eacute;coulement",
   aut: "L. Pascal",
   jou: "PD",
   yr : 2013
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1016/j.apnum.2014.01.009",
   tit: "Cartesian PML approximation to resonances in open systems in R<sup>2</sup>",
   aut: "S. Kim",
   jou: "Appl. Numer. Math.",
   num: "81",
   pag: "50-75",
   yr : 2014
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.2514/6.2016-2935 ",
   tit: "Stochastic and harmonic optimal forcing in subsonic jets",
   aut: "O. Semeraro et al.",
   pro: "22nd AIAA/CEAS Aeroacoustics Conference",
   yr : 2016
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.2514/6.2016-3055 ",
   tit: "Control of supersonic jet noise using linear feedback",
   aut: "M. Natarajan et al.",
   pro: "22nd AIAA/CEAS Aeroacoustics Conference",
   yr : 2016
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1093/qjmam/hbw008",
   tit: "Spectral study of the Laplace-Beltrami operator arising in the problem of acoustic wave scattering by a quarter-plane",
   aut: "R. C. Assier et al.",
   jou: "Q. J. Mech. Appl. Math",
   num: "69(3)",
   pag: "281-317",
   yr : 2016
  },
  {cat: aco,
   cla: pep,
   doi: "10.1016/j.jsv.2017.08.007",
   tit: "Global linear stability analysis of flow in a lined duct",
   aut: "L. Pascal et al.",
   jou: "J. Sound Vib.",
   num: "410",
   pag: "19-34",
   yr : 2017
  },
  {cat: aco,
   cla: pep,
   doi: "10.1121/1.5007851",
   tit: "Sound attenuation optimization using metaporous materials tuned on exceptional points",
   aut: "L. Xiong et al.",
   jou: "J. Acoust. Soc. Am.",
   num: "142(4)",
   pag: "2288-2297",
   yr : 2017
  },
  {cat: aco,
   cla: pep,
   doi: "10.1121/1.5115019",
   tit: "Non-reciprocal wave propagation in mechanically-modulated continuous elastic metamaterials",
   aut: "B. M. Goldsberry, S. P. Wallen, M. R. Haberman",
   jou: "J. Acoust. Soc. Am.",
   num: "146(1)",
   pag: "782-788",
   yr : 2019
  },
  {cat: aco,
   cla: nep,
   doi: "10.14279/depositonce-8952",
   tit: "Efficient computation of thermoacoustic modes",
   aut: "G. A. Mensah",
   jou: "PD",
   yr : 2019
  },
  {cat: aco,
   cla: pep,
   arx: "1909.11579",
   doi: "10.1016/j.jcp.2020.109425",
   tit: "A high order continuation method to locate exceptional points and to compute Puiseux series with applications to acoustic waveguides",
   aut: "B. Nennig and E. Perrey-Debain",
   jou: "J. Comput. Phys.",
   num: "412",
   pag: "109425",
   yr : 2020
  },
  {cat: aco,
   cla: pep,
   doi: "10.1016/j.jsv.2020.115291",
   tit: "Analysis of scattering by finite sonic crystals in free field with infinite elements and normal modes",
   aut: "L. Moheit, S. Anthis, J. Heinz, F. Kronowetter, S. Marburg",
   jou: "J. Sound Vib.",
   num: "476",
   pag: "115291",
   yr : 2020
  },
  {cat: aco,
   cla: pep,
   url: "http://www2.eng.cam.ac.uk/~mpj1001/papers/ASME_Falco_2020.pdf",
   doi: "10.1115/1.4049305",
   tit: "Shape optimization of thermoacoustic systems using a two-dimensional adjoint Helmholtz solver",
   aut: "S. Falco, M. P. Juniper",
   jou: "J. Eng. Gas Turbines Power",
   num: "143(7)",
   pag: "071025",
   yr : 2021
  },
  {cat: aco,
   cla: nep,
   doi: "10.26153/tsw/14184",
   tit: "Design and analysis of an underwater leaky wave antenna",
   aut: "C. W. Broadman",
   jou: "MS",
   yr : 2021
  },
  {cat: aco,
   cla: nep,
   doi: "10.17863/CAM.84402",
   tit: "Shape optimization for thermoacoustic instability with an adjoint Helmholtz solver",
   aut: "S. Falco",
   jou: "PD",
   yr : 2021
  },
  {cat: aco,
   cla: epsnh,
   arx: "2012.02276",
   doi: "10.1007/s40857-021-00259-w",
   tit: "A feedforward neural network for modelling of average pressure frequency response",
   aut: "K. Pettersson, A. Karzhou, I. Pettersson",
   jou: "Acoustics Australia",
   num: "50",
   pag: "185-201",
   yr : 2022
  },
  {cat: aco,
   cla: pep,
   url: "https://www.researchgate.net/publication/362961103",
   tit: "A Boundary Element Method (BEM) solver for low frequency room modes",
   aut: "A. Cicero, J. A. Hargreaves",
   pro: "Internoise 2022",
   yr : 2022
  },
  {cat: aco,
   cla: nep,
   arx: "2208.08717",
   doi: "10.1016/j.amc.2023.128249",
   tit: "Acoustic modal analysis with heat release fluctuations using nonlinear eigensolvers",
   aut: "V. Hiremath, J. E. Roman",
   jou: "Appl. Math. Comput.",
   num: "458",
   pag: "128249",
   yr : 2023
  },
  {cat: aco,
   cla: nep,
   doi: "10.1115/1.4055583",
   tit: "The nonlinear thermoacoustic eigenvalue problem and its rational approximations: assessment of solution strategies",
   aut: "M. Merk, P. E. Buschmann, J. Moeck, W. Polifke",
   jou: "J. Eng. Gas Turbines Power",
   num: "145(2)",
   pag: "021028",
   yr : 2023
  },
  {cat: aco,
   cla: nep,
   doi: "10.1121/10.0017486",
   tit: "Exact radiation boundary conditions to determine the complex wavenumber of an underwater acoustic leaky wave antenna",
   aut: "B. M. Goldsberry, C. W. Broadman, C. J. Naify, M. R. Haberman",
   jou: "JASA Express Lett.",
   num: "3(3)",
   pag: "035601",
   yr : 2023
  },
  {cat: aco,
   cla: epsh,
   arx: "2212.14465",
   doi: "10.1098/rspa.2022.0869",
   tit: "Localization in musical steelpans",
   aut: "P. Bryde, L. Mahadevan",
   jou: "Proc. Royal Soc. A",
   num: "479",
   pag: "2273",
   yr : 2023
  },
  {cat: aco,
   cla: epsnh,
   arx: "2307.12317",
   tit: "Global linear stability analysis of a slit flame subject to intrinsic thermoacoustic instability",
   aut: "G. Varillon, P. Brokof, W. Polifke",
   yr : 2023
  },
  {cat: aco,
   cla: pep,
   doi: "10.1007/978-3-031-36143-2_12",
   tit: "Numerical and experimental assessment of acoustic radiation damping",
   aut: "S. K. Baydoun, S. Marburg",
   boo: "Lecture Notes in Applied and Computational Mechanics, vol 102",
   pag: "231-246",
   yr : 2023
  },
  {cat: aco,
   cla: epsnh,
   doi: "10.1016/j.cma.2023.116572",
   tit: "Shape sensitivity of thermoacoustic oscillations in an annular combustor with a 3D adjoint Helmholtz solver",
   aut: "E. Ekici, S. Falco, M. P. Juniper",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "418",
   pag: "116572",
   yr : 2023
  },
  {cat: aco,
   cla: pep,
   url: "https://api.repository.cam.ac.uk/server/api/core/bitstreams/63d000cd-0250-42bb-a3cc-213d50ef1b1e/content",
   doi: "10.1115/GT2024-125711",
   tit: "Adjoint based shape optimization for thermoacoustic stability of combustors using free form deformation",
   aut: "E. Ekici, M. P. Juniper",
   pro: "Turbo Expo",
   yr : 2024
  },
  {cat: aco,
   cla: epsh,
   doi: "10.1016/j.buildenv.2024.111858",
   tit: "Ribbed floors with optimized thickness distribution for maximized broadband impact sound insulation",
   aut: "H. N. Lopes, D. Giannini, E. P. B. Reynders, R. Pavanello, M. Schevenels",
   jou: "Building and Environment",
   num: "263",
   pag: "111858",
   yr : 2024
  },
  {cat: aco,
   cla: pep,
   doi: "10.17863/CAM.112615",
   tit: "Shape optimization of annular combustors with an open source parallelized thermoacoustic Helmholtz solver",
   aut: "E. Ekici",
   jou: "PD",
   yr : 2024
  },
  {cat: aco,
   cla: epsh,
   doi: "10.1007/s00466-024-02488-y",
   tit: "Digital twin of surface acoustic wave transceivers for a computational design of an optimal wave guiding layer thickness",
   aut: "U. T. Baler, A. F. Okyar, B. E. Abali",
   jou: "Comput. Mech.",
   num: "75",
   pag: "15-31",
   yr : 2025
  },
  {cat: aco,
   cla: pep,
   doi: "10.1115/1.4067337",
   tit: "Shape optimization of an industrial aeroengine combustor to reduce thermoacoustic instability",
   aut: "E. Ekici, M. P. Juniper",
   jou: "J. Eng. Gas Turbines Power",
   num: "147",
   pag: "071016",
   yr : 2025
  },
  {cat: aco,
   cla: pep,
   doi: "10.1007/s00366-025-02107-1",
   tit: "Helmholtz-x: Parallelized adjoint open source solver for the thermoacoustic Helmholtz equation",
   aut: "E. Ekici, S. Falco, M. P. Juniper",
   jou: "Engin. Comput.",
   num: "41",
   pag: "2137-2164",
   yr : 2025
  },
  {cat: aco,
   cla: nep,
   url: "https://riunet.upv.es/handle/10251/222803",
   tit: "Estudio de la interacci&oacute;n termoac&uacute;stica provocada por un frente de llama en un modelo de c&aacute;mara de combusti&oacute;n mediante su analog&iacute;a con un tubo de Rijke",
   aut: "P. Villar Peris",
   jou: "MS",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://repositories.lib.utexas.edu/handle/2152/18091",
   tit: "Parallel adaptive finite element methods for problems in natural convection",
   aut: "J. W. Peterson",
   jou: "PD",
   yr : 2008
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://ir.lib.ncu.edu.tw:88/thesis/view_etd.asp?URN=972201027",
   tit: "A study for linear stability analysis of incompressible flows on parallel computers",
   aut: "S.-Y. Chen",
   jou: "MS",
   yr : 2009
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1137/090759239",
   tit: "A certified reduced basis method for the Fokker-Planck equation of dilute polymeric fluids: FENE dumbbells in extensional flow",
   aut: "D. J. Knezevic and A. T. Patera",
   jou: "SIAM J. Sci. Comput.",
   num: "32(2)",
   pag: "793-817",
   yr : 2010
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.apnum.2010.03.014",
   tit: "Parallel pseudo-transient Newton-Krylov-Schwarz continuation algorithms for bifurcation analysis of incompressible sudden expansion flows",
   aut: "C.-Y. Huang and F.-N. Hwang",
   jou: "Appl. Numer. Math.",
   num: "60(7)",
   pag: "738-751",
   yr : 2010
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.3481148",
   tit: "Feedback control of the vortex-shedding instability based on sensitivity analysis",
   aut: "S. Camarri and A. Iollo",
   jou: "Phys. Fluids",
   num: "22",
   pag: "094102",
   yr : 2010
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://www.amcaonline.org.ar/ojs/index.php/mc/article/view/3343",
   tit: "Numerical stability analysis of a pressure space with embedded discontinuities",
   aut: "F. S. Sousa et al.",
   jou: "Mec&aacute;nica Computacional",
   num: "Vol XXIX",
   pag: "4819-4837",
   yr : 2010
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.cma.2010.12.026",
   tit: "A high-performance parallel implementation of the certified reduced basis method",
   aut: "D. J. Knezevic and J. W. Peterson",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "210(13-16)",
   pag: "1455-1466",
   yr : 2011
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1137/110854084",
   tit: "Certified reduced basis methods for parametrized saddle point problems",
   aut: "A.-L. Gerner and K. Veroy",
   jou: "SIAM J. Sci. Comput.",
   num: "34(5)",
   pag: "A2812-A2836",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2011.419",
   tit: "The onset of unsteadiness of two-dimensional bodies falling or rising freely in a viscous fluid: a linear study",
   aut: "P. Assemat et al.",
   jou: "J. Fluid Mech.",
   num: "690",
   pag: "173-202",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jcp.2012.01.038",
   tit: "A relaxation method for large eigenvalue problems, with an application to flow stability analysis",
   aut: "X. Garnaud et al.",
   jou: "J. Comput. Phys.",
   num: "231(10)",
   pag: "3912-3927",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.cma.2012.06.019",
   tit: "Numerical assessment of stability of interface discontinuous finite element pressure spaces",
   aut: "F. S. Sousa et al.",
   jou: "Comput. Meth. Appl. Mech. Eng.",
   num: "245-246",
   pag: "63-74",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jcp.2012.06.038",
   tit: "Efficient evaluation of the direct and adjoint linearized dynamics from compressible flow solvers",
   aut: "M. Fosas de Pando et al.",
   jou: "J. Comput. Phys.",
   num: "231(23)",
   pag: "7739-7755",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hal-polytechnique.archives-ouvertes.fr/docs/00/74/01/33/PDF/thesis_garnaud.pdf",
   tit: "Modes, transient dynamics and forced response of circular jets",
   aut: "X. Garnaud",
   jou: "PD",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://izvestia.asu.ru/2012/1-2/phys/TheNewsOfASU-2012-1-2-phys-08.pdf",
   tit: "A local disturbance in Poiseuille flow",
   aut: "A. B. Proskurin and A. M. Sagalakov",
   jou: "TR",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://pdfs.semanticscholar.org/fb2a/11b65db76038f213ce446fe54864551b1e93.pdf",
   tit: "Controller selection and placement in compressible turbulent flows",
   aut: "D. J. Bodony and M. Natarajan",
   pro: "CTR Summer Program",
   yr : 2012
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2012.540",
   tit: "The preferred mode of incompressible jets: linear frequency response analysis",
   aut: "X. Garnaud et al.",
   jou: "J. Fluid Mech.",
   num: "716",
   pag: "189-202",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hal-polytechnique.archives-ouvertes.fr/docs/00/79/55/43/PDF/tesi.pdf",
   tit: "Stability and receptivity of the swept-wing attachment-line boundary layer: a multigrid numerical approach",
   aut: "G. Meneghello",
   jou: "PD",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.4801751",
   tit: "Modal and transient dynamics of jet flows",
   aut: "X. Garnaud et al.",
   jou: "Phys. Fluids",
   num: "25",
   pag: "044103",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://oatao.univ-toulouse.fr/10256/1/Tchoufag_10256.pdf",
   tit: "Weakly nonlinear analysis of the flutter motion of think cylinders",
   aut: "J. Tchoufag et al.",
   pro: "Int. ERCOFTAC Symp. on Engineering Turbulence Modelling and Measurements Interaction",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hal.inria.fr/docs/00/81/69/87/PDF/thesis_FosasdePando.pdf",
   tit: "Tonal noise generation in flows around aerofoils: a global stability analysis",
   aut: "M. Fosas de Pando",
   jou: "PD",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.4804552",
   tit: "Linear stability and sensitivity of the flow past a fixed oblate spheroidal bubble",
   aut: "J. Tchoufag et al.",
   jou: "Phys. Fluids",
   num: "25",
   pag: "054108",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.imft.fr/IMG/pdf/Rapport-Kamal-V12.pdf",
   tit: "Instability and dynamics of two dimensional falling heavy bodies in a viscous fluid",
   aut: "K. Selvam",
   jou: "MS",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://documents.irevues.inist.fr/bitstream/handle/2042/52128/a_TPX76CVC.pdf",
   tit: "Tonal noise generation in the flow around an aerofoil: a global stability analysis",
   aut: "M. Fosas de Pando et al.",
   pro: "Congr&egrave;s Fran&ccedil;ais de M&eacute;canique",
   yr : 2013
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2013.642",
   tit: "Global linear stability analysis of the wake and path of buoyancy-driven discs and thin cylinders",
   aut: "J. Tchoufag et al.",
   jou: "J. Fluid Mech.",
   num: "740",
   pag: "278-311",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2014.06.008",
   tit: "Accuracy analysis of unstructured finite volume discretization schemes for diffusive fluxes",
   aut: "A. Jalali et al.",
   jou: "Comput. &amp; Fluids",
   num: "101",
   pag: "220-232",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2014.340",
   tit: "Linear instability of the path of a freely rising spheroidal bubble",
   aut: "J. Tchoufag et al.",
   jou: "J. Fluid Mech.",
   num: "751",
   pag: "R4",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevLett.113.084501",
   tit: "Self-consistent mean flow description of the nonlinear saturation of the vortex shedding in the cylinder wake",
   aut: "V. Manti&ccaron;-Lugo et al.",
   jou: "Phys. Rev. Lett.",
   num: "113",
   pag: "084501",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2014.356",
   tit: "A global analysis of tonal noise in flows around aerofoils",
   aut: "M. Fosas de Pando et al.",
   jou: "J. Fluid Mech.",
   num: "754",
   pag: "5-38",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2014.537",
   tit: "Electrohydrodynamic linear stability analysis of dielectric liquids subjected to unipolar injection in a rectangular enclosure with rigid sidewalls",
   aut: "A. T. P&eacute;rez et al.",
   jou: "J. Fluid Mech.",
   num: "758",
   pag: "586-602",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://web.stanford.edu/group/ctr/Summer/SP14/08_Transition_and_turbulence/11_fosas.pdf",
   tit: "Parametric sensitivity for large-scale aeroacoustic flows",
   aut: "M. Fosas de Pando et al.",
   pro: "CTR Summer Program",
   yr : 2014
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.4926443",
   tit: "A self-consistent model for the saturation dynamics of the vortex shedding around the mean flow in the unstable cylinder wake",
   aut: "V. Manti&ccaron;-Lugo et al.",
   jou: "Phys. Fluids",
   num: "27",
   pag: "074103",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://infoscience.epfl.ch/record/210941/files/EPFL_TH6730.pdf",
   tit: "Instability of two-phase co-axial jets at small Reynolds number",
   aut: "L. Augello",
   jou: "PD",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2015.543",
   tit: "Second-order sensitivity of parallel shear flows and optimal spanwise-periodic flow modifications",
   aut: "E. Boujo et al.",
   jou: "J. Fluid Mech.",
   num: "782",
   pag: "491-514",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2015.591",
   tit: "Stability analysis of boundary layers controlled by miniature vortex generators",
   aut: "L. Siconolfi et al.",
   jou: "J. Fluid Mech.",
   num: "784",
   pag: "596-618",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.politesi.polimi.it/handle/10589/109028",
   tit: "Linear stability analysis in FSI problems including large displacements",
   aut: "S. Pedraglio",
   jou: "PD",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://ctr.stanford.edu/sites/default/files/14_jang.pdf",
   tit: "Linear stability analysis of the onset dynamics of scramjet unstart",
   aut: "I. Jang et al.",
   pro: "CTR Annual Research Briefs",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/s12273-015-0240-9",
   tit: "Fast prediction of indoor pollutant dispersion based on reduced-order ventilation models",
   aut: "S.-J. Cao and J. Meyers",
   jou: "Building Simulation",
   num: "8(4)",
   pag: "415-420",
   yr : 2015
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2016.04.018",
   tit: "A non-intrusive acceleration technique for compressible flow solvers based on dynamic mode decomposition",
   aut: "N. Andersson",
   jou: "Comput. &amp; Fluids",
   num: "133",
   pag: "32-42",
   yr : 2016
  },
  {cat: cfd,
   cla: epsnh,
   arx: "1603.00320",
   tit: "An example of the Rvachev function method",
   aut: "A. V. Proskurin and A. M. Sagalakov",
   yr : 2016
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2016-4382 ",
   tit: "Wake flow instability studies behind discrete roughness elements on a generic re-entry capsule",
   aut: "A. Theiss et al.",
   pro: "46th AIAA Fluid Dynamics Conference",
   yr : 2016
  },
  {cat: cfd,
   cla: svd,
   url: "http://hdl.handle.net/10589/121035",
   tit: "Spectral techniques for real-time post-processing and shape optimization",
   aut: "M. Leoni",
   jou: "MS",
   yr : 2016
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2016.240",
   tit: "Mechanisms of flow tripping by discrete roughness elements in a swept-wing boundary layer",
   aut: "H. B. E. Kurz and M. J. Kloker",
   jou: "J. Fluid Mech.",
   num: "796",
   pag: "158-194",
   yr : 2016
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2016.402",
   tit: "Stability of an isolated pancake vortex in continuously stratified-rotating fluids",
   aut: "E. Yim et al.",
   jou: "J. Fluid Mech.",
   num: "801",
   pag: "508-553",
   yr : 2016
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://arc.aiaa.org/doi/abs/10.2514/6.2017-0735",
   tit: "A posteriori stability analysis and improvement for finite volume methods on unstructured meshes",
   aut: "R. Zangeneh and C. Ollivier-Gooch",
   pro: "55th AIAA Aerospace Sciences Meeting",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://arc.aiaa.org/doi/abs/10.2514/6.2017-1879",
   tit: "Bi-global stability analysis of compressible channel flow over complex impedance walls",
   aut: "I. Rahbari and C. Scalo",
   pro: "55th AIAA Aerospace Sciences Meeting",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://arc.aiaa.org/doi/abs/10.2514/6.2017-1100",
   tit: "Perturbation dynamics in turbulent flames",
   aut: "M. Hassanaly and V. Raman",
   pro: "55th AIAA Aerospace Sciences Meeting",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://arc.aiaa.org/doi/abs/10.2514/6.2017-0527",
   tit: "Dynamic mode decomposition applied to a detached-eddy simulation of separated nozzle flow",
   aut: "R. Larusson et al.",
   pro: "55th AIAA Aerospace Sciences Meeting",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.4974069",
   tit: "Global stability and control of the confined turbulent flow past a thick flat plate",
   aut: "M. Carini et al.",
   jou: "Phys. Fluids",
   num: "29",
   pag: "024102",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2017.167",
   tit: "Towards a quantitative comparison between global and local stability analysis",
   aut: "L. Siconolfi et al.",
   jou: "J. Fluid Mech.",
   num: "819",
   pag: "147-164",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1051/eucass/201709451",
   tit: "Investigation on the wake flow instability behind isolated roughness elements on the forebody of a blunt generic reentry capsule",
   aut: "A. Theiss and S. Hein",
   jou: "Progress in Flight Physics",
   num: "9",
   pag: "451-480",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hdl.handle.net/2142/97417",
   tit: "Actuator selection and placement for linear feedback control of compressible flows",
   aut: "M. Natarajan",
   jou: "PD",
   yr : 2017
  },
  {cat: cfd,
   cla: svd,
   url: "https://www.iiav.org/archives_icsv_last/2017_icsv24/content/papers/papers/full_paper_593_20170421085047425.pdf",
   tit: "Parametric sensitivity analysis for premixed swirling M-flames",
   aut: "C. S. Skene and P. J. Schmid",
   pro: "ICSV",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2017.04.020",
   tit: "Mesh optimization to improve the stability of finite-volume methods on unstructured meshes",
   aut: "R. Zangeneh and C. F. Ollivier-Gooch",
   jou: "Comput. &amp; Fluids",
   num: "156",
   pag: "590-601",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://publications.lib.chalmers.se/publication/248086-modal-analysis-of-supersonic-flow-separation-in-nozzles",
   tit: "Modal analysis of supersonic flow separation in nozzles",
   aut: "R. Larusson",
   jou: "PD",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J055930",
   tit: "Higher-order transonic flutter predictions",
   aut: "M. Bhatia and P. Beran",
   jou: "AIAA Journal",
   num: "55(11)",
   pag: "3881-3890",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J055839",
   tit: "Transonic panel flutter predictions using a linearized stability formulation",
   aut: "M. Bhatia and P. Beran",
   jou: "AIAA Journal",
   num: "55(10)",
   pag: "3499-3516",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.C034301",
   tit: "Design of thermally stressed panels subject to transonic flutter constraints",
   aut: "M. Bhatia and P. Beran",
   jou: "J. Aircraft",
   num: "54(6)",
   pag: "2340-2349",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   arx: "1703.07405",
   tit: "Symmetry breaking in a 3D bluff-body wake",
   aut: "G. Rigas et al.",
   pro: "CTR Summer Program",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2016.736",
   tit: "On the receptivity of aerofoil tonal noise: an adjoint analysis",
   aut: "M. Fosas de Pando et al.",
   jou: "J. Fluid Mech.",
   num: "812",
   pag: "771-791",
   yr : 2017
  },
  {cat: cfd,
   cla: pep,
   doi: "10.1103/PhysRevFluids.2.113902",
   tit: "Stability analysis for n-periodic arrays of fluid systems",
   aut: "P. J. Schmid et al.",
   jou: "Phys. Rev. Fluids",
   num: "2",
   pag: "113902",
   yr : 2017
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J056023",
   tit: "Acoustic mode analysis of a supersonic jet",
   aut: "M. O. Burak and N. Andersson",
   jou: "AIAA Journal",
   num: "56(1)",
   pag: "279-289",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevE.97.023106",
   tit: "Electroconvection in a dielectric liquid between two concentric half-cylinders with rigid walls: Linear and nonlinear analysis",
   aut: "P. A. V&aacute;zquez et al.",
   jou: "Phys. Rev. E",
   num: "97",
   pag: "023106",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://doi.org/10.2514/6.2018-3229",
   tit: "Global instability analysis of unswept- and swept-wing transonic buffet onset",
   aut: "J. D. Crouch et al.",
   pro: "2018 Fluid Dynamics Conference, AIAA Aviation Forum",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2018.440",
   tit: "Localised streak solutions for a Blasius boundary layer",
   aut: "R. E. Hewitt and P. W. Duck",
   jou: "J. Fluid Mech.",
   num: "849",
   pag: "885-901",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/978-3-319-91494-7_3",
   tit: "Spatial and temporal adaptivity in numerical studies of instabilities, with applications to fluid flows",
   aut: "A. L. Hazel",
   boo: "Computational Modelling of Bifurcations and Instabilities in Fluid Dynamics",
   pag: "33-73",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://www.iccfd.org/iccfd10/papers/ICCFD10-022-Paper.pdf",
   tit: "A boundary condition stability analysis of finite-volume methods on unstructured meshes",
   aut: "R. Zangeneh and C. Ollivier-Gooch",
   pro: "10th Intl. Conf. on Computational Fluid Dynamics (ICCFD10)",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.crme.2018.07.005",
   tit: "Global mode-based control of laminar and turbulent high-speed jets",
   aut: "M. Natarajan et al.",
   jou: "Comptes Rendus M&eacute;canique",
   num: "346(10)",
   pag: "978-996",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1115/1.4041080",
   tit: "Influence of non-axisymmetric confinement on the hydrodynamic stability of multi-nozzle swirl flows",
   aut: "H. G. Subramanian et al.",
   jou: "J. Eng. Gas Turbines Power",
   num: "141(2)",
   pag: "021016",
   yr : 2018
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://eprints.soton.ac.uk/id/eprint/425396",
   tit: "Incipient buffet over laminar-flow airfoil - a DNS study at moderate Reynolds numbers",
   aut: "M. Zauner and N. D. Sandham",
   pro: "12th Int. ERCOFTAC Symp. on Engineering Turbulence Modelling and Measurements",
   yr : 2018
  },
  {cat: cfd,
   cla: epsh,
   arx: "1810.09340",
   doi: "10.1103/PhysRevFluids.4.063901",
   tit: "Resolvent-based modelling of coherent wavepackets in a turbulent jet",
   aut: "L. Lesshafft, O. Semeraro, V. Jaunet, A. V. G. Cavalieri, P. Jordan",
   jou: "Phys. Rev. Fluids",
   num: "4",
   pag: "063901",
   yr : 2019
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1017/jfm.2018.793",
   tit: "Adjoint-based parametric sensitivity analysis for swirling M-flames",
   aut: "C. S. Skene and P. J. Schmid",
   jou: "J. Fluid Mech.",
   num: "859",
   pag: "516-542",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2019-0170",
   tit: "Assessment of stabilized sensitivity analysis approach for high-dimensional chaotic systems",
   aut: "M. Bhatia and L. Taoudi",
   pro: "AIAA SciTech Forum",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.cma.2019.03.052",
   tit: "Augmented Lagrangian preconditioner for large-scale hydrodynamic stability analysis",
   aut: "J. Moulin, P. Jolivet, O. Marquet",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "351",
   pag: "718-743",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.euromechflu.2019.04.011",
   tit: "Instability of isolated boundary-layer streaks to spatially-developing travelling waves",
   aut: "R. E. Hewitt and P. W. Duck",
   jou: "Eur. J. Mech. B/Fluids",
   num: "76",
   pag: "413-421",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jcp.2019.05.002",
   tit: "Stability analysis and improvement of the solution reconstruction for cell-centered finite volume methods on unstructured meshes",
   aut: "R. Zangeneh and C. F. Ollivier-Gooch",
   jou: "J. Comput. Phys.",
   num: "393",
   pag: "375-405",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2019-3537",
   tit: "Global stability analysis of a boundary layer with surface indentations",
   aut: "T. Appel, M. S. Mughal, R. Ashworth",
   pro: "AIAA Aviation Forum",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2019.401",
   tit: "Bubble and conical forms of vortex breakdown in swirling jets",
   aut: "P. Moise and J. Mathew",
   jou: "J. Fluid Mech.",
   num: "873",
   pag: "322-357",
   yr : 2019
  },
  {cat: cfd,
   cla: svd,
   url: "http://hdl.handle.net/10044/1/72876",
   tit: "Adjoint based analysis for swirling and reacting flows",
   aut: "C. S. Skene",
   jou: "PD",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jcp.2019.108888",
   tit: "3D global optimal forcing and response of the supersonic boundary layer",
   aut: "B. Bugeat, J.-C. Chassaing, J.-C. Robinet, P. Sagaut",
   jou: "J. Comput. Phys.",
   num: "398",
   pag: "108888",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hdl.handle.net/2429/71814",
   tit: "Numerical stability analyses and improvement of cell-centered finite volume methods on unstructured meshes",
   aut: "R. Zangeneh",
   jou: "PD",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/1.5118322",
   tit: "Large eddy simulations and global stability analyses of an annular and cylindrical rotor/stator cavity limit cycles",
   aut: "M. Queguineur, T. Bridel-Bertomeu, L. Y. M. Gicquel1, G. Staffelbach",
   jou: "Phys. Fluids",
   num: "31",
   pag: "104109",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   url: "http://hdl.handle.net/2027.42/151461",
   tit: "Development of a hypersonic aerothermoelastic framework and its application to flutter and aerothermoelastic scaling of skin panels",
   aut: "D. Huang",
   jou: "PD",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2019.748",
   tit: "Global instability in the onset of transonic-wing buffet",
   aut: "J. D. Crouch, A. Garbaruk, M. Strelets",
   jou: "J. Fluid Mech.",
   num: "881",
   pag: "3-22",
   yr : 2019
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1088/1742-6596/1382/1/012033",
   tit: "Stability of magnetohydrodynamic flow around a circular cylinder",
   aut: "A. V. Proskurin and A. M. Sagalakov",
   jou: "J. Phys.: Conf. Ser.",
   num: "1382",
   pag: "012033",
   yr : 2019
  },
  {cat: cfd,
   cla: svd,
   arx: "1911.10179",
   doi: "10.1017/jfm.2020.497",
   tit: "Analysis of amplification mechanisms and cross-frequency interactions in nonlinear flows via the harmonic resolvent",
   aut: "A. Padovan, S. E. Otto, C. W. Rowley",
   jou: "J. Fluid Mech.",
   num: "900",
   pag: "A14",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   arx: "1909.11658",
   doi: "10.1016/j.ijheatmasstransfer.2020.119504",
   tit: "Three-dimensional advective-diffusive boundary layers in open channels with parallel and inclined walls",
   aut: "M. A. Etzold, J. R. Landel, S. B. Dalziel",
   jou: "Int. J. Heat Mass Tran.",
   num: "153",
   pag: "119504",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2019.104418",
   tit: "Boundary condition optimization to improve the stability of inviscid and compressible finite-volume methods on unstructured meshes",
   aut: "R. Zangeneh and C. F. Ollivier-Gooch",
   jou: "Comput. &amp; Fluids",
   num: "199",
   pag: "104418",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.euromechflu.2019.11.007",
   tit: "Shape sensitivity of eigenvalues in hydrodynamic stability, with physical interpretation for the flow around a cylinder",
   aut: "J. Brewster and M. P. Juniper",
   jou: "Eur. J. Mech. B/Fluids",
   num: "80",
   pag: "80-91",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/s00340-020-7376-8",
   tit: "A one-way coupled model for the vibration of tuning fork-based trace gas sensors driven by a thermoacoustic wave",
   aut: "A. Safin, J. Zweck, S. E. Minkoff",
   jou: "Appl. Phys. B",
   num: "126",
   pag: "29",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jfluidstructs.2020.102927",
   tit: "An aerothermoelastic analysis framework with reduced-order modeling applied to composite panels in hypersonic flows",
   aut: "D. Huang, P. P. Friedmann",
   jou: "J. Fluid Struct.",
   num: "94",
   pag: "102927",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2020.105",
   tit: "Bistability of bubble and conical forms of vortex breakdown in laminar swirling jets",
   aut: "P. Moise",
   jou: "J. Fluid Mech.",
   num: "889",
   pag: "A31",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevFluids.5.063902",
   tit: "Sensitivity gradients of surface geometry modifications based on stability analysis of compressible flows",
   aut: "A. Mart&itilde;nez-Cava, M. Ch&aacute;vez-Modena, E. Valero, J. de Vicente, E. Ferrer",
   jou: "Phys. Rev. Fluids",
   num: "5",
   pag: "063902",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.euromechflu.2020.07.007",
   tit: "Linear stability investigations on the inward flow between closely spaced co-rotating disks",
   aut: "S. Klingl, S. Lecheler, M. Pfitzner",
   jou: "Euro. J. Mech. B/Fluids",
   num: "84",
   pag: "455-469",
   yr : 2020
  },
  {cat: cfd,
   cla: svd,
   arx: "2005.05703",
   doi: "10.1017/jfm.2020.566",
   tit: "Ambiguity in mean-flow-based linear analysis",
   aut: "U. Karban, B. Bugeat, E. Martini, A. Towne, A.V.G. Cavalieri, L. Lesshafft, A. Agarwal, P. Jordan, T. Colonius",
   jou: "J. Fluid Mech.",
   num: "900",
   pag: "R5",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2020-3180",
   tit: "Structural sizing of post-buckled thermally stressed stiffened panel",
   aut: "W. Arsalane, M. Bhatia",
   pro: "AIAA Aviation Forum",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2020.581",
   tit: "Inviscid and viscous global stability of vortex rings",
   aut: "N. Balakrishna, J. Mathew, A. Samanta",
   jou: "J. Fluid Mech.",
   num: "902",
   pag: "A9",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.17863/CAM.79199",
   tit: "Adjoint-based optimization for inkjet printing",
   aut: "P. Kungurtsev",
   jou: "PD",
   yr : 2020
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2021.66",
   arx: "2006.05970",
   tit: "Hypersonic attachment-line instabilities with large sweep Mach numbers",
   aut: "Y. Xi, J. Ren, S. Fu",
   jou: "J. Fluid Mech.",
   num: "915",
   pag: "A44",
   yr : 2021
  },
  {cat: cfd,
   cla: svd,
   url: "https://www.researchgate.net/publication/346972960",
   doi: "10.2514/6.2021-1476",
   tit: "An efficient nonlinear reduced-order modeling approach for rapid aerodynamic analysis with OpenFOAM",
   aut: "P. He, R. Halder, K. J. Fidkowski, K. J. Maki, J. R. R. A. Martins",
   pro: "AIAA SciTech Forum",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.26153/tsw/13715",
   tit: "A reacting jet direct numerical simulation for assessing combustion model error",
   aut: "B. W. Reuter",
   jou: "PD",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2021-3092",
   tit: "Structural sizing of thermally stressed hat-stiffened panels",
   aut: "W. Arsalane, M. Bhatia",
   pro: "AIAA Aviation Forum",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2021.615",
   tit: "Nonlinear dynamics of fully developed swirling jets",
   aut: "C. M. Douglas, B. L. Emerson, T. C. Lieuwen",
   jou: "J. Fluid Mech.",
   num: "924",
   pag: "A14",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J060792",
   tit: "Stability of the low Reynolds number compressible flow past a NACA0012 airfoil",
   aut: "L. V. Rolandi, T. Jardin, J. Fontane, J. Gressier, L. Joly",
   jou: "AIAA Journal",
   num: "60(2)",
   pag: "1052-1066",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://elib.dlr.de/145146/",
   tit: "Transition mechanisms on blunt re-entry capsules with and without roughness",
   aut: "A. Theiss",
   jou: "PD",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/978-3-030-67902-6_30",
   tit: "Biglobal stability analysis of swept-wing boundary layers with forward and backward facing steps",
   aut: "T. Appel, E. Cooke, S. Mughal, R. Ashworth",
   boo: "IUTAM Laminar-Turbulent Transition",
   pag: "347-358",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://hal.archives-ouvertes.fr/hal-03426762",
   tit: "Global aeroelastic stability analysis of a NACA0012 airfoil in transitional Reynolds regime",
   aut: "D. Sabino, O. Marquet, D. Fabre, V. Mons",
   pro: "Aeroelasticity",
   yr : 2021
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1002/aic.17348",
   tit: "Reconstruction of large-scale flow structures in a stirred tank from limited sensor data",
   aut: "K. Mikhaylov, S. Rigopoulos, G. Papadakis1",
   jou: "AIChE Journal",
   num: "67(10)",
   pag: "e17348",
   yr : 2021
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/s10665-021-10190-8",
   tit: "Buoyancy-driven algebraic (localised) boundary-layer disturbances",
   aut: "S. M. Edwards, R. E. Hewitt",
   jou: "J. Eng. Math.",
   num: "132",
   pag: "11",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2022-0080",
   tit: "Airfoil unsteady aerodynamic analysis using a Galerkin reduced-order modeling approach",
   aut: "Z. Li, P. He",
   pro: "AIAA SciTech Forum",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2022-1074",
   tit: "Numerical investigation of cross-flow instability for a supersonic swept wing with a biconvex airfoil",
   aut: "A. P. Haas, C. Hader, H. F. Fasel",
   pro: "AIAA SciTech Forum",
   yr : 2022
  },
  {cat: cfd,
   cla: pep,
   doi: "10.2514/6.2022-1855",
   tit: "Investigation of a solution approach to quadratic eigenvalue problem for thermoacoustic instabilities",
   aut: "M. O. Ozturkmen, Y. Ozyoruk",
   pro: "AIAA SciTech Forum",
   yr : 2022
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1063/5.0076074",
   tit: "Sensitivity analysis of chaotic dynamical systems using a physics-constrained data-driven approach",
   aut: "H. R. Karbasian, B. C. Vermeire",
   jou: "Phys. Fluids",
   num: "34",
   pag: "014101",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jcp.2022.110959",
   tit: "A novel approach of mesh optimization to stabilize unstructured finite volume simulations",
   aut: "M. Zandsalimy and C. Ollivier-Gooch",
   jou: "J. Comput. Phys.",
   num: "453",
   pag: "110959",
   yr : 2022
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1017/jfm.2021.1051",
   tit: "Application of physics-constrained data-driven reduced-order models to shape optimization",
   aut: "H. R. Karbasian, B. C. Vermeire",
   jou: "J. Fluid Mech.",
   num: "934",
   pag: "A32",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2204.13527",
   doi: "10.1017/jfm.2022.390",
   tit: "Low-frequency resolvent analysis of the laminar oblique shock wave/boundary layer interaction",
   aut: "B. Bugeat, J.-Ch. Robinet, J.-C. Chassaing, P. Sagaut",
   jou: "J. Fluid Mech.",
   num: "942",
   pag: "A43",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://hal.archives-ouvertes.fr/hal-03664155",
   tit: "Resolvent analysis of an infinite swept airfoil with wall roughness",
   aut: "E. Kitzinger, D. Sipp, E. Piot, O. Marquet",
   pro: "AERO 2022",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2022.453",
   tit: "Dynamics and bifurcations of laminar annular swirling and non-swirling jets",
   aut: "C. M. Douglas, B. L. Emerson, T. C. Lieuwen",
   jou: "J. Fluid Mech.",
   num: "943",
   pag: "A35",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2022.417",
   tit: "Acoustic instability prediction of the flow through a circular aperture in a thick plate via an impedance criterion",
   aut: "J. Sierra-Ausin, D. Fabre, V. Citro, F. Giannetti",
   jou: "J. Fluid. Mech.",
   num: "943",
   pag: "A48",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2022-3227",
   tit: "Matrix-free global stability analysis framework for 2D and 3D applications",
   aut: "F. Plante, E. Laurendeau",
   pro: "AIAA Aviation Forum",
   yr : 2022
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1017/jfm.2022.519",
   tit: "Sparsifying the resolvent forcing mode via gradient-based optimisation",
   aut: "C. S. Skene, C.-A. Yeh, P. J. Schmid, K. Taira",
   jou: "J. Fluid Mech.",
   num: "944",
   pag: "A52",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.21203/rs.3.rs-1827744/v1",
   tit: "Bi-global stability analysis of hypersonic streamwise corner flows",
   aut: "D. Xu, Y. Xi, X. Chen, J. Ren, E. Lu, S. Fu",
   jou: "PP",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.research.manchester.ac.uk/portal/files/224504177/FULL_TEXT.PDF",
   tit: "Thermally driven three-dimensional flows and their stability",
   aut: "S. M. Edwards",
   jou: "PD",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/s00021-022-00720-4",
   tit: "Kinetic-energy instability of flows with slip boundary conditions",
   aut: "I. G. Gjerde, L. R. Scott",
   jou: "J. Math. Fluid Mech.",
   num: "24",
   pag: "97",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevFluids.7.113603",
   url: "https://hal.archives-ouvertes.fr/hal-03858749",
   tit: "Dynamics of a gas bubble in a straining flow: deformation, oscillations, self-propulsion",
   aut: "J. Sierra-Ausin, P. Bonnefis, A. Tirri, D. Fabre, J. Magnaudet",
   jou: "Phys. Rev. Fluids",
   num: "7",
   pag: "113603",
   yr : 2022
  },
  {cat: cfd,
   cla: svd,
   url: "https://www.proquest.com/dissertations-theses/frequency-domain-analysis-model-reduction-control/docview/2722365339/se-2",
   tit: "Frequency-domain analysis, model reduction and control of time-periodic fluid flows",
   aut: "A. Padovan",
   jou: "PD",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.17863/CAM.96087",
   tit: "Modelling the floating-catalyst method for carbon nanotube production",
   aut: "F. G&ouml;kstorp",
   jou: "PD",
   yr : 2022
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://hal.archives-ouvertes.fr/hal-03813339",
   doi: "10.1017/jfm.2023.38",
   tit: "Attachment-line, crossflow and Tollmien-Schlichting instabilities on swept ONERA-D and Joukowski airfoils",
   aut: "E. Kitzinger, T. Leclercq, O. Marquet, E. Piot, D. Sipp",
   jou: "J. Fluid Mech.",
   num: "957",
   pag: "A29",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2209.13980",
   doi: "10.1017/jfm.2023.426",
   tit: "From thin plates to Ahmed bodies: linear and weakly non-linear stability of rectangular prisms",
   aut: "G. A. Zampogna, E. Boujo",
   jou: "J. Fluid Mech.",
   num: "966",
   pag: "A19",
   yr : 2023
  },
  {cat: cfd,
   cla: svd,
   arx: "2210.12533",
   doi: "10.1063/5.0131923",
   tit: "Dissipation-optimized Proper Orthogonal Decomposition",
   aut: "P. J. Olesen, A. Hod&zcaron;i&cacute;, S. J. Andersen, N. N. S&oslash;rensen, C. M. Velte",
   jou: "Phys. Fluids",
   num: "35",
   pag: "015131",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2206.05493",
   doi: "10.1016/j.cpc.2022.108557",
   tit: "BROADCAST: A high-order compressible CFD toolbox for stability and sensitivity using Algorithmic Differentiation",
   aut: "A. Poulain, C. Content, D. Sipp, G. Rigas, E. Garnier",
   jou: "Comput. Phys. Commun.",
   num: "283",
   pag: "108557",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1115/1.4056184",
   tit: "Response of separated boundary layers to steady and pulsated flow injection",
   aut: "H. D. Nowak, F. Lluesma-Rodriguez, I. Rahbari, J. Clark, G. Paniagua",
   jou: "J. Turbomach.",
   num: "145(6)",
   pag: "061001",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2023-0833",
   tit: "Unsupervised residual vector analysis for mesh optimization",
   aut: "M. Zandsalimy and C. Ollivier Gooch",
   pro: "AIAA SCITECH Forum",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2023-2064",
   tit: "Validation of tailored resonant behavior for multiscale optimized lattice structures",
   aut: "M. Nightingale, R. Murphy, R. Hewson, M. Santer",
   pro: "AIAA SCITECH Forum",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2303.00395",
   doi: "10.1063/5.0149639",
   tit: "On the instability of the magnetohydrodynamic pipe flow subject to a transverse magnetic field",
   aut: "Y. Velizhanina, B. Knaepen",
   jou: "Phys. Fluids",
   num: "35",
   pag: "044112",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2303.16325",
   tit: "Global stability analysis of a hypersonic cone-cylinder-flare geometry",
   aut: "C. Caillaud, M. Lugrin, S. Esquieu, C. Content",
   yr : 2023
  },
  {cat: cfd,
   cla: epsh,
   url: "https://hal.science/hal-04065762",
   tit: "Optimal location for steady wall blowing or heating actuators in a hypersonic boundary layer",
   aut: "A. Poulain, C. Content, D. Sipp, G. Rigas, E. Garnier",
   pro: "AERO 2023",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1002/pamm.202200237",
   tit: "Global stability analysis of the interaction between a longitudinal vortex and an oblique shock wave",
   aut: "M. Werner, S. Hein",
   jou: "PAMM",
   num: "23(1)",
   pag: "e202200237",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2023-3414",
   tit: "Three-dimensional stability and resolvent analysis of external flows over spanwise-homogeneous immersed bodies",
   aut: "W. Hou, T. Colonius",
   pro: "AIAA Aviation Forum",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2023-3434",
   tit: "FELiCS: A Versatile Linearized Solver Addressing Dynamics in Multi-Physics Flows",
   aut: "T. L. Kaiser, S. Demange, J. S. M&uuml;ller, K. Oberleithner",
   pro: "AIAA Aviation Forum",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2023.430",
   tit: "Compressibility effects on the secondary instabilities of the circular cylinder wake",
   aut: "L. V. Rolandi, J. Fontane, T. Jardin, J. Gressier, L. Joly",
   jou: "J. Fluid Mech.",
   num: "966",
   pag: "A36",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://escholarship.org/uc/item/36c1j1nq",
   tit: "A 2D-local linear stability analysis of asymptotically-expanded jet-in-crossflows",
   aut: "D. W. D. Ren",
   jou: "PD",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.researchgate.net/publication/372980468",
   tit: "Study of the boundary layer stability, receptivity, and control based on linearized chordwise- global analyses",
   aut: "E. Kitzinger",
   jou: "PD",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2023.617",
   tit: "Linear global stability of a flow past a sphere under a streamwise magnetic field",
   aut: "X.-L. Zheng, J.-H. Pan, M.-J. Ni",
   jou: "J. Fluid Mech.",
   num: "970",
   pag: "A16",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://elib.dlr.de/197156",
   tit: "Numerische Untersuchung der Wirbel-Wirbel- und Wirbel-Sto&szlig;-Interaktion in transsonischen Str&ouml;mungen",
   aut: "M. Werner",
   jou: "PD",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://hal.science/hal-04207774",
   doi: "10.1016/j.combustflame.2023.113060",
   tit: "Flash-back, blow-off, and symmetry breaking of premixed conical flames",
   aut: "C. M. Douglas, W. Polifke, L. Lesshafft",
   jou: "Combustion and Flame",
   num: "258",
   pag: "113060",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://digitalcommons.dartmouth.edu/dissertations/161",
   tit: "A framework and approach for leveraging unsteady response in turbocompressor flowfields",
   aut: "E. M. Krivitzky",
   jou: "PD",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevFluids.8.103903",
   tit: "Global stability analysis of an idealized compressor blade row. I. Single-blade passage analysis",
   aut: "A. Glazkov, M. Fosas de Pando, P. J. Schmid, L. He",
   jou: "Phys. Rev. Fluids",
   num: "8",
   pag: "103903",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevFluids.8.103904",
   tit: "Global stability analysis of an idealized compressor blade row. II. Multiple-blade interactions",
   aut: "A. Glazkov, M. Fosas de Pando, P. J. Schmid, L. He",
   jou: "Phys. Rev. Fluids",
   num: "8",
   pag: "103904",
   yr : 2023
  },
  {cat: cfd,
   cla: pep,
   doi: "10.1016/j.ast.2023.108733",
   tit: "Three-dimensional global instability analysis for high-speed boundary layer flow",
   aut: "Y. Lu, J. Liang, Z. Liu, H. Liu, C. Yan",
   jou: "Aerospace Sci. Tech.",
   num: "143",
   pag: "108733",
   yr : 2023
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.18721/JPM.16405",
   tit: "A comparison of two approaches to the global stability analysis using the example of the cylinder flow problem",
   aut: "V. D. Golubkov, A. V. Garbaruk",
   jou: "St. Petersburg St. Pol. Univ. J.",
   num: "16(4)",
   pag: "226",
   yr : 2023
  },
  {cat: cfd,
   cla: svd,
   arx: "2312.05766",
   doi: "10.1007/s00162-024-00694-1",
   tit: "Efficient harmonic resolvent analysis via time stepping",
   aut: "A. Farghadan, J. Jung, R. Bhagwat, A. Towne",
   jou: "Theor. Comput. Fluid Dyn.",
   num: "38",
   pag: "331-353",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2306.07836",
   doi: "10.1017/jfm.2023.993",
   tit: "Adjoint-based linear sensitivity of a supersonic boundary layer to steady wall blowing-suction/heating-cooling",
   aut: "A. Poulain, C. Content, G. Rigas, E. Garnier, D. Sipp",
   jou: "J. Fluid Mech.",
   num: "978",
   pag: "A16",
   yr : 2024
  },
  {cat: cfd,
   cla: epsh,
   doi: "10.1098/rspa.2023.0951",
   arx: "2307.00730",
   tit: "Variational construction of tubular and toroidal streamsurfaces for flow visualization",
   aut: "M. Li, B. Kasz&aacute;s, G. Haller",
   jou: "P. R. Soc. A",
   num: "480",
   pag: "2285",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.ijmultiphaseflow.2023.104717",
   tit: "Flow stability and regime transitions on periodic open foams",
   aut: "Y. Jobic, M. M&eacute;dale, F. Topin",
   jou: "Int. J. Multiphase Flow",
   num: "172",
   pag: "104717",
   yr : 2024
  },
  {cat: cfd,
   cla: pep,
   doi: "10.1016/j.compfluid.2023.106115",
   tit: "Reused LU factorization as a preconditioner for efficient solution of the parabolized stability equation",
   aut: "A. Szab&oacute;, G. Pa&aacute;l",
   jou: "Comput. &amp; Fluids",
   num: "269",
   pag: "106115",
   yr : 2024
  },
  {cat: cfd,
   cla: pep,
   doi: "10.1016/j.compfluid.2023.106123",
   tit: "Stability analysis of a streaky boundary layer generated by miniature vortex generators",
   aut: "A. Szab&oacute;, P. T. Nagy, G. De Baets, M. Vanierschot, G. Pa&aacute;l",
   jou: "Comput. &amp; Fluids",
   num: "269",
   pag: "106123",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2024-2871",
   tit: "Automated convergence acceleration of flow solvers using dynamic mode decomposition",
   aut: "A. Mirshahi and C. Ollivier Gooch",
   pro: "AIAA SCITECH Forum",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2024-1949",
   tit: "Approximate Jacobian eigenanalysis for unstructured mesh optimization of finite-volume simulations",
   aut: "M. Zandsalimy and C. Ollivier Gooch",
   pro: "AIAA SCITECH Forum",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2024-2552",
   tit: "Optimal transitional mechanisms in oblique shock wave-boundary layer interaction using non-linear input/output analysis",
   aut: "F. Savarino, A. Poulain, D. Sipp, G. Rigas",
   pro: "AIAA SCITECH Forum",
   yr : 2024
  },
  {cat: cfd,
   cla: epsh,
   doi: "10.1016/j.apm.2024.02.008",
   tit: "Topology optimization for flow machine rotor design considering resonance and low mass density flows",
   aut: "D. H. Alonso, R. Picelli, J. R. Meneghini, E. C. N. Silva",
   jou: "Appl. Math. Model.",
   num: "129",
   pag: "806-822",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://theses.hal.science/tel-04502938",
   tit: "Optimal linear and non-linear solutions in hypersonic boundary layers: stability and open-loop control",
   aut: "A. Poulain",
   jou: "PD",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.ijheatfluidflow.2024.109358",
   tit: "Prediction of effect of small local surface irregularities on natural transition to turbulence based on Global Stability Analysis",
   aut: "K. Belyaev, A. Garbaruk, V. Golubkov, M. Strelets",
   jou: "Int. J. Heat Fluid Flow",
   num: "107",
   pag: "109358",
   yr : 2024
  },
  {cat: cfd,
   cla: svd,
   arx: "2404.11789",
   doi: "10.1007/s00162-024-00717-x",
   tit: "An invitation to resolvent analysis",
   aut: "L. V. Rolandi, J. H. Marques Ribeiro, Chi-An Yeh, K. Taira",
   jou: "Theor. Comput. Fluid Dyn.",
   num: "38",
   pag: "603-639",
   yr : 2024
  },
  {cat: cfd,
   cla: epsh,
   url: "http://www.researchgate.net/publication/371490367",
   doi: "10.1007/s00162-024-00700-6",
   tit: "Acoustic resolvent analysis of turbulent jets",
   aut: "B. Bugeat, U. Karban, A. Agarwal, L. Lesshafft, P. Jordan",
   jou: "Theor. Comput. Fluid Dyn.",
   num: "38",
   pag: "687-706",
   yr : 2024
  },
  {cat: cfd,
   cla: svd,
   doi: "10.1016/j.jcp.2024.113063",
   tit: "Residual vector and solution mode analysis using semi-supervised machine learning for mesh modification and CFD stability improvement",
   aut: "M. Zandsalimy and C. Ollivier-Gooch",
   jou: "J. Comput. Phys.",
   num: "510",
   pag: "113063",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1007/s00162-024-00704-2",
   tit: "Resolvent analysis of swirling turbulent jets",
   aut: "Q. Chevalier, C. M. Douglas, L. Lesshafft",
   jou: "Theor. Comput. Fluid Dyn.",
   num: "38",
   pag: "641-663",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2024.106386",
   tit: "Adjoint-based optimisation of time- and span-periodic flow fields with Space-Time Spectral Method: Application to non-linear instabilities in compressible boundary layer flows",
   aut: "A. Poulain, C. Content, a. Schiappa, P. Nibourei, G. Rigas, D. Sipp",
   jou: "Comput. &amp; Fluids",
   num: "282",
   pag: "106386",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.jfluidstructs.2024.104187",
   tit: "Global stability analysis of flow-induced-vibration problems using an immersed boundary method",
   aut: "Z. Zhang, J. Lu, X. Zhang",
   jou: "J. Fluid Struct.",
   num: "130",
   pag: "104187",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2409.16669",
   tit: "Biglobal linear stability analysis of a ducted 2D premixed flame: intrinsic thermoacoustic mode and role of exceptional point",
   aut: "L. Chen, Y. Lv",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2024.499",
   tit: "Weakly nonlinear behaviour of transonic buffet on airfoils",
   aut: "J. D. Crouch, B. R. Ahrabi, D. S. Kamenetskiy",
   jou: "J. Fluid Mech.",
   num: "999",
   pag: "A8",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2024.1113",
   tit: "Viscoelastic flow around a confined cylinder: 2-D linear stability analysis leading to asymmetric flow",
   aut: "A. Spyridakis, P. Moschopoulos, S. Varchanis, Y. Dimakopoulos, J. Tsamopoulos",
   jou: "J. Fluid Mech.",
   num: "1001",
   pag: "A40",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2024.1009",
   tit: "Linear stability analysis of turbulent mean flows based on a data-consistent Reynolds-averaged Navier-Stokes model: prediction of three-dimensional stall cells around an airfoil",
   aut: "K. Sarras, C. Tayeh, V. Mons, O. Marquet",
   jou: "J. Fluid Mech.",
   num: "1001",
   pag: "A41",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2412.13539",
   tit: "Linear stability and resolvent analyses of a bluff-body stabilized flame with conjugate heat transfer",
   aut: "L. Chen, W. L. Chan, Y. Lv",
   yr : 2024
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.researchgate.net/publication/387503998",
   tit: "Competition between 2D and 3D aerodynamic stall modes in transitional flows around a NACA0012 airfoil at Re=90000",
   aut: "K. Sarras, O. Marquet",
   pro: "ECCOMAS",
   yr : 2024
  },
  {cat: cfd,
   cla: svd,
   doi: "10.7302/25044",
   tit: "RSVD-&Delta;t: A unified algorithm for streamlined analysis of large-scale flows via resolvent and harmonic resolvent analyses",
   aut: "A. Farghadan",
   jou: "PD",
   yr : 2024
  },
  {cat: cfd,
   cla: svd,
   url: "https://juser.fz-juelich.de/record/1042307/files/178.pdf",
   tit: "Domain decomposition method for equivalent sources method in aeroacoustic",
   aut: "N. Debit, R. Denis, B. Fabrege, D. Tromeur-Dervout",
   pro: "ParCFD",
   yr : 2024
  },
  {cat: cfd,
   cla: pep,
   arx: "2311.02463",
   doi: "10.1103/PhysRevFluids.10.043902",
   tit: "Effect of streaks on hypersonic boundary layer linear instability",
   aut: "C. Caillaud, G. Lehnasch, E. Martini, P. Jordan",
   jou: "Phys. Rev. Fluids",
   num: "10",
   pag: "043902",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J064273",
   url: "https://www.researchgate.net/publication/384905999",
   tit: "Adjoint-based design optimization of stability constrained systems",
   aut: "S. He, E. Jonsson, J. R. R. A. Martins",
   jou: "AIAA Journal",
   num: "63",
   pag: "3",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2307.00094",
   doi: "10.1002/fld.5373",
   tit: "A finite element method to compute the damping rate and frequency of oscillating fluids inside microfluidic nozzles",
   aut: "S. Taverniers, S. Korneev, C. Somarakis, M. Behandish, A. J. Lew",
   jou: "Int. J. Numer. Meth. Fluids",
   num: "97(5)",
   pag: "765-782",
   yr : 2025
  },
  {cat: cfd,
   cla: svd,
   arx: "2309.04617",
   doi: "10.1016/j.jcp.2024.113695",
   tit: "Scalable resolvent analysis for three-dimensional flows",
   aut: "A. Farghadan, E. Martini, A. Towne",
   jou: "J. Comput. Phys.",
   num: "524",
   pag: "113695",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2025-1316",
   tit: "Global stability analysis of co-axial plasma jets",
   aut: "P. R. Sirmalla, A. Padovan, A. Munaf&ograve;, D. J. Bodony, M. Panesi",
   pro: "AIAA SCITECH Forum",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/6.2025-1533",
   tit: "Modeling freestream noise radiation from hypersonic tunnel wall turbulent boundary layers",
   aut: "G. Stroot, D. Roy, A. Madhusudanan, L. Duan, B. J. McKeon",
   pro: "AIAA SCITECH Forum",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.compfluid.2025.106549",
   tit: "A robust monolithic nonlinear Newton method for the compressible Reynolds averaged Navier-Stokes Equations",
   aut: "H. Sukas, M. Sahin",
   jou: "Comput. &amp; Fluids",
   num: "289",
   pag: "106549",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.18721/JPM.18103",
   tit: "The influence of pressure gradient and local surface irregularities on the laminar-turbulent transition in the boundary layer",
   aut: "A. V. Garbaruk, V. D. Golubkov, M. Kh. Strelets",
   jou: "St. Petersburg Poly. Univ. J.: Phys. Math.",
   num: "18",
   pag: "1",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1103/PhysRevFluids.10.043902",
   tit: "Effect of streaks on hypersonic boundary layer linear instability",
   aut: "G. Lehnasch, E. Martini",
   jou: "Phys. Rev. Fluids",
   num: "10",
   pag: "043902",
   yr : 2025
  },
  {cat: cfd,
   cla: svd,
   arx: "2501.04255",
   tit: "Biglobal resolvent analysis of separated flow over a NACA0012 airfoil",
   aut: "L. V. Rolandi, L. Smith, M. Amitay, V. Theofilis, K. Taira",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2503.08401",
   tit: "Mean resolvent analysis of periodic flows",
   aut: "A. Bongarzone, C. Content, D. Sipp, C. Leclercq",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2504.16679",
   tit: "Transition mechanisms in hypersonic wind-tunnel nozzles: a methodological approach using global linear stability analysis",
   aut: "H. Lemarquand, M. Lugrin, C. Content, C. Caillaud, S. Esquieu, D. Sipp",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://resolver.caltech.edu/CaltechTHESIS:03202025-173020131",
   tit: "Fast algorithms for spanwise periodic incompressible external flows: from simulation to analysis",
   aut: "W. Hou",
   jou: "PD",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2025.395",
   tit: "Self-excited instability and transition to turbulence in laminar separation bubbles induced by surface waviness",
   aut: "M. Moniripiri, D. Rodríguez, A. Hanifi",
   jou: "J. Fluid Mech.",
   num: "1011",
   pag: "A27",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.18721/JPM.18103",
   tit: "THe influence of pressure gradientand local surface irregularities on the laminar-turbulent transition in the boundary layer",
   aut: "A. V. Garbaruk, V. D. Golubkov, M. Kh. Strelets",
   jou: "St. Petersburg Pol. Univ. J.",
   num: "18(4)",
   pag: "203",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2506.20539",
   doi: "10.1016/j.softx.2025.102286",
   tit: "Resolvent4py: a parallel Python package for analysis, model reduction and control of large-scale linear systems",
   aut: "A. Padovan, V. Anantharaman, C. W. Rowley, B. Vollmer, T. Colonius, D. J. Bodony",
   jou: "SoftwareX",
   num: "31",
   pag: "102286",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://avestia.com/MHMT2025_Proceedings/files/paper/CSP/CSP_132.pdf",
   tit: "Linear stability analysis of laminar flames with Lewis number greater than unity and wide range of premixedness",
   aut: "D. Bhatt, D. Rodriguez",
   pro: "MHMT",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1063/5.0278544",
   tit: "Linear stability analysis of a premixed flame in curved micro-combustors",
   aut: "L. Chen, Y. Lv",
   jou: "Phys. Fluids",
   num: "37",
   pag: "084108",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.cmff.hu/papers25/CMFF25_Final_Paper_PDF_81.pdf",
   tit: "Geometrical optimization of rectangular MVGs delaying boundary layer transition over a flat plate",
   aut: "M. Kulcsar, A. Szabo, T. T. Nagy, G. Paal",
   pro: "CMFF’25",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1115/1.4069013",
   tit: "Stability of natural convection in a vertical porous layer of viscoelastic Navier–Stokes–Voigt fluid",
   aut: "D. L. Shivaraj",
   jou: "J. Heat Mass Tran.",
   num: "147(10)",
   pag: "102601",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.2514/1.J065742",
   tit: "Stability of low Reynolds number flow around a NACA4412 airfoil at stall",
   aut: "M. Fiore, G. Nastro, V. Rolandi, J. Gressier",
   jou: "AIAA Journal",
   num: "IP",
   pag: "",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2509.24602",
   tit: "Kinetic energy instability of pipe flow in finite domains",
   aut: "C. Giraudo, I. G. Gjerde, M. Kuchta, L. R. Scott",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   url: "https://www.diva-portal.org/smash/record.jsf?pid=diva2%3A2001930",
   tit: "Stability and transition analysis of shear flows",
   aut: "M. Moniripiri",
   jou: "PD",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1017/jfm.2025.10655",
   tit: "Phononic compliant surfaces for the suppression of travelling-wave flutter instabilities in boundary-layer flows",
   aut: "N. Fabbiane, O. Marquet, L. Pierpaoli, R. Cottereau, M. Couliou",
   jou: "J. Fluid Mech.",
   num: "1020",
   pag: "A47",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   doi: "10.1016/j.icheatmasstransfer.2025.109923",
   tit: "Stability of mixed convection in a vertical layer of Navier-Stokes-Voigt fluid under a uniform magnetic field",
   aut: "D. L. Shivaraj",
   jou: "Int. Comm. Heat Mass Tran.",
   num: "169",
   pag: "109923",
   yr : 2025
  },
  {cat: cfd,
   cla: epsnh,
   arx: "2510.11880",
   tit: "Is the transition to unsteadiness in the wake of slender bodies an artefact of boundary conditions?",
   aut: "D. Fabre",
   yr : 2025
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1134/S1028334X11110031",
   tit: "Infrasound oscillations in the Sea of Japan",
   aut: "G. I. Dolgikh et al.",
   jou: "Doklady Earth Sciences",
   num: "441(1)",
   pag: "1529-1532",
   yr : 2011
  },
  {cat: geo,
   cla: svd,
   url: "http://ieeexplore.ieee.org/xpl/login.jsp?tp=&arnumber=6223432",
   tit: "Ionospheric ionogram denoising based on Robust Principal Component Analysis",
   aut: "L. Shinan et al.",
   pro: "ICSAI",
   yr : 2012
  },
  {cat: geo,
   cla: epsh,
   url: "http://cmwr2012.cee.illinois.edu/Papers/Special%20Sessions/Advances%20in%20Nonlinear%20and%20Linear%20Solvers%20for%20Water%20Resources%20Applications/Saibaba(revised).pdf",
   tit: "Dimensionality reduction in the geostatistical approach for hydraulic tomography",
   aut: "A. K. Saibaba and P. K. Kitanidis",
   pro: "CMWR",
   yr : 2012
  },
  {cat: geo,
   cla: epsh,
   doi: "10.1029/2011WR011778",
   tit: "Efficient methods for large-scale linear inversion using a geostatistical approach",
   aut: "A. K. Saibaba and P. K. Kitanidis",
   jou: "Water Resources Research",
   num: "48",
   pag: "W05522",
   yr : 2012
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1093/gji/ggt064",
   tit: "Modelling the tsunami free oscillations in the Marquesas (French Polynesia)",
   aut: "S. Allgeyer et al.",
   jou: "Geophys. J. Int.",
   num: "193(3)",
   pag: "1447-1459",
   yr : 2013
  },
  {cat: geo,
   cla: svd,
   doi: "10.1002/wrcr.20250",
   tit: "Quantification of the upstream-to-downstream influence in the Muskingum method, and implications for speedup in parallel computations of river flow",
   aut: "C. H. David et al.",
   jou: "Water Resources Research",
   num: "49(5)",
   pag: "2783-2800",
   yr : 2013
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1134/S0001433813050125",
   tit: "Seiche oscillations in Lake Baikal",
   aut: "S. V. Smirnov et al.",
   jou: "Izvestiya, Atmospheric and Oceanic Physics",
   num: "50(1)",
   pag: "92-102",
   yr : 2014
  },
  {cat: geo,
   cla: epsnh,
   url: "http://hal-insu.archives-ouvertes.fr/docs/00/94/82/56/PDF/sebastien.allgeyer.pdf",
   tit: "Mod&eacute;lisation de l'al&eacute;a tsunamis et des r&eacute;sonances c&ocirc;ti&egrave;res en France",
   aut: "S. Allgeyer",
   jou: "PD",
   yr : 2014
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1134/S1995423914020104",
   tit: "On calculation of seiche oscillations of the middle part of the Peter the Great gulf",
   aut: "S. V. Smirnov",
   jou: "Numerical Analysis and Applications",
   num: "7(2)",
   pag: "168-179",
   yr : 2014
  },
  {cat: geo,
   cla: svd,
   url: "http://www.earthdoc.org/publication/publicationdetails/?publication=79058",
   tit: "Free surface effect on solution quality of inverse dynamic problem in seismic",
   aut: "K. G. Gadylshin et al.",
   jou: "Seismic Technology",
   num: "12(3)",
   pag: "1-16",
   yr : 2014
  },
  {cat: geo,
   cla: svd,
   doi: "10.1093/gji/ggv165",
   tit: "Parallel three-dimensional magnetotelluric inversion using adaptive finite-element method. Part I: theory and synthetic study",
   aut: "A. V. Grayver",
   jou: "Geophys. J. Int.",
   num: "202(1)",
   pag: "584-603",
   yr : 2015
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1093/gji/ggv282",
   tit: "Quasi-geostrophic modes in the Earth's fluid core with an outer stably stratified layer",
   aut: "J. Vidal and N. Schaeffer",
   jou: "Geophys. J. Int.",
   num: "202(3)",
   pag: "2182-2193",
   yr : 2015
  },
  {cat: geo,
   cla: pep,
   doi: "10.1093/gji/ggv349",
   tit: "Synthetic free-oscillation spectra: an appraisal of various mode-coupling methods",
   aut: "H.-Y. Yang and J. Tromp",
   jou: "Geophys. J. Int.",
   num: "203(2)",
   pag: "1179-1192",
   yr : 2015
  },
  {cat: geo,
   cla: svd,
   doi: "10.1002/2014WR016650",
   tit: "Enhanced fixed-size parallel speedup with the Muskingum method using a trans-boundary approach and a large subbasins approximation",
   aut: "C. H. David et al.",
   jou: "Water Resources Research",
   num: "51(9)",
   pag: "7547-7571",
   yr : 2015
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1002/2015GC006061",
   tit: "Torsion of a cylinder of partially molten mantle with a spherical inclusion: theory and simulation",
   aut: "L. Alisic et al.",
   jou: "Geochem. Geophy. Geosy.",
   num: "17(1)",
   pag: "143-161",
   yr : 2016
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.3103/S1068373916010076",
   tit: "Seiche oscillations in the Nakhodka Gulf",
   aut: "S. V. Smirnov",
   jou: "Russ. Meteorol. Hydrol.",
   num: "41(1)",
   pag: "57-62",
   yr : 2016
  },
  {cat: geo,
   cla: svd,
   doi: "10.1002/2015WR017782",
   tit: "Accurate and efficient prediction of fine-resolution hydrologic and carbon dynamic simulations from coarse-resolution models",
   aut: "G. S. H. Pau et al.",
   jou: "Water Resources Research",
   num: "52(2)",
   pag: "791-812",
   yr : 2016
  },
  {cat: geo,
   cla: epsh,
   arx: "1603.08135",
   tit: "Constructing low-dimensional stochastic wind models through hierarchical spatial temporal decomposition",
   aut: "Q. Guo et al.",
   yr : 2016
  },
  {cat: geo,
   cla: pep,
   doi: "10.1002/2015JD024527",
   tit: "The interaction between infrasonic waves and gravity wave perturbations: Application to observations using UTTR Rocket Motor Fuel Elimination Events",
   aut: "J.-M. Lalande and R. Waxler",
   jou: "J. Geophys. Res.-Atmos.",
   num: "121(10)",
   pag: "5585-5600",
   yr : 2016
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1002/2016GC006438",
   tit: "A computationally efficient spectral method for modeling core dynamics",
   aut: "P. Marti et al.",
   jou: "Geochem. Geophy. Geosy.",
   num: "17(8)",
   pag: "3031-3052",
   yr : 2016
  },
  {cat: geo,
   cla: svd,
   url: "http://mi.mathnet.ru/vmp854",
   tit: "Near surface reconstruction using the full waveform inversion method: a resolution analysis",
   aut: "K. G. Gadylshin et al.",
   jou: "Vychisl. Metody Programm.",
   num: "17(4)",
   pag: "487-499",
   yr : 2016
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1121/1.4976067",
   tit: "Modal expansions for infrasound propagation and their implications for ground-to-ground propagation",
   aut: "R. Waxler et al.",
   jou: "J. Acoust. Soc. Am.",
   num: "141(2)",
   pag: "1290-1307",
   yr : 2017
  },
  {cat: geo,
   cla: epsh,
   doi: "10.1175/JTECH-D-16-0140.1",
   tit: "Parallel direct solution of the Ensemble Square-Root Kalman Filter equations with observation principal components",
   aut: "J. L. Steward et al.",
   jou: "J. Atmos. Ocean. Tech.",
   num: "34(9)",
   pag: "1867-1884",
   yr : 2017
  },
  {cat: geo,
   cla: pep,
   doi: "10.1121/1.4977578",
   tit: "A wide-angle high Mach number modal expansion for infrasound propagation",
   aut: "J. Assink et al.",
   jou: "J. Acoust. Soc. Am.",
   num: "141(3)",
   pag: "1781-1792",
   yr : 2017
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1016/j.pepi.2018.01.005",
   tit: "Influence of magnetic field configuration on magnetohydrodynamic waves in Earth's core",
   aut: "N. Knezek and B. Buffett",
   jou: "Phys. Earth Planet. In.",
   num: "277",
   pag: "1-9",
   yr : 2018
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1108/EC-08-2016-0294",
   tit: "Large-scale parallel computation for earthquake response spectrum analysis",
   aut: "X. Fan et al.",
   jou: "Engin. Comput.",
   num: "35(2)",
   pag: "800-817",
   yr : 2018
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.3103/S1068373918020048",
   tit: "Studying resonance oscillations in the eastern part of the Posyet Bay",
   aut: "S. V. Smirnov et al.",
   jou: "Russ. Meteorol. Hydrol.",
   num: "43(2)",
   pag: "88-94",
   yr : 2018
  },
  {cat: geo,
   cla: mfn,
   doi: "10.1175/MWR-D-18-0022.1",
   tit: "Parallel direct solution of the covariance-localized Ensemble Square-Root Kalman filter equations with matrix functions",
   aut: "J. L. Steward et al.",
   jou: "Mon. Weather Rev..",
   num: "146(9)",
   pag: "2819-2836",
   yr : 2018
  },
  {cat: geo,
   cla: epsnh,
   url: "https://www.research.ed.ac.uk/portal/en/publications/leveraging-slepc-in-modeling-the-earths-magnetic-environment(c9ffb865-caf0-4a95-9e94-c5bb9b57aae4).html",
   tit: "Leveraging SLEPc in modeling the Earth's magnetic environment",
   aut: "N. Brown et al.",
   pro: "EASC2018",
   yr : 2018
  },
  {cat: geo,
   cla: pep,
   doi: "10.1093/gji/ggy465",
   tit: "Inertial modes in near-spherical geometries",
   aut: "J. Rekier et al.",
   jou: "Geophys. J. Int.",
   num: "216(2)",
   pag: "777-793",
   yr : 2019
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1175/JPO-D-18-0088.1",
   tit: "Stability criterion for the centrifugal instability of surface intensified anticyclones",
   aut: "E. Yim et al.",
   jou: "J. Phys. Oceanogr.",
   num: "49(3)",
   pag: "827-849",
   yr : 2019
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1093/gji/ggz212",
   arx: "1904.11837",
   tit: "The coupling between inertial and rotational eigenmodes in planets with liquid cores",
   aut: "S. A. Triana, J. Rekier, A. Trinh, V. Dehant",
   jou: "Geophys. J. Int.",
   num: "218",
   pag: "1071-1086",
   yr : 2019
  },
  {cat: geo,
   cla: epsnh,
   arx: "1902.08523",
   doi: "10.1093/gji/ggz347",
   tit: "Rotating double-diffusive convection in stably stratified planetary cores",
   aut: "R. Monville, J. Vidal, D. C&eacute;bron, N. Schaeffer",
   jou: "Geophys. J. Int.",
   num: "219",
   pag: "195-218",
   yr : 2019
  },
  {cat: geo,
   cla: svd,
   doi: "10.1088/1742-6596/1392/1/012080",
   tit: "Data space reflectivity full waveform inversion",
   aut: "K. G. Gadylshin and V. Tcheverda",
   jou: "J. Phys.: Conf. Ser.",
   num: "1392",
   pag: "012080",
   yr : 2019
  },
  {cat: geo,
   cla: epsnh,
   url: "https://escholarship.org/uc/item/0713x04s",
   tit: "Equatorial magnetic waves in the stratified ocean of earth's core",
   aut: "N. R. Knezek",
   jou: "PD",
   yr : 2019
  },
  {cat: geo,
   cla: epsnh,
   url: "https://www.research.ed.ac.uk/portal/en/publications/modelling-the-earths-geomagnetic-environment-on-cray-machines-using-petsc-and-slepc(d1281e20-33a6-423a-bea9-2f5760641268).html",
   doi: "10.1002/cpe.5660",
   tit: "Modelling the Earth's geomagnetic environment on Cray machines using PETSc and SLEPc",
   aut: "N. Brown, B. Bainbridge, C. Beggan, W. Brown, B. Hamilton, S. Macmillan",
   jou: "Concurr. Comp.-Pract. E.",
   num: "32(20)",
   pag: "e5660",
   yr : 2020
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.2118/201621-MS",
   tit: "Eigenmode decomposition of the diffusion equation: applications to pressure-rate deconvolution",
   aut: "L. Kubota, R. Piccinini",
   pro: "SPE Annual Technical Conference and Exhibition",
   yr : 2020
  },
  {cat: geo,
   cla: svd,
   url: "https://www.earthdoc.org/content/papers/10.3997/2214-4609.202053100",
   tit: "Multiparameter data-space reflectivity full waveform inversion in complex geology",
   aut: "K. Gadylshin and V. Cheverda",
   pro: "European Association of Geoscientists \& Engineers",
   yr : 2020
  },
  {cat: geo,
   cla: svd,
   doi: "10.3390/geosciences11020076",
   tit: "Elastic full-waveform inversion using migration-based depth reflector representation in the data domain",
   aut: "V. Tcheverda, K. Gadylshin",
   jou: "Geosciences",
   num: "11(2)",
   pag: "76",
   yr : 2021
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1186/s40623-020-01301-3",
   tit: "The BGS candidate models for IGRF-13 with a retrospective analysis of IGRF-12 secular variation forecasts",
   aut: "W. J. Brown, C. D. Beggan, G. A. Cox, S. Macmillan",
   jou: "Earth, Planets and Space",
   num: "73",
   pag: "42",
   yr : 2021
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1029/2020JB021042",
   tit: "The viscous and ohmic damping of the Earth's free core nutation",
   aut: "S. A. Triana, A. Trinh, J. Rekier, P. Zhu, V. Dehant",
   jou: "JGR Solid Earth",
   num: "126",
   pag: "e2020JB021042",
   yr : 2021
  },
  {cat: geo,
   cla: epsh,
   doi: "10.5194/gmd-14-5843-2021",
   tit: "fenics_ice 1.0: A framework for quantifying initialisation uncertainty for time-dependent ice-sheet models",
   aut: "C. Koziol, J. Todd, D. Goldberg, J. Maddison",
   jou: "Geosci. Model Dev.",
   num: "14",
   pag: "5843-5861",
   yr : 2021
  },
  {cat: geo,
   cla: mfn,
   url: "https://library.seg.org/doi/pdf/10.1190/segam2021-3595008.1",
   tit: "Solving one-step wave extrapolation matrix method using Krylov methods for matrix functions",
   aut: "O. F. Mojica, R. Pestana",
   pro: "1st Int. Meeting for Applied Geoscience & Energy",
   yr : 2021
  },
  {cat: geo,
   cla: epsnh,
   url: "https://academic.oup.com/gji/advance-article-pdf/doi/10.1093/gji/ggab476/41474504/ggab476.pdf",
   doi: "10.1093/gji/ggab476",
   tit: "A spectral element approach to computing normal modes",
   aut: "J. Kemper, M. van Driel, F. Munch, A. Khan, D. Giardini",
   jou: "Geophys. J. Int.",
   num: "229",
   pag: "915-932",
   yr : 2022
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.2118/201621-PA",
   tit: "Eigenmode decomposition of the diffusion equation: applications to pressure-rate deconvolution and reservoir pore volume estimation",
   aut: "L. Kubota, R. Piccinini",
   jou: "SPE J.",
   num: "27(03)",
   pag: "1744-1762",
   yr : 2022
  },
  {cat: geo,
   cla: svd,
   doi: "10.1007/978-3-031-10522-7_11",
   tit: "Full waveform inversion of the scattered component of the wavefield: resolution analysis",
   aut: "K. Gadylshin, M. Protasov",
   pro: "ICCSA",
   yr : 2022
  },
  {cat: geo,
   cla: epsh,
   arx: "2204.13007",
   doi: "10.3847/2041-8213/ac7dac",
   tit: "Identification of inertial modes in the solar convection zone",
   aut: "S. A. Triana, G. Guerrero, A. Barik, J. Rekier",
   jou: "ApJL",
   num: "934",
   pag: "L4",
   yr : 2022
  },
  {cat: geo,
   cla: epsnh,
   doi: "10.1029/2022EA002606",
   tit: "Onset of convection in rotating spherical shells: Variations with radius ratio",
   aut: "A. Barik, S. A. Triana, M. Calkins, S. Stanley, J. Aurnou",
   jou: "Earth and Space Science",
   num: "10(1)",
   pag: "e2022EA002606",
   yr : 2023
  },
  {cat: geo,
   cla: epsh,
   doi: "10.5194/tc-17-4241-2023",
   tit: "A framework for time-dependent ice sheet uncertainty quantification, applied to three West Antarctic ice streams",
   aut: "B. Recinos, D. Goldberg, J. R. Maddison, J. Todd",
   jou: "The Cryosphere",
   num: "17",
   pag: "4241-4266",
   yr : 2023
  },
  {cat: geo,
   cla: epsnh,
   url: "https://www.proquest.com/openview/0a95958453ee8199cc15253229aaa5d9",
   tit: "High performance computing methods for earthquake cycle simulations",
   aut: "A. Chen",
   jou: "PD",
   yr : 2024
  },
  {cat: geo,
   cla: pep,
   doi: "10.3397/IN_2024_3087",
   tit: "NCPAProp: an open-source, modular infrasound propagation modeling package",
   aut: "C. Hetzer, R. Waxler, J. Assink, D. Velea",
   pro: "INTER-NOISE and NOISE-CON",
   yr : 2024
  },
  {cat: geo,
   cla: epsnh,
   url: "https://www.researchgate.net/publication/384749939",
   doi: "10.1016/j.ress.2025.110921",
   tit: "Effects of inhomogeneity and statistical and material anisotropy on THM simulations",
   aut: "A. A. Chaudhry, C. Zhang, O. G. Ernst, T. Nagel",
   jou: "Reliab. Eng. Syst. Safe.",
   num: "260",
   pag: "110921",
   yr : 2025
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1016/j.pbiomolbio.2011.06.015",
   tit: "OpenCMISS: A multi-physics &amp; multi-scale computational infrastructure for the VPH/Physiome project",
   aut: "C. Bradley et al.",
   jou: "Prog. Biophys. Mol. Bio.",
   num: "107(1)",
   pag: "32-47",
   yr : 2011
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1109/TCSI.2011.2173394",
   tit: "Multistate and multistage synchronization of Hindmarsh-Rose neurons with excitatory chemical and electrical synapses",
   aut: "F.-J. Jhou et al.",
   jou: "IEEE T. Circuits Syst.",
   num: "59(6)",
   pag: "1335-1347",
   yr : 2012
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1016/j.neuroimage.2011.08.053",
   tit: "White matter atlas generation using HARDI based automated parcellation",
   aut: "L. Bloy et al.",
   jou: "NeuroImage",
   num: "59(4)",
   pag: "4055-4063",
   yr : 2012
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1007/978-88-470-1935-5_8",
   tit: "The VPH-Physiome project: standards, tools and databases for multi-scale physiological modelling",
   aut: "P. Hunter et al.",
   jou: "Modeling of Physiological Flows, MS&amp;A",
   num: "5",
   pag: "205-250",
   yr : 2012
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1016/j.jocs.2013.06.001",
   tit: "Open-source tools for dynamical analysis of Liley's mean-field cortex model",
   aut: "K. R. Green and L. van Veen",
   jou: "J. Comput. Sci.",
   num: "5(3)",
   pag: "507-516",
   yr : 2013
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1016/j.procs.2013.05.164",
   tit: "High performance computing in biomedical applications",
   aut: "S. Bastrakov et al.",
   jou: "Procedia Computer Science",
   num: "18",
   pag: "10-19",
   yr : 2013
  },
  {cat: bio,
   cla: mfn,
   doi: "10.1534/genetics.116.194019",
   tit: "Exact calculation of the joint allele frequency spectrum for isolation with migration models",
   aut: "A. D. Kern and J. Hey",
   jou: "Genetics",
   num: "207(1)",
   pag: "241-253",
   yr : 2017
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1007/s10237-016-0822-1",
   tit: "Material model of pelvic bone based on modal analysis: a study on the composite bone",
   aut: "P. Heny&scaron; and L. Capek",
   jou: "Biomech. Model. Mechanobiol.",
   num: "16(1)",
   pag: "363-373",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   url: "https://tel.archives-ouvertes.fr/tel-01538557",
   tit: "Mathematical modelling and simulations of the hemodynamics in the eye",
   aut: "M. C. M. Aletti",
   jou: "PD",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1016/j.camwa.2017.07.006",
   url: "http://www.public.iastate.edu/~jmchsu/files/Kamensky_et_al-2017-CAMWA.pdf",
   tit: "Projection-based stabilization of interface Lagrange multipliers in immersogeometric fluid-thin structure interaction analysis, with application to heart valve modeling",
   aut: "D. Kamensky et al.",
   jou: "Comput. Math. Appl.",
   num: "74(9)",
   pag: "2068-2088",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   doi: "10.3390/e19070367",
   tit: "Reliable approximation of long relaxation timescales in molecular dynamics",
   aut: "W. Zhang and C. Sch&uuml;tte",
   jou: "Entropy",
   num: "19(7)",
   pag: "367",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1063/1.4989545",
   tit: "Parallel O(N) Stokes' solver towards scalable Brownian dynamics of hydrodynamically interacting objects in general geometries",
   aut: "X. Zhao et al.",
   jou: "J. Chem. Phys.",
   num: "146",
   pag: "244114",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   url: "https://tel.archives-ouvertes.fr/tel-01646867",
   tit: "Mathematical modeling, analysis and simulations for fluid mechanics and their relevance to in silico medicine",
   aut: "M. Szopos",
   jou: "PD",
   yr : 2017
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1016/j.medengphy.2018.07.003",
   tit: "Modal frequency and shape curvature as a measure of implant fixation: a computer study on the acetabular cup",
   aut: "P. Heny&scaron; et al.",
   jou: "Medical Engin. &amp; Phys.",
   num: "60",
   pag: "30-38",
   yr : 2018
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1515/cdbme-2020-3028",
   tit: "Reduced order method for finite difference modeling of cardiac propagation",
   aut: "R. Khan, A. N. M. Shahebul Hasan, K. Ng",
   jou: "Curr. Dir. Biomedical Eng.",
   num: "6(3)",
   pag: "20203028",
   yr : 2020
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1371/journal.pcbi.1008356",
   tit: "Strong intracellular signal inactivation produces sharper and more robust signaling from cell membrane to nucleus",
   aut: "J. Ma et al.",
   jou: "PLOS Comput. Biol.",
   num: "16(11)",
   pag: "e1008356",
   yr : 2020
  },
  {cat: bio,
   cla: epsh,
   arx: "2004.01118",
   doi: "10.1088/1367-2630/ac29ff",
   tit: "Investigating the potential for a limited quantum speedup on protein lattice problems",
   aut: "C. Outeiral, G. M. Morris, J. Shi, M. Strahm, S. C. Benjamin, C. M. Deane",
   jou: "New J. Phys.",
   num: "23",
   pag: "103030",
   yr : 2021
  },
  {cat: bio,
   cla: epsh,
   url: "https://hdl.handle.net/2144/43124",
   tit: "Stochastic reaction-diffusion problems in modeling biochemical systems",
   aut: "J. Ma",
   jou: "PD",
   yr : 2021
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1038/s41598-021-94998-5",
   tit: "Mechanical metric for skeletal biomechanics derived from spectral analysis of stiffness matrix",
   aut: "P. Heny&scaron;, M. Kuchai, P, H&aacute;jek, N. Hammer",
   jou: "Scientific Reports",
   num: "11",
   pag: "15690",
   yr : 2021
  },
  {cat: bio,
   cla: svd,
   url: "https://journals.riverpublishers.com/index.php/ACES/article/view/8933",
   tit: "DMD-Galerkin model order reduction for cardiac propagation modeling",
   aut: "R. Khan, K. T. Ng",
   jou: "The ACES J.",
   num: "33(10)",
   pag: "1096-1099",
   yr : 2021
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1038/s41592-021-01346-6",
   tit: "CellRank for directed single-cell fate mapping",
   aut: "M. Lange, V. Bergen, M. Klein, M. Setty, B. Reuter, M. Bakhti, H. Lickert, M. Ansari, J. Schniering, H. Schiller, D. Pe'er, F. Theis",
   jou: "Nat. Methods",
   num: "19",
   pag: "159-170",
   yr : 2022
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1088/2057-1976/ac3c0b",
   tit: "Numerical study of POD-Galerkin-DEIM reduced order modeling of cardiac monodomain formulation",
   aut: "R. Khan, K. T. Ng",
   jou: "Biomed. Phys. Eng. Express",
   num: "8",
   pag: "015012",
   yr : 2022
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1007/978-3-031-05164-7_6",
   tit: "A computational study of flow instabilities in aneurysms",
   aut: "N. Berre1, G. Castro, H. Kjeldsberg, R. Masri, I. Gjerde",
   boo: "Computational Physiology",
   pag: "63-75",
   yr : 2022
  },
  {cat: bio,
   cla: epsh,
   url: "http://hdl.handle.net/20.500.11956/177895",
   tit: "Anthropometric-biomechanical characteristics of selected parts of the human skeleton based on principal loads and stiffnesses",
   aut: "M. Kuchar",
   jou: "PD",
   yr : 2022
  },
  {cat: bio,
   cla: epsnh,
   doi: "10.1007/978-3-031-35302-4_9",
   tit: "The Fibrotic Kernel Signature: simulation-free prediction of atrial fibrillation",
   aut: "F. Sahli Costabal, T. Banduc, L. Gander, S. Pezzuto",
   pro: "FIMH",
   yr : 2023
  },
  {cat: bio,
   cla: epsh,
   url: "http://hdl.handle.net/10012/19759",
   tit: "Modelling physical mechanisms of nodule development in phonotraumatic vocal hyperfunction using computational vocal fold models",
   aut: "J. J. Deng",
   jou: "PD",
   yr : 2023
  },
  {cat: bio,
   cla: epsh,
   doi: "10.1115/1.4064718",
   tit: "Sensitivity of phonation onset pressure to vocal fold stiffness distribution",
   aut: "J. Deng,  S. Peterson",
   jou: "J. Biomech. Eng.",
   num: "146(8)",
   pag: "081003",
   yr : 2024
  },
  {cat: bio,
   cla: epsnh,
   arx: "2206.14537",
   doi: "10.1016/j.cam.2024.115791",
   tit: "Spectral clustering of Markov chain transition matrices with complex eigenvalues",
   aut: "A.-S. Frank, A. Sikorski, S. Roblitz",
   jou: "J. Comput. Appl. Math.",
   num: "444",
   pag: "115791",
   yr : 2024
  },
  {cat: bio,
   cla: epsh,
   doi: "10.20944/preprints202508.0179.v1",
   tit: "Resonance-Induced Tumor Ablation (RITA): a new alternative to oncological therapy",
   aut: "C. Mello, F. M. da Cunha",
   jou: "PP",
   yr : 2025
  },
  //{cat: stru,
  // cla: epsh,
  // url: "http://lemac1.dem.ist.utl.pt/engopt2010/Book_and_CD/Papers_CD_Final_Version/pdf/12/01122-01.pdf",
  // tit: "Finding the elastic coefficients of a damaged zone in a concrete dam using material optimization to fit measured modal parameters",
  // aut: "S. Oliveira et al.",
  // jou: "TR",
  // yr : 2010
  //},
  {cat: stru,
   cla: epsh,
   url: "http://cmaf.ptmat.fc.ul.pt/~pvieira/tese_mestrado_pvieira.pdf",
   tit: "An&aacute;lise de valores e vectores pr&oacute;prios aplicada ao estudo de barragens com fissura&ccedil;&atilde;o. Um problema inverso",
   aut: "P. Vieira",
   jou: "MS",
   yr : 2010
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1109/ICFCSA.2011.16",
   tit: "Parallel computing of large eigenvalue problems for engineering structures",
   aut: "X. Fan et al.",
   pro: "ICFCSA",
   yr : 2011
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.nonrwa.2012.05.003",
   tit: "Damage identification in a concrete dam by fitting measured modal parameters",
   aut: "S. Oliveira et al.",
   jou: "Nonlinear Analysis: Real World Applications",
   num: "13",
   pag: "2888-2899",
   yr : 2012
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s00158-011-0715-y",
   tit: "Minmax topology optimization",
   aut: "K. Brittain et al.",
   jou: "Struct. Multidisc. Optim.",
   num: "45(5)",
   pag: "657-668",
   yr : 2012
  },
  {cat: stru,
   cla: epsh,
   url: "http://urn.kb.se/resolve?urn=urn:nbn:se:kth:diva-99381",
   tit: "Development of a parallel finite-element tool for dynamic soil-structure interaction",
   aut: "M. Ullberg",
   jou: "MS",
   yr : 2012
  },
  {cat: stru,
   cla: epsh,
   url: "http://lib.dr.iastate.edu/etd/13206",
   tit: "Incorporating stochastic analysis in wind turbine design: data-driven random temporal-spatial parameterization and uncertainty quantication",
   aut: "Q. Guo",
   jou: "PD",
   yr : 2013
  },
  {cat: stru,
   cla: epsh,
   url: "http://hal-polytechnique.archives-ouvertes.fr/docs/00/90/33/60/PDF/13_these_sicsic.pdf",
   tit: "Mod&eacute;lisation et simulation de l'initiation et de la propagation de l'endommagement dans les mat&eacute;riaux quasi-fragiles: Apports de l'approche variationnelle",
   aut: "P. Sicsic",
   jou: "PD",
   yr : 2013
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1177/1045389X13502870",
   tit: "A free vibration analysis of piezo-electric beams via hierarchical one-dimensional finite elements",
   aut: "Y. Koutsawa et al.",
   jou: "J. Intel. Mat. Syst. Str.",
   num: "25(8)",
   pag: "1009-1023",
   yr : 2014
  },
  {cat: stru,
   cla: pep,
   doi: "10.1016/j.tws.2013.09.019",
   tit: "A generalized model for heterogeneous and anisotropic beams including section distortions",
   aut: "A. Genoese et al.",
   jou: "Thin Wall Struct.",
   num: "74",
   pag: "85-103",
   yr : 2014
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.jmps.2013.09.003",
   tit: "Initiation of a periodic array of cracks in the thermal shock problem: a gradient damage modeling",
   aut: "P. Sicsic et al.",
   jou: "J. Mech. Phys. Solids",
   num: "63",
   pag: "256-284",
   yr : 2014
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1016/j.tws.2014.08.012",
   tit: "Buckling analysis through a generalized beam model including section distortions",
   aut: "A. Genoese et al.",
   jou: "Thin Wall Struct.",
   num: "85",
   pag: "125-141",
   yr : 2014
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1155/2015/253569",
   tit: "Some progress on parallel modal and vibration analysis using the JAUMIN framework",
   aut: "Xuanhua Fan et al.",
   jou: "Mathematical Problems in Engineering",
   num: "v.2015",
   pag: "ID 253569",
   yr : 2015
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s00466-015-1129-2",
   tit: "Predicting band structure of 3D mechanical metamaterials with complex geometry via XFEM",
   aut: "Jifeng Zhao et al.",
   jou: "Comput. Mech.",
   num: "55(4)",
   pag: "659-672",
   yr : 2015
  },
  {cat: stru,
   cla: epsnh,
   url: "http://www.theses.fr/2015PA066136",
   tit: "Stability of a viscous curtain falling in a vertical open flow",
   aut: "C. Perdigou",
   jou: "PD",
   yr : 2015
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1016/j.jmps.2016.07.015",
   tit: "The viscous curtain: general formulation and finite-element solution for the stability of flowing viscous sheets",
   aut: "C. Perdigou and B. Audoly",
   jou: "J. Mech. Phys. Solids",
   num: "96",
   pag: "291-311",
   yr : 2016
  },
  {cat: stru,
   cla: pep,
   doi: "10.1016/j.jmps.2016.12.001",
   tit: "Elastic rods with incompatible strain: Macroscopic versus microscopic buckling",
   aut: "C. Lestringant and B. Audoly",
   jou: "J. Mech. Phys. Solids",
   num: "103",
   pag: "40-71",
   yr : 2017
  },
  {cat: stru,
   cla: epsnh,
   url: "http://arc.aiaa.org/doi/abs/10.2514/6.2017-1302",
   tit: "A nonlinear finite element analysis capability for the optimization of thermoelastic structures",
   aut: "D. J. Neiferd et al.",
   pro: "58th AIAA/ASCE/AHS/ASC Structures, Structural Dynamics, and Materials Conference",
   yr : 2017
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1142/S0219455417501036",
   tit: "Analytical and finite element buckling solutions of fixed-fixed anisotropic laminated composite columns under axial compression",
   aut: "R. Al-Masri and H. A. Rasheed",
   jou: "Int. J. Struc. Stab. Dyn",
   num: "17(9)",
   pag: "1750103",
   yr : 2017
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1007/978-3-319-54735-0_8",
   tit: "Empirically-derived, constitutive damping model for cellular silicone",
   aut: "J. B. Russ and B. R. Pacini",
   pro: "Society for Experimental Mechanics",
   yr : 2017
  },
  {cat: stru,
   cla: pep,
   doi: "10.1103/PhysRevLett.118.165501",
   tit: "Buckling of an elastic ridge: competition between wrinkles and creases",
   aut: "C. Lestringant et al.",
   jou: "Phys. Rev. Lett.",
   num: "118",
   pag: "165501",
   yr : 2017
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1051/epjconf/201714002003",
   tit: "Nonaffinity in amorphous solids close to the jamming transition",
   aut: "R. Ar&eacute;valo and M. Pica Ciamarra",
   pro: "Powders and Grains",
   yr : 2017
  },
  {cat: stru,
   cla: epsh,
   url: "http://leaders.4spe.org/spe/conferences/ANTEC2017/papers/245.pdf",
   tit: "Analytical and finite element buckling solutions of fixed-fixed anisotropic laminated composite wide plates under axial compression",
   aut: "R. Al-Masri and H. A. Rasheed",
   pro: "ANTEC",
   yr : 2017
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.engstruct.2017.08.015",
   tit: "Closed form stability solution of simply supported anisotropic laminated composite plates under axial compression compared with experiments",
   aut: "H. A. Rasheed et al.",
   jou: "Eng. Struct.",
   num: "151",
   pag: "327-336",
   yr : 2017
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.tws.2017.11.022",
   tit: "Buckling solutions of clamped-pinned anisotropic laminated composite columns under axial compression using bifurcation approach and finite elements",
   aut: "R. Al-Masri and H. A. Rasheed",
   jou: "Thin Wall Struct.",
   num: "123",
   pag: "206-213",
   yr : 2018
  },
  {cat: stru,
   cla: epsnh,
   url: "https://www.proquest.com/openview/aedf8e14a9b0fa6e93fbbc9f1745afb5",
   tit: "Analytical and finite element buckling solutions of anisotropic laminated composite columns/plates under axial compression with various boundary conditiones",
   aut: "R. A. Al-Masri",
   jou: "PD",
   yr : 2018
  },
  {cat: stru,
   cla: epsh,
   url: "https://www.gpps.global/documents/events/montreal18/papers/design-modeling/GPPS-NA-2018-0133.pdf",
   tit: "CAD-based adjoint multidisciplinary optimization of a radial turbine under structural constraints",
   aut: "M. Schwalbach et al.",
   pro: "Global Power and Propulsion Forum",
   yr : 2018
  },
  {cat: stru,
   cla: epsh,
   url: "https://lib.dr.iastate.edu/etd/16374",
   tit: "A framework for isogeometric-analysis-based design and optimization of wind turbine blades",
   aut: "A. Herrema",
   jou: "PD",
   yr : 2018
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s10853-018-2678-5",
   tit: "Compressional stability of optical fibres: a combined experimental and computer study",
   aut: "L. Capek et al.",
   jou: "J. Mater. Sci.",
   num: "53(21)",
   pag: "15157-15164",
   yr : 2018
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1177/1077546318771221",
   tit: "Free vibration analysis of coupled sloshing-flexible membrane system in a liquid container",
   aut: "A. Kolaei and S. Rakheja",
   jou: "J. Vib. Control",
   num: "25",
   pag: "84-97",
   yr : 2019
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.compstruct.2018.10.056",
   tit: "A two-level computational approach for the elasto-plastic analysis of framed structures with generic composite cross-sections",
   aut: "A. Bilotta and G. Garcea",
   jou: "Composite Struct.",
   num: "209",
   pag: "192-205",
   yr : 2019
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1002/we.2276",
   tit: "A framework for isogeometric-analysis-based optimization of wind turbine blade structures",
   aut: "A. J. Herrema et al.",
   jou: "Wind Energy",
   num: "22(2)",
   pag: "153-170",
   yr : 2019
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1088/1361-6439/ab4bad",
   tit: "Vibrational modes in MEMS resonators",
   aut: "D. Platz and U. Schmid",
   jou: "J. Micromech. Microeng.",
   num: "29",
   pag: "123001",
   yr : 2019
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1016/j.eml.2019.100584",
   tit: "An elastica robot: Tip-control in tendon-actuated elastic arms",
   aut: "P. Handral and R. Rangarajan",
   jou: "Extreme Mech. Lett.",
   num: "34",
   pag: "100584",
   yr : 2020
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s00466-020-01852-y",
   url: "https://web.me.iastate.edu/jmchsu/files/Johnson_Hsu-2020-CM.pdf",
   tit: "Isogeometric analysis of ice accretion on wind turbine blades",
   aut: "E. L. Johnson, M.-C. Hsu",
   jou: "Comput. Mech.",
   num: "66",
   pag: "311-322",
   yr : 2020
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.jmps.2020.104053",
   tit: "Revisiting the wrinkling of elastic bilayers II: Post-bifurcation analysis",
   aut: "H. Alawiye, P. E.Farrell, A. Goriely",
   jou: "J. Mech. Phys. Solids",
   num: "143",
   pag: "104053",
   yr : 2020
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s00158-020-02752-8",
   tit: "Multiscale optimisation of resonant frequencies for lattice-based additive manufactured structures",
   aut: "M. Nightingale, R. Hewson, M. Santer",
   jou: "Struct. Multidiscip. O.",
   num: "63",
   pag: "1187-1201",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.cma.2020.113478",
   tit: "A novel elastoplastic topology optimization formulation for enhanced failure resistance via local ductile failure constraints and linear buckling analysis",
   aut: "J. B. Russ, H. Waisman",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "373",
   pag: "113478",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1007/s10659-021-09815-x",
   url: "https://hal.archives-ouvertes.fr/hal-03103019",
   tit: "Gradient damage analysis of a cylinder under torsion: Bifurcation and size effects",
   aut: "T. Li, R. Abdelmoulai",
   jou: "J. Elasticity",
   num: "143",
   pag: "209-237",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   doi: "10.26204/KLUEDO/6277",
   tit: "An efficient CAD-based multidisciplinary optimization framework for turbomachinery design",
   aut: "M. Schwalbach",
   jou: "PD",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.jmps.2021.104415",
   arx: "2012.01359",
   tit: "3D architected isotropic materials with tunable stiffness and buckling strength",
   aut: "F. Wang, O. Sigmund",
   jou: "J. Mech. Phys. Solids",
   num: "152",
   pag: "104415",
   yr : 2021
  },
  {cat: stru,
   cla: epsnh,
   doi: "10.1016/j.jmps.2021.104424",
   url: "https://hal.archives-ouvertes.fr/hal-03106368",
   tit: "Numerical bifurcation and stability analysis of variational gradient-damage models for phase-field fracture",
   aut: "A. L. Baldelli, C. Maurini",
   jou: "J. Mech. Phys. Solids",
   num: "152",
   pag: "104424",
   yr : 2021
  },
  {cat: stru,
   cla: svd,
   url: "http://hdl.handle.net/10589/174183",
   tit: "A non-intrusive reduced order method based on Gaussian process and Bayesian optimization for hot rolling process",
   aut: "J. J. Sandoval",
   jou: "MS",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   arx: "2110.11690",
   tit: "Wide elastic wave bandgap metamaterial with single phase constituent",
   aut: "N. Kumar, S. Pal",
   yr : 2021
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1002/nme.6941",
   tit: "Mapped shape optimization method for rational design of cellular mechanical metamaterials under large deformation",
   aut: "T. Xue, S. Mao",
   jou: "Int. J. Numer. Meth. Eng.",
   num: "123",
   pag: "2357-2380",
   yr : 2022
  },
  {cat: stru,
   cla: epsh,
   url: "https://www.proquest.com/openview/dd8ebeaca781f9617a7ac3167125175e",
   tit: "Computational modeling and design of mechanical metamaterials: a machine learning approach",
   aut: "T. Xue",
   jou: "PD",
   yr : 2022
  },
  {cat: stru,
   cla: pep,
   doi: "10.1016/j.compstruc.2022.106811",
   tit: "Damping optimization of viscoelastic cantilever beams and plates under free vibration",
   aut: "A. Joubert, G. Allaire, S. Amstutz, J. Diani",
   jou: "Comput. Struct.",
   num: "268",
   pag: "106811",
   yr : 2022
  },
  {cat: stru,
   cla: nep,
   doi: "10.1016/j.compstruct.2022.115787",
   tit: "Thermal buckling loads of rectangular FG plates with temperature-dependent properties using Carrera Unified Formulation",
   aut: "M. Afzali, M. Farrokh, E. Carrera",
   jou: "Composite Struct.",
   num: "295",
   pag: "115787",
   yr : 2022
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.addma.2022.103012",
   tit: "Realization and assessment of metal additive manufacturing and topology optimization for high-precision motion systems",
   aut: "A. Delissen, E. Boots, D. Laro, H. Kleijnen, F. van Keulen, M. Langelaar",
   jou: "Additive Manufacturing",
   num: "58",
   pag: "103012",
   yr : 2022
  },
  {cat: stru,
   cla: epsh,
   arx: "2210.00003",
   doi: "10.1017/pma.2023.5",
   tit: "Architecting materials for extremal stiffness, yield and buckling strength",
   aut: "F. Wang, O. Sigmund",
   jou: "Programmable Materials",
   num: "1",
   pag: "e6",
   yr : 2023
  },
  {cat: stru,
   cla: pep,
   url: "https://hal.science/hal-04086548",
   doi: "10.1007/s00158-023-03602-z",
   tit: "Damping optimization of viscoelastic thin structures, application and analysis",
   aut: "A. Joubert, G. Allaire, S. Amstutz, J. Diani",
   jou: "Struct. Multidisc. Optim.",
   num: "66",
   pag: "149",
   yr : 2023
  },
  {cat: stru,
   cla: epsh,
   url: "https://www.proquest.com/openview/fd4df1fc65c194ef9004813faba52367",
   tit: "Problems in the dynamics of shells and time-optimal control: from abseiling spiders to singing saws",
   aut: "P. Bryde",
   jou: "PD",
   yr : 2023
  },
  {cat: stru,
   cla: epsh,
   url: "https://repositorio.ufu.br/handle/123456789/38793",
   tit: "Modelagem matem&aacute;tica e computacional de intera&ccedil;&atilde;o fluido-estrutura utilizando elementos s&oacute;lidos com aplica&ccedil;&atilde;o na ind&uacute;stria",
   aut: "F. A. Portillo Morales",
   jou: "PD",
   yr : 2023
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.tws.2023.111427",
   tit: "Efficient inverse-designed structural infill for complex engineering structures",
   aut: "P. D. L. Jensen, T. F. Olsen, J. A. B&aelig;rentzen, N. Aage, O. Sigmund",
   jou: "Thin Wall Struct.",
   num: "195",
   pag: "111427",
   yr : 2024
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1088/1402-4896/ad400b",
   tit: "Excitation of symmetry-protected vertical modes through arrays of coaxial sub-&lambda; apertures for THz applications",
   aut: "A. Dhibi et al.",
   jou: "Phys. Scr.",
   num: "99",
   pag: "065514",
   yr : 2024
  },
  {cat: stru,
   cla: epsh,
   arx: "2402.14336",
   doi: "10.1103/PhysRevE.110.025001",
   tit: "Vibrational lifetimes and viscoelastic properties of ultrastable glasses",
   aut: "J. Grie&beta;er, L. Pastewka",
   jou: "Phys. Rev. E",
   num: "110",
   pag: "025001",
   yr : 2024
  },
  {cat: stru,
   cla: epsnh,
   url: "https://hdl.handle.net/20.500.12733/17868",
   tit: "High-frequency vibroacoustic topology optimization considering natural frequency separation and sound insulation",
   aut: "H. Nigro Lopes",
   jou: "PD",
   yr : 2024
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1016/j.jmps.2024.105762",
   tit: "Rainbow trapping of out-of-plane mechanical waves in spatially variant beam lattices",
   aut: "B. Telgen, V. Kannan, J.-C. Bail, C. Dorn, H. Niese, D. M. Kochmann",
   jou: "J. Mech. Phys. Solids",
   num: "191",
   pag: "105762",
   yr : 2024
  },
  {cat: stru,
   cla: pep,
   url: "https://doi.org/10.26153/tsw/55917",
   tit: "Topology optimization of metamaterials for wave control",
   aut: "M. H. Khazi",
   jou: "MS",
   yr : 2024
  },
  {cat: stru,
   cla: epsh,
   doi: "10.1063/5.0249464",
   tit: "Engineering mechanical resonances of magnetoelectric transducers",
   aut: "J. F. Butscher, M. C. Gather",
   jou: "Appl. Phys. Lett.",
   num: "126",
   pag: "053503",
   yr : 2025
  },
  {cat: stru,
   cla: epsh,
   doi: "10.3390/fluids10030056",
   tit: "Linear stability analysis on flow-induced vibration of an elastically mounted rotating cylinder",
   aut: "J. Lu, Z. Zhang, X. Zhang",
   jou: "Fluids",
   num: "10(3)",
   pag: "56",
   yr : 2025
  },
  {cat: stru,
   cla: epsh,
   arx: "2501.17853",
   tit: "Enriched immersed finite element and isogeometric analysis - algorithms and data structures",
   aut: "N. Wunsch, K. Doble, M. R. Schmidt, L. No&euml;l, J. A. Evans, K. Maute",
   yr : 2025
  },
  {cat: stru,
   cla: epsh,
   url: "https://www.proquest.com/openview/6196a6a24109f42e13cf784c4ab944cc",
   tit: "An adaptive enriched immersogeometric analysis framework for multi-material problems",
   aut: "N. Wunsch",
   jou: "PD",
   yr : 2025
  },
  {cat: stru,
   cla: pep,
   doi: "10.1016/j.compstruc.2025.107865",
   tit: "Connectivity constraints for eigenvalue reduction in level-set topology optimization",
   aut: "G. Bonaccorsi, M. Pozzi, J. Hyun, H. A. Kim, F. Braghin",
   jou: "Comput. Struct.",
   num: "316",
   pag: "107865",
   yr : 2025
  },
  {cat: info,
   cla: svd,
   url: "http://trec.nist.gov/pubs/trec18/papers/arsc.WEB.pdf",
   tit: "Lucene for n-grams using the ClueWeb collection",
   aut: "G. B. Newby et al.",
   pro: "18th Text REtrieval Conference (TREC)",
   yr : 2009
  },
  {cat: info,
   cla: epsh,
   url: "http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.156.836&rep=rep1&type=pdf",
   tit: "Learning fuzzy rule based classifier in high performance computing environment",
   aut: "V. da F. Vieira et al.",
   pro: "IFSA",
   yr : 2009
  },
  {cat: info,
   cla: epsh,
   url: "https://circle.ubc.ca/handle/2429/30302",
   tit: "Solving correlation matrix completion problems using parallel differential evolution",
   aut: "S. K. Enaganti",
   jou: "MS",
   yr : 2010
  },
  {cat: info,
   cla: epsh,
   url: "http://etd.lib.metu.edu.tr/upload/12612233/index.pdf",
   tit: "Computation and analysis of spectra of large undirected networks",
   aut: "&Ouml;. Erdem",
   jou: "MS",
   yr : 2010
  },
  {cat: info,
   cla: svd,
   url: "http://www2.imm.dtu.dk/pubdb/views/edoc_download.php/6003/pdf/imm6003.pdf",
   doi: "10.1007/978-3-642-21227-7_10",
   tit: "On inferring image label information using rank minimization for supervised concept embedding",
   aut: "D. Bespalov et al.",
   pro: "SCIA",
   yr : 2011
  },
  {cat: info,
   cla: epsh,
   doi: "10.1109/ICDE.2011.5767925",
   tit: "Consensus spectral clustering in near-linear time",
   aut: "D. Luo et al.",
   pro: "ICDE",
   yr : 2011
  },
  {cat: info,
   cla: epsh,
   doi: "10.1109/SAINT.2011.24",
   tit: "A proposal for social search system design",
   aut: "T. Akiyama et al.",
   pro: "SAINT",
   yr : 2011
  },
  {cat: info,
   cla: epsh,
   doi: "10.1145/2063384.2063469",
   tit: "A scalable eigensolver for large scale-free graphs using 2D graph partitioning",
   aut: "A. Yoo et al.",
   pro: "SC'11",
   yr : 2011
  },
  {cat: info,
   cla: epsh,
   doi: "10.1109/HIBIT.2011.6450812",
   tit: "Computation of graph spectra of protein-protein interaction networks",
   aut: "B. Karas&ouml;zen and &Ouml;. Erdem",
   pro: "HIBIT",
   yr : 2011
  },
  {cat: info,
   cla: epsh,
   url: "http://www.cs.ubc.ca/~welu/woss2012/papers/3-shiraishi.pdf",
   tit: "Proposal of combination system of page-centric communication and search",
   aut: "Y. Shiraishi et al.",
   pro: "WOSS",
   yr : 2012
  },
  {cat: info,
   cla: epsh,
   doi: "10.1140/epjb/e2012-30122-3",
   tit: "Distributed flow optimization and cascading effects in weighted complex networks",
   aut: "A. Asztalos et al.",
   jou: "Eur. Phys. J. B",
   num: "85(8)",
   pag: "288",
   yr : 2012
  },
  {cat: info,
   cla: epsh,
   url: "http://ieee-hpec.org/2012/index_htm_files/Rutledge.pdf",
   tit: "Benchmarking parallel eigen decomposition for residuals analysis of very large graphs",
   aut: "E. M. Rutledge et al.",
   pro: "HPEC",
   yr : 2012
  },
  {cat: info,
   cla: epsh,
   doi: "10.1145/2536780.2536785",
   tit: "Towards effective clustering techniques for the analysis of electric power grids",
   aut: "E. Hogan et al.",
   pro: "HiPCNA-PG",
   yr : 2013
  },
  {cat: info,
   cla: epsh,
   doi: "10.1371/journal.pone.0084563",
   tit: "Cascading failures in spatially-embedded random networks",
   aut: "A. Asztalos et al.",
   jou: "PLoS ONE",
   num: "9(1)",
   pag: "e84563",
   yr : 2014
  },
  {cat: info,
   cla: epsh,
   url: "http://iwbbio.ugr.es/2014/papers/IWBBIO_2014_paper_108.pdf",
   tit: "Robust error correction for de novo assembly via spectral partitioning and sequence alignment",
   aut: "A. Alic et al.",
   pro: "IWBBIO",
   yr : 2014
  },
  {cat: info,
   cla: epsh,
   doi: "10.1371/journal.pone.0109987",
   tit: "Local neutral networks help maintain inaccurately replicating ribozymes",
   aut: "A. Szilagyi et al.",
   jou: "PLoS ONE",
   num: "9(10)",
   pag: "e109987",
   yr : 2014
  },
  {cat: info,
   cla: epsh,
   doi: "10.1155/2015/180214",
   tit: "Parallel framework for dimensionality reduction of large-scale datasets",
   aut: "S. K. Samudrala et al.",
   jou: "Scientific Programming",
   num: "v.2015",
   pag: "180214",
   yr : 2015
  },
  {cat: info,
   cla: svd,
   url: "https://hal.inria.fr/hal-01219316",
   tit: "High-performance parallel algorithms for the Tucker decomposition of higher order sparse tensors",
   aut: "O. Kaya and B. U&ccedil;ar",
   jou: "TR",
   yr : 2015
  },
  {cat: info,
   cla: svd,
   url: "http://www.researchgate.net/publication/282314408",
   tit: "Discovering aspectual classes of Russian verbs in untagged large corpora",
   aut: "A. Drozd et al.",
   pro: "DSDIS",
   yr : 2015
  },
  {cat: info,
   cla: svd,
   url: "https://hal.inria.fr/hal-01354894",
   doi: "https://doi.org/10.1109/ICPP.2016.19",
   tit: "High-performance parallel algorithms for the Tucker decomposition of sparse tensors",
   aut: "O. Kaya and B. U&ccedil;ar",
   pro: "ICPP",
   yr : 2016
  },
  {cat: info,
   cla: epsh,
   doi: "10.1038/s41598-017-11765-1",
   tit: "Limits of predictability of cascading overload failures in spatially-embedded networks with distributed flows",
   aut: "A. Moussawi et al.",
   jou: "Scientific Reports",
   num: "7",
   pag: "article 11729",
   yr : 2017
  },
  {cat: info,
   cla: svd,
   url: "https://tel.archives-ouvertes.fr/tel-01623549",
   tit: "High performance parallel algorithms for tensor decompositions",
   aut: "O. Kaya",
   jou: "PD",
   yr : 2017
  },
  {cat: info,
   cla: svd,
   arx: "1804.09494",
   doi: "10.1145/3205289.3205315",
   tit: "On optimizing distributed Tucker decomposition for sparse tensors",
   aut: "V. T. Chakaravarthy et al.",
   pro: "International Conference on Supercomputing",
   yr : 2018
  },
  {cat: info,
   cla: epsh,
   arx: "1805.10712",
   doi: "10.1145/3219819.3219991",
   pro: "KDD '18",
   tit: "NetLSD: Hearing the Shape of a Graph",
   aut: "A. Tsitsulin et al.",
   yr : 2018
  },
  {cat: info,
   cla: svd,
   doi: "10.1142/9789813275355_0011",
   tit: "Scalability and distribution of collaborative recommenders",
   aut: "E. Christakopoulou, S. Smith, M. Sharma, A. Richards, D. Anastasiu, G. Karypis",
   boo: "Collaborative Recommendations: Algorithms, Practical Challenges and Applications",
   pag: "369-404",
   yr : 2019
  },
  {cat: info,
   cla: svd,
   url: "http://hdl.handle.net/11299/206331",
   tit: "Active and adaptive techniques for learning over large-scale graphs",
   aut: "D. Bermperidis",
   jou: "PD",
   yr : 2019
  },
  {cat: info,
   cla: epsnh,
   url: "http://hdl.handle.net/2142/106155",
   tit: "Reduced-order modeling of non-Boltzmann thermochemistry and radiation for hypersonic flows",
   aut: "A. Sahai",
   jou: "PD",
   yr : 2019
  },
  {cat: info,
   cla: epsh,
   arx: "1910.07247",
   doi: "10.1109/ICMLA.2019.00182",
   tit: "A notion of harmonic clustering in simplicial complexes",
   aut: "S. Ebli and G. Spreemann",
   pro: "18th IEEE Int. Conf. Machine Learning and Appl.",
   yr : 2019
  },
  {cat: info,
   cla: epsh,
   url: "https://hdl.handle.net/11511/69212",
   tit: "Reevaluating spectral partitioning for unsymmetric matrices",
   aut: "E. Oktay",
   jou: "MS",
   yr : 2020
  },
  {cat: info,
   cla: svd,
   arx: "1811.10797",
   doi: "10.1109/TKDE.2019.2931542",
   tit: "Node embedding with adaptive similarities for scalable learning over graphs",
   aut: "D. Berberidis and G. B. Giannakis",
   jou: "IEEE T. Knowl. Data En.",
   num: "33(2)",
   pag: "637-650",
   yr : 2021
  },
  {cat: info,
   cla: epsh,
   doi: "10.1016/j.cad.2020.102948",
   tit: "Geometric stability classification: datasets, metamodels, and adversarial attacks",
   aut: "E. Lejeune",
   jou: "Computer-Aided Design",
   num: "131",
   pag: "102948",
   yr : 2021
  },
  {cat: info,
   cla: epsh,
   url: "http://hdl.handle.net/20.500.11811/9119",
   tit: "Similarities and representations of graph structures",
   aut: "A. Tsitsulin",
   jou: "PD",
   yr : 2021
  },
  {cat: info,
   cla: epsh,
   doi: "10.1007/978-3-030-71704-9_1",
   tit: "Phoenix: A Scalable Streaming Hypergraph Analysis Framework",
   aut: "K. Kurte, N. Imam, S. M. Shamimul Hasan, R. Kannan",
   boo: "Advances in Data Science and Information Engineering",
   pag: "3-25",
   yr : 2021
  },
  {cat: info,
   cla: epsh,
   arx: "2110.13115",
   doi: "10.1103/PhysRevD.105.103001",
   tit: "A hierarchical approach to matched filtering using a reduced basis",
   aut: "R. Dhurkunde, H. Fehrmann, A. H. Nitz",
   jou: "Phys. Rev. D",
   num: "105",
   pag: "103001",
   yr : 2022
  },
  {cat: info,
   cla: epsh,
   url: "https://www.vldb.org/pvldb/vol15/p3031-beer.pdf",
   doi: "10.14778/3551793.3551850",
   tit: "SCAR - Spectral Clustering Accelerated and Robustified",
   aut: "E. Hohma, C. M. M. Frey, A. Beer, T. Seidl",
   jou: "PVLDB",
   num: "15(11)",
   pag: "2031-3044",
   yr : 2022
  },
  {cat: info,
   cla: epsh,
   url: "https://www.proquest.com/openview/ce59312736a92acfe00f99c38c74cea5",
   tit: "Domain decomposed learning algorithms and applications",
   aut: "J. Li",
   jou: "PD",
   yr : 2023
  },
  {cat: info,
   cla: epsh,
   arx: "2309.08271",
   doi: "10.1007/s13278-023-01137-1",
   tit: "Greedy optimization of resistance-based graph robustness with global and local edge insertions",
   aut: "M. Predari, L. Berner, R. Kooji, H. Meyerhenke",
   jou: "Soc. Netw. Anal. Min.",
   num: "13",
   pag: "130",
   yr : 2023
  },
  {cat: info,
   cla: epsh,
   arx: "2310.12169",
   doi: "10.1109/ICMLA58977.2023.00341",
   tit: "Enhanced graph neural networks with ego-centric spectral subgraph embeddings augmentation",
   aut: "A. Said, M. Shabbir, T. Derr, W. Abbas, X. Koutsoukos",
   pro: "ICMLA",
   yr : 2023
  },
  {cat: info,
   cla: epsh,
   arx: "2305.12656",
   doi: "10.1016/j.jcp.2024.112928",
   tit: "Computing multi-eigenpairs of high-dimensional eigenvalue problems using tensor neural networks",
   aut: "Y. Wang, H. Xie",
   jou: "J. Comput. Phys.",
   num: "506",
   pag: "112928",
   yr : 2024
  },
  {cat: info,
   cla: epsh,
   doi: "10.1016/j.engappai.2023.107324",
   tit: "&Delta;-PINNs: Physics-informed neural networks on complex geometries",
   aut: "F. Sahli Costabal, S. Pezzuto, P. Perdikaris",
   jou: "Eng. Appl. Artif. Intel.",
   num: "127(B)",
   pag: "107324",
   yr : 2024
  },
  {cat: info,
   cla: epsh,
   arx: "2404.16554",
   doi: "10.1016/j.cam.2024.116275",
   tit: "Generalized Multiscale Finite Element Method for discrete network (graph) models",
   aut: "M. Vasilyeva",
   jou: "J. Comput. Appl. Math.",
   num: "457",
   pag: "116275",
   yr : 2025
  },
  {cat: info,
   cla: svd,
   arx: "2502.17622",
   tit: "A priori generalizability estimate for a CNN",
   aut: "C. Balsells, B. Riviere, D. Fuentes",
   yr : 2025
  },
  {cat: info,
   cla: svd,
   url: "https://hdl.handle.net/1911/118493",
   tit: "An SVD guided active learning approach for medical image segmentation",
   aut: "A. Balsells",
   jou: "PD",
   yr : 2025
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1109/TVCG.2009.119",
   tit: "Applying manifold learning to plotting approximate contour trees",
   aut: "S. Takahashi et al.",
   jou: "IEEE T. Vis. Comput. Gr.",
   num: "15(6)",
   pag: "1185-1192",
   yr : 2010
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1007/978-3-642-15711-0_63",
   tit: "Heat kernel smoothing using Laplace-Beltrami eigenfunctions",
   aut: "Seongho Seo et al.",
   jou: "Lec. Notes Comput. Sci.",
   num: "6363",
   pag: "505-512",
   yr : 2010
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1109/SIBGRAPI.2010.23",
   tit: "Tuning manifold harmonics filters",
   aut: "T. Lewiner et al.",
   pro: "SIBGRAPI",
   yr : 2011
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1007/s00371-011-0617-4",
   tit: "Stereo music visualization through manifold harmonics",
   aut: "T. Lewiner et al.",
   jou: "Vis. Comput.",
   num: "27(10)",
   pag: "905-916",
   yr : 2011
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1016/j.cag.2012.03.027",
   tit: "Spectral computations on nontrivial line bundles",
   aut: "A. Vais et al.",
   jou: "Comput. Graph.",
   num: "36(5)",
   pag: "398-409",
   yr : 2012
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1007/s00371-012-0737-5",
   tit: "Complex line bundle Laplacians",
   aut: "A. Vais et al.",
   jou: "Vis. Comput.",
   num: "29(5)",
   pag: "345-357",
   yr : 2013
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1016/j.cag.2013.05.013",
   tit: "Laplacians on flat line bundles over 3-manifolds",
   aut: "A. Vais et al.",
   jou: "Comput. Graph.",
   num: "37(6)",
   pag: "718-729",
   yr : 2013
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1007/s00371-014-1038-y",
   tit: "Subimage sensitive eigenvalue spectra for image comparison",
   aut: "B. Berger et al.",
   jou: "Vis. Comput.",
   num: "31(2)",
   pag: "205-221",
   yr : 2015
  },
  {cat: visu,
   cla: epsh,
   doi: "10.1111/cgf.12912",
   tit: "Critical points of Gaussian-distributed scalar fields on simplicial grids",
   aut: "T. Liebmann and G. Scheuermann",
   jou: "Comput. Graph. Forum",
   num: "35(3)",
   pag: "361-370",
   yr : 2016
  },
  {cat: visu,
   cla: epsh,
   url: "http://www.nada.kth.se/~ann/exjobb/david_wobrock.pdf",
   tit: "Image processing using graph Laplacian operator",
   aut: "D. Wobrock",
   jou: "MS",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1145/1236463.1236464",
   tit: "SIPs: Shift-and-invert parallel spectral transformations",
   aut: "H. Zhang et al.",
   jou: "ACM Trans. Math. Softw.",
   num: "33(2)",
   pag: "Article No. 9",
   yr : 2007
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jmaa.2007.12.036",
   tit: "Spectrum of a non-self-adjoint operator associated with the periodic heat equation",
   aut: "M. Chugunova et al.",
   jou: "J. Math. Anal. Appl.",
   num: "342(2)",
   pag: "970-988",
   yr : 2008
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/978-3-540-92859-1_30",
   tit: "Parallel eigensolvers for a discretized radiative transfer problem",
   aut: "P. B. Vasconcelos et al.",
   jou: "Lec. Notes Comput. Sci.",
   num: "5336",
   pag: "336-348",
   yr : 2008
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1137/090747087",
   tit: "Optimal partitions for eigenvalues",
   aut: "B. Bourdin et al.",
   jou: "SIAM J. Sci. Comp.",
   num: "31(6)",
   pag: "4100-4114",
   yr : 2009
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s10092-009-0009-6",
   tit: "Stability of Lagrange elements for the mixed Laplacian",
   aut: "D. N. Arnold and M. E. Rognes",
   jou: "Calcolo",
   num: "46(4)",
   pag: "245-260",
   yr : 2009
  },
  {cat: pde,
   cla: epsh,
   url: "https://www.ima.umn.edu/~arnold/papers/RognesThesis.pdf",
   tit: "Mixed finite element methods with applications to viscoelasticity and gels",
   aut: "M. E. Rognes",
   jou: "PD",
   yr : 2009
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1145/1462173.1462174",
   tit: "A standard and software for numerical metadata",
   aut: "V. Eijkhout and E. Fuentes",
   jou: "ACM Trans. Math. Soft.",
   num: "35(4)",
   pag: "Article No. 25",
   yr : 2009
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/978-3-642-20671-9_89",
   tit: "3D benchmark on discretization schemes for anisotropic diffusion problems on general grids",
   aut: "R. Eymard et al.",
   jou: "Proceedings in Math.",
   num: "4",
   pag: "895-930",
   yr : 2011
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.jcp.2011.03.036",
   tit: "A priori mesh quality metric error analysis applied to a high-order finite element method",
   aut: "W. Lowrie et al.",
   jou: "J. Comput. Phys.",
   num: "230(14)",
   pag: "5564-5586",
   yr : 2011
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1137/100817528",
   tit: "Compact and stable Discontinuous Galerkin methods for convection-diffusion problems",
   aut: "S. Brdar et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "34(1)",
   pag: "A263-A282",
   yr : 2012
  },
  {cat: pde,
   cla: svd,
   doi: "10.1016/j.advengsoft.2012.07.005",
   tit: "Efficient parallel implementation of the fully algebraic multiplicative Aitken-RAS preconditioning technique",
   aut: "T. Dufaud and D. Tromeur-Dervout",
   jou: "Adv. Eng. Softw.",
   num: "53",
   pag: "33-44",
   yr : 2012
  },
  {cat: pde,
   cla: svd,
   url: "https://core.ac.uk/download/pdf/144786574.pdf",
   tit: "FETI coarse problem parallelization strategies and their comparison",
   aut: "T. Kozubek et al.",
   jou: "TR",
   yr : 2012
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1051/proc/201238024",
   tit: "Feel++: a computational framework for Galerkin methods and advanced numerical methods",
   aut: "C. Prud'homme et al.",
   jou: "ESAIM: Proceedings",
   num: "38",
   pag: "429-455",
   yr : 2012
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.enganabound.2013.08.018",
   tit: "Solving an eigenvalue problem on a periodic domain using a radial basis function finite difference scheme",
   aut: "N. S. O'Brien et al.",
   jou: "Eng. Anal. Bound. Elem.",
   num: "37(12)",
   pag: "1594-1601",
   yr : 2013
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1051/proc/201343015",
   tit: "A reduced basis framework: application to large scale non-linear multi-physics problems",
   aut: "C. Daversin et al.",
   jou: "ESAIM: Proceedings",
   num: "43",
   pag: "225-254",
   yr : 2013
  },
  //{cat: pde,
  // url: "http://dolfin-adjoint.org/_static/soa.pdf",
  // tit: "Exploiting high-level structure in algorithmic differentiation",
  // aut: "P. E. Farrell and S. W. Funke",
  // jou: "PP",
  // yr : 2013
  //},
  {cat: pde,
   cla: epsnh,
   url: "http://faraday1.ucd.ie/archive/papers/vancouver.pdf",
   tit: "A python-based software tool for power system analysis",
   aut: "F. Milano",
   pro: "IEEE PES",
   yr : 2013
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/978-3-319-05789-7_28",
   tit: "Overlapping domain decomposition methods with FreeFem++",
   aut: "P. Jolivet et al.",
   jou: "Domain Decomposition Methods in Science and Engineering XXI",
   num: "Part II",
   pag: "315-322",
   yr : 2014
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s00211-014-0610-8",
   tit: "Approximation of the Laplace and Stokes operators with Dirichlet boundary conditions through volume penalization: a spectral viewpoint",
   aut: "R. Nguyen van yen et al.",
   jou: "Numer. Math.",
   num: "128(2)",
   pag: "301-338",
   yr : 2014
  },
  {cat: pde,
   cla: epsh,
   doi: "10.3934/cpaa.2014.13.2115",
   tit: "On the nodal set of the eigenfunctions of the Laplace-Beltrami operator for bounded surfaces in R<sup>3</sup>: a computational approach",
   aut: "A. Bonito and R. Glowinski",
   jou: "Comm. Pure Appl. Anal.",
   num: "13(5)",
   pag: "2115-2126",
   yr : 2014
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1186/2213-7467-1-3",
   tit: "A port-reduced static condensation reduced basis element method for large component-synthesized structures: approximation and a posteriori error estimation",
   aut: "J. L. Eftang and A. T. Patera",
   jou: "Advanced Modeling and Simulation in Engineering Sciences",
   num: "1",
   pag: "3",
   yr : 2014
  },
  {cat: pde,
   cla: svd,
   doi: "10.1137/120900745",
   tit: "A framework for the automation of generalized stability theory",
   aut: "P. E. Farrell et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "36(1)",
   pag: "C25-C48",
   yr : 2014
  },
  {cat: pde,
   cla: epsh,
   arx: "1411.4283",
   tit: "A higher-order finite-volume discretization method for Poisson's equation in cut cell geometries",
   aut: "D. Devendran et al.",
   yr : 2014
  },
  {cat: pde,
   cla: epsh,
   url: "https://tel.archives-ouvertes.fr/tel-01079415/",
   tit: "Un framework de calcul pour la m&eacute;thode des bases r&eacute;duites: applications &agrave; des probl&egrave;mes non-lin&eacute;aires multi-physiques",
   aut: "S. Veys",
   jou: "PD",
   yr : 2014
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1186/s40323-015-0021-0",
   tit: "Component-based reduced basis for parametrized symmetric eigenproblems",
   aut: "S. Vallagh&eacute; et al.",
   jou: "Adv. Mod. Simulation Eng. Sciences",
   num: "2",
   pag: "7",
   yr : 2015
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.cma.2014.09.020",
   tit: "A new certification framework for the port reduced static condensation reduced basis element method",
   aut: "K. Smetana",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "283",
   pag: "352-383",
   yr : 2015
  },
  {cat: pde,
   cla: svd,
   doi: "10.1016/j.jcp.2015.11.004",
   tit: "Fully-implicit orthogonal reconstructed discontinuous Galerkin method for fluid dynamics with phase change",
   aut: "R. Nourgaliev et al.",
   jou: "J. Comput. Phys.",
   num: "305",
   pag: "964-996",
   yr : 2016
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1137/15M1052822",
   arx: "1605.07198",
   tit: "Preconditioners for saddle point systems with trace constraints coupling 2D and 1D domains",
   aut: "M. Kuchta et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "38(6)",
   pag: "B962-B987",
   yr : 2016
  },
  {cat: pde,
   cla: epsnh,
   url: "http://hdl.handle.net/2429/57700",
   tit: "Stability analysis and stabilization of unstructured finite volume method",
   aut: "L. Chen",
   jou: "PD",
   yr : 2016
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1515/rnam-2017-0009",
   arx: "1601.06368",
   tit: "Splitting schemes with respect to physical processes for double-porosity poroelasticity problems",
   aut: "A. E. Kolesov and P. N. Vabishchevich",
   jou: "Rus. J. Numer. Anal. M.",
   num: "32(2)",
   pag: "99-114",
   yr : 2017
  },
  {cat: pde,
   cla: nep,
   doi: "10.1016/j.camwa.2017.07.020",
   tit: "On spurious solutions in finite element approximations of resonances in open systems",
   aut: "J. C. Araujo-Cabarcas and C. Engstr&ouml;m",
   jou: "Comput. Math. Appl.",
   num: "74(10)",
   pag: "2385-2402",
   yr : 2017
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1002/nme.5300",
   tit: "Linear and nonlinear solvers for variational phase-field models of brittle fracture",
   aut: "P. E. Farrell and C. Maurini",
   jou: "Int. J. Numer. Meth. Eng.",
   num: "109(5)",
   pag: "648-667",
   yr : 2017
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/s11227-016-1892-7",
   tit: "On the improvement of a scalable sparse direct solver for unsymmetrical linear equations",
   aut: "M. S. Celebi et al.",
   jou: "J. Supercomput.",
   num: "73(5)",
   pag: "1852-1904",
   yr : 2017
  },
  {cat: pde,
   cla: epsh,
   doi: "10.2140/camcos.2017.12.51",
   tit: "A fourth-order Cartesian grid embedded boundary method for Poisson's equation",
   aut: "D. Devendran et al.",
   jou: "Comm. Appl. Math. Comput. Sci.",
   num: "12(1)",
   pag: "51-79",
   yr : 2017
  },
  {cat: pde,
   cla: epsnh,
   url: "http://www.diss.fu-berlin.de/diss/receive/FUDISS_thesis_000000104723",
   tit: "Hodge-type decompositions for piecewise constant vector fields on simplicial surfaces and solids with boundary",
   aut: "K. Poelke",
   jou: "PD",
   yr : 2017
  },
  //{cat: pde,
  // cla: epsnh,
  // arx: "1706.09179",
  // tit: "Randomized local model order reduction",
  // aut: "A. Buhr and K. Smetana",
  // yr : 2017
  //},
  {cat: pde,
   cla: epsh,
   doi: "10.1142/S1793524518500535",
   arx: "1604.05653",
   tit: "Parameter identification through mode isolation for reaction-diffusion systems on arbitrary geometries",
   aut: "L. Murphy et al.",
   jou: "Int. J. Biomath.",
   num: "11(4)",
   pag: "1850053",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   arx: "1705.07010",
   doi: "10.1002/num.22292",
   tit: "Fundamental mode exact schemes for unsteady problems",
   aut: "P. N. Vabishchevich",
   jou: "Numer. Methods Partial Differential Eq.",
   num: "34(6)",
   pag: "2301-2315",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   arx: "1704.03851",
   doi: "10.1515/cmam-2017-0028",
   tit: "Numerical solution of time-dependent problems with fractional power elliptic operator",
   aut: "P. N. Vabishchevich",
   jou: "Comput. Meth. Appl. Math.",
   num: "18",
   pag: "111-128",
   yr : 2018
  },
  {cat: pde,
   cla: epsnh,
   arx: "1711.07031",
   doi: "10.1016/j.jcp.2018.02.044",
   tit: "Two-level schemes for the advection equation",
   aut: "P. N. Vabishchevich",
   jou: "J. Comput. Phys.",
   num: "363",
   pag: "158-177",
   yr : 2018
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1553/etna_vol49s1",
   tit: "Adaptive FETI-DP and BDDC methods with a generalized transformation of basis for heterogeneous problems",
   aut: "A. Klawonn et al.",
   jou: "Elec. Trans. Numer. Anal.",
   num: "49",
   pag: "1-27",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   url: "http://kups.ub.uni-koeln.de/id/eprint/8234",
   tit: "Adaptive FETI-DP and BDDC methods for highly heterogeneous elliptic finite element problems in three dimensions",
   aut: "M. J. K&uuml;hn",
   jou: "PD",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   arx: "1801.03453",
   doi: "10.1103/PhysRevE.97.052105",
   tit: "Ordering statistics of four random walkers on the line",
   aut: "B. Helenbrook and D. ben-Avraham",
   jou: "Phys. Rev. E",
   num: "97",
   pag: "052105",
   yr : 2018
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.enganabound.2018.08.001",
   tit: "On the stability of direct time-domain boundary element methods for elastodynamics",
   aut: "X. Bai and R. Y. S. Pak",
   jou: "Eng. Anal. Bound. Elem.",
   num: "96",
   pag: "138-149",
   yr : 2018
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1137/17M1145823",
   tit: "A preconditioned finite element solution of the coupled pressure-temperature equations used to model trace gas sensors",
   aut: "A. Safin et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "40(5)",
   pag: "B1470-B1493",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   url: "https://doi.org/10.17863/CAM.25213",
   tit: "Uncertainty quantification of engineering systems using the multilevel Monte Carlo method",
   aut: "H. J. T. Unwin",
   jou: "PD",
   yr : 2018
  },
  {cat: pde,
   cla: svd,
   arx: "1810.01361",
   tit: "Validation of a PETSc based software implementing a 4DVAR Data Assimilation algorithm: a case study related with an Oceanic Model based on Shallow Water equation",
   aut: "L. Carracciuolo et al.",
   yr : 2018
  },
  {cat: pde,
   cla: epsh,
   url: "http://hdl.handle.net/10084/130303",
   tit: "Implementation of the deflated variants of the conjugate gradient method",
   aut: "J. Kru&zcaron;&iacute;k",
   jou: "MS",
   yr : 2018
  },
  {cat: pde,
   cla: epsnh,
   arx: "1808.05513",
   doi: "10.1145/3361745",
   tit: "Code generation for generally mapped finite elements",
   aut: "R. Kirby and L. Mitchell",
   jou: "ACM Trans. Math. Softw.",
   num: "45(4)",
   pag: "Article No. 41",
   yr : 2019
  },
  {cat: pde,
   cla: epsnh,
   arx: "1810.09010",
   doi: "10.1142/S0218202519500295",
   tit: "Regularity and hp discontinuous Galerkin finite element approximation of linear elliptic eigenvalue problems with singular potentials",
   aut: "Y. Maday and C. Marcati",
   jou: "Math. Models Methods Appl. Sci.",
   num: "29(8)",
   pag: "1585-1617",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   arx: "1711.04888",
   doi: "10.1137/17M1156721",
   tit: "Computing spectra without solving eigenvalue problems",
   aut: "D. Arnold et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "41(1)",
   pag: "B69-B92",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.cma.2018.08.038",
   tit: "Penalty coupling of non-matching isogeometric Kirchhoff-Love shell patches with application to composite wind turbine blades",
   aut: "A. J. Herrema et al.",
   jou: "Comput. Methods Appl. M.",
   num: "346",
   pag: "81-840",
   yr : 2019
  },
  {cat: pde,
   cla: svd,
   doi: "10.1016/j.cma.2018.09.009",
   arx: "1803.08741",
   tit: "Multimesh finite element methods: solving PDEs on multiple intersecting meshes",
   aut: "A. Johansson et al.",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "343",
   pag: "672-689",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   arx: "1812.11216",
   doi: "10.1002/nme.6165",
   tit: "An energy-stable mixed formulation for isogeometric analysis of incompressible hyperelastodynamics",
   aut: "J. Liu, A. L. Marsden, Z. Tao",
   jou: "Int. J. Numer. Meth. Engrg.",
   num: "120(8)",
   pag: "937-963",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   doi: "10.18452/20141",
   tit: "Topics in least-squares and discontinuous Petrov-Galerkin finite element analysis",
   aut: "J. Storn",
   jou: "PD",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1137/18M1209465",
   tit: "Automated calculation of higher order partial differential equation constrained derivative information",
   aut: "J. R. Maddison, D. N. Goldberg, B. D. Goddard",
   jou: "SIAM J. Sci. Comput.",
   num: "41(5)",
   pag: "C417-C445",
   yr : 2019
  },
  {cat: pde,
   cla: epsnh,
   url: "https://tel.archives-ouvertes.fr/tel-02167604",
   tit: "Modal analysis of structures in time-periodic elastic state",
   aut: "B. J. Bentvelsen",
   jou: "PD",
   yr : 2019
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jcp.2019.06.021",
   tit: "Multi-rate time integration on overset meshes",
   aut: "C. Mikida, A. Kl&ouml;ckner, D. Bodony",
   jou: "J. Comput. Phys.",
   num: "396",
   pag: "325-346",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   arx: "1906.10061",
   tit: "Isoperimetric relations between Dirichlet and Neumann eigenvalues",
   aut: "G. Cox, S. MacLachlan, L. Steeves",
   yr : 2019
  },
  {cat: pde,
   cla: epsh,
   url: "http://nbn-resolving.de/urn:nbn:de:bsz:352-2-2zoi8n9sxknm1",
   tit: "POD-based state-constrained economic model predictive control for convection-diffusion phenomena",
   aut: "L. Mechelli",
   jou: "PD",
   yr : 2019
  },
  {cat: pde,
   cla: epsnh,
   url: "https://tel.archives-ouvertes.fr/tel-02446813",
   tit: "Contribution to the emergence of new intelligent parallel and distributed methods using a multi-level programming paradigm for extreme computing",
   aut: "X. Wu",
   jou: "PD",
   yr : 2019
  },
  {cat: pde,
   cla: epsnh,
   url: "https://hal.inria.fr/hal-02419543",
   doi: "10.1007/s10915-020-01313-x",
   tit: "High-order locally A-stable implicit schemes for linear ODEs",
   aut: "H. Barucq, M. Durufle, M. N'Diaye",
   jou: "J. Sci. Comput.",
   num: "85",
   pag: "31",
   yr : 2020
  },
  {cat: pde,
   cla: epsh,
   arx: "1911.11906",
   doi: "10.1145/3392717.3392769",
   tit: "A scalable framework for solving fractional diffusion equations",
   aut: "M. Carlson, R. M. Kirby, H. Sundar",
   pro: "34th ACM ICS",
   yr : 2020
  },
  {cat: pde,
   cla: epsnh,
   url: "http://kups.ub.uni-koeln.de/id/eprint/9368",
   doi: "10.1002/nme.6237",
   tit: "Parallel adaptive FETI-DP using lightweight asynchronous dynamic load balancing",
   aut: "A. Klawonn, M. J. K&uuml;hn, O. Rheinbach",
   jou: "Int. J. Numer. Meth. Engrg.",
   num: "121(4)",
   pag: "621-643",
   yr : 2020
  },
  {cat: pde,
   cla: nep,
   arx: "1902.05059",
   doi: "10.1016/j.jcp.2019.109220",
   tit: "Computation of scattering resonances in absorptive and dispersive media with applications to metal-dielectric nano-structures",
   aut: "J. C. Araujo C., C. Campos, C. Engstr&ouml;m, J. E. Roman",
   jou: "J. Comput. Phys.",
   num: "407",
   pag: "109220",
   yr : 2020
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.parco.2020.102608",
   tit: "Comparison of selected FETI coarse space projector implementation strategies",
   aut: "J. Kruzik, D. Horak, V. Hapla, M. Cermak",
   jou: "Parallel Comput.",
   num: "93",
   pag: "102608",
   yr : 2020
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s42514-020-00029-6",
   tit: "A parallel generalized conjugate gradient method for large scale eigenvalue problems",
   aut: "Y. Li, H. Xie, R. Xu, C. You, N. Zhang",
   jou: "CCF Trans. HPC",
   num: "2",
   pag: "111-122",
   yr : 2020
  },
  {cat: pde,
   cla: epsnh,
   arx: "2001.05527",
   tit: "Robust preconditioning of monolithically coupled multiphysics problems",
   aut: "K. E. Holter, M. Kuchta, K.-A. Mardal",
   yr : 2020
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.17863/CAM.66257",
   tit: "Multigrid methods for complex engineering geometries and unstructured meshes",
   aut: "Y. Chen",
   jou: "PD",
   yr : 2020
  },
  {cat: pde,
   cla: epsnh,
   arx: "2001.05529",
   doi: "10.1016/j.camwa.2020.08.021",
   tit: "Robust preconditioning for coupled Stokes-Darcy problems with the Darcy problem in primal form",
   aut: "K. E. Holter, M. Kuchta, K.-A. Mardal",
   jou: "Comput. Math. Appl.",
   num: "91",
   pag: "53-66",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   arx: "2006.02952",
   doi: "10.1007/s13160-020-00449-5",
   tit: "Explicit a posteriori and a priori error estimation for the finite element solution of Stokes equations",
   aut: "X. Liu, M. Nakao, C. You, S. Oishi",
   jou: "Japan J. Indust. Appl. Math.",
   num: "38",
   pag: "545-559",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.cma.2021.113723",
   url: "http://hdl.handle.net/10993/36557",
   tit: "A hyper-reduction method using adaptivity to cut the assembly costs of reduced order models",
   aut: "J. S. Hale, E. Schenone, D. Baroli, L. A. A. Beex, S. P. A. Bordas",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "380",
   pag: "113723",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.cma.2021.113823",
   arx: "2009.08167",
   tit: "Refined isogeometric analysis for generalized Hermitian eigenproblems",
   aut: "A. Hashemian, D. Pardo, V. M. Calo",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "381",
   pag: "113823",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.cpc.2020.107695",
   tit: "An open-source parallel code for computing the spectral fractional Laplacian on 3D complex geometry domains",
   aut: "M. Carlson, X. Zheng, H. Sundar, G. E. Karniadakis, R. M. Kirby",
   jou: "Comput. Phys. Commun.",
   num: "261",
   pag: "107695",
   yr : 2021
  },
  {cat: pde,
   cla: nep,
   arx: "1904.08812",
   doi: "10.1016/j.jcp.2020.110024",
   tit: "On spurious solutions encountered in Helmholtz scattering resonance computations in R<sup>d</sup> with applications to nano-photonics and acoustics",
   aut: "J. C. Araujo C. and C. Engstr&ouml;m",
   jou: "J. Comput. Phys.",
   num: "429",
   pag: "110024",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/978-3-030-61157-6_6",
   tit: "Iterative Solvers for EMI Models",
   aut: "M. Kuchta and K.-A. Mardal",
   boo: "Modeling Excitable Tissue",
   pag: "70-86",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   arx: "1810.01028",
   doi: "10.1007/s10013-020-00465-5",
   tit: "Approximation of probability density functions for PDEs with random parameters using truncated series expansions",
   aut: "G. Capodaglio, M. Gunzburger, H. P. Wynn",
   jou: "Vietnam J. Math.",
   num: "49",
   pag: "685-711",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.camwa.2020.12.013",
   tit: "Least-squares formulations for eigenvalue problems associated with linear elasticity",
   aut: "R. Bertrand, D. Boffi",
   jou: "Comput. Math. Appl.",
   num: "95",
   pag: "19-27",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jcp.2021.110403",
   tit: "Adjoint-based sensitivity analysis of periodic orbits by the Fourier-Galerkin method",
   aut: "J. Sierra, P. Jolivet, F. Giannetti, V. Citro",
   jou: "J. Comput. Phys.",
   num: "440",
   pag: "110403",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   url: "http://urn.nb.no/URN:NBN:no-88697",
   tit: "Robust preconditioning of multiphysics problems and interstitial fluid flow",
   aut: "K. E. Holter",
   jou: "PD",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   arx: "2012.02678",
   doi: "10.1016/j.camwa.2021.07.011",
   tit: "A comparison of coarse spaces for Helmholtz problems in the high frequency regime",
   aut: "N. Bootland, V. Dolean, P. Jolivet, P.-H. Tournier",
   jou: "Comput. Math. Appl.",
   num: "98",
   pag: "239-253",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   arx: "2101.02116",
   doi: "10.1137/21M1399658",
   tit: "Eigenvalues of the truncated Helmholtz solution operator under strong trapping",
   aut: "J. Galkowski, P. Marchand, E. A. Spence",
   jou: "SIAM J. Math. Anal.",
   num: "53(6)",
   pag: "6724-6770",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s10836-021-05945-1",
   tit: "Fault tolerant Lanczos eigensolver via an invariant checking method",
   aut: "F. Loh, K. K. Saluja, P. Ramanathan",
   jou: "J. Electron. Test.",
   num: "37",
   pag: "409-422",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1103/PhysRevLett.126.177801",
   tit: "Structural landscapes in geometrically frustrated smectics",
   aut: "J. Xia, S. MacLachlan, T. J. Atherton, P. E. Farrell",
   jou: "Phys. Rev. Lett.",
   num: "126",
   pag: "177801",
   yr : 2021
  },
  {cat: pde,
   cla: epsnh,
   trx: "13553705",
   tit: "General technique for estimating number of groups for spectral clustering",
   aut: "M. Pecha",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   arx: "2106.10913",
   tit: "Fully algebraic domain decomposition preconditioners with adaptive spectral bounds",
   aut: "L. Gouarin, N. Spillane",
   yr : 2021
  },
  {cat: pde,
   cla: epsh,
   url: "https://www.unige.ch/~gander/Preprints/dd26NonSym.pdf",
   doi: "10.1007/978-3-030-95025-5_64",
   tit: "Coarse corrections for Schwarz methods for symmetric and non-symmetric problems",
   aut: "M. J. Gander, S. Van Criekingen",
   pro: "DD26",
   yr : 2021
  },
  {cat: pde,
   cla: svd,
   arx: "2109.06017",
   doi: "10.1007/s00020-022-02715-2",
   tit: "High-frequency estimates on boundary integral operators for the Helmholtz exterior Neumann problem",
   aut: "J. Galkowski, P. Marchand, E. A. Spence",
   jou: "Integr. Equ. Oper. Theory",
   num: "94",
   pag: "36",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   arx: "2106.05218",
   doi: "10.1007/s00211-022-01318-8",
   tit: "Convergence of parallel overlapping domain decomposition methods for the Helmholtz equation",
   aut: "S. Gong, M. J. Gander, I. G. Graham, D. Lafontaine, E. A. Spence",
   jou: "Numer. Math.",
   num: "152",
   pag: "259-306",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   arx: "2110.07486",
   doi: "10.1137/21M1452974",
   tit: "Robust monolithic solvers for the Stokes-Darcy problem with the Darcy equation in primal form",
   aut: "W. M. Boon, T. Koch, M. Kuchta, K.-A. Mardal",
   jou: "SIAM J. Sci. Comput.",
   num: "44(4)",
   pag: "B1148--B1174",
   yr : 2022
  },
  {cat: pde,
   cla: pep,
   arx: "2112.14064",
   doi: "10.1016/j.cma.2022.115327",
   tit: "Refined isogeometric analysis of quadratic eigenvalue problems",
   aut: "A. Hashemian, D. Garcia, D. Pardo, V. M. Calo",
   jou: "Comput. Meth. Appl. Mech. Eng.",
   num: "399",
   pag: "115327",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   arx: "2110.14523",
   doi: "10.1016/j.jcp.2022.111377",
   tit: "Solving eigenvalue PDEs of metastable diffusion processes using artificial neural networks",
   aut: "W. Zhang, T. Li, C. Sch&uuml;tte",
   jou: "J. Comput. Phys.",
   num: "465",
   pag: "111377",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2107.09006",
   doi: "10.1137/21M1434891",
   tit: "A robust algebraic domain decomposition preconditioner for sparse normal equations",
   aut: "H. Al Daas, P. Jolivet, J. Scott",
   jou: "SIAM J. Sci. Comput.",
   num: "44(3)",
   pag: "A1047-A1068",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2109.05908",
   doi: "10.1137/21M1446320",
   tit: "A robust algebraic multilevel domain decomposition preconditioner for sparse symmetric positive definite matrices",
   aut: "H. Al Daas, P. Jolivet",
   jou: "SIAM J. Sci. Comput.",
   num: "44(4)",
   pag: "A2582-A2598",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2102.10576",
   doi: "10.1103/PhysRevE.105.055106",
   tit: "Bifurcation analysis of two-dimensional Rayleigh-B&eacute;nard convection using deflation",
   aut: "N. Boull&eacute;, V. Dallas, P. E. Farrell",
   jou: "Phys. Rev. E",
   num: "105",
   pag: "055106",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1093/imanum/drab005",
   tit: "First order least-squares formulations for eigenvalue problems",
   aut: "R. Bertrand, D. Boffi",
   jou: "IMA J. Numer. Anal.",
   num: "42(2)",
   pag: "1339-1363",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2104.12986",
   doi: "10.1145/3490485",
   tit: "Bringing trimmed serendipity methods to computational practice in Firedrake",
   aut: "J. Crum, C. Cheng, D. A. Ham, L. Mitchell, R. C. Kirby, J. A. Levine, A. Gillette",
   jou: "ACM Trans. Math. Softw.",
   num: "48(1)",
   pag: "Article No. 8",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   arx: "2101.05577",
   url: "https://www.routledge.com/Deterministic-and-Stochastic-Optimal-Control-and-Inverse-Problems/Jadamba-Khan-Migorski-Sama/p/book/9780367506308",
   tit: "All-at-once formulation meets the Bayesian approach: A study of two prototypical linear inverse problems",
   aut: "A. Schlintl, B. Kaltenbacher",
   boo: "Deterministic and Stochastic Optimal Control and Inverse Problems",
   pag: "1-44",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2105.14884",
   doi: "10.1137/21M1418708",
   tit: "Control of bifurcation structures using shape optimization",
   aut: "N. Boull&eacute;, P. E. Farrell, A. Paganini",
   jou: "SIAM J. Sci. Comput.",
   num: "44(1)",
   pag: "A57-A76",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jcp.2022.110965",
   tit: "An assessment of implicit-explicit time integrators for the pseudo-spectral approximation of Boussinesq thermal convection in an annulus",
   aut: "V. Gopinath, A. Fournier, T. Gastine",
   jou: "J. Comput. Phys.",
   num: "460",
   pag: "110965",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.cma.2022.114807",
   tit: "Concurrent multiscale analysis without meshing: Microscale representation with CutFEM and micro/macro model blending",
   aut: "E. Mikaeili, S. Claus, P.Kerfriden",
   jou: "Comput. Meth. Appl. Mech. Eng.",
   num: "393",
   pag: "114807",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/s10444-022-09947-1",
   tit: "Optimal control for a coupled spin-polarized current and magnetization system",
   aut: "X. An, A. K. Majee, A. Prohl, T. Tran",
   jou: "Adv. Comput. Math.",
   num: "48",
   pag: "Art. 28",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   url: "http://hdl.handle.net/10150/663799",
   tit: "Implementing and testing exterior calculus discretization techniques for PDEs",
   aut: "J. Crum",
   jou: "PD",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.25781/KAUST-W5351",
   tit: "A priori error analysis for a penalty finite element Method",
   aut: "U. Zerbinati",
   jou: "MS",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2201.06800",
   tit: "Numerical solution of the div-curl problem by finite element exterior calculus",
   aut: "P. Azerad, M.-L. Hanot",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   url: "http://imar.ro/journals/Mathematical_Reports/Pdfs/2022/1-2/11.pdf",
   tit: "Long-time behavior of a coupled heat-wave system using a structure-preserving finite element method",
   aut: "G. Haine, D. Matignon, F. Monteghetti",
   jou: "Math. Reports",
   num: "24(74)",
   pag: "187-215",
   yr : 2022
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.camwa.2022.07.001",
   tit: "Virtual element method on polyhedral meshes for bi-harmonic eigenvalues problems",
   aut: "F. Dassi, I. Vel&aacute;squez",
   jou: "Comput. &amp; Math. Appl.",
   num: "121",
   pag: "85-101",
   yr : 2022
  },
  {cat: pde,
   cla: svd,
   doi: "10.1016/j.jqsrt.2022.108345",
   tit: "Proper orthogonal decomposition based reduced-order modeling of flux-limited gray thermal radiation",
   aut: "A. L. Alberti, T. S. Palmer, C. J. Palmer",
   jou: "J. Quant. Spectrosc. Ra.",
   num: "292",
   pag: "108345",
   yr : 2022
  },
  {cat: pde,
   cla: svd,
   doi: "10.1002/nla.2469",
   tit: "On the evaluation of general sparse hybrid linear solvers",
   aut: "A. Farea, M. Serdar &Ccedil;elebi",
   jou: "Numer. Linear Alg. Appl.",
   num: "30(2)",
   pag: "e2469",
   yr : 2022
  },
  {cat: pde,
   cla: epsnh,
   arx: "2211.15025",
   doi: "10.1007/978-3-031-50769-4_42",
   tit: "FETI-DP algorithms for 2D Biot model with discontinuous galerkin discretization",
   aut: "P. Lee",
   pro: "Domain Decomposition Methods in Science and Engineering XXVII",
   pag: "351-358",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2201.11684",
   doi: "10.1137/22M1474448",
   tit: "Optimization of Hopf bifurcation points",
   aut: "N. Boull&eacute;, P. E. Farrell, M. E. Rognes",
   jou: "SIAM J. Sci. Comput.",
   num: "45(3)",
   pag: "B390-B411",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   arx: "2010.07179",
   doi: "10.1103/PhysRevD.107.074501",
   tit: "Spectral analysis of causal dynamical triangulations via finite element method",
   aut: "F. Caceffo, G. Clemente",
   jou: "Phys. Rev. D",
   num: "107",
   pag: "074501",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   arx: "2103.11379",
   doi: "10.1007/978-3-030-95025-5_30",
   tit: "A variational interpretation of Restricted Additive Schwarz with impedance transmission condition for the Helmholtz problem",
   aut: "S. Gong, M. J. Gander, I. G. Graham, E. A. Spence",
   pro: "Domain Decomposition Methods in Science and Engineering XXVI",
   pag: "291-298",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   arx: "2107.03159",
   doi: "10.1051/cocv/2022090",
   tit: "Phase-field methods for spectral shape and topology optimization",
   aut: "H. Garcke, P. H&uuml;ttl, C. Kahle, P. Knopf, T. Laux",
   jou: "ESAIM Control Optim. Calc. Var.",
   num: "29",
   pag: "Paper No. 10",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1002/nme.7100",
   tit: "Hierarchical subspace evolution method for super large parallel computing: a linear solver and an eigensolver as examples",
   aut: "H. Xu, B. Liu",
   jou: "Int. J. Numer. Meth. Engrg.",
   num: "124(1)",
   pag: "5-39",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   arx: "2008.07691",
   doi: "10.1007/s10915-022-02089-y",
   tit: "A nonnested augmented subspace method for elliptic eigenvalue problems with curved interfaces",
   aut: "H. Dang, H. Xie, G. Zhao, C. Zhou",
   jou: "J. Sci. Comput.",
   num: "94",
   pag: "Article 34",
   yr : 2023
  },
  {cat: pde,
   cla: svd,
   arx: "2301.06108",
   doi: "10.1016/j.cma.2023.116109",
   tit: "Stabilized cut discontinuous Galerkin methods for advection-reaction problems on surfaces",
   aut: "T. B. Ulfsby, A. Massing, S. Sticko",
   jou: "Comp. Meth. Appl. Mech. Eng.",
   num: "413",
   pag: "116109",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   arx: "2303.17999",
   doi: "10.1051/m2an/2024060",
   tit: "The modelling error in multi-dimensional time-dependent solute transport models",
   aut: "R. Masri, M. Zeinhofer, M. Kuchta, M. E. Rognes",
   jou: "ESAIM-Math. Model. Numer. Anal.",
   num: "58(5)",
   pag: "1681-1724",
   yr : 2024
  },
  {cat: pde,
   cla: pep,
   doi: "10.1016/j.ijheatmasstransfer.2023.124177",
   tit: "Stability of natural convection in a heated vertical corner",
   aut: "S. M. Edwards, R. E. Hewitt",
   jou: "Int. J. Heat Mass Tran.",
   num: "210",
   pag: "124177",
   yr : 2023
  },
  {cat: pde,
   cla: mfn,
   url: "http://www.theses.fr/2023ESAE0013",
   tit: "M&eacute;thodologies permettant l'obtention efficace de solutions multi-physiques stationnaires pour des applications en &eacute;nerg&eacute;tique",
   aut: "P. Seize",
   jou: "PD",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   url: "http://www.researchgate.net/publication/369982105",
   doi: "https://doi.org/10.1016/j.enganabound.2023.07.043",
   tit: "Edge smoothed finite element for multiscale homogenization",
   aut: "P. Heny&scaron;, G. Pokatilov",
   jou: "Eng. Anal. Bound. Elem.",
   num: "156",
   pag: "70-77",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/978-3-031-50769-4_27",
   url: "https://www.unige.ch/~gander/Preprints/volume-6.pdf",
   tit: "Spectral Q1-based coarse spaces for Schwarz methods",
   aut: "M. J. Gander, S. Van Criekingen",
   pro: "Domain Decomposition Methods in Science and Engineering XXVII",
   pag: "231-238",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2305.08996",
   doi: "10.1016/j.camwa.2023.08.010",
   tit: "Approximation of the Maxwell eigenvalue problem in a least-squares setting",
   aut: "R. Bertrand, D. Boffi, L. Gastaldi",
   jou: "Comput. Math. Appl.",
   num: "148",
   pag: "302-312",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   url: "https://epub.uni-regensburg.de/54582",
   tit: "Phase-field methods for spectral shape and topology optimization",
   aut: "P. H&uuml;ttl",
   jou: "PD",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1137/22M1469833",
   tit: "Efficient algebraic two-level Schwarz preconditioner for sparse matrices",
   aut: "H. Al Daas, P. Jolivet, T. Rees",
   jou: "SIAM J. Sci. Comput.",
   num: "45(3)",
   pag: "A1199-A1213",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/978-3-031-36942-1_15",
   tit: "Advanced IGA Mesh Generation and Application to Structural Vibrations",
   aut: "E. Wobbes, Y. Bazilevs, T. Kuraishi, Y. Otoguro, K. Takizawa, T. E. Tezduyar",
   boo: "Frontiers in Computational Fluid-Structure Interaction and Flow Simulation",
   pag: "513-531",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   arx: "1704.00560",
   doi: "10.1007/s00021-023-00789-5",
   tit: "Numerical investigations of non-uniqueness for the Navier-Stokes initial value problem in borderline spaces",
   aut: "J. Guillod and V. &Scaron;ver&aacute;k",
   jou: "J. Math. Fluid Mech.",
   num: "25",
   pag: "46",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1137/22M1532019",
   tit: "A fourth-order embedded boundary finite volume method for the unsteady Stokes equations with complex geometries",
   aut: "N. Overton-Katz, X. Gao, S. Guzik, O. Antepara, D. T. Graves, H. Johansen",
   jou: "SIAM J. Sci. Comput.",
   num: "45(5)",
   pag: "A2409-A2430",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   url: "https://hal.science/hal-04297658",
   tit: "Semi-orthogonal functions for the internal approximation of null-controls and a heat source inverse problem",
   aut: "A. Osses, F. Urrutia",
   jou: "TR",
   yr : 2023
  },
  {cat: pde,
   cla: epsh,
   arx: "2312.11801",
   tit: "Fast, scalable, warm-start semidefinite programming with spectral bundling and sketching",
   aut: "R. Angell, A. McCallum",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/s10915-022-02090-5",
   tit: "Enhanced error estimates for augmented subspace method",
   aut: "Z. Guan, Y. Wang, H. Xie, C. Zhou",
   jou: "J. Sci. Comput.",
   num: "94",
   pag: "40",
   yr : 2023
  },
  {cat: pde,
   cla: epsnh,
   arx: "2306.15563",
   doi: "10.1016/j.physd.2023.134019",
   tit: "The radial hedgehog solution in the Landau-de Gennes theory: effects of the bulk potentials",
   aut: "S. McLauchlan, Y. Han, M. Langer, A. Majumdar",
   jou: "Physica D",
   num: "459",
   pag: "134019",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2203.16409",
   doi: "10.5802/jep.250",
   tit: "On the polygonal Faber-Krahn inequality",
   aut: "B. Bogosel, D. Bucur",
   jou: "J. Ecole Pol. Math.",
   num: "11",
   pag: "19-105",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2304.02477",
   doi: "10.1007/s00245-023-10093-3",
   tit: "Sharp-interface limit of a multi-phase spectral shape optimization problem for elastic structures",
   aut: "H. Garcke, P. H&uuml;ttl, C. Kahle, P. Knopf",
   jou: "Appl. Math. Optim.",
   num: "89",
   pag: "24",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s00466-023-02432-6",
   tit: "Complex-geometry IGA mesh generation: application to structural vibrations",
   aut: "E. Wobbes, Y. Bazilevs, T. Kuraishi, Y. Otoguro, K. Takizawa, T. E. Tezduyar",
   jou: "Comput. Mech.",
   num: "74",
   pag: "247-261",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.21105/joss.05846",
   tit: "FeenoX: a cloud-first finite-element(ish) computational engineering tool",
   aut: "J. Theler",
   jou: "J. Open Source Soft.",
   num: "9(95)",
   pag: "5846",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jcp.2024.113306",
   tit: "Bifurcation tracking on moving meshes and with consideration of azimuthal symmetry breaking instabilities",
   aut: "C. Diddens, D. Rocha",
   jou: "J. Comput. Phys.",
   num: "518",
   pag: "113306",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1016/j.jcp.2024.113421",
   tit: "Adaptive-stabilized finite element methods for eigenvalue problems based on residual minimization onto a dual discontinuous Galerkin norm",
   aut: "P. Behnoudfar, A. Hashemian, Q. Deng, V. M. Calo",
   jou: "J. Comput. Phys.",
   num: "519",
   pag: "113421",
   yr : 2024
  },
  {cat: pde,
   cla: mfn,
   arx: "2401.06684",
   tit: "Polynomial preconditioning for the action of the matrix square root and inverse square root",
   aut: "A. Frommer, G. Ramirez-Hidalgo, M. Schweitzer, M. Tsolakis",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2401.17739",
   url: "http://jmlr.org/papers/v25/24-0162.html",
   tit: "Operator learning without the adjoint",
   aut: "N. Boull&eacute;, D. Halikias, S. E. Otto, A. Townsend",
   jou: "J. Mach. Learning. Res.",
   num: "25",
   pag: "1-54",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2402.06905",
   tit: "A novel coarse space applying to the weighted Schwarz method for Helmholtz equations",
   aut: "Q. Hu, Z. Li",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2402.12947",
   tit: "Multigrid on unstructured meshes with regions of low quality cells",
   aut: "Y. Chen, G. N. Wells",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2403.19356",
   doi: "10.1137/23M1558987",
   tit: "A robust two-level overlapping preconditioner for Darcy flow in high-contrast media",
   aut: "C. Ye, S. Fu, E. T. Chung, J. Huang",
   jou: "SIAM J. Sci. Comput.",
   num: "46(5)",
   pag: "A3151-A3176",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2404.08356",
   tit: "Variational solvers for irreversible evolutionary systems",
   aut: "A. A. L. Baldelli, P. Cesana",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2405.00399",
   tit: "Enhanced error estimates for augmented subspace method with Crouzeix-Raviart element",
   aut: "Z. Guan, Y. Wang, H. Xie, C. Zhou",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   url: "http://hdl.handle.net/10754/698872",
   tit: "Non-standard finite elements for eigenvalue problems",
   aut: "P. Alzaben",
   jou: "PD",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2407.18230",
   tit: "Stability analysis of periodic orbits in nonlinear dynamical systems using Chebyshev polynomials",
   aut: "A. Gesla, Y. Duguet, P. Le Qu&eacute;r&eacute;, L. M. Witkowski",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   arx: "2409.17314",
   tit: "A mixed finite element method for the velocity-pseudostress formulation of the Oseen eigenvalue problem",
   aut: "F. Lepe, G. Rivera, J. Vellojin",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2409.17388",
   tit: "A semi-analytic diagonalization FEM for the spectral fractional Laplacian",
   aut: "A. J. Salgado, S. E. Sawyer",
   yr : 2024
  },
  {cat: pde,
   cla: epsnh,
   url: "http://hdl.handle.net/10871/137562",
   tit: "Using nonlinear interactions to quantify and improve timestepping accuracy in the Rotating Shallow Water Equations",
   aut: "T. Andrews",
   jou: "PD",
   yr : 2024
  },
  {cat: pde,
   cla: svd,
   url: "http://resolver.tudelft.nl/uuid:f4cd2a81-70d9-4ed6-a761-26d6ac00fe45",
   tit: "The application of Algebraic Multigrid-based linear solvers for performance enhancement of geomechanical simulators",
   aut: "A. Glasbeek",
   jou: "MS",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2410.06850",
   tit: "A robust solver for large-scale heat transfer topology optimization",
   aut: "Y. Zhou, C. Ye, Y. Liu, S. Fu, E. T. Chung",
   yr : 2024
  },
  {cat: pde,
   cla: epsh,
   arx: "2401.03915",
   doi: "10.1137/24M1629882",
   tit: "A robust algebraic two-level Schwarz preconditioner for sparse matrices",
   aut: "H. Al Daas, P. Jolivet, F. Nataf, P.-H. Tournier",
   jou: "SIAM J. Sci. Comput.",
   num: "47(4)",
   pag: "A2378-A2402",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2401.04485",
   doi: "10.1142/S0218202525500071",
   tit: "On the stabilization of a virtual element method for an acoustic vibration problem",
   aut: "L. Alzaben, D. Boffi, A. Dedner, L. Gastaldi",
   jou: "Math. Mod. Meth. Appl. S.",
   num: "35",
   pag: "655-701",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/s11075-024-01839-3",
   tit: "Nystr&ouml;m discretization of integrodifference equations: numerical continuation of periodic solutions and Floquet multipliers",
   aut: "C. P&ouml;tzsche, D. Rackl",
   jou: "Numer. Alg.",
   num: "98",
   pag: "1429-1465",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2307.14688",
   doi: "10.1007/s10596-025-10339-9",
   tit: "Theoretical results on a block preconditioner used in ice-sheet modeling: eigenvalue bounds for singular power-law fluids",
   aut: "C. Helanow, J. Ahlkrona",
   jou: "Comput. Geosci.",
   num: "29",
   pag: "9",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2403.19342",
   doi: "10.1016/j.jcp.2024.113603",
   tit: "A highly parallelized multiscale preconditioner for Darcy flow in high-contrast media",
   aut: "C. Ye, S. Fu, E. T. Chung, J. Huang",
   jou: "J. Comput. Phys.",
   num: "522",
   pag: "113603",
   yr : 2025
  },
  {cat: pde,
   cla: svd,
   arx: "2311.02039",
   doi: "10.1016/j.matcom.2024.10.003",
   tit: "Analysis and comparison of high-performance computing solvers for minimisation problems in signal processing",
   aut: "S. Cammarasana, G. Patan&egrave;",
   jou: "Math. Comput. Simulat.",
   num: "229",
   pag: "525-538",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1016/j.camwa.2025.01.035",
   tit: "Nonconforming virtual element method for the Schr&ouml;dinger eigenvalue problem",
   aut: "D. Adak, G. Manzini, J. Vellojin",
   jou: "Comput. Math. Appl.",
   num: "182",
   pag: "213-235",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1137/24M1669669",
   tit: "Asynchronous semi-iterative methods and the asynchronous Chebyshev method with multigrid preconditioning",
   aut: "J Wolfson-Pou, E Chow",
   jou: "SIAM J. Sci. Comput.",
   num: "IP",
   pag: "S23-S49",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2503.11386",
   doi: "10.1016/j.cam.2025.116651",
   tit: "Adaptive regularisation for PDE-constrained optimal control",
   aut: "J. Power, T. Pryer",
   jou: "J. Comput. Appl. Math.",
   num: "470",
   pag: "116651",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   arx: "2503.19261",
   tit: "Parameter-robust preconditioner for Stokes-Darcy coupled problem with Lagrange multiplier",
   aut: "X. Hu, M. Kuchta, K.-A. Mardal, X. Wang",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   arx: "2504.03074",
   tit: "An optimal O(N) Helmholtz solver for complex geometry using WaveHoltz and overset grids",
   aut: "D. Appelo, J. W. Banksb, W. D. Henshawb, D. W. Schwendeman",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   url: "https://hdl.handle.net/20.500.14394/55975",
   tit: "Fast, scalable, warm-start semidefinite programming with application to knowledge editing and mixed integer semidefinite optimization",
   aut: "R. Angell",
   jou: "PD",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1137/24M1637994",
   tit: "A hybrid two-level weighted Schwarz method for Helmholtz equations",
   aut: "Q. Hu, Z. Li",
   jou: "SIAM J. Numer. Anal.",
   num: "63",
   pag: "2",
   yr : 2025
  },
  {cat: pde,
   cla: svd,
   arx: "2504.17101",
   tit: "MOOSE ProbML: parallelized probabilistic machine learning and uncertainty quantification for computational energy applications",
   aut: "S. L. N. Dhulipala, P. German, Y. Che, Z. M. Prince, X. Xie, P.-C. A. Simon, V. M. Laboure, H. Yan",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2504.21150",
   tit: "On feedback stabilisation for the Cahn-Hilliard equation and its numerical approximation",
   aut: "H. Egger, M. Fritz, K. Kunisch, S. S. Rodrigues",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   arx: "2505.06141",
   tit: "Fast recovery of parametric eigenvalues depending on several parameters and location of high order exceptional points",
   aut: "B. Nenniga, M. Ghiennea, E. Perrey-Debain",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   url: "http://dr.iiserpune.ac.in:8080/jspui/bitstream/123456789/8777/1/20191014_Sriram_V_MS_Thesis.pdf",
   tit: "Shape optimization problems on polygons",
   aut: "V. Sriram",
   jou: "MS",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2506.02429",
   tit: "Rust implementation of finite element exterior calculus on coordinate-free simplicial complexes",
   aut: "L. Wirth",
   jou: "MS",
   yr : 2025
  },
  {cat: pde,
   cla: mfn,
   arx: "2506.03617",
   tit: "MatExPre: A matrix exponential preconditioner for the high-frequency Helmholtz equation",
   aut: "S. Fu, Q. H. Liu, Q. Zhan, E. T. Chung, C. Ye",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2507.06846",
   tit: "A posteriori error estimates for a C<sup>1</sup> virtual element method applied to the thin plate vibration problem",
   aut: "F. Dassia, A. E. Rubiano, I. Velasquez",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   doi: "10.1007/s11075-025-02166-x",
   tit: "GenEO spectral coarse spaces in SPD domain decomposition",
   aut: "N. Spillane",
   jou: "Numer. Alg.",
   num: "IP",
   pag: "",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   doi: "10.1007/s10915-025-02993-z",
   tit: "Stokes-Brinkman-Type formulation for the eigenvalue problem in porous media",
   aut: "F. Lepe, G. Rivera, J. A: Vellojin",
   jou: "J. Sci. Comput.",
   num: "104",
   pag: "84",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2509.02131",
   tit: "Achieving wavenumber robustness in domain decomposition for heterogeneous Helmholtz equation: an overview of spectral coarse spaces",
   aut: "V. Dolean, M. Fry, M. Langer, E. Parolin, P.-H. Tournier",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   arx: "2508.21607",
   tit: "Approximate calculation of multidimensional first passage times",
   aut: "J. F. Lutsko",
   yr : 2025
  },
  {cat: pde,
   cla: epsnh,
   arx: "2509.18429",
   tit: "ff-bifbox: A scalable, open-source toolbox for bifurcation analysis of nonlinear PDEs",
   aut: "C. M. Douglas, P. Jolivet",
   yr : 2025
  },
  {cat: pde,
   cla: svd,
   arx: "2509.22846",
   tit: "Accelerating high-fidelity fixed point schemes with on-the-fly Reduced Order Modeling",
   aut: "P.-A. Luneau, J. Deteix",
   yr : 2025
  },
  {cat: pde,
   cla: epsh,
   arx: "2501.18305",
   doi: "10.1016/j.cam.2025.117015",
   tit: "A hybrid two-level weighted Schwartz method for time-harmonic Maxwell equations",
   aut: "Z. Li, Q. Hu",
   jou: "J. Comput. Appl. Math.",
   num: "475",
   pag: "117015",
   yr : 2026
  },
  {cat: pde,
   cla: epsh,
   arx: "2510.24590",
   tit: "On a robust inf-sup condition for the Stokes problem in slender domains - with application to preconditioning",
   aut: "E. Sande, T. Koch, M. Kuchta, K.-A. Mardal",
   yr : 2025
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1007/978-3-540-72584-8_133",
   tit: "Hessian-based model reduction for large-scale data assimilation problems",
   aut: "O. Bashir et al.",
   jou: "Lec. Notes Comput. Sci.",
   num: "4487",
   pag: "1010-1017",
   yr : 2007
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1002/nme.2100",
   tit: "Hessian-based model reduction for large-scale systems with initial-condition inputs",
   aut: "O. Bashir et al.",
   jou: "Int. J. Numer. Meth. Engrg.",
   num: "73(6)",
   pag: "844-868",
   yr : 2007
  },
  {cat: dyn,
   cla: epsh,
   url: "https://ecommons.cornell.edu/handle/1813/11195",
   tit: "Computational techniques for uncertainty modeling and stochastic optimization of material systems",
   aut: "S. Sankaran",
   jou: "PD",
   yr : 2008
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1016/j.probengmech.2008.11.002",
   tit: "Stochastic optimization using a sparse grid collocation scheme",
   aut: "S. Sankaran",
   jou: "Probabilist. Eng. Mech.",
   num: "24(3)",
   pag: "382-396",
   yr : 2009
  },
  {cat: dyn,
   cla: epsnh,
   url: "http://padas.ices.utexas.edu/static/papers/par2d.pdf",
   tit: "Fast algorithms for inverse problems with parabolic PDE constraints",
   aut: "S. Adavani and G. Biros",
   jou: "PP",
   yr : 2010
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1137/090780717",
   tit: "Fast algorithms for Bayesian uncertainty quantification in large-scale linear inverse problems based on low-rank partial Hessian approximations",
   aut: "H. P. Flath et al.",
   jou: "SIAM J. Sci. Comput.",
   num: "33(1)",
   pag: "407-432",
   yr : 2011
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1016/j.ijengsci.2013.05.001",
   tit: "Reconstruction of the residual stresses in a hyperelastic body using ultrasound techniques",
   aut: "S. Joshi and J. R. Walton",
   jou: "Intl. J. Eng. Sci.",
   num: "70",
   pag: "46-72",
   yr : 2013
  },
  {cat: dyn,
   cla: epsh,
   url: "http://repositories.lib.utexas.edu/handle/2152/21157",
   tit: "Hessian-based response surface approximations for uncertainty quantification in large-scale statistical inverse problems, with applications to groundwater flow",
   aut: "H. P. Flath",
   jou: "PD",
   yr : 2013
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1109/TMTT.2015.2473157",
   tit: "Estimating the inf-sup constant in reduced basis methods for time-harmonic Maxwell's equations",
   aut: "M. Hess et al.",
   jou: "IEEE T. Microw. Theory",
   num: "63(11)",
   pag: "3549-3557",
   yr : 2015
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1016/j.proeng.2016.05.161",
   tit: "Reduced order models in analysis of stochastically parametered linear dynamical systems",
   aut: "H. P. Lal et al.",
   jou: "Procedia Engineering",
   num: "144",
   pag: "1325-1331",
   yr : 2016
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1016/j.ifacol.2018.03.055",
   tit: "Modeling and motion planning for an artificial fishtail",
   aut: "D. Siebelts et al.",
   jou: "IFAC-PapersOnLine",
   num: "51(2)",
   pag: "319-324",
   yr : 2018
  },
  {cat: dyn,
   cla: svd,
   doi: "10.1007/978-3-319-93701-4_25",
   tit: "CT medical imaging reconstruction using direct algebraic methods with few projections",
   aut: "M. Chillar&oacute;n et al.",
   pro: "ICCS",
   yr : 2018
  },
  {cat: dyn,
   cla: epsh,
   url: "http://kops.uni-konstanz.de/handle/123456789/40437",
   doi: "10.1007/978-3-030-01959-4_4",
   tit: "POD-based economic optimal control of heat-convection phenomena",
   aut: "L. Mechelli and S. Volkwein",
   boo: "Numerical Methods for Optimal Control Problems",
   pag: "63-87",
   yr : 2019
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1190/geo2021-0702.1",
   tit: "3D finite-difference and finite-element frequency-domain wave simulation with multilevel optimized additive Schwarz domain-decomposition preconditioner: A tool for full-waveform inversion of sparse node data sets",
   aut: "P.-H. Tournier, P. Jolivet, V. Dolean, H. S. Aghamiry, S. Operto, S. Riffo",
   jou: "Geophysics",
   num: "87(5)",
   pag: "1-84",
   yr : 2022
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1016/j.ifacol.2022.11.089",
   tit: "Explicit structure-preserving discretization of port-Hamiltonian systems with mixed boundary control",
   aut: "A. Brugnoli, G. Haine, D. Matignon",
   jou: "IFAC-PapersOnLine",
   num: "55(30)",
   pag: "418-423",
   yr : 2022
  },
  {cat: dyn,
   cla: epsnh,
   doi: "10.1016/j.ifacol.2022.11.090",
   tit: "Structure-preserving discretization of Maxwell's equations as a port-Hamiltonian system",
   aut: "G. Haine, D. Matignon, F. Monteghetti",
   jou: "IFAC-PapersOnLine",
   num: "55(30)",
   pag: "424-429",
   yr : 2022
  },
  {cat: dyn,
   cla: svd,
   doi: "10.1016/j.ast.2023.108412",
   tit: "Accelerating unsteady aerodynamic simulations using predictive reduced-order modeling",
   aut: "Z. Li, P. He",
   jou: "Aerospace Sci. Tech.",
   num: "139",
   pag: "108412",
   yr : 2023
  },
  {cat: dyn,
   cla: epsh,
   doi: "10.1016/j.jsv.2023.117862",
   tit: "Preserving transfer-behavior in model order reduction for thermoacoustic stability analysis",
   aut: "N. Purwar, W. Polifke",
   jou: "J. Sound Vib.",
   num: "565",
   pag: "117862",
   yr : 2023
  }
];

