//                     usage.cc

#include "main.ih"

// Vervallend:
//        --totalrisk (-T) path   - path name of the file containing the
//                                  cumulative total risk percentages (default:
//                                  '<base>/totalrisk-$.txt', use ! to
//                                  suppress)
//        --id-base (-i) nr       - Use the IDPoool, starting with value 'nr'
//                                  (specify 0 to use the std. RandomPool,
//                                  1 is used by default)
//

//        --test (-t) specs       - run one simulation using the following
//                                  comma-separated values:
//                                      natural death age, tumor start age, 
//                                      tumor self-detect age, tumor death-age,
//                                      screening testresult: 
//                                        0: incorrect (false positive/negative)
//                                        1: correct test
//                                  Use tumor start age 0 to indicate no tumor

namespace {
char const info[] = R"_( [options] analyses
Where:
        [options] - optional arguments (short options between parentheses):
        --base (-B) dirname     - base directory (by default './', below
                                  referred to as '<base>/')
        --cancer (-c) type      - cancer type to simulate. 'type' can be
                                    breast (default): breast cancer simulation
                                    female: female lung cancer simulation
                                    male: male lung cancer simulation
        --config (-C) path      - path name to the config file (by default
                                  '~/.config/simrisc')
        --cum-death (-d) path   - path name of the file containing the 101
                                  cumulative death proportions
        --data (-D) path        - path name of the file containing the data
                                  generated by the simulation (default:
                                  '<base>/data-$.txt', use ! to suppress)
        --death-age (-a) age    - run one simulation using a specific natural
                                  death-age (also requires --tumor-age)
        --err (-e)              - use the previously used Beir7 ERR function
                                  (excess relative risk) instead of the
                                  excess absolute risk function, using the
                                  cases' subsequent simulated ages;
        --help (-h)             - provide this help
        --last-case (-l) nCases - perform simulations until 'nCases' have been
                                  analyzed and only write the data for the
                                  final case to the data file;
        --log "begin end file [set]" - begin: 1st case index to start logging
                                  end: last case index being logged
                                  file: path to the file to receive the logs
                                  [set]: optional set of logs to skip:
                                    C: uniform case random values
                                    L: log-normal random values
                                    U: uniform random values
                                    V: uniform VSD random values
        --one-analysis (-o)     - run a single scenario analysis. The
                                  program's arguments may be used to specify
                                  comma-separated configuration parameters
        --parameters (-P) path  - path name of the parameters-file (default:
                                  not used)
        --rounds (-R) path      - path name of the file containing the summary
                                  info of the simulation rounds (default:
                                  '<base>/rounds-$.txt', use ! to suppress)
        --sensitivity (-S) path - path name of the sensitivity-file (default:
                                  '<base>/sensitivity.txt', use ! to
                                  suppress)
        --spread (-s) path      - path name of the file showing the actual
                                  'spread' values when 'spread: true' is
                                  specified (default: '<base/spread.txt', use
                                  ! to suppress)
        --tnm (-T)              - write -1,0 in the data file for cases not
                                  having tumors
        --tumor-age (-t) age    - run one simulation using 'age' as the
                                  self-detect age of the tumor (also requires
                                  --death-age)
        --verbose (-V)          - write informative messages to the stdandard
                                  output stream
        --version (-v)          - show version information and terminate


    analyses - analyses to perform. See the simrisc(1) man-page for details.
    cumdeath - optional 101 cumulative death proportion values

    $ characters in non-default filenames are replaced by iteration indices.
    The first + characterr of non-default filenames is replaced by the
    base-directory.

    The structure of the configuration file is described in the
    simriscinput(7) man-page.

)_";

}

void usage(std::string const &progname)
{
    cout << "\n" <<
    progname << " by " << Icmake::author << "\n" <<
    progname << " V" << Icmake::version << " " << Icmake::years << "\n"
    "\n"
    "Usage: " << progname << info;
}
