###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_web_script_exec_vuln_jun09.nasl 2948 2009-06-16 14:23:29Z jun $
#
# Microsoft Internet Explorer Web Script Execution Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

desc1 = "
  *****
  Note: Vulnerability is related to CVE-2009-2057 and CVE-2009-2069
  *****

  Overview: This host has Internet Explorer installed and is prone to Web Script
  Execution vulnerabilities.

  Vulnerability Insight:
  - Error exists while the HTTP Host header to determine the context of a
    document provided in a '4xx' or '5xx' CONNECT response from a proxy server,
    and these can be exploited by modifying the CONNECT response, aka an
    'SSL tampering' attack.
  - Displays a cached certificate for a '4xx' or '5xx' CONNECT response page
    returned by a proxy server, which can be exploited by sending the browser a
    crafted 502 response page upon a subsequent request.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary web script
  and spoof an arbitrary https site by letting a browser obtain a valid
  certificate.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version prior to 8.0 on Windows.";

desc2 = "
  *****
  Note: Vulnerability is related to CVE-2009-2064
  *****

  Overview: This host has Internet Explorer installed and is prone to Web Script
  Execution vulnerability.

  Vulnerability Insight:
  - Detects http content in https web pages only when the top-level frame uses
    https. These can be exploited by modifying an http page to include an https
    iframe that references a script file on an http site, related to
    'HTTP-Intended-but-HTTPS-Loadable (HPIHSL) pages.'

  Impact:
  Successful exploitation will let the attacker to execute arbitrary web script.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 8.0 and later on Windows";

desc3 = "

  Fix: No solution or patch is available as on 16th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://research.microsoft.com/apps/pubs/default.aspx?id=79323
  http://research.microsoft.com/pubs/79323/pbp-final-with-update.pdf

  CVSS Score Report:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

if(description)
{
  script_id(900366);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_name("Microsoft Internet Explorer Web Script Execution Vulnerabilites");
  script_description(desc1);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

if(version_is_less(version:ieVer, test_version:"8.0")){
  security_hole(data:string(desc1, desc3));
}
else if(version_in_range(version:ieVer, test_version:"8.0",
                         test_version2:"8.0.6001.18782")){
  security_hole(data:string(desc2, desc3));
}
