###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_webcamxp_detect.nasl 821 2009-01-09 18:00:24Z jan $
#
# webcamXP Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800221);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("webcamXP Version Detection");
  desc = "
  Overview : This script finds the installed webcamXP Version and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of webcamXP in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

foreach port (make_list("80", "8080"))
{
  if(get_port_state(port))
  {
    req = http_get(item:"/", port:port);
    rsp = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
    if(rsp == NULL){
      exit(0);
    }

    if("webcamXP" >< rsp)
    {
      webcamVer = eregmatch(pattern:" v([0-9.]+)", string:rsp);
      if(webcamVer[1] != NULL){
        #Set the KB item for webcamXP
        set_kb_item(name:"WebcamXP/Version", value:webcamVer[1]);
        security_note(data:"WebcamXP/Version version " + webcamVer[1] +
                                                 " was detected on the host");
      }
      exit(0);
    }
  }
}
