# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1958-1 (libtool)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66599);
 script_cve_id("CVE-2009-3736");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1958-1 (libtool)");

 desc = "The remote host is missing an update to libtool
announced via advisory DSA 1958-1.

It was discovered that ltdl, a system-independent dlopen wrapper for
GNU libtool, can be tricked to load and run modules from an arbitrary
directory, which might be used to execute arbitrary code with the
privileges of the user running an application that uses libltdl.


For the stable distribution (lenny), this problem has been fixed in
version 1.5.26-4+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 1.5.22-4+etch1.

For the testing distribution (squeeze) and unstable distribution (sid),
this problem has been fixed in 2.2.6b-1.


We recommend that you upgrade your libtool packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201958-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1958-1 (libtool)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtool-doc", ver:"1.5.22-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtool", ver:"1.5.22-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libltdl3", ver:"1.5.22-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libltdl3-dev", ver:"1.5.22-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtool-doc", ver:"1.5.26-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtool", ver:"1.5.26-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libltdl3", ver:"1.5.26-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libltdl3-dev", ver:"1.5.26-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
