/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCIDEVICECONTROLLEDBYPCIPORT_H_
#define OPENDRIM_PCIDEVICECONTROLLEDBYPCIPORT_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Controller.h"
#include "CIM_ControllerAccess.h"
#include "cmpiCIM_LogicalDevice.h"
#include "CIM_LogicalDeviceAccess.h"
*/

const static char* OpenDRIM_PCIDeviceControlledByPCIPort_classnames[] = {"OpenDRIM_PCIDeviceControlledByPCIPort"};
static string OpenDRIM_PCIDeviceControlledByPCIPort_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_PCIDevice"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"OpenDRIM_PCIPort"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_PCIDeviceControlledByPCIPort {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	unsigned long long NegotiatedSpeed;
	bool NegotiatedSpeed_isNULL;
	
	unsigned int NegotiatedDataWidth;
	bool NegotiatedDataWidth_isNULL;
	
	unsigned short AccessState;
	bool AccessState_isNULL;
	
	string TimeOfDeviceReset;
	bool TimeOfDeviceReset_isNULL;
	
	unsigned int NumberOfHardResets;
	bool NumberOfHardResets_isNULL;
	
	unsigned int NumberOfSoftResets;
	bool NumberOfSoftResets_isNULL;
	
	string DeviceNumber;
	bool DeviceNumber_isNULL;
	
	unsigned short AccessMode;
	bool AccessMode_isNULL;
	
	unsigned short AccessPriority;
	bool AccessPriority_isNULL;
	
	OpenDRIM_PCIDeviceControlledByPCIPort() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		NegotiatedSpeed_isNULL = true;
		NegotiatedDataWidth_isNULL = true;
		AccessState_isNULL = true;
		TimeOfDeviceReset_isNULL = true;
		NumberOfHardResets_isNULL = true;
		NumberOfSoftResets_isNULL = true;
		DeviceNumber_isNULL = true;
		AccessMode_isNULL = true;
		AccessPriority_isNULL = true;
	}
	
	~OpenDRIM_PCIDeviceControlledByPCIPort() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getNegotiatedSpeed(unsigned long long& value) const {
		if (NegotiatedSpeed_isNULL==true)
			return NOT_FOUND;
		value = NegotiatedSpeed;
		return OK;
	}
	
	int setNegotiatedSpeed(const unsigned long long& newValue) {
		NegotiatedSpeed = newValue;
		NegotiatedSpeed_isNULL = false;
		return OK;
	}

	int getNegotiatedDataWidth(unsigned int& value) const {
		if (NegotiatedDataWidth_isNULL==true)
			return NOT_FOUND;
		value = NegotiatedDataWidth;
		return OK;
	}
	
	int setNegotiatedDataWidth(const unsigned int& newValue) {
		NegotiatedDataWidth = newValue;
		NegotiatedDataWidth_isNULL = false;
		return OK;
	}

	int getAccessState(unsigned short& value) const {
		if (AccessState_isNULL==true)
			return NOT_FOUND;
		value = AccessState;
		return OK;
	}
	
	int setAccessState(const unsigned short& newValue) {
		AccessState = newValue;
		AccessState_isNULL = false;
		return OK;
	}

	int getTimeOfDeviceReset(string& value) const {
		if (TimeOfDeviceReset_isNULL==true)
			return NOT_FOUND;
		value = TimeOfDeviceReset;
		return OK;
	}
	
	int setTimeOfDeviceReset(const string& newValue) {
		TimeOfDeviceReset = newValue;
		TimeOfDeviceReset_isNULL = false;
		return OK;
	}

	int getNumberOfHardResets(unsigned int& value) const {
		if (NumberOfHardResets_isNULL==true)
			return NOT_FOUND;
		value = NumberOfHardResets;
		return OK;
	}
	
	int setNumberOfHardResets(const unsigned int& newValue) {
		NumberOfHardResets = newValue;
		NumberOfHardResets_isNULL = false;
		return OK;
	}

	int getNumberOfSoftResets(unsigned int& value) const {
		if (NumberOfSoftResets_isNULL==true)
			return NOT_FOUND;
		value = NumberOfSoftResets;
		return OK;
	}
	
	int setNumberOfSoftResets(const unsigned int& newValue) {
		NumberOfSoftResets = newValue;
		NumberOfSoftResets_isNULL = false;
		return OK;
	}

	int getDeviceNumber(string& value) const {
		if (DeviceNumber_isNULL==true)
			return NOT_FOUND;
		value = DeviceNumber;
		return OK;
	}
	
	int setDeviceNumber(const string& newValue) {
		DeviceNumber = newValue;
		DeviceNumber_isNULL = false;
		return OK;
	}

	int getAccessMode(unsigned short& value) const {
		if (AccessMode_isNULL==true)
			return NOT_FOUND;
		value = AccessMode;
		return OK;
	}
	
	int setAccessMode(const unsigned short& newValue) {
		AccessMode = newValue;
		AccessMode_isNULL = false;
		return OK;
	}

	int getAccessPriority(unsigned short& value) const {
		if (AccessPriority_isNULL==true)
			return NOT_FOUND;
		value = AccessPriority;
		return OK;
	}
	
	int setAccessPriority(const unsigned short& newValue) {
		AccessPriority = newValue;
		AccessPriority_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PCIDEVICECONTROLLEDBYPCIPORT_H_*/
