/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Implements prototypical inheritance by replacing the prototype of one constructor with the prototype of another constructor.
*
* @param ctor - constructor which will inherit
* @param superCtor - super (parent) constructor
* @throws first argument must be either an object or a function which can inherit
* @throws second argument must be either an object or a function from which a constructor can inherit
* @throws second argument must have an inheritable prototype
* @returns child constructor
*
* @example
* function Foo() {
*     return this;
* }
* Foo.prototype.beep = function beep() {
*     return 'boop';
* };
*
* function Bar() {
*     Foo.call( this );
*     return this;
* }
* inherit( Bar, Foo );
*
* var bar = new Bar();
* var v = bar.beep();
* // returns 'boop'
*/
declare function inherit( ctor: any, superCtor: any ): any;


// EXPORTS //

export = inherit;
