/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Classes } from "@blueprintjs/core";

const NS = Classes.getClassNamespace();

export const DATEINPUT = `${NS}-dateinput`;
export const DATEINPUT_POPOVER = `${DATEINPUT}-popover`;

export const DATEPICKER = `${NS}-datepicker`;
export const DATEPICKER_CAPTION = `${DATEPICKER}-caption`;
export const DATEPICKER_CAPTION_CARET = `${DATEPICKER_CAPTION}-caret`;
export const DATEPICKER_CAPTION_MEASURE = `${DATEPICKER_CAPTION}-measure`;
export const DATEPICKER_CAPTION_SELECT = `${DATEPICKER_CAPTION}-select`;
export const DATEPICKER_CONTENT = `${DATEPICKER}-content`;
export const DATEPICKER_DAY = "DayPicker-Day";
export const DATEPICKER_DAY_DISABLED = `${DATEPICKER_DAY}--disabled`;
export const DATEPICKER_DAY_OUTSIDE = `${DATEPICKER_DAY}--outside`;
export const DATEPICKER_DAY_SELECTED = `${DATEPICKER_DAY}--selected`;
export const DATEPICKER_DAY_IS_TODAY = `${DATEPICKER_DAY}--isToday`;
export const DATEPICKER_DAY_WRAPPER = `${DATEPICKER}-day-wrapper`;
export const DATEPICKER_FOOTER = `${DATEPICKER}-footer`;
export const DATEPICKER_MONTH_SELECT = `${DATEPICKER}-month-select`;
export const DATEPICKER_YEAR_SELECT = `${DATEPICKER}-year-select`;
export const DATEPICKER_NAVBAR = `${DATEPICKER}-navbar`;
export const DATEPICKER_NAVBUTTON = `DayPicker-NavButton`;
export const DATEPICKER_TIMEPICKER_WRAPPER = `${DATEPICKER}-timepicker-wrapper`;

export const DATERANGEPICKER = `${NS}-daterangepicker`;
export const DATERANGEPICKER_CALENDARS = `${DATERANGEPICKER}-calendars`;
export const DATERANGEPICKER_CONTIGUOUS = `${DATERANGEPICKER}-contiguous`;
export const DATERANGEPICKER_SINGLE_MONTH = `${DATERANGEPICKER}-single-month`;
export const DATERANGEPICKER_DAY_SELECTED_RANGE = `${DATEPICKER_DAY}--selected-range`;
export const DATERANGEPICKER_DAY_HOVERED_RANGE = `${DATEPICKER_DAY}--hovered-range`;
export const DATERANGEPICKER_SHORTCUTS = `${DATERANGEPICKER}-shortcuts`;
export const DATERANGEPICKER_TIMEPICKERS = `${DATERANGEPICKER}-timepickers`;

export const DATETIMEPICKER = `${NS}-datetimepicker`;

export const TIMEPICKER = `${NS}-timepicker`;
export const TIMEPICKER_ARROW_BUTTON = `${TIMEPICKER}-arrow-button`;
export const TIMEPICKER_ARROW_ROW = `${TIMEPICKER}-arrow-row`;
export const TIMEPICKER_DIVIDER_TEXT = `${TIMEPICKER}-divider-text`;
export const TIMEPICKER_HOUR = `${TIMEPICKER}-hour`;
export const TIMEPICKER_INPUT = `${TIMEPICKER}-input`;
export const TIMEPICKER_INPUT_ROW = `${TIMEPICKER}-input-row`;
export const TIMEPICKER_MILLISECOND = `${TIMEPICKER}-millisecond`;
export const TIMEPICKER_MINUTE = `${TIMEPICKER}-minute`;
export const TIMEPICKER_SECOND = `${TIMEPICKER}-second`;
export const TIMEPICKER_AMPM_SELECT = `${TIMEPICKER}-ampm-select`;
