/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQComboLine_H
#define MvQComboLine_H

#include <QWidget>

class QComboBox;
class QLineEdit;
class QRegExpValidator;

using namespace std;

class MvQComboLine : public QWidget
{
    Q_OBJECT

public:
    MvQComboLine(QStringList, QWidget* parent = 0);
    void setItems(QStringList);
    void setRegExps(QList<QRegExp>);
    void setToolTips(QStringList);
    void setCurrentIndex(int);

signals:
    void currentIndexChanged(int);
    void textChanged(QString);

protected slots:
    void slotCurrentIndexChanged(int);

protected:
    //void resizeEvent(QResizeEvent*);
    QComboBox* combo_;
    QLineEdit* line_;
    QRegExpValidator* validator_;
    QList<QRegExp> regExps_;
    QStringList toolTips_;
};


#endif
