# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1PersistentVolumeClaimSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'access_modes': 'list[V1PersistentVolumeAccessMode]',
            'resources': 'V1ResourceRequirements',
            'volume_name': 'str'
        }

        self.attribute_map = {
            'access_modes': 'accessModes',
            'resources': 'resources',
            'volume_name': 'volumeName'
        }

        self._access_modes = None
        self._resources = None
        self._volume_name = None

    @property
    def access_modes(self):
        """
        Gets the access_modes of this V1PersistentVolumeClaimSpec.
        the desired access modes the volume should have; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#access-modes-1

        :return: The access_modes of this V1PersistentVolumeClaimSpec.
        :rtype: list[V1PersistentVolumeAccessMode]
        """
        return self._access_modes

    @access_modes.setter
    def access_modes(self, access_modes):
        """
        Sets the access_modes of this V1PersistentVolumeClaimSpec.
        the desired access modes the volume should have; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#access-modes-1

        :param access_modes: The access_modes of this V1PersistentVolumeClaimSpec.
        :type: list[V1PersistentVolumeAccessMode]
        """
        self._access_modes = access_modes

    @property
    def resources(self):
        """
        Gets the resources of this V1PersistentVolumeClaimSpec.
        the desired resources the volume should have; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#resources

        :return: The resources of this V1PersistentVolumeClaimSpec.
        :rtype: V1ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this V1PersistentVolumeClaimSpec.
        the desired resources the volume should have; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#resources

        :param resources: The resources of this V1PersistentVolumeClaimSpec.
        :type: V1ResourceRequirements
        """
        self._resources = resources

    @property
    def volume_name(self):
        """
        Gets the volume_name of this V1PersistentVolumeClaimSpec.
        the binding reference to the persistent volume backing this claim

        :return: The volume_name of this V1PersistentVolumeClaimSpec.
        :rtype: str
        """
        return self._volume_name

    @volume_name.setter
    def volume_name(self, volume_name):
        """
        Sets the volume_name of this V1PersistentVolumeClaimSpec.
        the binding reference to the persistent volume backing this claim

        :param volume_name: The volume_name of this V1PersistentVolumeClaimSpec.
        :type: str
        """
        self._volume_name = volume_name

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
