/*
 * $Id: TestColor.java,v 1.7 2007-03-11 20:40:58 larry Exp $ 
 */
package com.representqueens.spark;

/*
 * 
 * Copyright 2006 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import com.representqueens.util.ColorUtils;


/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.7 $ $Date: 2007-03-11 20:40:58 $
 */
public class TestColor
{

  public static void main(final String[] args)
  throws IOException
  {
    final Number[] data = {5, 23, 11, 25, -19, 4, 2, 3, -13, 2, 3, 4, 5};
    
    final Color color = ColorUtils.parseColor("black");
    final Color back = ColorUtils.parseColor("red");
    
    System.out.println("Found color: " + color);
    
    final BufferedImage i = LineGraph.createGraph(data, LineGraph.DEFAULT_SIZE, color, back);
    //final BufferedImage i = BarGraph.createGraph(data, BarGraph.DEFAULT_SIZE, color, null, null); 
    
    final File file = new File(args[0]);
    
    ImageIO.write(i, "png", file);
  }

}
