/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLReasonCodeExtension
extends Extension
implements CertAttrSet {
    public static final String NAME = "CRLReasonCode";
    public static final String REASON = "reason";
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFLIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private int reasonCode = 0;

    private void encodeThis() throws IOException {
        if (this.reasonCode == 0) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putEnumerated(this.reasonCode);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CRLReasonCodeExtension(int n) throws IOException {
        this.reasonCode = n;
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = false;
        this.encodeThis();
    }

    public CRLReasonCodeExtension(boolean bl, int n) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        this.reasonCode = n;
        this.encodeThis();
    }

    public CRLReasonCodeExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.reasonCode = derValue.getEnumerated();
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!string.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = (Integer)object;
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(REASON)) {
            return new Integer(this.reasonCode);
        }
        throw new IOException("Name not supported by CRLReasonCodeExtension");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = 0;
        this.encodeThis();
    }

    public String toString() {
        String string = super.toString() + "    Reason Code: ";
        switch (this.reasonCode) {
            case 0: {
                string = string + "Unspecified";
                break;
            }
            case 1: {
                string = string + "Key Compromise";
                break;
            }
            case 2: {
                string = string + "CA Compromise";
                break;
            }
            case 3: {
                string = string + "Affiliation Changed";
                break;
            }
            case 4: {
                string = string + "Superseded";
                break;
            }
            case 5: {
                string = string + "Cessation Of Operation";
                break;
            }
            case 6: {
                string = string + "Certificate Hold";
                break;
            }
            case 8: {
                string = string + "Remove from CRL";
                break;
            }
            case 9: {
                string = string + "Privilege Withdrawn";
                break;
            }
            case 10: {
                string = string + "AA Compromise";
                break;
            }
            default: {
                string = string + "Unrecognized reason code (" + this.reasonCode + ")";
            }
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.extensionId = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.tag == 1) {
            this.critical = derValue2.getBoolean();
            derValue2 = derInputStream.getDerValue();
            this.extensionValue = derValue2.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = derValue2.getOctetString();
        }
        derValue = new DerValue(this.extensionValue);
        this.reasonCode = derValue.getEnumerated();
        if (derValue.data.available() != 0) {
            throw new IOException("Illegal encoding of CRLReasonCodeExtension");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ReasonCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REASON);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

