/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImplFactory;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetPropertyAction;

public class Socket {
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    SocketImpl impl;
    private boolean oldImpl = false;
    static Class implClass = null;
    private static SocketImplFactory factory = null;
    static /* synthetic */ Class class$java$net$SocketAddress;

    public Socket() {
        this.setImpl();
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl;
        if (socketImpl != null) {
            this.checkOldImpl();
            this.impl.setSocket(this);
        }
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(0), true);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(0), true);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(inetAddress, n2), true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(inetAddress2, n2), true);
    }

    private Socket(SocketAddress socketAddress, SocketAddress socketAddress2, boolean bl) throws IOException {
        this.setImpl();
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(bl);
            if (socketAddress2 == null) {
                socketAddress2 = new InetSocketAddress(0);
            }
            this.bind(socketAddress2);
            if (socketAddress != null) {
                this.connect(socketAddress);
            }
        }
        catch (SocketException socketException) {
            this.close();
            throw socketException;
        }
    }

    void createImpl(boolean bl) throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(bl);
            this.created = true;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Class[] classArray = new Class[]{class$java$net$SocketAddress == null ? (class$java$net$SocketAddress = Socket.class$("java.net.SocketAddress")) : class$java$net$SocketAddress, Integer.TYPE};
                    Socket.this.impl.getClass().getDeclaredMethod("connect", classArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.oldImpl = true;
        }
    }

    void setImpl() {
        Socket.checkSocks();
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            if (implClass == null) {
                try {
                    String string = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix.stream", "Plain"));
                    implClass = Class.forName("java.net." + string + "SocketImpl");
                }
                catch (Exception exception) {
                    implClass = PlainSocketImpl.class;
                }
            }
            try {
                this.impl = (SocketImpl)implClass.newInstance();
            }
            catch (Exception exception) {
                this.impl = new PlainSocketImpl();
            }
            if (this.impl != null && !(this.impl instanceof PlainSocketImpl)) {
                this.checkOldImpl();
            }
        }
        if (this.impl != null) {
            this.impl.setSocket(this);
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return this.impl;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            } else {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
        }
        if (!this.created) {
            this.createImpl(true);
        }
        if (!this.oldImpl) {
            this.impl.connect(inetSocketAddress, n);
        } else if (n == 0) {
            if (inetSocketAddress.isUnresolved()) {
                this.impl.connect(inetSocketAddress.getAddress().getHostName(), inetSocketAddress.getPort());
            } else {
                this.impl.connect(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            }
        } else {
            throw new UnsupportedOperationException("SocketImpl.connect(addr, timeout)");
        }
        this.connected = true;
        this.bound = true;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress != null && !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress != null && inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (socketAddress == null) {
            this.getImpl().bind(InetAddress.anyLocalAddress(), 0);
        } else {
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        this.bound = true;
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    void setBound() {
        this.bound = true;
    }

    void setConnected() {
        this.connected = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.getImpl().getOption(15);
            if (inetAddress.isAnyLocalAddress()) {
                inetAddress = InetAddress.anyLocalAddress();
            }
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress();
        }
        return inetAddress;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        Socket socket = this;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Socket.this.impl.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        Socket socket = this;
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Socket.this.impl.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(1, new Boolean(bl));
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(1);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!bl) {
            this.getImpl().setOption(128, new Boolean(bl));
        } else {
            if (n < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (n > 65535) {
                n = 65535;
            }
            this.getImpl().setOption(128, new Integer(n));
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void sendUrgentData(int n) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw new SocketException("Urgent data not supported");
        }
        this.getImpl().sendUrgentData(n);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4099, new Boolean(bl));
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4099);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.getImpl().setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(n));
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(8, new Boolean(bl));
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(8);
    }

    public void setTrafficClass(int n) throws SocketException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(3, new Integer(n));
    }

    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, new Boolean(bl));
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected || this.oldImpl;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    private static synchronized void checkSocks() {
        int n = -1;
        String string = null;
        String string2 = null;
        if (factory == null) {
            string2 = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyHost"));
            if (string2 == null || string2.length() <= 0) {
                return;
            }
            string = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyPort"));
            if (string != null && string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = -1;
                }
            }
            if (string2 != null) {
                factory = new SocksSocketImplFactory(string2, n);
            }
        } else if (factory instanceof SocksSocketImplFactory && ((string2 = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyHost"))) == null || string2.length() <= 0)) {
            factory = null;
        }
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }
}

