/*
 * @(#)IUrlClassLoaderOnlineUTestI.java
 *
 * Copyright (C) 2001,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;

import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Just like util.http.tests, this uses the Sourceforge account to ensure
 * that the URLs work correctly.  It loads the sample applet "BeliefOfTheDay"
 * to make sure that this is able to load classes remotely.
 * As insurance, this also tests to make sure that the same applet is not
 * in the current classpath.
 * <P>
 * The system must have access to the internet to correctly run this test.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/05/06 05:35:01 $
 * @since   May 23, 2001 (GroboUtils Alpha 0.9.0)
 */
public class IUrlClassLoaderOnlineUTestI extends InterfaceTestCase
{
    private static final Class THIS_CLASS = IUrlClassLoaderOnlineUTestI.class;
    
    public IUrlClassLoaderOnlineUTestI( String name, ImplFactory f )
    {
        super( name, IUrlClassLoader.class, f );
    }

    
    public IUrlClassLoader createLoader()
    {
        return (IUrlClassLoader)createImplObject();
    }
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    //-------------------------------------------------------------------------
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    public void testInstantiate()
    {
        assertNotNull( "Creation should not return null.",
            createLoader() );
    }
    
    
    public static final String BELIEF_CLASS = "BeliefOfTheDay";
    public static final String BELIEF_JAR =
        "http://groboutils.sourceforge.net/Belief.jar";
    
    public static class InnerClass
    {
        public InnerClass()
        {
            // do nothing
        }
    }
    
    
    public void testGetClass1()
    {
        IUrlClassLoader loader = createLoader();
        
        Class c = loader.loadClass( this.getClass().getName(), null );
        assertNotNull( "loadClass( "+this.getClass().getName()+
            " ) returned null.",
            c );
        assertEquals( "Did not load the class from the default classloader.",
            this.THIS_CLASS, c );
        
        c = loader.loadClass( BELIEF_CLASS, null );
        assertEquals(
            "getClass( Belief ) was found in the default classloader.",
            null, c );
    }
    
    
    public void testGetClass2()
    {
        IUrlClassLoader loader = createLoader();
        
        Class c = loader.loadClass( BELIEF_CLASS, BELIEF_JAR );
        assertNotNull( "getClass( "+BELIEF_CLASS+" ) returned null.", c );
        assertEquals( "getClass( "+BELIEF_CLASS+" ) returned the wrong class.",
            BELIEF_CLASS, c.getName() );
    }
    
    
    public void testFlush()
    {
        IUrlClassLoader loader = createLoader();
        
        Class c = loader.loadClass( this.getClass().getName(), null );
        loader.flush();
        
        // Can't really test this for correctness, just for error throwing.
        // Testing for GC size is really inaccurate.
    }
    
}
