/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * This class holds a Xml-Rpc struct object.
 *
 * @author Elias Ross
 * @version 1.0
 */

public class StructPairImpl
	implements StructPair
{
	String name;
	Object value;

	/**
	 * Construct a StructPairImpl object with a name and value.
	 * @param name name belonging to this struct member
	 * @param value value belonging to this struct member.  May be of
	 * any Xml-Rpc type, or possibly a ParamIterator.
	 */
	public StructPairImpl(String name, Object value) {
		this.name = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public Object getValue() {
		return value;
	}

	/**
	 * Returns a string for viewing its contents.
	 * @return a string
	 */
	public String toString() {
		return "name=" + name + " value=" + value;
	}
}
