/* vfs-trash-impl-gnome-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-trash-impl-gnome-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: Trash implementation with GNOME VFS.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <libgnomevfs/gnome-vfs.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME (desktop_agnostic_vfs_trash_volume_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME, DesktopAgnosticVFSTrashVolume))
#define DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME, DesktopAgnosticVFSTrashVolumeClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME))
#define DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME, DesktopAgnosticVFSTrashVolumeClass))

typedef struct _DesktopAgnosticVFSTrashVolume DesktopAgnosticVFSTrashVolume;
typedef struct _DesktopAgnosticVFSTrashVolumeClass DesktopAgnosticVFSTrashVolumeClass;
typedef struct _DesktopAgnosticVFSTrashVolumePrivate DesktopAgnosticVFSTrashVolumePrivate;
#define _gnome_vfs_file_info_unref0(var) ((var == NULL) ? NULL : (var = (gnome_vfs_file_info_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS (desktop_agnostic_vfs_trash_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFSClass))

typedef struct _DesktopAgnosticVFSTrashGnomeVFS DesktopAgnosticVFSTrashGnomeVFS;
typedef struct _DesktopAgnosticVFSTrashGnomeVFSClass DesktopAgnosticVFSTrashGnomeVFSClass;
typedef struct _DesktopAgnosticVFSTrashGnomeVFSPrivate DesktopAgnosticVFSTrashGnomeVFSPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _gnome_vfs_uri_unref0(var) ((var == NULL) ? NULL : (var = (gnome_vfs_uri_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSTrashVolume {
	GObject parent_instance;
	DesktopAgnosticVFSTrashVolumePrivate * priv;
};

struct _DesktopAgnosticVFSTrashVolumeClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSTrashVolumePrivate {
	guint _file_count;
	DesktopAgnosticVFSTrash* trash;
	GnomeVFSMonitorHandle* monitor;
	GnomeVFSURI* _uri;
};

struct _DesktopAgnosticVFSTrashGnomeVFS {
	GObject parent_instance;
	DesktopAgnosticVFSTrashGnomeVFSPrivate * priv;
	GHashTable* trash_dirs;
};

struct _DesktopAgnosticVFSTrashGnomeVFSClass {
	GObjectClass parent_class;
};


static gpointer desktop_agnostic_vfs_trash_volume_parent_class = NULL;
static gpointer desktop_agnostic_vfs_trash_gnome_vfs_parent_class = NULL;
static DesktopAgnosticVFSTrashIface* desktop_agnostic_vfs_trash_gnome_vfs_desktop_agnostic_vfs_trash_parent_iface = NULL;

GType desktop_agnostic_vfs_trash_volume_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME, DesktopAgnosticVFSTrashVolumePrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_FILE_COUNT,
	DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_URI
};
DesktopAgnosticVFSTrashVolume* desktop_agnostic_vfs_trash_volume_new (DesktopAgnosticVFSTrash* trash, GnomeVFSURI* uri);
DesktopAgnosticVFSTrashVolume* desktop_agnostic_vfs_trash_volume_construct (GType object_type, DesktopAgnosticVFSTrash* trash, GnomeVFSURI* uri);
void desktop_agnostic_vfs_trash_volume_set_uri (DesktopAgnosticVFSTrashVolume* self, GnomeVFSURI* value);
static void desktop_agnostic_vfs_trash_volume_update_file_count (DesktopAgnosticVFSTrashVolume* self, GnomeVFSMonitorHandle* monitor, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type);
static void desktop_agnostic_vfs_trash_volume_reset_file_count (DesktopAgnosticVFSTrashVolume* self);
GnomeVFSURI* desktop_agnostic_vfs_trash_volume_get_uri (DesktopAgnosticVFSTrashVolume* self);
static gboolean desktop_agnostic_vfs_trash_volume_visit_callback (const char* rel_path, GnomeVFSFileInfo* info, gboolean recursing_will_loop, void** data, gboolean recurse);
static void desktop_agnostic_vfs_trash_volume_do_empty (GnomeVFSURI* dir);
void desktop_agnostic_vfs_trash_volume_empty (DesktopAgnosticVFSTrashVolume* self);
guint desktop_agnostic_vfs_trash_volume_get_file_count (DesktopAgnosticVFSTrashVolume* self);
static void _desktop_agnostic_vfs_trash_volume_update_file_count_gnome_vfs_monitor_callback (GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type, gpointer self);
static void desktop_agnostic_vfs_trash_volume_finalize (GObject* obj);
static void desktop_agnostic_vfs_trash_volume_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_trash_volume_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_trash_gnome_vfs_get_type (void) G_GNUC_CONST;
enum  {
	DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_FILE_COUNT
};
static void desktop_agnostic_vfs_trash_gnome_vfs_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* uri, GError** error);
static void desktop_agnostic_vfs_trash_gnome_vfs_real_empty (DesktopAgnosticVFSTrash* base);
static gboolean desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs (DesktopAgnosticVFSTrashGnomeVFS* self);
static void desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir (DesktopAgnosticVFSTrashGnomeVFS* self, GnomeVFSVolumeMonitor* vm, GnomeVFSVolume* vol);
static void _desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir_gnome_vfs_volume_monitor_volume_mounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self);
static void desktop_agnostic_vfs_trash_gnome_vfs_remove_volume (DesktopAgnosticVFSTrashGnomeVFS* self, GnomeVFSVolumeMonitor* vm, GnomeVFSVolume* vol);
static void _desktop_agnostic_vfs_trash_gnome_vfs_remove_volume_gnome_vfs_volume_monitor_volume_unmounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self);
DesktopAgnosticVFSTrashGnomeVFS* desktop_agnostic_vfs_trash_gnome_vfs_new (void);
DesktopAgnosticVFSTrashGnomeVFS* desktop_agnostic_vfs_trash_gnome_vfs_construct (GType object_type);
static gboolean _desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs_gsource_func (gpointer self);
static GObject * desktop_agnostic_vfs_trash_gnome_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_trash_gnome_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_trash_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



DesktopAgnosticVFSTrashVolume* desktop_agnostic_vfs_trash_volume_construct (GType object_type, DesktopAgnosticVFSTrash* trash, GnomeVFSURI* uri) {
	DesktopAgnosticVFSTrashVolume * self = NULL;
	g_return_val_if_fail (trash != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (DesktopAgnosticVFSTrashVolume*) g_object_new (object_type, NULL);
	self->priv->_file_count = (guint) 0;
	self->priv->trash = trash;
	desktop_agnostic_vfs_trash_volume_set_uri (self, uri);
	return self;
}


DesktopAgnosticVFSTrashVolume* desktop_agnostic_vfs_trash_volume_new (DesktopAgnosticVFSTrash* trash, GnomeVFSURI* uri) {
	return desktop_agnostic_vfs_trash_volume_construct (DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_VOLUME, trash, uri);
}


static void desktop_agnostic_vfs_trash_volume_update_file_count (DesktopAgnosticVFSTrashVolume* self, GnomeVFSMonitorHandle* monitor, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type) {
	gboolean _tmp0_ = FALSE;
	guint old_file_count;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (monitor_uri != NULL);
	g_return_if_fail (info_uri != NULL);
	if (event_type != GNOME_VFS_MONITOR_EVENT_CREATED) {
		_tmp0_ = event_type != GNOME_VFS_MONITOR_EVENT_DELETED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	old_file_count = self->priv->_file_count;
	desktop_agnostic_vfs_trash_volume_reset_file_count (self);
	if (old_file_count != self->priv->_file_count) {
		g_signal_emit_by_name (self->priv->trash, "file-count-changed");
	}
}


static void desktop_agnostic_vfs_trash_volume_reset_file_count (DesktopAgnosticVFSTrashVolume* self) {
	GnomeVFSDirectoryHandle* handle;
	GnomeVFSResult res = 0;
	g_return_if_fail (self != NULL);
	g_message ("vfs-trash-impl-gnome-vfs.vala:91: reset_file_count");
	handle = NULL;
	self->priv->_file_count = (guint) 0;
	res = gnome_vfs_directory_open_from_uri (&handle, desktop_agnostic_vfs_trash_volume_get_uri (self), GNOME_VFS_FILE_INFO_NAME_ONLY);
	if (res == GNOME_VFS_OK) {
		GnomeVFSFileInfo* file_info;
		GnomeVFSFileInfo* _tmp0_;
		file_info = NULL;
		file_info = (_tmp0_ = gnome_vfs_file_info_new (), _gnome_vfs_file_info_unref0 (file_info), _tmp0_);
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (!((res = gnome_vfs_directory_read_next (handle, file_info)) == GNOME_VFS_OK)) {
				break;
			}
			if (_vala_strcmp0 (file_info->name, ".") != 0) {
				_tmp1_ = _vala_strcmp0 (file_info->name, "..") != 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				self->priv->_file_count++;
			}
		}
		gnome_vfs_directory_close (handle);
		_gnome_vfs_file_info_unref0 (file_info);
	}
}


static gboolean desktop_agnostic_vfs_trash_volume_visit_callback (const char* rel_path, GnomeVFSFileInfo* info, gboolean recursing_will_loop, void** data, gboolean recurse) {
	gboolean result = FALSE;
	GnomeVFSURI* item;
	g_return_val_if_fail (rel_path != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	item = NULL;
	item = gnome_vfs_uri_resolve_relative ((GnomeVFSURI*) (*data), rel_path);
	if (info->type == GNOME_VFS_FILE_TYPE_DIRECTORY) {
		desktop_agnostic_vfs_trash_volume_do_empty (item);
	}
	gnome_vfs_unlink_from_uri (item);
	result = TRUE;
	return result;
}


static void desktop_agnostic_vfs_trash_volume_do_empty (GnomeVFSURI* dir) {
	GnomeVFSResult res = 0;
	g_return_if_fail (dir != NULL);
	res = gnome_vfs_directory_visit_uri (dir, GNOME_VFS_FILE_INFO_DEFAULT, GNOME_VFS_DIRECTORY_VISIT_LOOPCHECK, (GnomeVFSDirectoryVisitFunc) desktop_agnostic_vfs_trash_volume_visit_callback, &dir);
	if (res != GNOME_VFS_OK) {
		g_warning ("vfs-trash-impl-gnome-vfs.vala:141: Error occurred: %s", gnome_vfs_result_to_string (res));
	}
}


void desktop_agnostic_vfs_trash_volume_empty (DesktopAgnosticVFSTrashVolume* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_uri == NULL) {
		g_warning ("vfs-trash-impl-gnome-vfs.vala:150: URI is NULL!");
	}
	desktop_agnostic_vfs_trash_volume_do_empty (self->priv->_uri);
}


guint desktop_agnostic_vfs_trash_volume_get_file_count (DesktopAgnosticVFSTrashVolume* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_file_count;
	return result;
}


GnomeVFSURI* desktop_agnostic_vfs_trash_volume_get_uri (DesktopAgnosticVFSTrashVolume* self) {
	GnomeVFSURI* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uri;
	return result;
}


static void _desktop_agnostic_vfs_trash_volume_update_file_count_gnome_vfs_monitor_callback (GnomeVFSMonitorHandle* handle, const char* monitor_uri, const char* info_uri, GnomeVFSMonitorEventType event_type, gpointer self) {
	desktop_agnostic_vfs_trash_volume_update_file_count (self, handle, monitor_uri, info_uri, event_type);
}


void desktop_agnostic_vfs_trash_volume_set_uri (DesktopAgnosticVFSTrashVolume* self, GnomeVFSURI* value) {
	g_return_if_fail (self != NULL);
	self->priv->_uri = value;
	desktop_agnostic_vfs_trash_volume_reset_file_count (self);
	if (self->priv->monitor == NULL) {
		gnome_vfs_monitor_add (&self->priv->monitor, gnome_vfs_uri_to_string (desktop_agnostic_vfs_trash_volume_get_uri (self), GNOME_VFS_URI_HIDE_NONE), GNOME_VFS_MONITOR_DIRECTORY, _desktop_agnostic_vfs_trash_volume_update_file_count_gnome_vfs_monitor_callback, self);
	}
	g_object_notify ((GObject *) self, "uri");
}


static void desktop_agnostic_vfs_trash_volume_class_init (DesktopAgnosticVFSTrashVolumeClass * klass) {
	desktop_agnostic_vfs_trash_volume_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSTrashVolumePrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_trash_volume_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_trash_volume_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_trash_volume_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_FILE_COUNT, g_param_spec_uint ("file-count", "file-count", "file-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_URI, g_param_spec_pointer ("uri", "uri", "uri", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void desktop_agnostic_vfs_trash_volume_instance_init (DesktopAgnosticVFSTrashVolume * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_trash_volume_finalize (GObject* obj) {
	DesktopAgnosticVFSTrashVolume * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME (obj);
	G_OBJECT_CLASS (desktop_agnostic_vfs_trash_volume_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_trash_volume_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_volume_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_volume_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSTrashVolumeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_trash_volume_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSTrashVolume), 0, (GInstanceInitFunc) desktop_agnostic_vfs_trash_volume_instance_init, NULL };
		GType desktop_agnostic_vfs_trash_volume_type_id;
		desktop_agnostic_vfs_trash_volume_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSTrashVolume", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_vfs_trash_volume_type_id__volatile, desktop_agnostic_vfs_trash_volume_type_id);
	}
	return desktop_agnostic_vfs_trash_volume_type_id__volatile;
}


static void desktop_agnostic_vfs_trash_volume_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSTrashVolume * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_FILE_COUNT:
		g_value_set_uint (value, desktop_agnostic_vfs_trash_volume_get_file_count (self));
		break;
		case DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_URI:
		g_value_set_pointer (value, desktop_agnostic_vfs_trash_volume_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_trash_volume_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSTrashVolume * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_TRASH_VOLUME_URI:
		desktop_agnostic_vfs_trash_volume_set_uri (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _gnome_vfs_uri_ref0 (gpointer self) {
	return self ? gnome_vfs_uri_ref (self) : NULL;
}


static void desktop_agnostic_vfs_trash_gnome_vfs_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* uri, GError** error) {
	DesktopAgnosticVFSTrashGnomeVFS * self;
	GnomeVFSURI* g_uri;
	GnomeVFSURI* trash_uri;
	GnomeVFSResult res = 0;
	GnomeVFSURI* _tmp0_;
	GnomeVFSURI* _tmp1_ = NULL;
	GnomeVFSResult _tmp2_;
	GnomeVFSURI* _tmp3_;
	self = (DesktopAgnosticVFSTrashGnomeVFS*) base;
	g_return_if_fail (uri != NULL);
	g_uri = NULL;
	trash_uri = NULL;
	g_uri = (_tmp0_ = _gnome_vfs_uri_ref0 ((GnomeVFSURI*) desktop_agnostic_vfs_file_get_implementation (uri)), _gnome_vfs_uri_unref0 (g_uri), _tmp0_);
	res = (_tmp2_ = gnome_vfs_find_directory (g_uri, GNOME_VFS_DIRECTORY_KIND_TRASH, &_tmp1_, TRUE, FALSE, (guint) 0777), trash_uri = (_tmp3_ = _gnome_vfs_uri_ref0 (_tmp1_), _gnome_vfs_uri_unref0 (trash_uri), _tmp3_), _tmp2_);
	if (res == GNOME_VFS_OK) {
		GnomeVFSURI* new_uri;
		new_uri = _gnome_vfs_uri_ref0 (gnome_vfs_uri_append_file_name (trash_uri, gnome_vfs_uri_extract_short_path_name (g_uri)));
		g_message ("vfs-trash-impl-gnome-vfs.vala:196: Moving '%s' to '%s'...", gnome_vfs_uri_to_string (g_uri, GNOME_VFS_URI_HIDE_NONE), gnome_vfs_uri_to_string (new_uri, GNOME_VFS_URI_HIDE_NONE));
		res = gnome_vfs_move_uri (g_uri, new_uri, FALSE);
		if (res != GNOME_VFS_OK) {
			g_warning ("vfs-trash-impl-gnome-vfs.vala:200: Error occurred: %s", gnome_vfs_result_to_string (res));
		}
		_gnome_vfs_uri_unref0 (new_uri);
	} else {
		g_warning ("vfs-trash-impl-gnome-vfs.vala:205: Error occurred: %s", gnome_vfs_result_to_string (res));
	}
	_gnome_vfs_uri_unref0 (trash_uri);
	_gnome_vfs_uri_unref0 (g_uri);
}


static void desktop_agnostic_vfs_trash_gnome_vfs_real_empty (DesktopAgnosticVFSTrash* base) {
	DesktopAgnosticVFSTrashGnomeVFS * self;
	GList* values;
	GList* _tmp0_;
	self = (DesktopAgnosticVFSTrashGnomeVFS*) base;
	values = NULL;
	values = (_tmp0_ = g_hash_table_get_values (self->trash_dirs), _g_list_free0 (values), _tmp0_);
	{
		GList* tv_collection;
		GList* tv_it;
		tv_collection = values;
		for (tv_it = tv_collection; tv_it != NULL; tv_it = tv_it->next) {
			DesktopAgnosticVFSTrashVolume* tv;
			tv = (DesktopAgnosticVFSTrashVolume*) tv_it->data;
			{
				desktop_agnostic_vfs_trash_volume_empty (tv);
			}
		}
	}
	_g_list_free0 (values);
}


static void _desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir_gnome_vfs_volume_monitor_volume_mounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self) {
	desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir (self, _sender, volume);
}


static void _desktop_agnostic_vfs_trash_gnome_vfs_remove_volume_gnome_vfs_volume_monitor_volume_unmounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self) {
	desktop_agnostic_vfs_trash_gnome_vfs_remove_volume (self, _sender, volume);
}


static gboolean desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs (DesktopAgnosticVFSTrashGnomeVFS* self) {
	gboolean result = FALSE;
	GnomeVFSVolumeMonitor* volume_monitor;
	GList* volumes;
	g_return_val_if_fail (self != NULL, FALSE);
	volume_monitor = NULL;
	volumes = NULL;
	volume_monitor = gnome_vfs_get_volume_monitor ();
	volumes = gnome_vfs_volume_monitor_get_mounted_volumes (volume_monitor);
	{
		GList* volume_collection;
		GList* volume_it;
		volume_collection = volumes;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GnomeVFSVolume* volume;
			volume = (GnomeVFSVolume*) volume_it->data;
			{
				desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir (self, volume_monitor, volume);
			}
		}
	}
	g_signal_connect_object (volume_monitor, "volume-mounted", (GCallback) _desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir_gnome_vfs_volume_monitor_volume_mounted, self, 0);
	g_signal_connect_object (volume_monitor, "volume-unmounted", (GCallback) _desktop_agnostic_vfs_trash_gnome_vfs_remove_volume_gnome_vfs_volume_monitor_volume_unmounted, self, 0);
	g_signal_emit_by_name ((DesktopAgnosticVFSTrash*) self, "file-count-changed");
	result = FALSE;
	return result;
}


static void desktop_agnostic_vfs_trash_gnome_vfs_check_volume_for_trash_dir (DesktopAgnosticVFSTrashGnomeVFS* self, GnomeVFSVolumeMonitor* vm, GnomeVFSVolume* vol) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	if (gnome_vfs_volume_handles_trash (vol)) {
		GnomeVFSResult res = 0;
		GnomeVFSURI* uri;
		GnomeVFSURI* trash_uri;
		GnomeVFSURI* _tmp0_;
		GnomeVFSURI* _tmp1_ = NULL;
		GnomeVFSResult _tmp2_;
		GnomeVFSURI* _tmp3_;
		uri = NULL;
		trash_uri = NULL;
		uri = (_tmp0_ = gnome_vfs_uri_new (gnome_vfs_volume_get_activation_uri (vol)), _gnome_vfs_uri_unref0 (uri), _tmp0_);
		res = (_tmp2_ = gnome_vfs_find_directory (uri, GNOME_VFS_DIRECTORY_KIND_TRASH, &_tmp1_, FALSE, TRUE, (guint) 0777), trash_uri = (_tmp3_ = _gnome_vfs_uri_ref0 (_tmp1_), _gnome_vfs_uri_unref0 (trash_uri), _tmp3_), _tmp2_);
		if (res == GNOME_VFS_OK) {
			DesktopAgnosticVFSTrashVolume* tv;
			DesktopAgnosticVFSTrashVolume* _tmp4_;
			DesktopAgnosticVFSTrashVolume* _tmp5_;
			tv = NULL;
			tv = (_tmp4_ = desktop_agnostic_vfs_trash_volume_new ((DesktopAgnosticVFSTrash*) self, trash_uri), _g_object_unref0 (tv), _tmp4_);
			g_hash_table_insert (self->trash_dirs, vol, (_tmp5_ = tv, tv = NULL, _tmp5_));
			g_message ("vfs-trash-impl-gnome-vfs.vala:254: Volume added");
			_g_object_unref0 (tv);
		}
		_gnome_vfs_uri_unref0 (trash_uri);
		_gnome_vfs_uri_unref0 (uri);
	}
}


static void desktop_agnostic_vfs_trash_gnome_vfs_remove_volume (DesktopAgnosticVFSTrashGnomeVFS* self, GnomeVFSVolumeMonitor* vm, GnomeVFSVolume* vol) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	if (((DesktopAgnosticVFSTrashVolume*) g_hash_table_lookup (self->trash_dirs, vol)) != NULL) {
		g_hash_table_remove (self->trash_dirs, vol);
	}
}


DesktopAgnosticVFSTrashGnomeVFS* desktop_agnostic_vfs_trash_gnome_vfs_construct (GType object_type) {
	DesktopAgnosticVFSTrashGnomeVFS * self = NULL;
	self = (DesktopAgnosticVFSTrashGnomeVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSTrashGnomeVFS* desktop_agnostic_vfs_trash_gnome_vfs_new (void) {
	return desktop_agnostic_vfs_trash_gnome_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS);
}


static guint desktop_agnostic_vfs_trash_gnome_vfs_real_get_file_count (DesktopAgnosticVFSTrash* base) {
	guint result;
	DesktopAgnosticVFSTrashGnomeVFS* self;
	guint total;
	GList* values;
	GList* _tmp0_;
	self = (DesktopAgnosticVFSTrashGnomeVFS*) base;
	total = (guint) 0;
	values = NULL;
	values = (_tmp0_ = g_hash_table_get_values (self->trash_dirs), _g_list_free0 (values), _tmp0_);
	{
		GList* tv_collection;
		GList* tv_it;
		tv_collection = values;
		for (tv_it = tv_collection; tv_it != NULL; tv_it = tv_it->next) {
			DesktopAgnosticVFSTrashVolume* tv;
			tv = (DesktopAgnosticVFSTrashVolume*) tv_it->data;
			{
				total = total + desktop_agnostic_vfs_trash_volume_get_file_count (tv);
			}
		}
	}
	result = total;
	_g_list_free0 (values);
	return result;
}


static gboolean _desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs_gsource_func (gpointer self) {
	gboolean result;
	result = desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs (self);
	return result;
}


static GObject * desktop_agnostic_vfs_trash_gnome_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSTrashGnomeVFS * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_trash_gnome_vfs_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS (obj);
	{
		GHashTable* _tmp0_;
		g_message ("vfs-trash-impl-gnome-vfs.vala:162: GNOME VFS Impl.");
		self->trash_dirs = (_tmp0_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, NULL, g_object_unref), _g_hash_table_unref0 (self->trash_dirs), _tmp0_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _desktop_agnostic_vfs_trash_gnome_vfs_search_for_trash_dirs_gsource_func, g_object_ref (self), g_object_unref);
	}
	return obj;
}


static void desktop_agnostic_vfs_trash_gnome_vfs_class_init (DesktopAgnosticVFSTrashGnomeVFSClass * klass) {
	desktop_agnostic_vfs_trash_gnome_vfs_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_trash_gnome_vfs_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_trash_gnome_vfs_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_trash_gnome_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_FILE_COUNT, "file-count");
}


static void desktop_agnostic_vfs_trash_gnome_vfs_desktop_agnostic_vfs_trash_interface_init (DesktopAgnosticVFSTrashIface * iface) {
	desktop_agnostic_vfs_trash_gnome_vfs_desktop_agnostic_vfs_trash_parent_iface = g_type_interface_peek_parent (iface);
	iface->send_to_trash = desktop_agnostic_vfs_trash_gnome_vfs_real_send_to_trash;
	iface->empty = desktop_agnostic_vfs_trash_gnome_vfs_real_empty;
	iface->get_file_count = desktop_agnostic_vfs_trash_gnome_vfs_real_get_file_count;
}


static void desktop_agnostic_vfs_trash_gnome_vfs_instance_init (DesktopAgnosticVFSTrashGnomeVFS * self) {
}


static void desktop_agnostic_vfs_trash_gnome_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSTrashGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS (obj);
	_g_hash_table_unref0 (self->trash_dirs);
	G_OBJECT_CLASS (desktop_agnostic_vfs_trash_gnome_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_trash_gnome_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_gnome_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_gnome_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSTrashGnomeVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_trash_gnome_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSTrashGnomeVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_trash_gnome_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_trash_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_trash_gnome_vfs_desktop_agnostic_vfs_trash_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_trash_gnome_vfs_type_id;
		desktop_agnostic_vfs_trash_gnome_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSTrashGnomeVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_trash_gnome_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, &desktop_agnostic_vfs_trash_info);
		g_once_init_leave (&desktop_agnostic_vfs_trash_gnome_vfs_type_id__volatile, desktop_agnostic_vfs_trash_gnome_vfs_type_id);
	}
	return desktop_agnostic_vfs_trash_gnome_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_trash_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSTrashGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_FILE_COUNT:
		g_value_set_uint (value, desktop_agnostic_vfs_trash_get_file_count ((DesktopAgnosticVFSTrash*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




