#if !defined (__FLYWEIGHT_HPP)
#define __FLYWEIGHT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  

namespace corelinux
{

   DECLARE_CLASS( Flyweight );

   /**
   Flyweight type is used to support large numbers of
   fine-grained objects.
   */

   class Flyweight
   {
   public:

      //
      // Constructors and destructor
      //

                           /// Default Constructor

                           Flyweight( void );

                           /**
                           Copy constructor
                           @param  Flyweight const reference
                           */

                           Flyweight( FlyweightCref );

                           /// Virtual Destructor  

      virtual              ~Flyweight( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Flyweight const reference
               @return Flyweight reference to self
               */
            
               FlyweightRef operator=( FlyweightCref );

               /**
               Equality operator overload
               @param Flyweight const reference
               @return true if equal, false otherwise
               */

               bool        operator==( FlyweightCref ) const;

      //
      // Accessors
      //


      //
      // Mutators
      //

   protected:


   private:

   };

}
          
#endif   // if !defined(__FLYWEIGHT_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


