//******************************************************************************
//  Copyright (c) 2005-2022 by Jan Van hijfte, Željan Rikalo
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QEVENT_C_H
#define QEVENT_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT void QInputEvent_Destroy(QInputEventH handle);
C_EXPORT unsigned int QInputEvent_modifiers(QInputEventH handle);
C_EXPORT void QInputEvent_setModifiers(QInputEventH handle, unsigned int amodifiers);
C_EXPORT ulong QInputEvent_timestamp(QInputEventH handle);
C_EXPORT void QInputEvent_setTimestamp(QInputEventH handle, ulong atimestamp);
C_EXPORT QInputDevice::DeviceType QInputEvent_deviceType(QInputEventH handle);

C_EXPORT QPointingDeviceUniqueIdH QPointingDeviceUniqeId_Create();
C_EXPORT qint64 QPointingDeviceUniqeId_numericId(QPointingDeviceUniqueIdH handle);
C_EXPORT bool QPointingDeviceUniqeId_isValid(QPointingDeviceUniqueIdH handle);
C_EXPORT void QPointingDeviceUniqeId_fromNumericId(qint64 id, QPointingDeviceUniqueIdH retval);

C_EXPORT QEventPointH QEventPoint_Create(const QEventPointH other);
C_EXPORT QEventPointH QEventPoint_Create2(int pointid, QEventPoint::State state, const QPointFH scenePosition, const QPointFH globalPosition);
C_EXPORT void QEventPoint_Destroy(QEventPointH handle);
C_EXPORT QPointingDeviceH QEventPoint_device(QEventPointH handle);
C_EXPORT void QEventPoint_ellipseDiameters(QEventPointH handle, QSizeFH retval);
C_EXPORT void QEventPoint_globalGrabPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_globalLastPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_globalPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_globalPressPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_grabPosition(QEventPointH handle, QPointFH retval);
C_EXPORT int QEventPoint_id(QEventPointH handle);
C_EXPORT bool QEventPoint_isAccepted(QEventPointH handle);
C_EXPORT void QEventPoint_lastPosition(QEventPointH handle, QPointFH retval);
C_EXPORT ulong QEventPoint_lastTimestamp(QEventPointH handle);
C_EXPORT void QEventPoint_normalizedPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_position(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_pressPosition(QEventPointH handle, QPointFH retval);
C_EXPORT ulong QEventPoint_pressTimestamp(QEventPointH handle);
C_EXPORT qreal QEventPoint_pressure(QEventPointH handle);
C_EXPORT qreal QEventPoint_rotation(QEventPointH handle);
C_EXPORT void QEventPoint_sceneGrabPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_sceneLastPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_scenePosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_scenePressPosition(QEventPointH handle, QPointFH retval);
C_EXPORT void QEventPoint_setAccepted(QEventPointH handle, bool accepted);
C_EXPORT QEventPoint::State QEventPoint_state(QEventPointH handle);
C_EXPORT qreal QEventPoint_timeHeld(QEventPointH handle);
C_EXPORT ulong QEventPoint_timestamp(QEventPointH handle);
C_EXPORT void QEventPoint_uniqueId(QEventPointH handle, QPointingDeviceUniqueIdH retval);
C_EXPORT void QEventPoint_velocity(QEventPointH handle, QVector2DH retval);

C_EXPORT bool QPointerEvent_allPointsAccepted(QPointerEventH handle);
C_EXPORT bool QPointerEvent_allPointsGrabbed(QPointerEventH handle);
C_EXPORT void QPointerEvent_point(QPointerEventH handle, qsizetype i, QEventPointH retval);
C_EXPORT QEventPointH QPointerEvent_pointById(QPointerEventH handle, int id);
C_EXPORT qsizetype QPointerEvent_pointCount(QPointerEventH handle);
C_EXPORT QPointingDevice::PointerType QPointerEvent_pointerType(QPointerEventH handle);
C_EXPORT QPointingDeviceH QPointerEvent_pointingDevice(QPointerEventH handle);
C_EXPORT void QPointerEvent_points(QPointerEventH handle, PPtrIntArray retval);
C_EXPORT void QPointerEvent_setAccepted(QPointerEventH handle, bool accepted);

C_EXPORT QInputDeviceH QInputDevice_Create();
C_EXPORT QInputDeviceH QInputDevice_Create2(QObjectH parent);
C_EXPORT QInputDeviceH QInputDevice_Create3(PWideString name, qint64 id, QInputDevice::DeviceType type, PWideString seatName, QObjectH parent);
C_EXPORT void QInputDevice_availableVirtualGeometry(QInputDeviceH handle, PRect retval);
C_EXPORT QInputDevice::Capabilities QInputDevice_capabilities(QInputDeviceH handle);
C_EXPORT bool QInputDevice_hasCapability(QInputDeviceH handle, const QInputDevice::Capability capability);
C_EXPORT void QInputDevice_name(QInputDeviceH handle, PWideString retval);
C_EXPORT void QInputDevice_seatName(QInputDeviceH handle, PWideString retval);
C_EXPORT qint64 QInputDevice_systemId(QInputDeviceH handle);
C_EXPORT QInputDevice::DeviceType QInputDevice_type(QInputDeviceH handle);
C_EXPORT void QInputDevice_devices(PPtrIntArray retval);
C_EXPORT QInputDeviceH QInputDevice_primaryKeyboard(PWideString seatName);

C_EXPORT QPointingDeviceH QPointingDevice_Create();
C_EXPORT QPointingDeviceH QPointingDevice_Create2(QObjectH parent);
C_EXPORT QPointingDeviceH QPointingDevice_Create3(PWideString name, qint64 id, QInputDevice::DeviceType type, QPointingDevice::PointerType pointerType, QInputDevice::Capabilities capabilities, int maxPoints, int buttonCount, PWideString seatName);
C_EXPORT int QPointingDevice_buttonCount(QPointingDeviceH handle);
C_EXPORT int QPointingDevice_maximumPoints(QPointingDeviceH handle);
C_EXPORT QPointingDevice::PointerType QPointingDevice_pointerType(QPointingDeviceH handle);
C_EXPORT void QPointingDevice_uniqueId(QPointingDeviceH handle, QPointingDeviceUniqueIdH retval);
C_EXPORT QPointingDeviceH QPointingDevice_primaryPointingDevice(const PWideString seatName);

C_EXPORT Qt::MouseButton QSinglePointEvent_button(QSinglePointEventH handle);
C_EXPORT Qt::MouseButtons QSinglePointEvent_buttons(QSinglePointEventH handle);
C_EXPORT QObjectH QSinglePointEvent_exclusivePointGrabber(QSinglePointEventH handle);
C_EXPORT void QSinglePointEvent_globalPosition(QSinglePointEventH handle, QPointFH retval);
C_EXPORT void QSinglePointEvent_position(QSinglePointEventH handle, QPointFH retval);
C_EXPORT void QSinglePointEvent_scenePosition(QSinglePointEventH handle, QPointFH retval);
C_EXPORT void QSinglePointEvent_setExclusivePointGrabber(QSinglePointEventH handle, QObjectH exclusiveGrabber);
C_EXPORT bool QSinglePointEvent_isBeginEvent(QSinglePointEventH handle);
C_EXPORT bool QSinglePointEvent_isEndEvent(QSinglePointEventH handle);
C_EXPORT bool QSinglePointEvent_isUpdateEvent(QSinglePointEventH handle);

C_EXPORT void QNativeGestureEvent_delta(QNativeGestureEventH handle, PQtPointF retval);
C_EXPORT int QNativeGestureEvent_fingerCount(QNativeGestureEventH handle);
C_EXPORT Qt::NativeGestureType QNativeGestureEvent_gestureType(QNativeGestureEventH handle);
C_EXPORT qreal QNativeGestureEvent_value(QNativeGestureEventH handle);

C_EXPORT QObjectH QTouchEvent_target(QTouchEventH handle);
C_EXPORT QEventPoint::States QTouchEvent_touchPointStates(QTouchEventH handle);
C_EXPORT QInputDeviceH QTouchEvent_device(QTouchEventH handle);
C_EXPORT bool QTouchEvent_isBeginEvent(QTouchEventH handle);
C_EXPORT bool QTouchEvent_isEndEvent(QTouchEventH handle);
C_EXPORT bool QTouchEvent_isUpdateEvent(QTouchEventH handle);

C_EXPORT QEnterEventH QEnterEvent_Create(const QPointFH localPos, const QPointFH windowPos, const QPointFH screenPos);
C_EXPORT void QEnterEvent_Destroy(QEnterEventH handle);
C_EXPORT void QEnterEvent_pos(QEnterEventH handle, PQtPoint retval);
C_EXPORT void QEnterEvent_globalPos(QEnterEventH handle, PQtPoint retval);
C_EXPORT int QEnterEvent_x(QEnterEventH handle);
C_EXPORT int QEnterEvent_y(QEnterEventH handle);
C_EXPORT int QEnterEvent_globalX(QEnterEventH handle);
C_EXPORT int QEnterEvent_globalY(QEnterEventH handle);
C_EXPORT void QEnterEvent_position(QEnterEventH handle, QPointFH retval);
C_EXPORT void QEnterEvent_windowPos(QEnterEventH handle, QPointFH retval);
C_EXPORT void QEnterEvent_screenPos(QEnterEventH handle, QPointFH retval);
C_EXPORT QMouseEventH QMouseEvent_Create(QEvent::Type type, const QPointFH localPos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT void QMouseEvent_Destroy(QMouseEventH handle);
C_EXPORT QMouseEventH QMouseEvent_Create2(QEvent::Type type, const QPointFH localPos, const QPointFH screenPos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT QMouseEventH QMouseEvent_Create3(QEvent::Type type, const QPointFH localPos, const QPointFH windowPos, const QPointFH screenPos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT void QMouseEvent_pos(QMouseEventH handle, PQtPoint retval);
C_EXPORT void QMouseEvent_globalPos(QMouseEventH handle, PQtPoint retval);
C_EXPORT int QMouseEvent_x(QMouseEventH handle);
C_EXPORT int QMouseEvent_y(QMouseEventH handle);
C_EXPORT int QMouseEvent_globalX(QMouseEventH handle);
C_EXPORT int QMouseEvent_globalY(QMouseEventH handle);
C_EXPORT void QMouseEvent_position(QMouseEventH handle, QPointFH retval);
C_EXPORT void QMouseEvent_windowPos(QEnterEventH handle, QPointFH retval);
C_EXPORT void QMouseEvent_screenPos(QEnterEventH handle, QPointFH retval);
C_EXPORT Qt::MouseButton QMouseEvent_button(QMouseEventH handle);
C_EXPORT unsigned int QMouseEvent_buttons(QMouseEventH handle);
C_EXPORT QHoverEventH QHoverEvent_Create(QEvent::Type type, const QPointFH pos, const QPointFH oldPos, unsigned int modifiers);
C_EXPORT void QHoverEvent_Destroy(QHoverEventH handle);
C_EXPORT void QHoverEvent_pos(QHoverEventH handle, PQtPoint retval);
C_EXPORT void QHoverEvent_oldPos(QHoverEventH handle, PQtPoint retval);
C_EXPORT void QHoverEvent_position(QHoverEventH handle, QPointFH retval);
C_EXPORT void QHoverEvent_oldPosF(QHoverEventH handle, QPointFH retval);
C_EXPORT void QWheelEvent_Destroy(QWheelEventH handle);
C_EXPORT QWheelEventH QWheelEvent_Create(const QPointFH pos, const QPointFH globalPos, PQtPoint pixelDelta, PQtPoint angleDelta, Qt::MouseButtons buttons, Qt::KeyboardModifiers modifiers, Qt::ScrollPhase phase, bool inverted, Qt::MouseEventSource source);
C_EXPORT void QWheelEvent_pixelDelta(QWheelEventH handle, PQtPoint retval);
C_EXPORT void QWheelEvent_angleDelta(QWheelEventH handle, PQtPoint retval);
C_EXPORT void QWheelEvent_pos(QWheelEventH handle, PQtPoint retval);
C_EXPORT void QWheelEvent_globalPos(QWheelEventH handle, PQtPoint retval);
C_EXPORT int QWheelEvent_x(QWheelEventH handle);
C_EXPORT int QWheelEvent_y(QWheelEventH handle);
C_EXPORT int QWheelEvent_globalX(QWheelEventH handle);
C_EXPORT int QWheelEvent_globalY(QWheelEventH handle);
C_EXPORT void QWheelEvent_position(QWheelEventH handle, QPointFH retval);
C_EXPORT void QWheelEvent_globalPosition(QWheelEventH handle, QPointFH retval);
C_EXPORT unsigned int QWheelEvent_buttons(QWheelEventH handle);
C_EXPORT bool QWheelEvent_inverted(QWheelEventH handle);
C_EXPORT Qt::ScrollPhase QWheelEvent_phase(QWheelEventH handle);
C_EXPORT Qt::MouseEventSource QWheelEvent_source(QWheelEventH handle);
C_EXPORT QTabletEventH QTabletEvent_Create(QEvent::Type t,  const QPointingDeviceH dev, const QPointFH pos, const QPointFH globalPos, qreal pressure, float xTilt, float yTilt, float tangentialPressure, qreal rotation, float z, unsigned int keyState, unsigned int button, unsigned int buttons);
C_EXPORT void QTabletEvent_Destroy(QTabletEventH handle);
C_EXPORT void QTabletEvent_pos(QTabletEventH handle, PQtPoint retval);
C_EXPORT void QTabletEvent_globalPos(QTabletEventH handle, PQtPoint retval);
C_EXPORT void QTabletEvent_position(QTabletEventH handle, QPointFH retval);
C_EXPORT void QTabletEvent_globalPosition(QTabletEventH handle, QPointFH retval);
C_EXPORT int QTabletEvent_x(QTabletEventH handle);
C_EXPORT int QTabletEvent_y(QTabletEventH handle);
C_EXPORT int QTabletEvent_globalX(QTabletEventH handle);
C_EXPORT int QTabletEvent_globalY(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_hiResGlobalX(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_hiResGlobalY(QTabletEventH handle);
C_EXPORT QInputDevice::DeviceType QTabletEvent_deviceType(QTabletEventH handle);
C_EXPORT QPointingDevice::PointerType QTabletEvent_pointerType(QTabletEventH handle);
C_EXPORT qint64 QTabletEvent_uniqueId(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_pressure(QTabletEventH handle);
C_EXPORT int QTabletEvent_z(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_tangentialPressure(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_rotation(QTabletEventH handle);
C_EXPORT int QTabletEvent_xTilt(QTabletEventH handle);
C_EXPORT int QTabletEvent_yTilt(QTabletEventH handle);
C_EXPORT QKeyEventH QKeyEvent_Create(QEvent::Type type, int key, unsigned int modifiers, PWideString text, bool autorep, ushort count);
C_EXPORT void QKeyEvent_Destroy(QKeyEventH handle);
C_EXPORT QKeyEventH QKeyEvent_Create2(QEvent::Type type, int key, unsigned int modifiers, quint32 nativeScanCode, quint32 nativeVirtualKey, quint32 nativeModifiers, PWideString text, bool autorep, ushort count);
C_EXPORT int QKeyEvent_key(QKeyEventH handle);
C_EXPORT bool QKeyEvent_matches(QKeyEventH handle, QKeySequence::StandardKey key);
C_EXPORT unsigned int QKeyEvent_modifiers(QKeyEventH handle);
C_EXPORT void QKeyEvent_text(QKeyEventH handle, PWideString retval);
C_EXPORT bool QKeyEvent_isAutoRepeat(QKeyEventH handle);
C_EXPORT int QKeyEvent_count(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeScanCode(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeVirtualKey(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeModifiers(QKeyEventH handle);
C_EXPORT void QKeyEvent_keyCombination(QKeyEventH handle, QKeyCombinationH retval);
C_EXPORT QFocusEventH QFocusEvent_Create(QEvent::Type type, Qt::FocusReason reason);
C_EXPORT void QFocusEvent_Destroy(QFocusEventH handle);
C_EXPORT bool QFocusEvent_gotFocus(QFocusEventH handle);
C_EXPORT bool QFocusEvent_lostFocus(QFocusEventH handle);
C_EXPORT Qt::FocusReason QFocusEvent_reason(QFocusEventH handle);
C_EXPORT QPaintEventH QPaintEvent_Create(const QRegionH paintRegion);
C_EXPORT void QPaintEvent_Destroy(QPaintEventH handle);
C_EXPORT QPaintEventH QPaintEvent_Create2(PRect paintRect);
C_EXPORT void QPaintEvent_rect(QPaintEventH handle, PRect retval);
C_EXPORT const QRegionH QPaintEvent_region(QPaintEventH handle);
C_EXPORT QMoveEventH QMoveEvent_Create(const QPointH pos, const QPointH oldPos);
C_EXPORT void QMoveEvent_Destroy(QMoveEventH handle);
C_EXPORT const QPointH QMoveEvent_pos(QMoveEventH handle);
C_EXPORT const QPointH QMoveEvent_oldPos(QMoveEventH handle);
C_EXPORT QExposeEventH QExposeEvent_Create(const QRegionH rgn);
C_EXPORT void QExposeEvent_Destroy(QExposeEventH handle);
C_EXPORT const QRegionH QExposeEvent_region(QExposeEventH handle);
C_EXPORT QResizeEventH QResizeEvent_Create(const QSizeH size, const QSizeH oldSize);
C_EXPORT void QResizeEvent_Destroy(QResizeEventH handle);
C_EXPORT const QSizeH QResizeEvent_size(QResizeEventH handle);
C_EXPORT const QSizeH QResizeEvent_oldSize(QResizeEventH handle);
C_EXPORT QCloseEventH QCloseEvent_Create();
C_EXPORT void QCloseEvent_Destroy(QCloseEventH handle);
C_EXPORT QIconDragEventH QIconDragEvent_Create();
C_EXPORT void QIconDragEvent_Destroy(QIconDragEventH handle);
C_EXPORT QShowEventH QShowEvent_Create();
C_EXPORT void QShowEvent_Destroy(QShowEventH handle);
C_EXPORT QHideEventH QHideEvent_Create();
C_EXPORT void QHideEvent_Destroy(QHideEventH handle);
C_EXPORT QContextMenuEventH QContextMenuEvent_Create(QContextMenuEvent::Reason reason, const QPointH pos, const QPointH globalPos, unsigned int modifiers);
C_EXPORT void QContextMenuEvent_Destroy(QContextMenuEventH handle);
C_EXPORT QContextMenuEventH QContextMenuEvent_Create2(QContextMenuEvent::Reason reason, const QPointH pos, const QPointH globalPos);
C_EXPORT QContextMenuEventH QContextMenuEvent_Create3(QContextMenuEvent::Reason reason, const QPointH pos);
C_EXPORT int QContextMenuEvent_x(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_y(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_globalX(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_globalY(QContextMenuEventH handle);
C_EXPORT const QPointH QContextMenuEvent_pos(QContextMenuEventH handle);
C_EXPORT const QPointH QContextMenuEvent_globalPos(QContextMenuEventH handle);
C_EXPORT QContextMenuEvent::Reason QContextMenuEvent_reason(QContextMenuEventH handle);
C_EXPORT QInputMethodEventH QInputMethodEvent_Create();
C_EXPORT void QInputMethodEvent_Destroy(QInputMethodEventH handle);
C_EXPORT void QInputMethodEvent_setCommitString(QInputMethodEventH handle, PWideString commitString, int replaceFrom, int replaceLength);
C_EXPORT void QInputMethodEvent_preeditString(QInputMethodEventH handle, PWideString retval);
C_EXPORT void QInputMethodEvent_commitString(QInputMethodEventH handle, PWideString retval);
C_EXPORT int QInputMethodEvent_replacementStart(QInputMethodEventH handle);
C_EXPORT int QInputMethodEvent_replacementLength(QInputMethodEventH handle);
C_EXPORT QInputMethodQueryEventH QInputMethodQueryEvent_Create(unsigned int queries);
C_EXPORT void QInputMethodQueryEvent_Destroy(QInputMethodQueryEventH handle);
C_EXPORT unsigned int QInputMethodQueryEvent_queries(QInputMethodQueryEventH handle);
C_EXPORT void QInputMethodQueryEvent_setValue(QInputMethodQueryEventH handle, Qt::InputMethodQuery query, const QVariantH value);
C_EXPORT void QInputMethodQueryEvent_value(QInputMethodQueryEventH handle, QVariantH retval, Qt::InputMethodQuery query);
C_EXPORT QDropEventH QDropEvent_Create(const QPointFH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers, QEvent::Type type);
C_EXPORT void QDropEvent_Destroy(QDropEventH handle);
C_EXPORT void QDropEvent_pos(QDropEventH handle, PQtPoint retval);
C_EXPORT void QDropEvent_position(QDropEventH handle, QPointFH retval);
C_EXPORT unsigned int QDropEvent_mouseButtons(QDropEventH handle);
C_EXPORT unsigned int QDropEvent_keyboardModifiers(QDropEventH handle);
C_EXPORT unsigned int QDropEvent_possibleActions(QDropEventH handle);
C_EXPORT Qt::DropAction QDropEvent_proposedAction(QDropEventH handle);
C_EXPORT void QDropEvent_acceptProposedAction(QDropEventH handle);
C_EXPORT Qt::DropAction QDropEvent_dropAction(QDropEventH handle);
C_EXPORT void QDropEvent_setDropAction(QDropEventH handle, Qt::DropAction action);
C_EXPORT QObjectH QDropEvent_source(QDropEventH handle);
C_EXPORT const QMimeDataH QDropEvent_mimeData(QDropEventH handle);
C_EXPORT QDragMoveEventH QDragMoveEvent_Create(const QPointH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers, QEvent::Type type);
C_EXPORT void QDragMoveEvent_Destroy(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_answerRect(QDragMoveEventH handle, PRect retval);
C_EXPORT void QDragMoveEvent_accept(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_ignore(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_accept2(QDragMoveEventH handle, PRect r);
C_EXPORT void QDragMoveEvent_ignore2(QDragMoveEventH handle, PRect r);
C_EXPORT QDragEnterEventH QDragEnterEvent_Create(const QPointH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers);
C_EXPORT void QDragEnterEvent_Destroy(QDragEnterEventH handle);
C_EXPORT QDragLeaveEventH QDragLeaveEvent_Create();
C_EXPORT void QDragLeaveEvent_Destroy(QDragLeaveEventH handle);
C_EXPORT QHelpEventH QHelpEvent_Create(QEvent::Type type, const QPointH pos, const QPointH globalPos);
C_EXPORT void QHelpEvent_Destroy(QHelpEventH handle);
C_EXPORT int QHelpEvent_x(QHelpEventH handle);
C_EXPORT int QHelpEvent_y(QHelpEventH handle);
C_EXPORT int QHelpEvent_globalX(QHelpEventH handle);
C_EXPORT int QHelpEvent_globalY(QHelpEventH handle);
C_EXPORT const QPointH QHelpEvent_pos(QHelpEventH handle);
C_EXPORT const QPointH QHelpEvent_globalPos(QHelpEventH handle);
C_EXPORT QStatusTipEventH QStatusTipEvent_Create(PWideString tip);
C_EXPORT void QStatusTipEvent_Destroy(QStatusTipEventH handle);
C_EXPORT void QStatusTipEvent_tip(QStatusTipEventH handle, PWideString retval);
C_EXPORT QWhatsThisClickedEventH QWhatsThisClickedEvent_Create(PWideString href);
C_EXPORT void QWhatsThisClickedEvent_Destroy(QWhatsThisClickedEventH handle);
C_EXPORT void QWhatsThisClickedEvent_href(QWhatsThisClickedEventH handle, PWideString retval);
C_EXPORT QActionEventH QActionEvent_Create(int type, QActionH action, QActionH before);
C_EXPORT void QActionEvent_Destroy(QActionEventH handle);
C_EXPORT QActionH QActionEvent_action(QActionEventH handle);
C_EXPORT QActionH QActionEvent_before(QActionEventH handle);
C_EXPORT QFileOpenEventH QFileOpenEvent_Create(PWideString file);
C_EXPORT void QFileOpenEvent_Destroy(QFileOpenEventH handle);
C_EXPORT QFileOpenEventH QFileOpenEvent_Create2(const QUrlH url);
C_EXPORT void QFileOpenEvent_file(QFileOpenEventH handle, PWideString retval);
C_EXPORT void QFileOpenEvent_url(QFileOpenEventH handle, QUrlH retval);
C_EXPORT bool QFileOpenEvent_openFile(QFileOpenEventH handle, QFileH file, unsigned int flags);
C_EXPORT QShortcutEventH QShortcutEvent_Create(const QKeySequenceH key, int id, bool ambiguous);
C_EXPORT void QShortcutEvent_Destroy(QShortcutEventH handle);
C_EXPORT const QKeySequenceH QShortcutEvent_key(QShortcutEventH handle);
C_EXPORT int QShortcutEvent_shortcutId(QShortcutEventH handle);
C_EXPORT bool QShortcutEvent_isAmbiguous(QShortcutEventH handle);
C_EXPORT QWindowStateChangeEventH QWindowStateChangeEvent_Create(unsigned int aOldState, bool isOverride);
C_EXPORT void QWindowStateChangeEvent_Destroy(QWindowStateChangeEventH handle);
C_EXPORT unsigned int QWindowStateChangeEvent_oldState(QWindowStateChangeEventH handle);
C_EXPORT bool QWindowStateChangeEvent_isOverride(QWindowStateChangeEventH handle);

C_EXPORT QScrollPrepareEventH QScrollPrepareEvent_Create(const QPointFH startPos);
C_EXPORT void QScrollPrepareEvent_Destroy(QScrollPrepareEventH handle);
C_EXPORT void QScrollPrepareEvent_startPos(QScrollPrepareEventH handle, PQtPointF retval);
C_EXPORT void QScrollPrepareEvent_viewportSize(QScrollPrepareEventH handle, QSizeFH retval);
C_EXPORT void QScrollPrepareEvent_contentPosRange(QScrollPrepareEventH handle, QRectFH retval);
C_EXPORT void QScrollPrepareEvent_contentPos(QScrollPrepareEventH handle, PQtPointF retval);
C_EXPORT void QScrollPrepareEvent_setViewportSize(QScrollPrepareEventH handle, const QSizeFH size);
C_EXPORT void QScrollPrepareEvent_setContentPosRange(QScrollPrepareEventH handle, const QRectFH rect);
C_EXPORT void QScrollPrepareEvent_setContentPos(QScrollPrepareEventH handle, const QPointFH pos);
C_EXPORT QScrollEventH QScrollEvent_Create(const QPointFH contentPos, const QPointFH overshoot, QScrollEvent::ScrollState scrollState);
C_EXPORT void QScrollEvent_Destroy(QScrollEventH handle);
C_EXPORT void QScrollEvent_contentPos(QScrollEventH handle, PQtPointF retval);
C_EXPORT void QScrollEvent_overshootDistance(QScrollEventH handle, PQtPointF retval);
C_EXPORT QScrollEvent::ScrollState QScrollEvent_scrollState(QScrollEventH handle);
C_EXPORT QScreenOrientationChangeEventH QScreenOrientationChangeEvent_Create(QScreenH screen, Qt::ScreenOrientation orientation);
C_EXPORT void QScreenOrientationChangeEvent_Destroy(QScreenOrientationChangeEventH handle);
C_EXPORT QScreenH QScreenOrientationChangeEvent_screen(QScreenOrientationChangeEventH handle);
C_EXPORT Qt::ScreenOrientation QScreenOrientationChangeEvent_orientation(QScreenOrientationChangeEventH handle);
C_EXPORT QApplicationStateChangeEventH QApplicationStateChangeEvent_Create(Qt::ApplicationState state);
C_EXPORT void QApplicationStateChangeEvent_Destroy(QApplicationStateChangeEventH handle);
C_EXPORT Qt::ApplicationState QApplicationStateChangeEvent_applicationState(QApplicationStateChangeEventH handle);

#endif
