{-
    Kaya - My favourite toy language.
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU General
    Public Licence. See COPYING for licence.
-}

module VarUsage where

{- check whether a variable is used outside the current block, or
just locally. If it's just local, it need not be heap allocated and can
just go on the stack, which is quicker -}

import Language
import Debug.Trace

{- A variable is used if:
     * it, on its own, is an argument to a function or closure
           (TODO: but also check propagation in the function)
     * it appears, on its own, on the rhs of an lvalue
           (TODO: unless the lvalue itself is unused)   
     * it appears, on its own, in an array construction
     * it is returned from a function
     * it is a component of an exception
-}

isUsed :: Int -> Expr Name -> Bool
isUsed _ _ = True -- Actually, we do it dynamically now
{-
isUsed n exp = foldsubexpr unm (||) False exp
   where unm (Apply _ args) = isUsedL args
         unm (Partial _ args _) = isUsedL args
         unm (Assign _ a) | a == (Loc n) = True
                          | otherwise = isUsed n a
         unm (ArrayInit args) = isUsedL args
         unm (Return x) = usedLoc x
         unm (Except x y) = usedLoc x || usedLoc y
         unm x = isUsed n x

         isUsedL [] = False
         isUsedL ((Loc i):xs) | i==n = True
                              | otherwise = isUsedL xs
         isUsedL (x:xs) = isUsed n x || isUsedL xs

         usedLoc (Loc i) = i == n
         usedLoc _ = False
-}