/* graphmodel.c generated by valac 0.22.1, the Vala compiler
 * generated from graphmodel.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GRAPH_MODEL (graph_model_get_type ())
#define GRAPH_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPH_MODEL, GraphModel))
#define GRAPH_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPH_MODEL, GraphModelClass))
#define IS_GRAPH_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPH_MODEL))
#define IS_GRAPH_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPH_MODEL))
#define GRAPH_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPH_MODEL, GraphModelClass))

typedef struct _GraphModel GraphModel;
typedef struct _GraphModelClass GraphModelClass;
typedef struct _GraphModelPrivate GraphModelPrivate;

#define TYPE_PROVIDERS (providers_get_type ())
#define PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROVIDERS, Providers))
#define PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROVIDERS, ProvidersClass))
#define IS_PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROVIDERS))
#define IS_PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROVIDERS))
#define PROVIDERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROVIDERS, ProvidersClass))

typedef struct _Providers Providers;
typedef struct _ProvidersClass ProvidersClass;

#define TYPE_EXPRESSION_CACHE (expression_cache_get_type ())
#define EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_CACHE, ExpressionCache))
#define EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))
#define IS_EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_CACHE))
#define IS_EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_CACHE))
#define EXPRESSION_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))

typedef struct _ExpressionCache ExpressionCache;
typedef struct _ExpressionCacheClass ExpressionCacheClass;

#define TYPE_TRACE_MODEL (trace_model_get_type ())
#define TRACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACE_MODEL, TraceModel))
#define TRACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACE_MODEL, TraceModelClass))
#define IS_TRACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACE_MODEL))
#define IS_TRACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACE_MODEL))
#define TRACE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACE_MODEL, TraceModelClass))

typedef struct _TraceModel TraceModel;
typedef struct _TraceModelClass TraceModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GraphModel {
	GObject parent_instance;
	GraphModelPrivate * priv;
};

struct _GraphModelClass {
	GObjectClass parent_class;
};

struct _GraphModelPrivate {
	guint smoothvalue;
	gdouble* scalerhistory;
	gint scalerhistory_length1;
	gint _scalerhistory_size_;
	gchar* _id;
	Providers* _providers;
	ExpressionCache* _minimum;
	ExpressionCache* _maximum;
	gchar* _smooth;
	gboolean _enabled;
	gchar** _traces;
	gint _traces_length1;
	gint __traces_size_;
	gdouble _scale;
	TraceModel** _tracemodels;
	gint _tracemodels_length1;
	gint __tracemodels_size_;
};


static gpointer graph_model_parent_class = NULL;

GType graph_model_get_type (void) G_GNUC_CONST;
GType providers_get_type (void) G_GNUC_CONST;
GType expression_cache_get_type (void) G_GNUC_CONST;
GType trace_model_get_type (void) G_GNUC_CONST;
#define GRAPH_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRAPH_MODEL, GraphModelPrivate))
enum  {
	GRAPH_MODEL_DUMMY_PROPERTY,
	GRAPH_MODEL_ID,
	GRAPH_MODEL_PROVIDERS,
	GRAPH_MODEL_MINIMUM,
	GRAPH_MODEL_MAXIMUM,
	GRAPH_MODEL_SMOOTH,
	GRAPH_MODEL_ENABLED,
	GRAPH_MODEL_TRACES,
	GRAPH_MODEL_SCALE
};
GraphModel* graph_model_new (const gchar* id, Providers* providers);
GraphModel* graph_model_construct (GType object_type, const gchar* id, Providers* providers);
ExpressionCache* expression_cache_new (Providers* providers, const gchar* expression);
ExpressionCache* expression_cache_construct (GType object_type, Providers* providers, const gchar* expression);
void graph_model_update (GraphModel* self, guint trace_length);
TraceModel** graph_model_get_tracemodels (GraphModel* self, int* result_length1);
void trace_model_set_values_length (TraceModel* self, guint length);
ExpressionCache* trace_model_get_expression (TraceModel* self);
void expression_cache_update (ExpressionCache* self);
void trace_model_add_value (TraceModel* self, gdouble value);
gchar* expression_cache_label (ExpressionCache* self);
ExpressionCache* graph_model_get_minimum (GraphModel* self);
ExpressionCache* graph_model_get_maximum (GraphModel* self);
static void graph_model_update_scale (GraphModel* self, gdouble scalerminimum, gdouble scalermaximum, guint trace_length);
gboolean trace_model_get_enabled (TraceModel* self);
gdouble* trace_model_get_values (TraceModel* self, int* result_length1);
gdouble utils_max (gdouble* data, int data_length1);
gdouble utils_mean (gdouble* data, int data_length1);
static void graph_model_set_scale (GraphModel* self, gdouble value);
const gchar* graph_model_get_id (GraphModel* self);
static void graph_model_set_id (GraphModel* self, const gchar* value);
Providers* graph_model_get_providers (GraphModel* self);
static void graph_model_set_providers (GraphModel* self, Providers* value);
static void graph_model_set_minimum (GraphModel* self, ExpressionCache* value);
static void graph_model_set_maximum (GraphModel* self, ExpressionCache* value);
const gchar* graph_model_get_smooth (GraphModel* self);
void graph_model_set_smooth (GraphModel* self, const gchar* value);
gboolean graph_model_get_enabled (GraphModel* self);
void graph_model_set_enabled (GraphModel* self, gboolean value);
gchar** graph_model_get_traces (GraphModel* self, int* result_length1);
void graph_model_set_traces (GraphModel* self, gchar** value, int value_length1);
static gchar** _vala_array_dup10 (gchar** self, int length);
gdouble graph_model_get_scale (GraphModel* self);
static void graph_model_set_tracemodels (GraphModel* self, TraceModel** value, int value_length1);
static TraceModel** _vala_array_dup11 (TraceModel** self, int length);
static GObject * graph_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _graph_model___lambda4_ (GraphModel* self);
static void __graph_model___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _graph_model___lambda5_ (GraphModel* self);
TraceModel* trace_model_new (Providers* providers);
TraceModel* trace_model_construct (GType object_type, Providers* providers);
static void _vala_array_add10 (TraceModel*** array, int* length, int* size, TraceModel* value);
static TraceModel** _vala_array_dup12 (TraceModel** self, int length);
static void __graph_model___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void graph_model_finalize (GObject* obj);
static void _vala_graph_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_graph_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GraphModel* graph_model_construct (GType object_type, const gchar* id, Providers* providers) {
	GraphModel * self = NULL;
	const gchar* _tmp0_ = NULL;
	Providers* _tmp1_ = NULL;
	Providers* _tmp2_ = NULL;
	ExpressionCache* _tmp3_ = NULL;
	ExpressionCache* _tmp4_ = NULL;
	Providers* _tmp5_ = NULL;
	ExpressionCache* _tmp6_ = NULL;
	ExpressionCache* _tmp7_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (IS_PROVIDERS (providers), NULL);
	_tmp0_ = id;
	_tmp1_ = providers;
	_tmp2_ = providers;
	_tmp3_ = expression_cache_new (_tmp2_, "");
	_tmp4_ = _tmp3_;
	_tmp5_ = providers;
	_tmp6_ = expression_cache_new (_tmp5_, "");
	_tmp7_ = _tmp6_;
	self = (GraphModel*) g_object_new (object_type, "id", _tmp0_, "providers", _tmp1_, "minimum", _tmp4_, "maximum", _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	return self;
}


GraphModel* graph_model_new (const gchar* id, Providers* providers) {
	return graph_model_construct (TYPE_GRAPH_MODEL, id, providers);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


void graph_model_update (GraphModel* self, guint trace_length) {
	TraceModel** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	TraceModel** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gdouble scalerminimum = 0.0;
	ExpressionCache* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble scalermaximum = 0.0;
	ExpressionCache* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	guint _tmp25_ = 0U;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = graph_model_get_tracemodels (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	{
		TraceModel** tracemodel_collection = NULL;
		gint tracemodel_collection_length1 = 0;
		gint _tracemodel_collection_size_ = 0;
		gint tracemodel_it = 0;
		tracemodel_collection = _tmp1_;
		tracemodel_collection_length1 = _tmp1__length1;
		for (tracemodel_it = 0; tracemodel_it < _tmp1__length1; tracemodel_it = tracemodel_it + 1) {
			TraceModel* _tmp2_ = NULL;
			TraceModel* tracemodel = NULL;
			_tmp2_ = _g_object_ref0 (tracemodel_collection[tracemodel_it]);
			tracemodel = _tmp2_;
			{
				TraceModel* _tmp3_ = NULL;
				guint _tmp4_ = 0U;
				TraceModel* _tmp5_ = NULL;
				ExpressionCache* _tmp6_ = NULL;
				ExpressionCache* _tmp7_ = NULL;
				TraceModel* _tmp8_ = NULL;
				TraceModel* _tmp9_ = NULL;
				ExpressionCache* _tmp10_ = NULL;
				ExpressionCache* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gdouble _tmp14_ = 0.0;
				_tmp3_ = tracemodel;
				_tmp4_ = trace_length;
				trace_model_set_values_length (_tmp3_, _tmp4_);
				_tmp5_ = tracemodel;
				_tmp6_ = trace_model_get_expression (_tmp5_);
				_tmp7_ = _tmp6_;
				expression_cache_update (_tmp7_);
				_tmp8_ = tracemodel;
				_tmp9_ = tracemodel;
				_tmp10_ = trace_model_get_expression (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = expression_cache_label (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = double_parse (_tmp13_);
				trace_model_add_value (_tmp8_, _tmp14_);
				_g_free0 (_tmp13_);
				_g_object_unref0 (tracemodel);
			}
		}
	}
	_tmp15_ = self->priv->_minimum;
	_tmp16_ = expression_cache_label (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = double_parse (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	scalerminimum = _tmp19_;
	_tmp20_ = self->priv->_maximum;
	_tmp21_ = expression_cache_label (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = double_parse (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	scalermaximum = _tmp24_;
	_tmp25_ = trace_length;
	graph_model_update_scale (self, scalerminimum, scalermaximum, _tmp25_);
}


static void graph_model_update_scale (GraphModel* self, gdouble scalerminimum, gdouble scalermaximum, guint trace_length) {
	gdouble currentpeak = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gdouble historymaximum = 0.0;
	gdouble* _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gdouble* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gdouble* _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	gdouble _tmp68_ = 0.0;
	gdouble _tmp69_ = 0.0;
	gdouble* _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gdouble _tmp71_ = 0.0;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = scalerminimum;
	currentpeak = _tmp0_;
	{
		guint i = 0U;
		guint isize = 0U;
		guint _tmp1_ = 0U;
		i = (guint) 0;
		_tmp1_ = trace_length;
		isize = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				guint _tmp5_ = 0U;
				guint _tmp6_ = 0U;
				gdouble currentvalue = 0.0;
				TraceModel** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				TraceModel** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gdouble _tmp19_ = 0.0;
				gdouble _tmp20_ = 0.0;
				gdouble _tmp21_ = 0.0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					guint _tmp4_ = 0U;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = isize;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				currentvalue = (gdouble) 0;
				_tmp7_ = graph_model_get_tracemodels (self, &_tmp7__length1);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _tmp7__length1;
				{
					TraceModel** tracemodel_collection = NULL;
					gint tracemodel_collection_length1 = 0;
					gint _tracemodel_collection_size_ = 0;
					gint tracemodel_it = 0;
					tracemodel_collection = _tmp8_;
					tracemodel_collection_length1 = _tmp8__length1;
					for (tracemodel_it = 0; tracemodel_it < _tmp8__length1; tracemodel_it = tracemodel_it + 1) {
						TraceModel* _tmp9_ = NULL;
						TraceModel* tracemodel = NULL;
						_tmp9_ = _g_object_ref0 (tracemodel_collection[tracemodel_it]);
						tracemodel = _tmp9_;
						{
							TraceModel* _tmp10_ = NULL;
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							_tmp10_ = tracemodel;
							_tmp11_ = trace_model_get_enabled (_tmp10_);
							_tmp12_ = _tmp11_;
							if (_tmp12_) {
								gdouble _tmp13_ = 0.0;
								TraceModel* _tmp14_ = NULL;
								gdouble* _tmp15_ = NULL;
								gint _tmp15__length1 = 0;
								gdouble* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								guint _tmp17_ = 0U;
								gdouble _tmp18_ = 0.0;
								_tmp13_ = currentvalue;
								_tmp14_ = tracemodel;
								_tmp15_ = trace_model_get_values (_tmp14_, &_tmp15__length1);
								_tmp16_ = _tmp15_;
								_tmp16__length1 = _tmp15__length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								currentvalue = _tmp13_ + _tmp18_;
							}
							_g_object_unref0 (tracemodel);
						}
					}
				}
				_tmp19_ = currentpeak;
				_tmp20_ = currentvalue;
				_tmp21_ = MAX (_tmp19_, _tmp20_);
				currentpeak = _tmp21_;
			}
		}
	}
	_tmp22_ = scalermaximum;
	if (_tmp22_ != ((gdouble) 0)) {
		gdouble _tmp23_ = 0.0;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		_tmp23_ = currentpeak;
		_tmp24_ = scalermaximum;
		_tmp25_ = MIN (_tmp23_, _tmp24_);
		currentpeak = _tmp25_;
	}
	_tmp26_ = self->priv->scalerhistory;
	_tmp26__length1 = self->priv->scalerhistory_length1;
	if (_tmp26__length1 == 0) {
		guint _tmp27_ = 0U;
		guint _tmp28_ = 0U;
		gdouble* _tmp29_ = NULL;
		_tmp27_ = self->priv->smoothvalue;
		_tmp28_ = CLAMP (_tmp27_, (guint) 1, (guint) 128);
		_tmp29_ = g_new0 (gdouble, _tmp28_);
		self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
		self->priv->scalerhistory = _tmp29_;
		self->priv->scalerhistory_length1 = _tmp28_;
		self->priv->_scalerhistory_size_ = self->priv->scalerhistory_length1;
		{
			guint i = 0U;
			guint isize = 0U;
			gdouble* _tmp30_ = NULL;
			gint _tmp30__length1 = 0;
			i = (guint) 0;
			_tmp30_ = self->priv->scalerhistory;
			_tmp30__length1 = self->priv->scalerhistory_length1;
			isize = (guint) _tmp30__length1;
			{
				gboolean _tmp31_ = FALSE;
				_tmp31_ = TRUE;
				while (TRUE) {
					gboolean _tmp32_ = FALSE;
					guint _tmp34_ = 0U;
					guint _tmp35_ = 0U;
					gdouble* _tmp36_ = NULL;
					gint _tmp36__length1 = 0;
					guint _tmp37_ = 0U;
					gdouble _tmp38_ = 0.0;
					gdouble _tmp39_ = 0.0;
					_tmp32_ = _tmp31_;
					if (!_tmp32_) {
						guint _tmp33_ = 0U;
						_tmp33_ = i;
						i = _tmp33_ + 1;
					}
					_tmp31_ = FALSE;
					_tmp34_ = i;
					_tmp35_ = isize;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = self->priv->scalerhistory;
					_tmp36__length1 = self->priv->scalerhistory_length1;
					_tmp37_ = i;
					_tmp38_ = scalerminimum;
					_tmp36_[_tmp37_] = _tmp38_;
					_tmp39_ = _tmp36_[_tmp37_];
				}
			}
		}
	}
	_tmp40_ = self->priv->scalerhistory;
	_tmp40__length1 = self->priv->scalerhistory_length1;
	_tmp41_ = utils_max (_tmp40_, _tmp40__length1);
	historymaximum = _tmp41_;
	_tmp42_ = currentpeak;
	_tmp43_ = historymaximum;
	if (_tmp42_ < _tmp43_) {
		{
			guint i = 0U;
			guint isize = 0U;
			gdouble* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			i = (guint) 0;
			_tmp44_ = self->priv->scalerhistory;
			_tmp44__length1 = self->priv->scalerhistory_length1;
			isize = (guint) _tmp44__length1;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gboolean _tmp46_ = FALSE;
					guint _tmp48_ = 0U;
					guint _tmp49_ = 0U;
					gdouble* _tmp50_ = NULL;
					gint _tmp50__length1 = 0;
					guint _tmp51_ = 0U;
					gdouble* _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					guint _tmp53_ = 0U;
					gdouble _tmp54_ = 0.0;
					gdouble _tmp55_ = 0.0;
					_tmp46_ = _tmp45_;
					if (!_tmp46_) {
						guint _tmp47_ = 0U;
						_tmp47_ = i;
						i = _tmp47_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp48_ = i;
					_tmp49_ = isize;
					if (!((_tmp48_ + 1) < _tmp49_)) {
						break;
					}
					_tmp50_ = self->priv->scalerhistory;
					_tmp50__length1 = self->priv->scalerhistory_length1;
					_tmp51_ = i;
					_tmp52_ = self->priv->scalerhistory;
					_tmp52__length1 = self->priv->scalerhistory_length1;
					_tmp53_ = i;
					_tmp54_ = _tmp52_[_tmp53_ + 1];
					_tmp50_[_tmp51_] = _tmp54_;
					_tmp55_ = _tmp50_[_tmp51_];
				}
			}
		}
	} else {
		{
			guint i = 0U;
			guint isize = 0U;
			gdouble* _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			i = (guint) 0;
			_tmp56_ = self->priv->scalerhistory;
			_tmp56__length1 = self->priv->scalerhistory_length1;
			isize = (guint) _tmp56__length1;
			{
				gboolean _tmp57_ = FALSE;
				_tmp57_ = TRUE;
				while (TRUE) {
					gboolean _tmp58_ = FALSE;
					guint _tmp60_ = 0U;
					guint _tmp61_ = 0U;
					gdouble* _tmp62_ = NULL;
					gint _tmp62__length1 = 0;
					guint _tmp63_ = 0U;
					gdouble _tmp64_ = 0.0;
					gdouble _tmp65_ = 0.0;
					_tmp58_ = _tmp57_;
					if (!_tmp58_) {
						guint _tmp59_ = 0U;
						_tmp59_ = i;
						i = _tmp59_ + 1;
					}
					_tmp57_ = FALSE;
					_tmp60_ = i;
					_tmp61_ = isize;
					if (!((_tmp60_ + 1) < _tmp61_)) {
						break;
					}
					_tmp62_ = self->priv->scalerhistory;
					_tmp62__length1 = self->priv->scalerhistory_length1;
					_tmp63_ = i;
					_tmp64_ = currentpeak;
					_tmp62_[_tmp63_] = _tmp64_;
					_tmp65_ = _tmp62_[_tmp63_];
				}
			}
		}
	}
	_tmp66_ = self->priv->scalerhistory;
	_tmp66__length1 = self->priv->scalerhistory_length1;
	_tmp67_ = self->priv->scalerhistory;
	_tmp67__length1 = self->priv->scalerhistory_length1;
	_tmp68_ = currentpeak;
	_tmp66_[_tmp67__length1 - 1] = _tmp68_;
	_tmp69_ = _tmp66_[_tmp67__length1 - 1];
	_tmp70_ = self->priv->scalerhistory;
	_tmp70__length1 = self->priv->scalerhistory_length1;
	_tmp71_ = utils_mean (_tmp70_, _tmp70__length1);
	graph_model_set_scale (self, _tmp71_);
}


const gchar* graph_model_get_id (GraphModel* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void graph_model_set_id (GraphModel* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


Providers* graph_model_get_providers (GraphModel* self) {
	Providers* result;
	Providers* _tmp0_ = NULL;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_providers;
	result = _tmp0_;
	return result;
}


static void graph_model_set_providers (GraphModel* self, Providers* value) {
	Providers* _tmp0_ = NULL;
	Providers* _tmp1_ = NULL;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_providers);
	self->priv->_providers = _tmp1_;
	g_object_notify ((GObject *) self, "providers");
}


ExpressionCache* graph_model_get_minimum (GraphModel* self) {
	ExpressionCache* result;
	ExpressionCache* _tmp0_ = NULL;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_minimum;
	result = _tmp0_;
	return result;
}


static void graph_model_set_minimum (GraphModel* self, ExpressionCache* value) {
	ExpressionCache* _tmp0_ = NULL;
	ExpressionCache* _tmp1_ = NULL;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_minimum);
	self->priv->_minimum = _tmp1_;
	g_object_notify ((GObject *) self, "minimum");
}


ExpressionCache* graph_model_get_maximum (GraphModel* self) {
	ExpressionCache* result;
	ExpressionCache* _tmp0_ = NULL;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_maximum;
	result = _tmp0_;
	return result;
}


static void graph_model_set_maximum (GraphModel* self, ExpressionCache* value) {
	ExpressionCache* _tmp0_ = NULL;
	ExpressionCache* _tmp1_ = NULL;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_maximum);
	self->priv->_maximum = _tmp1_;
	g_object_notify ((GObject *) self, "maximum");
}


const gchar* graph_model_get_smooth (GraphModel* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_smooth;
	result = _tmp0_;
	return result;
}


void graph_model_set_smooth (GraphModel* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_smooth);
	self->priv->_smooth = _tmp1_;
	g_object_notify ((GObject *) self, "smooth");
}


gboolean graph_model_get_enabled (GraphModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), FALSE);
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


void graph_model_set_enabled (GraphModel* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


gchar** graph_model_get_traces (GraphModel* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_traces;
	_tmp0__length1 = self->priv->_traces_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void graph_model_set_traces (GraphModel* self, gchar** value, int value_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup10 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_traces = _tmp1_;
	self->priv->_traces_length1 = _tmp1__length1;
	self->priv->__traces_size_ = self->priv->_traces_length1;
	g_object_notify ((GObject *) self, "traces");
}


gdouble graph_model_get_scale (GraphModel* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), 0.0);
	_tmp0_ = self->priv->_scale;
	result = _tmp0_;
	return result;
}


static void graph_model_set_scale (GraphModel* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	self->priv->_scale = _tmp0_;
	g_object_notify ((GObject *) self, "scale");
}


TraceModel** graph_model_get_tracemodels (GraphModel* self, int* result_length1) {
	TraceModel** result;
	TraceModel** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	TraceModel** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_tracemodels;
	_tmp0__length1 = self->priv->_tracemodels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static TraceModel** _vala_array_dup11 (TraceModel** self, int length) {
	TraceModel** result;
	int i;
	result = g_new0 (TraceModel*, length + 1);
	for (i = 0; i < length; i++) {
		TraceModel* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void graph_model_set_tracemodels (GraphModel* self, TraceModel** value, int value_length1) {
	TraceModel** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	TraceModel** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup11 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_tracemodels = _tmp1_;
	self->priv->_tracemodels_length1 = _tmp1__length1;
	self->priv->__tracemodels_size_ = self->priv->_tracemodels_length1;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void _graph_model___lambda4_ (GraphModel* self) {
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	_tmp0_ = self->priv->_smooth;
	_tmp1_ = uint64_parse (_tmp0_);
	self->priv->smoothvalue = (guint) _tmp1_;
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	self->priv->scalerhistory = NULL;
	self->priv->scalerhistory_length1 = 0;
	self->priv->_scalerhistory_size_ = self->priv->scalerhistory_length1;
}


static void __graph_model___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_graph_model___lambda4_ (self);
}


static void _vala_array_add10 (TraceModel*** array, int* length, int* size, TraceModel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TraceModel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static TraceModel** _vala_array_dup12 (TraceModel** self, int length) {
	TraceModel** result;
	int i;
	result = g_new0 (TraceModel*, length + 1);
	for (i = 0; i < length; i++) {
		TraceModel* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _graph_model___lambda5_ (GraphModel* self) {
	TraceModel** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	TraceModel** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	while (TRUE) {
		TraceModel** _tmp0_ = NULL;
		gint _tmp0__length1 = 0;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		TraceModel** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		Providers* _tmp3_ = NULL;
		TraceModel* _tmp4_ = NULL;
		_tmp0_ = self->priv->_tracemodels;
		_tmp0__length1 = self->priv->_tracemodels_length1;
		_tmp1_ = self->priv->_traces;
		_tmp1__length1 = self->priv->_traces_length1;
		if (!(_tmp0__length1 < _tmp1__length1)) {
			break;
		}
		_tmp2_ = self->priv->_tracemodels;
		_tmp2__length1 = self->priv->_tracemodels_length1;
		_tmp3_ = self->priv->_providers;
		_tmp4_ = trace_model_new (_tmp3_);
		_vala_array_add10 (&self->priv->_tracemodels, &self->priv->_tracemodels_length1, &self->priv->__tracemodels_size_, _tmp4_);
	}
	_tmp5_ = self->priv->_tracemodels;
	_tmp5__length1 = self->priv->_tracemodels_length1;
	_tmp6_ = self->priv->_traces;
	_tmp6__length1 = self->priv->_traces_length1;
	_tmp7_ = ((_tmp5_ + 0) != NULL) ? _vala_array_dup12 (_tmp5_ + 0, _tmp6__length1 - 0) : ((gpointer) (_tmp5_ + 0));
	_tmp7__length1 = _tmp6__length1 - 0;
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_tracemodels = _tmp7_;
	self->priv->_tracemodels_length1 = _tmp7__length1;
	self->priv->__tracemodels_size_ = self->priv->_tracemodels_length1;
}


static void __graph_model___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_graph_model___lambda5_ (self);
}


static GObject * graph_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GraphModel * self;
	parent_class = G_OBJECT_CLASS (graph_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRAPH_MODEL, GraphModel);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::smooth", (GCallback) __graph_model___lambda4__g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::traces", (GCallback) __graph_model___lambda5__g_object_notify, self, 0);
	return obj;
}


static void graph_model_class_init (GraphModelClass * klass) {
	graph_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GraphModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_graph_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graph_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = graph_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = graph_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_PROVIDERS, g_param_spec_object ("providers", "providers", "providers", TYPE_PROVIDERS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_MINIMUM, g_param_spec_object ("minimum", "minimum", "minimum", TYPE_EXPRESSION_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_MAXIMUM, g_param_spec_object ("maximum", "maximum", "maximum", TYPE_EXPRESSION_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_SMOOTH, g_param_spec_string ("smooth", "smooth", "smooth", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_TRACES, g_param_spec_boxed ("traces", "traces", "traces", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_SCALE, g_param_spec_double ("scale", "scale", "scale", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void graph_model_instance_init (GraphModel * self) {
	self->priv = GRAPH_MODEL_GET_PRIVATE (self);
	self->priv->_scale = (gdouble) 1;
}


static void graph_model_finalize (GObject* obj) {
	GraphModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRAPH_MODEL, GraphModel);
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_providers);
	_g_object_unref0 (self->priv->_minimum);
	_g_object_unref0 (self->priv->_maximum);
	_g_free0 (self->priv->_smooth);
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (graph_model_parent_class)->finalize (obj);
}


/******************************************************************************
 * Copyright (C) 2011-2013  Michael Hofmann <mh21@mh21.de>                    *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType graph_model_get_type (void) {
	static volatile gsize graph_model_type_id__volatile = 0;
	if (g_once_init_enter (&graph_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GraphModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graph_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphModel), 0, (GInstanceInitFunc) graph_model_instance_init, NULL };
		GType graph_model_type_id;
		graph_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GraphModel", &g_define_type_info, 0);
		g_once_init_leave (&graph_model_type_id__volatile, graph_model_type_id);
	}
	return graph_model_type_id__volatile;
}


static void _vala_graph_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GraphModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRAPH_MODEL, GraphModel);
	switch (property_id) {
		case GRAPH_MODEL_ID:
		g_value_set_string (value, graph_model_get_id (self));
		break;
		case GRAPH_MODEL_PROVIDERS:
		g_value_set_object (value, graph_model_get_providers (self));
		break;
		case GRAPH_MODEL_MINIMUM:
		g_value_set_object (value, graph_model_get_minimum (self));
		break;
		case GRAPH_MODEL_MAXIMUM:
		g_value_set_object (value, graph_model_get_maximum (self));
		break;
		case GRAPH_MODEL_SMOOTH:
		g_value_set_string (value, graph_model_get_smooth (self));
		break;
		case GRAPH_MODEL_ENABLED:
		g_value_set_boolean (value, graph_model_get_enabled (self));
		break;
		case GRAPH_MODEL_TRACES:
		{
			int length;
			g_value_set_boxed (value, graph_model_get_traces (self, &length));
		}
		break;
		case GRAPH_MODEL_SCALE:
		g_value_set_double (value, graph_model_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_graph_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GraphModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRAPH_MODEL, GraphModel);
	switch (property_id) {
		case GRAPH_MODEL_ID:
		graph_model_set_id (self, g_value_get_string (value));
		break;
		case GRAPH_MODEL_PROVIDERS:
		graph_model_set_providers (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_MINIMUM:
		graph_model_set_minimum (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_MAXIMUM:
		graph_model_set_maximum (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_SMOOTH:
		graph_model_set_smooth (self, g_value_get_string (value));
		break;
		case GRAPH_MODEL_ENABLED:
		graph_model_set_enabled (self, g_value_get_boolean (value));
		break;
		case GRAPH_MODEL_TRACES:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			graph_model_set_traces (self, boxed, g_strv_length (boxed));
		}
		break;
		case GRAPH_MODEL_SCALE:
		graph_model_set_scale (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



