/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <fsodevice.h>
#include <freesmartphone.h>
#include <stdlib.h>
#include <string.h>
#include <linux/rfkill.h>
#include <fsoframework.h>
#include <unistd.h>
#include <errno.h>
#include <gio/gio.h>
#include <fcntl.h>
#include <sys/types.h>


#define KERNEL26_TYPE_RF_KILL_POWER_CONTROL (kernel26_rf_kill_power_control_get_type ())
#define KERNEL26_RF_KILL_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL26_TYPE_RF_KILL_POWER_CONTROL, Kernel26RfKillPowerControl))
#define KERNEL26_RF_KILL_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL26_TYPE_RF_KILL_POWER_CONTROL, Kernel26RfKillPowerControlClass))
#define KERNEL26_IS_RF_KILL_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL26_TYPE_RF_KILL_POWER_CONTROL))
#define KERNEL26_IS_RF_KILL_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL26_TYPE_RF_KILL_POWER_CONTROL))
#define KERNEL26_RF_KILL_POWER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL26_TYPE_RF_KILL_POWER_CONTROL, Kernel26RfKillPowerControlClass))

typedef struct _Kernel26RfKillPowerControl Kernel26RfKillPowerControl;
typedef struct _Kernel26RfKillPowerControlClass Kernel26RfKillPowerControlClass;
typedef struct _Kernel26RfKillPowerControlPrivate Kernel26RfKillPowerControlPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Kernel26RfKillPowerControlGetPowerData Kernel26RfKillPowerControlGetPowerData;
typedef struct _Kernel26RfKillPowerControlSetPowerData Kernel26RfKillPowerControlSetPowerData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

struct _Kernel26RfKillPowerControl {
	FsoFrameworkAbstractObject parent_instance;
	Kernel26RfKillPowerControlPrivate * priv;
};

struct _Kernel26RfKillPowerControlClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _Kernel26RfKillPowerControlPrivate {
	guint id;
	gchar* type;
	gboolean softoff;
	gboolean hardoff;
	FsoDeviceBasePowerControlResource* resource;
};

struct _Kernel26RfKillPowerControlGetPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26RfKillPowerControl* self;
	gboolean result;
	gboolean _tmp0_;
};

struct _Kernel26RfKillPowerControlSetPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26RfKillPowerControl* self;
	gboolean on;
	gboolean _tmp0_;
};


static gpointer kernel26_rf_kill_power_control_parent_class = NULL;
extern FsoFrameworkSubsystem* subsystem;
extern gint fd;
extern gboolean ignore_wifi;
extern GHashTable* instances;
static FsoDeviceISimplePowerControlIface* kernel26_rf_kill_power_control_fso_device_isimple_power_control_parent_iface = NULL;
static FreeSmartphoneDevicePowerControlIface* kernel26_rf_kill_power_control_free_smartphone_device_power_control_parent_iface = NULL;
static GType kernel26_rf_kill_power_control_type_id = 0;
GHashTable* instances = NULL;
extern gchar* devfs_root;
gchar* devfs_root = NULL;
FsoFrameworkSubsystem* subsystem = NULL;
gboolean ignore_wifi = FALSE;
gint fd = 0;
extern guint watch;
guint watch = 0U;
extern GIOChannel* channel;
GIOChannel* channel = NULL;

GType kernel26_rf_kill_power_control_get_type (void) G_GNUC_CONST;
GType kernel26_rf_kill_power_control_register_type (GTypeModule * module);
#define KERNEL26_RF_KILL_POWER_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL26_TYPE_RF_KILL_POWER_CONTROL, Kernel26RfKillPowerControlPrivate))
enum  {
	KERNEL26_RF_KILL_POWER_CONTROL_DUMMY_PROPERTY
};
static Kernel26RfKillPowerControl* kernel26_rf_kill_power_control_new (guint id, guint8 type, gboolean softoff, gboolean hardoff);
static Kernel26RfKillPowerControl* kernel26_rf_kill_power_control_construct (GType object_type, guint id, guint8 type, gboolean softoff, gboolean hardoff);
static gboolean __lambda2_ (Kernel26RfKillPowerControl* self);
static gboolean ___lambda2__gsource_func (gpointer self);
static gchar* kernel26_rf_kill_power_control_real_repr (FsoFrameworkAbstractObject* base);
gboolean kernel26_rf_kill_power_control_onActionFromRfKill (GIOChannel* source, GIOCondition condition);
void kernel26_rf_kill_power_control_handleEvent (struct rfkill_event* event);
void kernel26_rf_kill_power_control_powerChangedTo (Kernel26RfKillPowerControl* self, gboolean softoff, gboolean hardoff);
static gboolean kernel26_rf_kill_power_control_real_getPower (FsoDeviceISimplePowerControl* base);
static void kernel26_rf_kill_power_control_real_setPower (FsoDeviceISimplePowerControl* base, gboolean on);
static void kernel26_rf_kill_power_control_real_get_power_data_free (gpointer _data);
static void kernel26_rf_kill_power_control_real_get_power (FreeSmartphoneDevicePowerControl* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rf_kill_power_control_real_get_power_co (Kernel26RfKillPowerControlGetPowerData* _data_);
static void kernel26_rf_kill_power_control_real_set_power_data_free (gpointer _data);
static void kernel26_rf_kill_power_control_real_set_power (FreeSmartphoneDevicePowerControl* base, gboolean on, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_rf_kill_power_control_real_set_power_co (Kernel26RfKillPowerControlSetPowerData* _data_);
static void kernel26_rf_kill_power_control_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* system, GError** error);
static void _g_object_unref0_ (gpointer var);
static gboolean _kernel26_rf_kill_power_control_onActionFromRfKill_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void fso_register_function (GTypeModule* module);

static const gchar* KERNEL26_RF_KILL_POWER_CONTROL_opValue[7] = {"Add", "Del", "Change", "ChangeAll", "unknown:4", "unknown:5", "unknown:6"};
static const gchar* KERNEL26_RF_KILL_POWER_CONTROL_typeValue[8] = {"All", "WiFi", "Bluetooth", "UWB", "WiMax", "WWan", "GPS", "FM"};

static gboolean __lambda2_ (Kernel26RfKillPowerControl* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	FsoDeviceBasePowerControlResource* _tmp2_;
	_tmp0_ = self->priv->type;
	_tmp1_ = subsystem;
	_tmp2_ = fso_device_base_power_control_resource_new ((FsoDeviceISimplePowerControl*) self, _tmp0_, _tmp1_, FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_AUTO);
	_g_object_unref0 (self->priv->resource);
	self->priv->resource = _tmp2_;
	result = FALSE;
	return result;
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
	return result;
}


static Kernel26RfKillPowerControl* kernel26_rf_kill_power_control_construct (GType object_type, guint id, guint8 type, gboolean softoff, gboolean hardoff) {
	Kernel26RfKillPowerControl * self = NULL;
	guint _tmp0_;
	guint8 _tmp1_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	FsoFrameworkSubsystem* _tmp14_;
	FsoFrameworkLogger* _tmp15_;
	self = (Kernel26RfKillPowerControl*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = id;
	self->priv->id = _tmp0_;
	_tmp1_ = type;
	switch (_tmp1_) {
		case RFKILL_TYPE_WLAN:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("WiFi");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp2_;
			break;
		}
		case RFKILL_TYPE_BLUETOOTH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Bluetooth");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp3_;
			break;
		}
		case RFKILL_TYPE_UWB:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("UWB");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp4_;
			break;
		}
		case RFKILL_TYPE_WIMAX:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("WiMax");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp5_;
			break;
		}
		case RFKILL_TYPE_WWAN:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("WWan");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp6_;
			break;
		}
		case 0x6:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("GPS");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp7_;
			break;
		}
		case 0x7:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("FM");
			_g_free0 (self->priv->type);
			self->priv->type = _tmp8_;
			break;
		}
		default:
		{
			FsoFrameworkLogger* _tmp9_;
			guint8 _tmp10_;
			gchar* _tmp11_ = NULL;
			_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
			fso_framework_logger_warning (_tmp9_, "Unknown RfKillType %u - please report");
			_tmp10_ = type;
			_tmp11_ = g_strdup_printf ("unknown:%u", (guint) _tmp10_);
			_g_free0 (self->priv->type);
			self->priv->type = _tmp11_;
			break;
		}
	}
	_tmp12_ = softoff;
	self->priv->softoff = _tmp12_;
	_tmp13_ = hardoff;
	self->priv->hardoff = _tmp13_;
	_tmp14_ = subsystem;
	fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp14_, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_PowerControlServicePath, (FreeSmartphoneDevicePowerControl*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, g_object_ref (self), g_object_unref);
	_tmp15_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp15_, "created.");
	return self;
}


static Kernel26RfKillPowerControl* kernel26_rf_kill_power_control_new (guint id, guint8 type, gboolean softoff, gboolean hardoff) {
	return kernel26_rf_kill_power_control_construct (KERNEL26_TYPE_RF_KILL_POWER_CONTROL, id, type, softoff, hardoff);
}


static gchar* kernel26_rf_kill_power_control_real_repr (FsoFrameworkAbstractObject* base) {
	Kernel26RfKillPowerControl * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	self = (Kernel26RfKillPowerControl*) base;
	_tmp1_ = self->priv->softoff;
	if (_tmp1_) {
		_tmp0_ = "off";
	} else {
		_tmp0_ = "on";
	}
	_tmp3_ = self->priv->hardoff;
	if (_tmp3_) {
		_tmp2_ = "off";
	} else {
		_tmp2_ = "on";
	}
	_tmp4_ = self->priv->id;
	_tmp5_ = self->priv->type;
	_tmp6_ = _tmp0_;
	_tmp7_ = _tmp2_;
	_tmp8_ = g_strdup_printf ("<%u:%s:soft%s:hard%s>", _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	result = _tmp8_;
	return result;
}


gboolean kernel26_rf_kill_power_control_onActionFromRfKill (GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GIOCondition _tmp0_;
	GIOCondition _tmp1_;
	GIOCondition _tmp9_;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = condition;
	if ((_tmp0_ & G_IO_HUP) == G_IO_HUP) {
		g_warning ("plugin.vala:98: HUP on rfkill, will no longer get any notifications");
		result = FALSE;
		return result;
	}
	_tmp1_ = condition;
	if ((_tmp1_ & G_IO_IN) == G_IO_IN) {
		gint _tmp2_;
		struct rfkill_event event = {0};
		gint _tmp3_;
		gssize _tmp4_ = 0L;
		gssize bytesread;
		gssize _tmp5_;
		gssize _tmp7_;
		struct rfkill_event _tmp8_;
		_tmp2_ = fd;
		g_assert (_tmp2_ != (-1));
		memset (&event, 0, sizeof (struct rfkill_event));
		_tmp3_ = fd;
		_tmp4_ = read (_tmp3_, &event, (gsize) sizeof (struct rfkill_event));
		bytesread = _tmp4_;
		_tmp5_ = bytesread;
		if (((gulong) _tmp5_) != sizeof (struct rfkill_event)) {
			gssize _tmp6_;
			_tmp6_ = bytesread;
			g_warning ("plugin.vala:109: can't read full rfkill event, got only %d bytes", (gint) _tmp6_);
			result = TRUE;
			return result;
		}
		_tmp7_ = bytesread;
		g_debug ("plugin.vala:113: onActionFromRfKill: read %d bytes", (gint) _tmp7_);
		_tmp8_ = event;
		kernel26_rf_kill_power_control_handleEvent (&_tmp8_);
		result = TRUE;
		return result;
	}
	_tmp9_ = condition;
	g_warning ("plugin.vala:119: Unsupported IOCondition %u", (guint) ((gint) _tmp9_));
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kernel26_rf_kill_power_control_handleEvent (struct rfkill_event* event) {
	const gchar* _tmp0_ = NULL;
	struct rfkill_event _tmp1_;
	guint8 _tmp2_;
	const gchar* _tmp3_ = NULL;
	struct rfkill_event _tmp4_;
	guint8 _tmp5_;
	struct rfkill_event _tmp6_;
	guint32 _tmp7_;
	struct rfkill_event _tmp8_;
	guint8 _tmp9_;
	const gchar* _tmp10_;
	struct rfkill_event _tmp11_;
	guint8 _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	struct rfkill_event _tmp16_;
	guint8 _tmp17_;
	g_return_if_fail (event != NULL);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.soft;
	if (((gint) _tmp2_) == 1) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.hard;
	if (((gint) _tmp5_) == 1) {
		_tmp3_ = "true";
	} else {
		_tmp3_ = "false";
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.idx;
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.type;
	_tmp10_ = KERNEL26_RF_KILL_POWER_CONTROL_typeValue[_tmp9_];
	_tmp11_ = *event;
	_tmp12_ = _tmp11_.op;
	_tmp13_ = KERNEL26_RF_KILL_POWER_CONTROL_opValue[_tmp12_];
	_tmp14_ = _tmp0_;
	_tmp15_ = _tmp3_;
	g_debug ("plugin.vala:125: got rfkill event: ID %u, %s, %s, SOFTBLOCK %s, HARDBL" \
"OCK %s", (guint) _tmp7_, _tmp10_, _tmp13_, _tmp14_, _tmp15_);
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.op;
	switch (_tmp17_) {
		case RFKILL_OP_ADD:
		{
			gboolean _tmp18_ = FALSE;
			struct rfkill_event _tmp19_;
			guint8 _tmp20_;
			gboolean _tmp22_;
			GHashTable* _tmp23_;
			struct rfkill_event _tmp24_;
			guint32 _tmp25_;
			struct rfkill_event _tmp26_;
			guint32 _tmp27_;
			struct rfkill_event _tmp28_;
			guint8 _tmp29_;
			struct rfkill_event _tmp30_;
			guint8 _tmp31_;
			struct rfkill_event _tmp32_;
			guint8 _tmp33_;
			Kernel26RfKillPowerControl* _tmp34_;
			_tmp19_ = *event;
			_tmp20_ = _tmp19_.type;
			if (_tmp20_ == RFKILL_TYPE_WLAN) {
				gboolean _tmp21_;
				_tmp21_ = ignore_wifi;
				_tmp18_ = _tmp21_;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp22_ = _tmp18_;
			if (_tmp22_) {
				g_warning ("plugin.vala:137: %s", "Ignore WiFi rfkill as defined by configuration");
				break;
			}
			_tmp23_ = instances;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.idx;
			_tmp26_ = *event;
			_tmp27_ = _tmp26_.idx;
			_tmp28_ = *event;
			_tmp29_ = _tmp28_.type;
			_tmp30_ = *event;
			_tmp31_ = _tmp30_.soft;
			_tmp32_ = *event;
			_tmp33_ = _tmp32_.hard;
			_tmp34_ = kernel26_rf_kill_power_control_new ((guint) _tmp27_, _tmp29_, ((gint) _tmp31_) == 1, ((gint) _tmp33_) == 1);
			g_hash_table_insert (_tmp23_, GINT_TO_POINTER ((gint) _tmp25_), _tmp34_);
			break;
		}
		case RFKILL_OP_DEL:
		{
			GHashTable* _tmp35_;
			struct rfkill_event _tmp36_;
			guint32 _tmp37_;
			_tmp35_ = instances;
			_tmp36_ = *event;
			_tmp37_ = _tmp36_.idx;
			g_hash_table_remove (_tmp35_, GINT_TO_POINTER ((gint) _tmp37_));
			break;
		}
		case RFKILL_OP_CHANGE:
		{
			GHashTable* _tmp38_;
			struct rfkill_event _tmp39_;
			guint32 _tmp40_;
			gconstpointer _tmp41_ = NULL;
			Kernel26RfKillPowerControl* _tmp42_;
			Kernel26RfKillPowerControl* instance;
			Kernel26RfKillPowerControl* _tmp43_;
			Kernel26RfKillPowerControl* _tmp44_;
			struct rfkill_event _tmp45_;
			guint8 _tmp46_;
			struct rfkill_event _tmp47_;
			guint8 _tmp48_;
			_tmp38_ = instances;
			_tmp39_ = *event;
			_tmp40_ = _tmp39_.idx;
			_tmp41_ = g_hash_table_lookup (_tmp38_, GINT_TO_POINTER ((gint) _tmp40_));
			_tmp42_ = _g_object_ref0 ((Kernel26RfKillPowerControl*) _tmp41_);
			instance = _tmp42_;
			_tmp43_ = instance;
			if (_tmp43_ == NULL) {
				g_warning ("plugin.vala:150: Got rfkill change event for unknown IDX; ignoring");
				_g_object_unref0 (instance);
				return;
			}
			_tmp44_ = instance;
			_tmp45_ = *event;
			_tmp46_ = _tmp45_.soft;
			_tmp47_ = *event;
			_tmp48_ = _tmp47_.hard;
			kernel26_rf_kill_power_control_powerChangedTo (_tmp44_, ((gint) _tmp46_) == 1, ((gint) _tmp48_) == 1);
			_g_object_unref0 (instance);
			break;
		}
		default:
		{
			struct rfkill_event _tmp49_;
			guint8 _tmp50_;
			_tmp49_ = *event;
			_tmp50_ = _tmp49_.op;
			g_warning ("plugin.vala:156: unknown rfkill op %u; ignoring", (guint) _tmp50_);
			break;
		}
	}
}


void kernel26_rf_kill_power_control_powerChangedTo (Kernel26RfKillPowerControl* self, gboolean softoff, gboolean hardoff) {
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	FsoFrameworkLogger* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Status changed from...");
	g_assert (_tmp1_);
	_tmp2_ = softoff;
	self->priv->softoff = _tmp2_;
	_tmp3_ = hardoff;
	self->priv->hardoff = _tmp3_;
	_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp5_ = fso_framework_logger_debug (_tmp4_, "... to");
	g_assert (_tmp5_);
}


static gboolean kernel26_rf_kill_power_control_real_getPower (FsoDeviceISimplePowerControl* base) {
	Kernel26RfKillPowerControl * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	self = (Kernel26RfKillPowerControl*) base;
	_tmp1_ = self->priv->hardoff;
	if (_tmp1_) {
		_tmp0_ = FALSE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->softoff;
		_tmp0_ = !_tmp2_;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void kernel26_rf_kill_power_control_real_setPower (FsoDeviceISimplePowerControl* base, gboolean on) {
	Kernel26RfKillPowerControl * self;
	guint _tmp0_;
	gboolean _tmp1_;
	struct rfkill_event _tmp2_ = {0};
	struct rfkill_event event;
	gint _tmp3_;
	gssize _tmp4_ = 0L;
	gssize bwritten;
	gssize _tmp5_;
	self = (Kernel26RfKillPowerControl*) base;
	_tmp0_ = self->priv->id;
	_tmp1_ = on;
	memset (&_tmp2_, 0, sizeof (struct rfkill_event));
	_tmp2_.idx = (guint32) _tmp0_;
	_tmp2_.op = RFKILL_OP_CHANGE;
	_tmp2_.soft = (guint8) (!_tmp1_);
	event = _tmp2_;
	_tmp3_ = fd;
	_tmp4_ = write (_tmp3_, &event, (gsize) sizeof (struct rfkill_event));
	bwritten = _tmp4_;
	_tmp5_ = bwritten;
	if (_tmp5_ == ((gssize) (-1))) {
		FsoFrameworkLogger* _tmp6_;
		gint _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp6_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Could not write rfkill event: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_error (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
	}
}


static void kernel26_rf_kill_power_control_real_get_power_data_free (gpointer _data) {
	Kernel26RfKillPowerControlGetPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RfKillPowerControlGetPowerData, _data_);
}


static void kernel26_rf_kill_power_control_real_get_power (FreeSmartphoneDevicePowerControl* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26RfKillPowerControl * self;
	Kernel26RfKillPowerControlGetPowerData* _data_;
	Kernel26RfKillPowerControl* _tmp0_;
	self = (Kernel26RfKillPowerControl*) base;
	_data_ = g_slice_new0 (Kernel26RfKillPowerControlGetPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rf_kill_power_control_real_get_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rf_kill_power_control_real_get_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_rf_kill_power_control_real_get_power_co (_data_);
}


static gboolean kernel26_rf_kill_power_control_real_get_power_finish (FreeSmartphoneDevicePowerControl* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	Kernel26RfKillPowerControlGetPowerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean kernel26_rf_kill_power_control_real_get_power_co (Kernel26RfKillPowerControlGetPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = fso_device_isimple_power_control_getPower ((FsoDeviceISimplePowerControl*) _data_->self);
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rf_kill_power_control_real_set_power_data_free (gpointer _data) {
	Kernel26RfKillPowerControlSetPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26RfKillPowerControlSetPowerData, _data_);
}


static void kernel26_rf_kill_power_control_real_set_power (FreeSmartphoneDevicePowerControl* base, gboolean on, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26RfKillPowerControl * self;
	Kernel26RfKillPowerControlSetPowerData* _data_;
	Kernel26RfKillPowerControl* _tmp0_;
	gboolean _tmp1_;
	self = (Kernel26RfKillPowerControl*) base;
	_data_ = g_slice_new0 (Kernel26RfKillPowerControlSetPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_rf_kill_power_control_real_set_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_rf_kill_power_control_real_set_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = on;
	_data_->on = _tmp1_;
	kernel26_rf_kill_power_control_real_set_power_co (_data_);
}


static void kernel26_rf_kill_power_control_real_set_power_finish (FreeSmartphoneDevicePowerControl* base, GAsyncResult* _res_, GError** error) {
	Kernel26RfKillPowerControlSetPowerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel26_rf_kill_power_control_real_set_power_co (Kernel26RfKillPowerControlSetPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->on;
	fso_device_isimple_power_control_setPower ((FsoDeviceISimplePowerControl*) _data_->self, _data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_rf_kill_power_control_class_init (Kernel26RfKillPowerControlClass * klass) {
	kernel26_rf_kill_power_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Kernel26RfKillPowerControlPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel26_rf_kill_power_control_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel26_rf_kill_power_control_finalize;
}


static void kernel26_rf_kill_power_control_fso_device_isimple_power_control_interface_init (FsoDeviceISimplePowerControlIface * iface) {
	kernel26_rf_kill_power_control_fso_device_isimple_power_control_parent_iface = g_type_interface_peek_parent (iface);
	iface->getPower = (gboolean (*)(FsoDeviceISimplePowerControl*)) kernel26_rf_kill_power_control_real_getPower;
	iface->setPower = (void (*)(FsoDeviceISimplePowerControl*, gboolean)) kernel26_rf_kill_power_control_real_setPower;
}


static void kernel26_rf_kill_power_control_free_smartphone_device_power_control_interface_init (FreeSmartphoneDevicePowerControlIface * iface) {
	kernel26_rf_kill_power_control_free_smartphone_device_power_control_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_power = (gboolean (*)(FreeSmartphoneDevicePowerControl*, GError**)) kernel26_rf_kill_power_control_real_get_power;
	iface->get_power_finish = kernel26_rf_kill_power_control_real_get_power_finish;
	iface->set_power = (void (*)(FreeSmartphoneDevicePowerControl*, gboolean, GError**)) kernel26_rf_kill_power_control_real_set_power;
	iface->set_power_finish = kernel26_rf_kill_power_control_real_set_power_finish;
}


static void kernel26_rf_kill_power_control_instance_init (Kernel26RfKillPowerControl * self) {
	self->priv = KERNEL26_RF_KILL_POWER_CONTROL_GET_PRIVATE (self);
}


static void kernel26_rf_kill_power_control_finalize (GObject* obj) {
	Kernel26RfKillPowerControl * self;
	self = KERNEL26_RF_KILL_POWER_CONTROL (obj);
	_g_free0 (self->priv->type);
	_g_object_unref0 (self->priv->resource);
	G_OBJECT_CLASS (kernel26_rf_kill_power_control_parent_class)->finalize (obj);
}


/**
 * @class Kernel26.RfKillPowerControl
 *
 * Implementing org.freesmartphone.Device.PowerControl via Linux 2.6 rfkill API
 **/
GType kernel26_rf_kill_power_control_get_type (void) {
	return kernel26_rf_kill_power_control_type_id;
}


GType kernel26_rf_kill_power_control_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (Kernel26RfKillPowerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel26_rf_kill_power_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Kernel26RfKillPowerControl), 0, (GInstanceInitFunc) kernel26_rf_kill_power_control_instance_init, NULL };
	static const GInterfaceInfo fso_device_isimple_power_control_info = { (GInterfaceInitFunc) kernel26_rf_kill_power_control_fso_device_isimple_power_control_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_device_power_control_info = { (GInterfaceInitFunc) kernel26_rf_kill_power_control_free_smartphone_device_power_control_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel26_rf_kill_power_control_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "Kernel26RfKillPowerControl", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel26_rf_kill_power_control_type_id, FSO_DEVICE_TYPE_ISIMPLE_POWER_CONTROL, &fso_device_isimple_power_control_info);
	g_type_module_add_interface (module, kernel26_rf_kill_power_control_type_id, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, &free_smartphone_device_power_control_info);
	return kernel26_rf_kill_power_control_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gboolean _kernel26_rf_kill_power_control_onActionFromRfKill_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = kernel26_rf_kill_power_control_onActionFromRfKill (source, condition);
	return result;
}


gchar* fso_factory_function (FsoFrameworkSubsystem* system, GError** error) {
	gchar* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	FsoFrameworkSubsystem* _tmp3_;
	FsoFrameworkSmartKeyFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_;
	gchar* _tmp25_;
	g_return_val_if_fail (system != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (instances);
	instances = _tmp2_;
	_tmp3_ = system;
	subsystem = _tmp3_;
	_tmp4_ = fso_framework_theConfig;
	_tmp5_ = fso_framework_smart_key_file_stringValue (_tmp4_, "cornucopia", "devfs_root", "/dev");
	_g_free0 (devfs_root);
	devfs_root = _tmp5_;
	_tmp6_ = fso_framework_theConfig;
	_tmp7_ = fso_framework_smart_key_file_boolValue (_tmp6_, "fsodevice.kernel26_rfkill", "ignore_wifi", FALSE);
	ignore_wifi = _tmp7_;
	_tmp8_ = devfs_root;
	_tmp9_ = g_build_filename (_tmp8_, "rfkill", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = open (_tmp10_, O_RDWR, (mode_t) 0);
	fd = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = fd;
	if (_tmp12_ == (-1)) {
		FsoFrameworkLogger* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		_tmp13_ = fso_framework_theLogger;
		_tmp14_ = devfs_root;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = errno;
		_tmp17_ = g_strerror (_tmp16_);
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Can't open ", _tmp15_, "/rfkill: ", _tmp18_, "; rfkill plugin will not be operating", NULL);
		_tmp20_ = _tmp19_;
		fso_framework_logger_error (_tmp13_, _tmp20_);
		_g_free0 (_tmp20_);
	} else {
		gint _tmp21_;
		GIOChannel* _tmp22_;
		GIOChannel* _tmp23_;
		guint _tmp24_ = 0U;
		_tmp21_ = fd;
		_tmp22_ = g_io_channel_unix_new (_tmp21_);
		_g_io_channel_unref0 (channel);
		channel = _tmp22_;
		_tmp23_ = channel;
		_tmp24_ = g_io_add_watch (_tmp23_, G_IO_IN | G_IO_HUP, _kernel26_rf_kill_power_control_onActionFromRfKill_gio_func, NULL);
		watch = _tmp24_;
	}
	_tmp25_ = g_strdup ("fsodevice.kernel26_rfkill");
	result = _tmp25_;
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel26_rf_kill_power_control_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel26_rfkill fso_register_function()");
}



