/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.JClass;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.service.Service;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptorGenerator
implements GeneratorPlugin {
    private Namespace xfireNs = Namespace.getNamespace((String)"http://xfire.codehaus.org/config/1.0");

    @Override
    public void generate(GenerationContext context) throws Exception {
        if (!context.isServerStubGenerated()) {
            return;
        }
        File dir = new File(context.getOutputDirectory(), "META-INF/xfire/");
        File descriptor = new File(dir, "services.xml");
        if (!context.isDescriptorOverwritten() && descriptor.exists()) {
            return;
        }
        dir.mkdirs();
        Element root = new Element("beans", this.xfireNs);
        Document doc = new Document(root);
        for (Map.Entry<QName, Collection<Service>> entry : context.getServices().entrySet()) {
            this.generate(context, root, entry.getKey(), (List)entry.getValue());
        }
        Element serviceFactoryBean = context.getSchemaGenerator().getServiceFactoryBean();
        if (serviceFactoryBean != null) {
            root.addContent((Content)serviceFactoryBean);
        }
        this.writeDocument(context, doc, descriptor);
    }

    public void generate(GenerationContext context, Element servicesEl, QName name, List<Service> services) throws Exception {
        for (Service service : services) {
            this.generate(context, servicesEl, service);
        }
    }

    public void generate(GenerationContext context, Element servicesEl, Service service) throws Exception {
        Element serviceEl = new Element("service", this.xfireNs);
        servicesEl.addContent((Content)serviceEl);
        JClass serviceImpl = (JClass)service.getProperty("service.stub");
        if (serviceImpl == null) {
            return;
        }
        Element serviceClassEl = new Element("serviceClass", this.xfireNs);
        serviceClassEl.addContent(serviceImpl.fullName());
        serviceEl.addContent((Content)serviceClassEl);
        Element wsdlEl = new Element("wsdlURL", this.xfireNs);
        wsdlEl.addContent(context.getWsdlLocation());
        serviceEl.addContent((Content)wsdlEl);
        Element serviceFactoryEl = new Element("serviceFactory", this.xfireNs);
        serviceFactoryEl.addContent(context.getSchemaGenerator().getServiceFactory());
        serviceEl.addContent((Content)serviceFactoryEl);
    }

    private void writeDocument(GenerationContext context, Document doc, File location) throws Exception {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        location.createNewFile();
        outputter.output(doc, (OutputStream)new FileOutputStream(location));
    }
}

