struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 466,
		.content = "Processor\t: ARMv7 Processor rev 3 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 3\n"
			   "\n"
			   "Hardware\t: Qualcomm MSM8226\n"
			   "Revision\t: 8400\n"
			   "Serial\t\t: d1c59d080f000000\n"
			   "Device\t\t: titan\n"
			   "Radio\t\t: 5\n"
			   "MSM Hardware\t: MSM8226 CS\n",
	},
	{
		.path = "/system/build.prop",
		.size = 7894,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MPB24.65-34\n"
			"ro.build.display.id=MPB24.65-34\n"
			"ro.build.version.incremental=31\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0\n"
			"ro.build.version.security_patch=2016-01-01\n"
			"ro.build.version.base_os=,release-keys\n"
			"ro.build.date=Wed Jan  6 12:21:20 CST 2016\n"
			"ro.build.date.utc=1452104480\n"
			"ro.build.type=user\n"
			"ro.build.user=hudsoncm\n"
			"ro.build.host=ilclbld26\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=titan_retla_ds-user\n"
			"ro.product.model=XT1068\n"
			"ro.product.brand=motorola\n"
			"ro.product.name=titan_retla_ds\n"
			"ro.product.device=titan_umtsds\n"
			"ro.product.board=MSM8226\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=motorola\n"
			"ro.product.locale=es-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8226\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=titan_umtsds\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=titan_retla_ds-user 6.0 MPB24.65-34 31 release-keys\n"
			"ro.build.fingerprint=motorola/titan_retla_ds/titan_umtsds:6.0/MPB24.65-34/31:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"#\n"
			"# from device/moto/titan_umtsds/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8226\n"
			"#\n"
			"\n"
			"# Use reference RIL for initial bringup\n"
			"#rild.libpath=/system/lib/libreference-ril.so\n"
			"rild.libpath=/vendor/lib/libril-qc-qmi-1.so\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.radio.nitz_plmn=\n"
			"persist.radio.nitz_lons_0=\n"
			"persist.radio.nitz_lons_1=\n"
			"persist.radio.nitz_lons_2=\n"
			"persist.radio.nitz_lons_3=\n"
			"persist.radio.nitz_sons_0=\n"
			"persist.radio.nitz_sons_1=\n"
			"persist.radio.nitz_sons_2=\n"
			"persist.radio.nitz_sons_3=\n"
			"ril.subscription.types=NV,RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"persist.radio.msgtunnel.start=false\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=0\n"
			"\n"
			"\n"
			"# Skip /sys/power/wait_for_fb_* nodes and\n"
			"# force FB to be always on\n"
			"debug.sf.fb_always_on=1\n"
			"\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"debug.composition.type=c2d\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"\n"
			"persist.demo.hdmirotationlock=false\n"
			"ro.hdmi.enable=true\n"
			"tunnel.decode=false\n"
			"tunnel.audiovideo.decode=false\n"
			"lpa.decode=true\n"
			"lpa.use-stagefright=true\n"
			"\n"
			"#system props for the MM modules\n"
			"\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"mmp.enable.3g2=true\n"
			"#9273 is decimal sum of supported codecs in AAL\n"
			"#codecs:(PARSER_)AVI AC3 ASF AAC QCP DTS 3G2 MP2TS\n"
			"mm.enable.qcom_parser=37491\n"
			"\n"
			"# VIDC: debug_levels\n"
			"# 1:ERROR 2:HIGH 4:LOW 0:NOlogs 7:AllLogs\n"
			"vidc.debug.level=1\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=true\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 196608 is decimal for 0x30000 to report version 3\n"
			"ro.opengles.version=196608\n"
			"\n"
			"#\n"
			"# System props for telephony\n"
			"# System prop to turn on CdmaLTEPhone always\n"
			"telephony.lteOnCdmaDevice=0\n"
			"\n"
			"#\n"
			"# enable esdfs by default\n"
			"#\n"
			"persist.esdfs_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"# System props for audio\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"ro.config.vc_call_vol_steps=8\n"
			"# FM maximum volume be between 0 and 8192 (0dB)\n"
			"ro.audio.fm_max_volume=4096\n"
			"\n"
			"#need rotation info in audio-land\n"
			"ro.audio.monitorRotation=1\n"
			"\n"
			"# Enable/disable cabl\n"
			"ro.qualcomm.cabl=0\n"
			"\n"
			"# system prop for NFC DT\n"
			"ro.nfc.port=I2C\n"
			"\n"
			"#\n"
			"# system property for Bluetooth hci transport\n"
			"#\n"
			"ro.qualcomm.bt.hci_transport=smd\n"
			"\n"
			"#\n"
			"# system property for Bluetooth HFP version\n"
			"#\n"
			"ro.bluetooth.hfp.ver=1.6\n"
			"\n"
			"#\n"
			"# system property for Bluetooth SAP support\n"
			"# Motorola disabled SAP\n"
			"#\n"
			"ro.qualcomm.bluetooth.sap=false\n"
			"\n"
			"# Bluetooth LE power class\n"
			"qcom.bt.le_dev_pwr_class=1\n"
			"\n"
			"##property to choose between virtual/external wfd display\n"
			"persist.sys.wfd.virtual=0\n"
			"# Motorola, ams087, 09/24/2013, IKJBMR2-6432 : disable tunnel audio encode\n"
			"#tunnel.audio.encode = true\n"
			"\n"
			"# Enable SSR\n"
			"persist.sys.ssr.restart_level=3\n"
			"persist.sys.qc.sub.rdump.on=1\n"
			"\n"
			"# For TCMD debug level\n"
			"persist.tcmd.log.limit=0\n"
			"\n"
			"# Disable QCOM net early sockets feature\n"
			"net.early.sockets=0\n"
			"\n"
			"# Radio RIL properties\n"
			"persist.radio.no_wait_for_card=1\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"persist.radio.dfr_mode_set=1\n"
			"persist.radio.relay_oprt_change=1\n"
			"\n"
			"#Enable offload audio playback by default\n"
			"audio.offload.disable=0\n"
			"\n"
			"#Disable offload audio video playback by default\n"
			"av.offload.enable=false\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.build.version.full=Blur_Version.24.41.34.titan_retla_ds.retla.en.01\n"
			"ro.mot.build.customerid=retla\n"
			"ro.mot.build.version.sdk_int=22\n"
			"ro.product.display=Moto G\n"
			"ro.persist.qcapb=0\n"
			"ro.build.version.qcom=AU_LINUX_ANDROID_LNX.LA.3.5.1_RB1.04.04.02.048.045\n"
			"persist.radio.plmn_name_cmp=1\n"
			"ro.camera.sound.forced=0\n"
			"ro.com.android.dataroaming=false\n"
			"persist.mot.gps.assisted=false\n"
			"persist.radio.process_sups_ind=1\n"
			"persist.radio.all_bc_msg=all\n"
			"ro.telephony.default_network=3\n"
			"persist.radio.multisim.config=dsds\n"
			"persist.radio.force_get_pref=1\n"
			"ro.config.ringtone=Moto.ogg\n"
			"ro.config.notification_sound=Moto.ogg\n"
			"ro.config.alarm_alert=Oxygen.ogg\n"
			"dalvik.vm.boot-dex2oat-threads=2\n"
			"dalvik.vm.dex2oat-threads=4\n"
			"ro.MAX_HIDDEN_APPS=12\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=96m\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"persist.sys.logkit.ctrlcode=0\n"
			"ro.vendor.extension_library=/vendor/lib/libqc-opt.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"ro.usb.mtp=0x2e82\n"
			"ro.usb.mtp_adb=0x2e76\n"
			"ro.usb.ptp=0x2e83\n"
			"ro.usb.ptp_adb=0x2e84\n"
			"ro.usb.bpt=0x2e28\n"
			"ro.usb.bpt_adb=0x2e29\n"
			"ro.usb.bpteth=0x2e2a\n"
			"ro.usb.bpteth_adb=0x2e2b\n"
			"persist.audio.calfile0=/etc/Bluetooth_cal.acdb\n"
			"persist.audio.calfile1=/etc/General_cal.acdb\n"
			"persist.audio.calfile2=/etc/Global_cal.acdb\n"
			"persist.audio.calfile3=/etc/Handset_cal.acdb\n"
			"persist.audio.calfile4=/etc/Hdmi_cal.acdb\n"
			"persist.audio.calfile5=/etc/Headset_cal.acdb\n"
			"persist.audio.calfile6=/etc/Speaker_cal.acdb\n"
			"persist.audio.dualmic.config=endfire\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicecomm=false\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.speaker=false\n"
			"ro.bug2go.magickeys=24,26\n"
			"persist.sys.qc.sub.rdump.max=0\n"
			"ro.adb.secure=1\n"
			"ro.sf.lcd_density=320\n"
			"persist.radio.apn_delay=5000\n"
			"persist.sys.media.use-awesome=false\n"
			"audio.offload.disable=0\n"
			"audio.offload.pcm.16bit.enable=false\n"
			"audio.offload.pcm.24bit.enable=false\n"
			"audio.offload.gapless.enabled=false\n"
			"av.offload.enable=false\n"
			"mm.enable.qcom_parser=4643\n"
			"persist.radio.mot_ecc_enabled=1\n"
			"persist.radio.mot_ecc_custid=common\n"
			"keyguard.no_require_sim=true\n"
			"drm.service.enabled=true\n"
			"mdc_initial_max_retry=10\n"
			"ro.com.google.clientidbase=android-motorola\n"
			"ro.com.google.clientidbase.ms=android-motorola\n"
			"ro.com.google.clientidbase.am=android-motorola\n"
			"ro.com.google.clientidbase.gmm=android-motorola\n"
			"ro.com.google.clientidbase.yt=android-motorola\n"
			"ro.url.legal=http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html\n"
			"ro.url.legal.android_privacy=http://www.google.com/intl/%s/mobile/android/basic/privacy.html\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r1\n"
			"ro.carrier=unknown\n"
			"telephony.lteOnCdmaDevice=0\n"
			"ro.media.enc.aud.fileformat=amr\n"
			"ro.media.enc.aud.codec=amrnb\n"
			"persist.sys.dalvik.vm.lib.2=libart\n"
			"dalvik.vm.isa.arm.variant=krait\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.qc.sdk.izat.premium_enabled=0\n"
			"ro.qc.sdk.izat.service_mask=0x0\n"
			"persist.gps.qc_nlp_in_use=0\n"
			"ro.gps.agps_provider=1\n"
			"persist.radio.dont_use_dsd=true\n"
			"persist.radio.set_dds_ia_apn=1\n"
			"ro.expect.recovery_id=0x60ebc3a1ec78d5e05f3e943dfc2f4418a9d7f5eb000000000000000000000000\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 31,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 71,
		.content = "CPU0:300000=0 384000=0 600000=0 787200=0 998400=0 1094400=0 1190400=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "300000 384000 600000 787200 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 68,
		.content = "300000 0\n"
			   "384000 0\n"
			   "600000 0\n"
			   "787200 0\n"
			   "998400 0\n"
			   "1094400 0\n"
			   "1190400 2628\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "300000 384000 600000 787200 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 68,
		.content = "300000 0\n"
			   "384000 0\n"
			   "600000 0\n"
			   "787200 0\n"
			   "998400 0\n"
			   "1094400 0\n"
			   "1190400 2897\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 6,
		.content = "0 1 2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 6,
		.content = "0 1 2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 52,
		.content = "300000 384000 600000 787200 998400 1094400 1190400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "787200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 68,
		.content = "300000 0\n"
			   "384000 0\n"
			   "600000 0\n"
			   "787200 0\n"
			   "998400 0\n"
			   "1094400 6\n"
			   "1190400 3170\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1190400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "787200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 69,
		.content = "300000 0\n"
			   "384000 0\n"
			   "600000 0\n"
			   "787200 0\n"
			   "998400 2\n"
			   "1094400 15\n"
			   "1190400 3428\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 3,
		.content = "16\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "audio.offload.disable",
		.value = "0",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.16bit.enable",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.24bit.enable",
		.value = "false",
	},
	{
		.key = "av.offload.enable",
		.value = "false",
	},
	{
		.key = "dalvik.vm.boot-dex2oat-threads",
		.value = "2",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.dex2oat-threads",
		.value = "4",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "96m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "krait",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.composition.type",
		.value = "c2d",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.fb_always_on",
		.value = "1",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "MSM8626BP_1032.3116.99.00R ROW_DSDS_CUST",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "MSM8626BP_1032.3116.99.00R ROW_DSDS_CUST",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.apanic_annotate",
		.value = "stopped",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.atvc",
		.value = "stopped",
	},
	{
		.key = "init.svc.atvc_core",
		.value = "stopped",
	},
	{
		.key = "init.svc.batt_health",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.dropboxd",
		.value = "running",
	},
	{
		.key = "init.svc.esdpll",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hw_revs",
		.value = "stopped",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.mbm_spy",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mmi-boot-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-radio-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-touch-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mpdecision",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.ptt_socket_app",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qe",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.rfs_access",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon1",
		.value = "running",
	},
	{
		.key = "init.svc.ril-qmi",
		.value = "stopped",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.sensord",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ss_rdump",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tcmd",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.post_fs_data_ready",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lpa.decode",
		.value = "true",
	},
	{
		.key = "lpa.use-stagefright",
		.value = "true",
	},
	{
		.key = "mdc_initial_max_retry",
		.value = "10",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "4643",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.early.sockets",
		.value = "0",
	},
	{
		.key = "net.hostname",
		.value = "android-df7da3508ca7bd5e",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "net.tcp.delack.default",
		.value = "1",
	},
	{
		.key = "net.tcp.delack.lte",
		.value = "1",
	},
	{
		.key = "net.tcp.delack.wifi",
		.value = "20",
	},
	{
		.key = "net.tcp.usercfg.default",
		.value = "0",
	},
	{
		.key = "net.tcp.usercfg.lte",
		.value = "0",
	},
	{
		.key = "net.tcp.usercfg.wifi",
		.value = "1",
	},
	{
		.key = "net.tethering.on",
		.value = "0",
	},
	{
		.key = "net.wifi.netid",
		.value = "100",
	},
	{
		.key = "persist.atvc.adb",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_all_core",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_res_core",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_res_panic",
		.value = "0",
	},
	{
		.key = "persist.atvc.log",
		.value = "0",
	},
	{
		.key = "persist.atvc.netmon_ih",
		.value = "0",
	},
	{
		.key = "persist.atvc.netmon_usb",
		.value = "0",
	},
	{
		.key = "persist.atvc.simswap",
		.value = "0",
	},
	{
		.key = "persist.atvc.uid",
		.value = "",
	},
	{
		.key = "persist.audio.calfile0",
		.value = "/etc/Bluetooth_cal.acdb",
	},
	{
		.key = "persist.audio.calfile1",
		.value = "/etc/General_cal.acdb",
	},
	{
		.key = "persist.audio.calfile2",
		.value = "/etc/Global_cal.acdb",
	},
	{
		.key = "persist.audio.calfile3",
		.value = "/etc/Handset_cal.acdb",
	},
	{
		.key = "persist.audio.calfile4",
		.value = "/etc/Hdmi_cal.acdb",
	},
	{
		.key = "persist.audio.calfile5",
		.value = "/etc/Headset_cal.acdb",
	},
	{
		.key = "persist.audio.calfile6",
		.value = "/etc/Speaker_cal.acdb",
	},
	{
		.key = "persist.audio.dualmic.config",
		.value = "endfire",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecomm",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.env.phone.global",
		.value = "false",
	},
	{
		.key = "persist.env.plmn.update",
		.value = "false",
	},
	{
		.key = "persist.esdfs_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "0",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.mot.gps.assisted",
		.value = "false",
	},
	{
		.key = "persist.mot.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.qe",
		.value = "qe 0/0",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.all_bc_msg",
		.value = "all",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.apn_delay",
		.value = "5000",
	},
	{
		.key = "persist.radio.dfr_mode_set",
		.value = "1",
	},
	{
		.key = "persist.radio.dont_use_dsd",
		.value = "true",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.force_get_pref",
		.value = "1",
	},
	{
		.key = "persist.radio.mot_ecc_custid",
		.value = "common",
	},
	{
		.key = "persist.radio.mot_ecc_enabled",
		.value = "1",
	},
	{
		.key = "persist.radio.msgtunnel.start",
		.value = "false",
	},
	{
		.key = "persist.radio.msim.stackid_0",
		.value = "0",
	},
	{
		.key = "persist.radio.msim.stackid_1",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.nitz_lons_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_lons_1",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_lons_2",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_lons_3",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_1",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_2",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_3",
		.value = "",
	},
	{
		.key = "persist.radio.no_wait_for_card",
		.value = "1",
	},
	{
		.key = "persist.radio.plmn_name_cmp",
		.value = "1",
	},
	{
		.key = "persist.radio.process_sups_ind",
		.value = "1",
	},
	{
		.key = "persist.radio.relay_oprt_change",
		.value = "1",
	},
	{
		.key = "persist.radio.set_dds_ia_apn",
		.value = "1",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:33:13:6f:17",
	},
	{
		.key = "persist.sys.country",
		.value = "",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.language",
		.value = "",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.logkit.ctrlcode",
		.value = "0",
	},
	{
		.key = "persist.sys.media.use-awesome",
		.value = "false",
	},
	{
		.key = "persist.sys.phonelock.mode",
		.value = "0",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.qc.sub.rdump.max",
		.value = "0",
	},
	{
		.key = "persist.sys.qc.sub.rdump.on",
		.value = "1",
	},
	{
		.key = "persist.sys.ssr.restart_level",
		.value = "3",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.wfd.virtual",
		.value = "0",
	},
	{
		.key = "persist.tcmd.log.limit",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.audio.init",
		.value = "complete",
	},
	{
		.key = "qcom.bt.le_dev_pwr_class",
		.value = "1",
	},
	{
		.key = "ril.baseband.config.ver_num",
		.value = "Unknown",
	},
	{
		.key = "ril.baseband.config.version",
		.value = "ROW_DSDS_CUST",
	},
	{
		.key = "ril.ecclist",
		.value = "112,911,000,08,110,999,118,119,190,066,060,*911,#911",
	},
	{
		.key = "ril.ecclist1",
		.value = "112,911,000,08,110,999,118,119,190,066,060,*911,#911",
	},
	{
		.key = "ril.lte.bc.config",
		.value = "0",
	},
	{
		.key = "ril.qcril_pre_init_lock_held",
		.value = "0",
	},
	{
		.key = "ril.radio.ctbk_inst",
		.value = "773",
	},
	{
		.key = "ril.radio.ctbk_val",
		.value = "1,0,0,0,0,0,1,0,0,0,1,0",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/vendor/lib/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.MAX_HIDDEN_APPS",
		.value = "12",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.fm_max_volume",
		.value = "4096",
	},
	{
		.key = "ro.audio.monitorRotation",
		.value = "1",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8226",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "0x4886",
	},
	{
		.key = "ro.boot.carrier",
		.value = "retla",
	},
	{
		.key = "ro.boot.cid",
		.value = "0xC",
	},
	{
		.key = "ro.boot.device",
		.value = "titan",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.fsg-id",
		.value = "",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.hwrev",
		.value = "0x8400",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.powerup_reason",
		.value = "0x00004000",
	},
	{
		.key = "ro.boot.radio",
		.value = "0x5",
	},
	{
		.key = "ro.boot.secure_hardware",
		.value = "1",
	},
	{
		.key = "ro.boot.serialno",
		.value = "ZX1D23P5LS",
	},
	{
		.key = "ro.boot.write_protect",
		.value = "0",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Wed Jan 6 12:27:27 CST 2016",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1452104847",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "motorola/titan_retla_ds/titan_umtsds:6.0/MPB24.65-34/31:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "0x4886",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.bug2go.magickeys",
		.value = "24,26",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Wed Jan  6 12:21:20 CST 2016",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1452104480",
	},
	{
		.key = "ro.build.description",
		.value = "titan_retla_ds-user 6.0 MPB24.65-34 31 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "MPB24.65-34",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "motorola/titan_retla_ds/titan_umtsds:6.0/MPB24.65-34/31:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "titan_retla_ds-user",
	},
	{
		.key = "ro.build.host",
		.value = "ilclbld26",
	},
	{
		.key = "ro.build.id",
		.value = "MPB24.65-34",
	},
	{
		.key = "ro.build.product",
		.value = "titan_umtsds",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "hudsoncm",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = ",release-keys",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.full",
		.value = "Blur_Version.24.41.34.titan_retla_ds.retla.en.01",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "31",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.qcom",
		.value = "AU_LINUX_ANDROID_LNX.LA.3.5.1_RB1.04.04.02.048.045",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-01-01",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "retla",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r1",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Oxygen.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Moto.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Moto.ogg",
	},
	{
		.key = "ro.config.vc_call_vol_steps",
		.value = "8",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x60ebc3a1ec78d5e05f3e943dfc2f4418a9d7f5eb000000000000000000000000",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdmi.enable",
		.value = "true",
	},
	{
		.key = "ro.hw.device",
		.value = "titan",
	},
	{
		.key = "ro.hw.hwrev",
		.value = "0x8400",
	},
	{
		.key = "ro.hw.radio",
		.value = "0x5",
	},
	{
		.key = "ro.hw.revision",
		.value = "p4",
	},
	{
		.key = "ro.manufacturedate",
		.value = "Unknown",
	},
	{
		.key = "ro.media.enc.aud.codec",
		.value = "amrnb",
	},
	{
		.key = "ro.media.enc.aud.fileformat",
		.value = "amr",
	},
	{
		.key = "ro.mot.build.customerid",
		.value = "retla",
	},
	{
		.key = "ro.mot.build.version.sdk_int",
		.value = "22",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.persist.qcapb",
		.value = "0",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8226",
	},
	{
		.key = "ro.product.brand",
		.value = "motorola",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.device",
		.value = "titan_umtsds",
	},
	{
		.key = "ro.product.display",
		.value = "Moto G",
	},
	{
		.key = "ro.product.locale",
		.value = "es-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "motorola",
	},
	{
		.key = "ro.product.model",
		.value = "XT1068",
	},
	{
		.key = "ro.product.name",
		.value = "titan_retla_ds",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.izat.premium_enabled",
		.value = "0",
	},
	{
		.key = "ro.qc.sdk.izat.service_mask",
		.value = "0x0",
	},
	{
		.key = "ro.qualcomm.bluetooth.sap",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "0",
	},
	{
		.key = "ro.revision",
		.value = "p400",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1515124311385",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "ZX1D23P5LS",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "3",
	},
	{
		.key = "ro.url.legal",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html",
	},
	{
		.key = "ro.url.legal.android_privacy",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/privacy.html",
	},
	{
		.key = "ro.usb.bpt",
		.value = "0x2e28",
	},
	{
		.key = "ro.usb.bpt_adb",
		.value = "0x2e29",
	},
	{
		.key = "ro.usb.bpteth",
		.value = "0x2e2a",
	},
	{
		.key = "ro.usb.bpteth_adb",
		.value = "0x2e2b",
	},
	{
		.key = "ro.usb.mtp",
		.value = "0x2e82",
	},
	{
		.key = "ro.usb.mtp_adb",
		.value = "0x2e76",
	},
	{
		.key = "ro.usb.ptp",
		.value = "0x2e83",
	},
	{
		.key = "ro.usb.ptp_adb",
		.value = "0x2e84",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "/vendor/lib/libqc-opt.so",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.bootbroadcast_completed",
		.value = "0",
	},
	{
		.key = "sys.runtime.restart.times",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.sysctl.tcp_def_init_rwnd",
		.value = "60",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "tcmd.blan.interface",
		.value = "usb0",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "tunnel.audiovideo.decode",
		.value = "false",
	},
	{
		.key = "tunnel.decode",
		.value = "false",
	},
	{
		.key = "vidc.debug.level",
		.value = "1",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/system/etc/firmware/wlan/prima/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
