/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class MetaTagAdjuster
extends ProxyReceiver {
    boolean seekingHead = true;
    int droppingMetaTags = -1;
    boolean inMetaTag = false;
    boolean foundHead = false;
    int metaCode;
    short requiredURICode = 0;
    AttributeCollectionImpl attributes;
    String encoding;
    String mediaType;
    int level = 0;
    boolean isXHTML = false;

    public void setOutputProperties(Properties properties) {
        this.encoding = properties.getProperty("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.mediaType = properties.getProperty("media-type");
        if (this.mediaType == null) {
            this.mediaType = "text/html";
        }
    }

    public void setIsXHTML(boolean bl) {
        this.isXHTML = bl;
        this.requiredURICode = bl ? this.getNamePool().getCodeForURI("http://www.w3.org/1999/xhtml") : (short)0;
    }

    private boolean comparesEqual(String string, String string2) {
        if (this.isXHTML) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.droppingMetaTags == this.level) {
            this.metaCode = n;
            short s = this.getNamePool().getURICode(n);
            String string = this.getNamePool().getLocalName(n);
            if (s == this.requiredURICode && this.comparesEqual(string, "meta")) {
                this.inMetaTag = true;
                this.attributes.clear();
                return;
            }
        }
        ++this.level;
        this.nextReceiver.startElement(n, n2, n3, n4);
        if (this.seekingHead) {
            NamePool namePool = this.getNamePool();
            short s = namePool.getURICode(n);
            String string = namePool.getLocalName(n);
            if (s == this.requiredURICode && this.comparesEqual(string, "head")) {
                this.foundHead = true;
            }
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.inMetaTag) {
            this.attributes.addAttribute(n, n2, charSequence.toString(), n3, n4);
        } else {
            this.nextReceiver.attribute(n, n2, charSequence, n3, n4);
        }
    }

    public void startContent() throws XPathException {
        if (this.foundHead) {
            this.foundHead = false;
            NamePool namePool = this.getNamePool();
            this.nextReceiver.startContent();
            int n = namePool.allocate("", this.requiredURICode, "meta");
            this.nextReceiver.startElement(n, 641, 0, 0);
            int n2 = namePool.allocate("", "", "http-equiv");
            this.nextReceiver.attribute(n2, 642, "Content-Type", 0, 0);
            int n3 = namePool.allocate("", "", "content");
            this.nextReceiver.attribute(n3, 642, this.mediaType + "; charset=" + this.encoding, 0, 0);
            this.nextReceiver.startContent();
            this.droppingMetaTags = this.level;
            this.seekingHead = false;
            this.attributes = new AttributeCollectionImpl(namePool);
            this.nextReceiver.endElement();
        }
        if (!this.inMetaTag) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        if (this.inMetaTag) {
            int n;
            this.inMetaTag = false;
            boolean bl = false;
            for (n = 0; n < this.attributes.getLength(); ++n) {
                String string;
                String string2 = this.attributes.getLocalName(n);
                if (!this.comparesEqual(string2, "http-equiv") || !(string = this.attributes.getValue(n).trim()).equalsIgnoreCase("Content-Type")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.nextReceiver.startElement(this.metaCode, 641, 0, 0);
                for (n = 0; n < this.attributes.getLength(); ++n) {
                    int n2 = this.attributes.getNameCode(n);
                    int n3 = this.attributes.getTypeAnnotation(n);
                    String string = this.attributes.getValue(n);
                    int n4 = this.attributes.getLocationId(n);
                    int n5 = this.attributes.getProperties(n);
                    this.nextReceiver.attribute(n2, n3, string, n4, n5);
                }
                this.nextReceiver.startContent();
                this.nextReceiver.endElement();
            }
        } else {
            --this.level;
            if (this.droppingMetaTags == this.level + 1) {
                this.droppingMetaTags = -1;
            }
            this.nextReceiver.endElement();
        }
    }
}

