class font_factory {

public:
  font_factory();
  
  virtual ~font_factory();

  Fl_Font get_actual_font(Fl_Font alias);
  

protected:
  void search_for_font(const char* desidered, Fl_Font destination, int num_fonts);
  void set_actual_font_from_prefs();
  std::map<Fl_Font,Fl_Font> _fonts;
};

class font_map_singleton {

public:

  static font_factory* get_context();
  static void     free_context();
  static bool     works();

protected:
  font_map_singleton();

  static font_factory* factory;

};
