/*
    kwintv, Video4Linux based TV application

    Copyright (C) 1998,1999 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PARSECL_H
#define PARSECL_H

#include <default.h>
#include <avm_stl.h>












struct parse_option {
    int oshort;
    const char* olong;
    const char* help;

    void* val;
    enum { BOOL, INT, STRING, ANYSTRING, CODECINFO } type;
    int maxval;
    int minval;
    const char* arr[];
};

class parsecl
{
public:
    parsecl(int _argc = 0, char *_argv[] = 0,
	    const struct parse_option* opt = 0,
	    const char* help = 0);
    ~parsecl();

    int getInt(int oid, int odefault, int min, int max) const;
    const char * getString(int oid, const char* odefault, const char* opt[] = 0) const;
    bool getSwitch(int oid, bool odefault) const;

protected:
    const char* find(int oid) const;
    int argc;
    char** argv;
    const struct parse_option* opt;
};

#endif /* PARSECL_H */
