#!/usr/bin/perl

use strict;
use warnings;

my $check = 0;
my $prev  = <>;
my $buf   = "";

while ( <> )
{
   s/[\s]+$//;
   s/\t/        /g;
   s/^[\s]+subroutine/subroutine/;
   s/^[\s]+end subroutine/end subroutine/;
   s/^[\s]+module ([^ ]*)$/module $1/;
   s/^[\s]+end module/end module/;
   s/^#[\s]+/#/;
   s/enddo/end do/;
   s/([^#])endif/$1end if/;
   s/#end if/#endif/;   # This line fixes a former bug

   if ( $check == 2 )
   {
      if ( ! /implicit none/ )
      {
         $buf .= "\n";
      }
   }
   else
   {
      $buf .= $prev;
   }

   if ( /^$/ )
   {
      $check++;
   }
   else
   {
      $check = 0;
   }

   $prev = "$_\n";
}

$_ = $prev;

if ( ! /^$/ )
{
   $buf .= $prev;
}

$_ = $buf;

print $_;
