/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_DHCPELEMENTSETTINGDATA_H_
#define OPENDRIM_DHCPELEMENTSETTINGDATA_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_SettingData.h"
#include "CIM_SettingDataAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_DHCPElementSettingData_classnames[] = {"OpenDRIM_DHCPElementSettingData"};
static string OpenDRIM_DHCPElementSettingData_NAMESPACE = _NAMESPACE;
const static string SettingData_role = "SettingData";
const static char* SettingData_classnames[] = {"OpenDRIM_DHCPSettingData"};
const static string SettingData_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_DHCPProtocolEndpoint"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_DHCPElementSettingData {

public:
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	Objectpath SettingData;
	bool SettingData_isNULL;
	
	unsigned short IsDefault;
	bool IsDefault_isNULL;
	
	unsigned short IsCurrent;
	bool IsCurrent_isNULL;
	
	unsigned short IsNext;
	bool IsNext_isNULL;
	
	OpenDRIM_DHCPElementSettingData() {
		ManagedElement_isNULL = true;
		SettingData_isNULL = true;
		IsDefault_isNULL = true;
		IsCurrent_isNULL = true;
		IsNext_isNULL = true;
	}
	
	~OpenDRIM_DHCPElementSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\""".SettingData=\"" + CF_quoteString(SettingData.toString()) + "\"");
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

	int getSettingData(Objectpath& value) const {
		if (SettingData_isNULL==true)
			return NOT_FOUND;
		value = SettingData;
		return OK;
	}
	
	int setSettingData(const Objectpath& newValue) {
		SettingData = newValue;
		SettingData.setNamespace(SettingData_NAMESPACE);
		SettingData_isNULL = false;
		return OK;
	}

	int getIsDefault(unsigned short& value) const {
		if (IsDefault_isNULL==true)
			return NOT_FOUND;
		value = IsDefault;
		return OK;
	}
	
	int setIsDefault(const unsigned short& newValue) {
		IsDefault = newValue;
		IsDefault_isNULL = false;
		return OK;
	}

	int getIsCurrent(unsigned short& value) const {
		if (IsCurrent_isNULL==true)
			return NOT_FOUND;
		value = IsCurrent;
		return OK;
	}
	
	int setIsCurrent(const unsigned short& newValue) {
		IsCurrent = newValue;
		IsCurrent_isNULL = false;
		return OK;
	}

	int getIsNext(unsigned short& value) const {
		if (IsNext_isNULL==true)
			return NOT_FOUND;
		value = IsNext;
		return OK;
	}
	
	int setIsNext(const unsigned short& newValue) {
		IsNext = newValue;
		IsNext_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_DHCPELEMENTSETTINGDATA_H_*/
