#!/bin/bash
#
# Copyright 2009-2020 Intel Corporation.
#
# This software and the related documents are Intel copyrighted materials, and
# your use of them is governed by the express license under which they were
# provided to you ("License"). Unless the License provides otherwise, you may
# not use, modify, copy, publish, distribute, disclose or transmit this software
# or the related documents without Intel's prior written permission.
# 
# This software and the related documents are provided as is, with no express
# or implied warranties, other than those that are expressly stated in the
# License.

# Bourne Shell script for the Intel(R) Parallel Studio XE 2020 Update 4 for Linux* OS

SCRIPTPATH=%INSTALLDIR%
ROOTPATH=%INSTALLDIR_ROOT%
INTEL_TARGET_ARCH="intel64"
ITAC_PARAM=""

while [ $# -gt 0 ]; do
    arg="$1"
    if [ -n "$arg" ]; then
        case "$arg" in
            ia32 )       INTEL_TARGET_ARCH="ia32"    ;;
            intel64 )    INTEL_TARGET_ARCH="intel64" ;;
            impi64 )     ITAC_PARAM="$arg"           ;;
            * )          break                       ;;
        esac
    fi
    shift
done

echo "Intel(R) Parallel Studio XE 2020 Update 4 for Linux*"
echo "Copyright 2009-2020 Intel Corporation."

if [[ -f "$SCRIPTPATH/compilers_and_libraries_2020/linux/bin/compilervars.sh" ]]; then
    . "$SCRIPTPATH/compilers_and_libraries_2020/linux/bin/compilervars.sh" "$INTEL_TARGET_ARCH"
fi

if [ x"$INTEL_TARGET_ARCH" = x"intel64" ]; then
    if [[ -f "$SCRIPTPATH/clck_2019/bin/clckvars.sh" ]]; then
        . "$SCRIPTPATH/clck_2019/bin/clckvars.sh" 
    fi
fi

if [[ -f "$SCRIPTPATH/itac_2020/bin/itacvars.sh" ]]; then
    . "$SCRIPTPATH/itac_2020/bin/itacvars.sh" "$ITAC_PARAM"
fi

if [[ -f "$SCRIPTPATH/inspector_2020/inspxe-vars.sh" ]]; then
    . "$SCRIPTPATH/inspector_2020/inspxe-vars.sh" quiet
fi

if [[ -f "$SCRIPTPATH/vtune_profiler_2020/vtune-vars.sh" ]]; then
    . "$SCRIPTPATH/vtune_profiler_2020/vtune-vars.sh" quiet
fi

if [[ -f "$SCRIPTPATH/advisor_2020/advixe-vars.sh" ]]; then
    . "$SCRIPTPATH/advisor_2020/advixe-vars.sh" quiet
fi

if [[ -f "$ROOTPATH/intelpython3/bin/activate" ]]; then
    export SETVARS_CALL=1
    BACKUP_PROMPT="$PS1"
    . "$ROOTPATH/intelpython3/bin/activate"
    export PS1=$BACKUP_PROMPT
    unset BACKUP_PROMPT
    unset SETVARS_CALL
fi

export PATH="${PATH}:$SCRIPTPATH/bin"

if [ -z "${INTEL_LICENSE_FILE}" ]; then
    export INTEL_LICENSE_FILE="$ROOTPATH/licenses"
else
    export INTEL_LICENSE_FILE="$ROOTPATH/licenses:$INTEL_LICENSE_FILE"
fi
