/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGEXIT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgExitGetopt(struct Cfg_Getopt *optstru)

	The user must free resources allocated by himself *before* calling
	this function.
	Free all automatically allocated resources, the clears the structure.

ob(ject): cfgExitGetopt
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Terminate the \subsys{cmdline}
he(ader files): 
lo(ng description): Free all internally allocated resources, closes & frees all
	items of the input and output stacks, then the structures are marked as
	"unused".
pr(erequistes): 
va(lue): 
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgexit.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "supplio.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGEXIT.C 1.5 1999/12/13 02:22:09 ska Exp ska $";
#endif

void cfgExitGetopt(struct Cfg_Getopt *optstru)
{	DBG_ENTER("cfgExitGetopt", Suppl_cmdline)

	assert(optstru);

	/* first free all contexts */
	chkHeap
	while(C(_stk))
		cfg_pop(optstru);
	while(C(_oHead))
		cfg_ostkDel(optstru, C(_oHead));

	/* free the resources in the main structure */
	chkHeap
	free(C(_hbuf));

	chkHeap
	cfgInitGetopt(optstru);

	chkHeap
	DBG_EXIT
}
