/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import [Ljava.awt.Component;;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import sun.awt.AWTAccessor;
import sun.awt.DebugHelper;

public class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[0];
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private transient FocusTraversalPolicy focusTraversalPolicy;
    private boolean focusCycleRoot = false;
    private boolean focusTraversalPolicyProvider;
    private transient Set printingThreads;
    private transient boolean printing = false;
    transient ContainerListener containerListener;
    transient int listeningChildren;
    transient int listeningBoundsChildren;
    transient int descendantsCount;
    private static final long serialVersionUID = 4613797578919906343L;
    private static final DebugHelper dbg = DebugHelper.create((Class)Container.class);
    static final boolean INCLUDE_SELF = true;
    static final boolean SEARCH_HEAVYWEIGHTS = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ncomponents", Integer.TYPE), new ObjectStreamField("component", Component;.class), new ObjectStreamField("layoutMgr", LayoutManager.class), new ObjectStreamField("dispatcher", LightweightDispatcher.class), new ObjectStreamField("maxSize", Dimension.class), new ObjectStreamField("focusCycleRoot", Boolean.TYPE), new ObjectStreamField("containerSerializedDataVersion", Integer.TYPE), new ObjectStreamField("focusTraversalPolicyProvider", Boolean.TYPE)};
    private int containerSerializedDataVersion = 1;

    private static native void initIDs();

    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[4];
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("No such child: " + n);
            }
            return this.component[n];
        }
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Component[] getComponents_NoClientCode() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            return componentArray;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer != null && this.peer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            return (Insets)containerPeer.insets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    void checkTreeLock() {
        if (!Thread.holdsLock(this.getTreeLock())) {
            throw new IllegalStateException("This function should be called while holding treeLock");
        }
    }

    private void checkAdding(Component component, int n) {
        Window window;
        Container container;
        this.checkTreeLock();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (n > this.ncomponents || n < 0) {
            throw new IllegalArgumentException("illegal component position");
        }
        if (component.parent == this && n == this.ncomponents) {
            throw new IllegalArgumentException("illegal component position " + n + " should be less then " + this.ncomponents);
        }
        if (component instanceof Container) {
            container = this;
            while (container != null) {
                if (container == component) {
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
                container = container.parent;
            }
            if (component instanceof Window) {
                throw new IllegalArgumentException("adding a window to a container");
            }
        }
        if ((container = this.getContainingWindow()) != (window = component.getContainingWindow())) {
            throw new IllegalArgumentException("component and container should be in the same top-level window");
        }
        if (graphicsConfiguration != null) {
            component.checkGD(graphicsConfiguration.getDevice().getIDstring());
        }
    }

    private void removeDelicately(Component component, Container container, int n) {
        this.checkTreeLock();
        int n2 = this.getComponentZOrder(component);
        if (Container.isRemoveNotifyNeeded(component, this, container)) {
            component.removeNotify();
        }
        if (container != this) {
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            System.arraycopy(this.component, n2 + 1, this.component, n2, this.ncomponents - n2 - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
        } else {
            if (n > n2) {
                if (n - n2 > 0) {
                    System.arraycopy(this.component, n2 + 1, this.component, n2, n - n2);
                }
            } else if (n2 - n > 0) {
                System.arraycopy(this.component, n, this.component, n + 1, n2 - n);
            }
            this.component[n] = component;
        }
        if (component.parent == null) {
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canContainFocusOwner(Component component) {
        Object object;
        if (!(this.isEnabled() && this.isDisplayable() && this.isVisible() && this.isFocusable())) {
            return false;
        }
        if (this.isFocusCycleRoot() && (object = this.getFocusTraversalPolicy()) instanceof DefaultFocusTraversalPolicy && !((DefaultFocusTraversalPolicy)object).accept(component)) {
            return false;
        }
        object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null) {
                return this.parent.canContainFocusOwner(component);
            }
        }
        return true;
    }

    private boolean hasHeavyweightChildren() {
        this.checkTreeLock();
        boolean bl = true;
        for (int i = 0; i < this.getComponentCount() && bl; ++i) {
            Component component = this.getComponent(i);
            if (!(bl &= component.isLightweight()) || !(component instanceof Container)) continue;
            bl &= !((Container)component).hasHeavyweightChildren();
        }
        return !bl;
    }

    Container getHeavyweightContainer() {
        this.checkTreeLock();
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            return this;
        }
        return this.getNativeContainer();
    }

    private static boolean isRemoveNotifyNeeded(Component component, Container container, Container container2) {
        Container container3;
        if (container == null) {
            return false;
        }
        if (component.peer == null) {
            return false;
        }
        if (container2.peer == null) {
            return true;
        }
        if (component.isLightweight()) {
            if (component instanceof Container) {
                return ((Container)component).hasHeavyweightChildren();
            }
            return false;
        }
        Container container4 = container.getHeavyweightContainer();
        if (container4 != (container3 = container2.getHeavyweightContainer())) {
            return !component.peer.isReparentSupported();
        }
        return !component.isLightweight() && !((ContainerPeer)container4.peer).isRestackSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setComponentZOrder(Component component, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = component.parent;
            if (container == this && n == this.getComponentZOrder(component)) {
                return;
            }
            this.checkAdding(component, n);
            if (container != null) {
                container.removeDelicately(component, this, n);
            }
            this.addDelicately(component, container, n);
        }
    }

    private void reparentTraverse(ContainerPeer containerPeer, Container container) {
        this.checkTreeLock();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component.isLightweight()) {
                if (!(component instanceof Container)) continue;
                this.reparentTraverse(containerPeer, (Container)component);
                continue;
            }
            component.getPeer().reparent(containerPeer);
        }
    }

    private void reparentChild(Component component) {
        this.checkTreeLock();
        if (component == null) {
            return;
        }
        if (component.isLightweight()) {
            if (component instanceof Container) {
                this.reparentTraverse((ContainerPeer)this.getPeer(), (Container)component);
            }
        } else {
            component.getPeer().reparent((ContainerPeer)this.getPeer());
        }
    }

    private void addDelicately(Component component, Container container, int n) {
        Object object;
        this.checkTreeLock();
        if (container != this) {
            if (this.ncomponents == this.component.length) {
                object = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object, 0, this.ncomponents);
                this.component = object;
            }
            if (n == -1 || n == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
        } else if (n < this.ncomponents) {
            this.component[n] = component;
        }
        if (this.valid) {
            this.invalidate();
        }
        if (this.peer != null) {
            if (component.peer == null) {
                component.addNotify();
                object = this.getHeavyweightContainer();
                if (((ContainerPeer)((Component)object).getPeer()).isRestackSupported()) {
                    ((ContainerPeer)((Component)object).getPeer()).restack();
                }
            } else {
                object = this.getHeavyweightContainer();
                Container container2 = container.getHeavyweightContainer();
                if (container2 != object) {
                    super.reparentChild(component);
                }
                if ((!component.isLightweight() || component instanceof Container) && ((ContainerPeer)((Component)object).getPeer()).isRestackSupported()) {
                    ((ContainerPeer)((Component)object).getPeer()).restack();
                }
                if (!component.isLightweight() && this.isLightweight()) {
                    if (!container.isLightweight()) {
                        component.nativeInLightFixer = new Component.NativeInLightFixer((Component)this);
                    } else {
                        component.nativeInLightFixer.install(this);
                    }
                }
            }
        }
        if (container != this) {
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, null);
                } else {
                    this.layoutMgr.addLayoutComponent(null, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object = new ContainerEvent(this, 300, component);
                this.dispatchEvent((AWTEvent)object);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (component.isFocusOwner() && !component.canBeFocusOwner()) {
                component.transferFocus();
            } else if (component instanceof Container && (object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && this.isParentOf((Component)object) && !((Component)object).canBeFocusOwner()) {
                ((Component)object).transferFocus();
            }
        } else {
            component.createHierarchyEvents(1400, component, this, 1400L, Toolkit.enabledOnToolkit(32768L));
        }
        if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
            this.updateCursorImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getComponentZOrder(Component component) {
        if (component == null) {
            return -1;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent != this) {
                return -1;
            }
            for (int i = 0; i < this.ncomponents; ++i) {
                if (this.component[i] != component) continue;
                return i;
            }
        }
        return -1;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n > this.ncomponents || n < 0 && n != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                object3 = this;
                while (object3 != null) {
                    if (object3 == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    object3 = object3.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                component.parent.remove(component);
                if (n > this.ncomponents) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (this.ncomponents == this.component.length) {
                object3 = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object3, 0, this.ncomponents);
                this.component = object3;
            }
            if (n == -1 || n == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object3 = new ContainerEvent((Component)this, 300, component);
                this.dispatchEvent((AWTEvent)object3);
            }
            component.createHierarchyEvents(1400, component, (Container)this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    void checkGD(String string) {
        for (int i = 0; i < this.component.length; ++i) {
            Component component = this.component[i];
            if (component == null) continue;
            component.checkGD(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            Component component = this.component[n];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent == this) {
                Component[] componentArray = this.component;
                int n = this.ncomponents;
                while (--n >= 0) {
                    if (componentArray[n] != component) continue;
                    this.remove(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.adjustListeningChildren(32768L, -this.listeningChildren);
            this.adjustListeningChildren(65536L, -this.listeningBoundsChildren);
            this.adjustDescendants(-this.descendantsCount);
            while (this.ncomponents > 0) {
                Component component = this.component[--this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            }
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    int numListening(long l) {
        int n = super.numListening(l);
        if (l == 32768L) {
            return this.listeningChildren + n;
        }
        if (l == 65536L) {
            return this.listeningBoundsChildren + n;
        }
        return n;
    }

    void adjustListeningChildren(long l, int n) {
        if (n == 0) {
            return;
        }
        if ((l & 0x8000L) != 0L) {
            this.listeningChildren += n;
        }
        if ((l & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n;
        }
        this.adjustListeningChildrenOnParent(l, n);
    }

    void adjustDescendants(int n) {
        if (n == 0) {
            return;
        }
        this.descendantsCount += n;
        this.adjustDecendantsOnParent(n);
    }

    void adjustDecendantsOnParent(int n) {
        if (this.parent != null) {
            this.parent.adjustDescendants(n);
        }
    }

    int countHierarchyMembers() {
        return this.descendantsCount;
    }

    int createHierarchyEvents(int n, Component component, Container container, long l, boolean bl) {
        int n2 = 0;
        switch (n) {
            case 1400: {
                n2 = this.listeningChildren;
                break;
            }
            case 1401: 
            case 1402: {
                n2 = this.listeningBoundsChildren;
                break;
            }
        }
        if (bl) {
            n2 = this.descendantsCount;
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            n3 -= this.component[n4].createHierarchyEvents(n, component, container, l, bl);
            ++n4;
        }
        return n2 + super.createHierarchyEvents(n, component, container, l, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createChildHierarchyEvents(int n, long l, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            switch (n) {
                case 1400: {
                    n2 = this.listeningChildren;
                    break;
                }
                case 1401: 
                case 1402: {
                    n2 = this.listeningBoundsChildren;
                    break;
                }
            }
            if (bl) {
                n2 = this.descendantsCount;
            }
            int n3 = n2;
            int n4 = 0;
            while (n3 > 0) {
                n3 -= this.component[n4].createHierarchyEvents(n, this, this.parent, l, bl);
                ++n4;
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    public void invalidate() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            boolean bl = false;
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.valid && this.peer != null) {
                    ContainerPeer containerPeer = null;
                    if (this.peer instanceof ContainerPeer) {
                        containerPeer = (ContainerPeer)this.peer;
                    }
                    if (containerPeer != null) {
                        containerPeer.beginValidate();
                    }
                    this.validateTree();
                    this.valid = true;
                    if (containerPeer != null) {
                        containerPeer.endValidate();
                        bl = this.isVisible();
                    }
                }
            }
            if (bl) {
                this.updateCursorImmediately();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).beginLayout();
            }
            this.doLayout();
            Component[] componentArray = this.component;
            for (int i = 0; i < this.ncomponents; ++i) {
                Component component = componentArray[i];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                    continue;
                }
                component.validate();
            }
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).endLayout();
            }
        }
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.ncomponents; ++i) {
                Component component = this.component[i];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                    continue;
                }
                if (!component.valid) continue;
                component.invalidate();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public void setFont(Font font) {
        boolean bl = false;
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension == null || !this.isPreferredSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension == null || !this.isMinimumSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension == null || !this.isMaximumSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                    this.maxSize = layoutManager2.maximumLayoutSize(this);
                } else {
                    this.maxSize = super.getMaximumSize();
                }
                dimension = this.maxSize;
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentX() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentY() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            if (this.printing) {
                Container container = this;
                synchronized (container) {
                    if (this.printing && this.printingThreads.contains(Thread.currentThread())) {
                        return;
                    }
                }
            }
            GraphicsCallback.PaintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        if (this.isShowing()) {
            Container container;
            Thread thread = Thread.currentThread();
            try {
                container = this;
                synchronized (container) {
                    if (this.printingThreads == null) {
                        this.printingThreads = new HashSet();
                    }
                    this.printingThreads.add(thread);
                    this.printing = true;
                }
                super.print(graphics);
                container = this;
            }
            catch (Throwable throwable) {
                Container container2 = this;
                synchronized (container2) {
                    this.printingThreads.remove(thread);
                    this.printing = !this.printingThreads.isEmpty();
                }
                throw throwable;
            }
            synchronized (container) {
                this.printingThreads.remove(thread);
                this.printing = !this.printingThreads.isEmpty();
            }
            GraphicsCallback.PrintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPaint(Graphics graphics) {
        super.lightweightPaint(graphics);
        this.paintHeavyweightComponents(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printHeavyweightComponents(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])this.getListeners(ContainerListener.class);
    }

    public EventListener[] getListeners(Class clazz) {
        ContainerListener containerListener = null;
        if (clazz != ContainerListener.class) {
            return super.getListeners(clazz);
        }
        containerListener = this.containerListener;
        return AWTEventMulticaster.getListeners((EventListener)containerListener, (Class)clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 300 || n == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        ContainerListener containerListener = this.containerListener;
        if (containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    containerListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
        switch (aWTEvent.getID()) {
            case 101: {
                this.createChildHierarchyEvents(1402, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
            case 100: {
                this.createChildHierarchyEvents(1401, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
        }
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    Component getMouseEventTarget(int n, int n2, boolean bl) {
        return this.getMouseEventTarget(n, n2, bl, MouseEventTargetFilter.FILTER, false);
    }

    Component getDropTargetEventTarget(int n, int n2, boolean bl) {
        return this.getMouseEventTarget(n, n2, bl, DropTargetEventTargetFilter.FILTER, true);
    }

    private Component getMouseEventTarget(int n, int n2, boolean bl, EventTargetFilter eventTargetFilter, boolean bl2) {
        Component component = null;
        if (bl2) {
            component = this.getMouseEventTargetImpl(n, n2, bl, eventTargetFilter, true, bl2);
        }
        if (component == null || component == this) {
            component = this.getMouseEventTargetImpl(n, n2, bl, eventTargetFilter, false, bl2);
        }
        return component;
    }

    private Component getMouseEventTargetImpl(int n, int n2, boolean bl, EventTargetFilter eventTargetFilter, boolean bl2, boolean bl3) {
        int n3;
        int n4 = this.ncomponents;
        Component[] componentArray = this.component;
        for (n3 = 0; n3 < n4; ++n3) {
            Component component = componentArray[n3];
            if (component == null || !component.visible || (bl2 || !(component.peer instanceof LightweightPeer)) && (!bl2 || component.peer instanceof LightweightPeer) || !component.contains(n - component.x, n2 - component.y)) continue;
            if (component instanceof Container) {
                Container container = (Container)component;
                Component component2 = container.getMouseEventTarget(n - container.x, n2 - container.y, bl, eventTargetFilter, bl3);
                if (component2 == null) continue;
                return component2;
            }
            if (!eventTargetFilter.accept(component)) continue;
            return component;
        }
        n3 = this.peer instanceof LightweightPeer || bl ? 1 : 0;
        boolean bl4 = this.contains(n, n2);
        if (bl4 && n3 != 0 && eventTargetFilter.accept(this)) {
            return this;
        }
        return null;
    }

    void proxyEnableEvents(long l) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyEnableEvents(l);
            }
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l);
        }
    }

    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component locate(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            int n3;
            for (n3 = 0; n3 < this.ncomponents; ++n3) {
                component = this.component[n3];
                if (component == null || component.peer instanceof LightweightPeer || !component.contains(n - component.x, n2 - component.y)) continue;
                return component;
            }
            for (n3 = 0; n3 < this.ncomponents; ++n3) {
                component = this.component[n3];
                if (component == null || !(component.peer instanceof LightweightPeer) || !component.contains(n - component.x, n2 - component.y)) continue;
                return component;
            }
        }
        return this;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getMousePosition(boolean bl) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PointerInfo pointerInfo = (PointerInfo)AccessController.doPrivileged(new AWTAccessor.ContainerAccessor(this){

            @Override
            public void validateUnconditionally(Container cont) {
                cont.validateUnconditionally();
            }

            @Override
            public Component findComponentAt(Container cont, int x, int y, boolean ignoreEnabled) {
                return cont.findComponentAt(x, y, ignoreEnabled);
            }

            @Override
            public void startLWModal(Container cont) {
                cont.startLWModal();
            }

            @Override
            public void stopLWModal(Container cont) {
                cont.stopLWModal();
            }
        });
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.findUnderMouseInWindow(pointerInfo);
            if (this.isSameOrAncestorOf(component, bl)) {
                return this.pointRelativeToComponent(pointerInfo.getLocation());
            }
            return null;
        }
    }

    boolean isSameOrAncestorOf(Component component, boolean bl) {
        return this == component || bl && this.isParentOf(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component findComponentAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.findComponentAt(n, n2, true);
        }
    }

    final Component findComponentAt(int n, int n2, boolean bl) {
        if (this.isShowing()) {
            return this.findComponentAtImpl(n, n2, bl);
        }
        return null;
    }

    final Component findComponentAtImpl(int n, int n2, boolean bl) {
        Component component;
        int n3;
        if (!this.contains(n, n2) || !this.visible || !bl && !this.enabled) {
            return null;
        }
        int n4 = this.ncomponents;
        Component[] componentArray = this.component;
        for (n3 = 0; n3 < n4; ++n3) {
            component = componentArray[n3];
            if (component == null || component.peer instanceof LightweightPeer || (component = component instanceof Container ? ((Container)component).findComponentAtImpl(n - component.x, n2 - component.y, bl) : component.locate(n - component.x, n2 - component.y)) == null || !component.visible || !bl && !component.enabled) continue;
            return component;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            component = componentArray[n3];
            if (component == null || !(component.peer instanceof LightweightPeer) || (component = component instanceof Container ? ((Container)component).findComponentAtImpl(n - component.x, n2 - component.y, bl) : component.locate(n - component.x, n2 - component.y)) == null || !component.visible || !bl && !component.enabled) continue;
            return component;
        }
        return this;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            for (int i = 0; i < n; ++i) {
                componentArray[i].addNotify();
            }
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            if (containerPeer.isRestackSupported()) {
                containerPeer.restack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            for (int i = n - 1; i >= 0; --i) {
                if (componentArray[i] == null) continue;
                componentArray[i].removeNotify();
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
                this.dispatcher = null;
            }
            super.removeNotify();
        }
    }

    public boolean isAncestorOf(Component component) {
        Container container;
        if (component == null || (container = component.getParent()) == null) {
            return false;
        }
        while (container != null) {
            if (container == this) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = string + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        for (int i = 0; i < n2; ++i) {
            Component component = componentArray[i];
            if (component == null) continue;
            component.list(printStream, n + 1);
        }
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        for (int i = 0; i < n2; ++i) {
            Component component = componentArray[i];
            if (component == null) continue;
            component.list(printWriter, n + 1);
        }
    }

    public void setFocusTraversalKeys(int n, Set set) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n, set);
    }

    public Set getFocusTraversalKeys(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n);
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this.isFocusCycleRoot() && container == this) {
            return true;
        }
        return super.isFocusCycleRoot(container);
    }

    private Container findTraversalRoot() {
        Container container;
        Container container2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (container2 == this) {
            container = this;
        } else {
            container = this.getFocusCycleRootAncestor();
            if (container == null) {
                container = this;
            }
        }
        if (container != container2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean containsFocus() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            for (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component != null && !(component instanceof Window) && component != this; component = component.getParent()) {
            }
            return component == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isParentOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (component != null && component != this && !(component instanceof Window)) {
                component = component.getParent();
            }
            return component == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMostRecentFocusOwnerOnHide() {
        Container container;
        Component component = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null) {
                for (component = KeyboardFocusManager.getMostRecentFocusOwner((Window)container); component != null && component != this && !(component instanceof Window); component = component.getParent()) {
                }
            }
        }
        if (component == this) {
            KeyboardFocusManager.setMostRecentFocusOwner((Window)container, null);
        }
        if (container != null) {
            object = (Window)container;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                Class clazz = KeyboardFocusManager.class;
                synchronized (clazz) {
                    Component component2 = ((Window)object).getTemporaryLostComponent();
                    if (this.isParentOf(component2) || component2 == this) {
                        ((Window)object).setTemporaryLostComponent(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCurrentFocusCycleRootOnHide() {
        Container container;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object = this.getTreeLock();
        synchronized (object) {
            for (container = keyboardFocusManager.getCurrentFocusCycleRoot(); this != container && !(container instanceof Window) && container != null; container = container.getParent()) {
            }
        }
        if (container == this) {
            keyboardFocusManager.setGlobalCurrentFocusCycleRoot(null);
        }
    }

    boolean nextFocusHelper() {
        if (this.isFocusCycleRoot()) {
            Container container;
            Container container2 = this.findTraversalRoot();
            Container container3 = this;
            while (!(container2 == null || (container = container2.getFocusCycleRootAncestor()) == null || container2.isShowing() && container2.isFocusable() && container2.isEnabled())) {
                container3 = container2;
                container2 = container;
            }
            if (container2 != null) {
                FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(container2, container3);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container2);
                }
                if (component != null) {
                    return component.requestFocus(false);
                }
            }
            return false;
        }
        return super.nextFocusHelper();
    }

    public void transferFocusBackward() {
        if (this.isFocusCycleRoot()) {
            Container container = this.findTraversalRoot();
            Container container2 = this;
            while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
                container2 = container;
                container = container2.getFocusCycleRootAncestor();
            }
            if (container != null) {
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(container, container2);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container);
                }
                if (component != null) {
                    component.requestFocus();
                }
            }
        } else {
            super.transferFocusBackward();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        Container container = this;
        synchronized (container) {
            focusTraversalPolicy2 = this.focusTraversalPolicy;
            this.focusTraversalPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("focusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusTraversalPolicyProvider() && !this.isFocusCycleRoot()) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.focusTraversalPolicy;
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy;
        }
        Container container = this.getFocusCycleRootAncestor();
        if (container != null) {
            return container.getFocusTraversalPolicy();
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusCycleRoot(boolean bl) {
        boolean bl2;
        Container container = this;
        synchronized (container) {
            bl2 = this.focusCycleRoot;
            this.focusCycleRoot = bl;
        }
        this.firePropertyChange("focusCycleRoot", bl2, bl);
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFocusTraversalPolicyProvider(boolean bl) {
        boolean bl2;
        Container container = this;
        synchronized (container) {
            bl2 = this.focusTraversalPolicyProvider;
            this.focusTraversalPolicyProvider = bl;
        }
        this.firePropertyChange("focusTraversalPolicyProvider", bl2, bl);
    }

    public final boolean isFocusTraversalPolicyProvider() {
        return this.focusTraversalPolicyProvider;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
            Component component = this.getFocusTraversalPolicy().getDefaultComponent(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    boolean postsOldMouseEvents() {
        return true;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].applyComponentOrientation(componentOrientation);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("ncomponents", this.ncomponents);
        putField.put("component", this.component);
        putField.put("layoutMgr", this.layoutMgr);
        putField.put("dispatcher", this.dispatcher);
        putField.put("maxSize", this.maxSize);
        putField.put("focusCycleRoot", this.focusCycleRoot);
        putField.put("containerSerializedDataVersion", this.containerSerializedDataVersion);
        putField.put("focusTraversalPolicyProvider", this.focusTraversalPolicyProvider);
        objectOutputStream.writeFields();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block7: {
            Object object;
            Object object2;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.ncomponents = getField.get("ncomponents", 0);
            this.component = (Component[])getField.get("component", new Component[0]);
            this.layoutMgr = (LayoutManager)getField.get("layoutMgr", null);
            this.dispatcher = (LightweightDispatcher)getField.get("dispatcher", null);
            if (this.maxSize == null) {
                this.maxSize = (Dimension)getField.get("maxSize", null);
            }
            this.focusCycleRoot = getField.get("focusCycleRoot", false);
            this.containerSerializedDataVersion = getField.get("containerSerializedDataVersion", 1);
            this.focusTraversalPolicyProvider = getField.get("focusTraversalPolicyProvider", false);
            Component[] componentArray = this.component;
            for (int i = 0; i < this.ncomponents; ++i) {
                componentArray[i].parent = this;
                this.adjustListeningChildren(32768L, componentArray[i].numListening(32768L));
                this.adjustListeningChildren(65536L, componentArray[i].numListening(65536L));
                this.adjustDescendants(componentArray[i].countHierarchyMembers());
            }
            while (null != (object2 = objectInputStream.readObject())) {
                object = ((String)object2).intern();
                if ("containerL" == object) {
                    this.addContainerListener((ContainerListener)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            try {
                object = objectInputStream.readObject();
                if (object instanceof FocusTraversalPolicy) {
                    this.focusTraversalPolicy = (FocusTraversalPolicy)object;
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block7;
                throw optionalDataException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleAt(Point point) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)this);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    int n = accessibleContext.getAccessibleChildrenCount();
                    for (int i = 0; i < n; ++i) {
                        AccessibleComponent accessibleComponent;
                        accessible = accessibleContext.getAccessibleChild(i);
                        if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                        Point point2 = accessibleComponent.getLocation();
                        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                        if (!accessibleComponent.contains(point3)) continue;
                        return accessible;
                    }
                }
                return (Accessible)((Object)this);
            }
            Component component = this;
            if (!this.contains(point.x, point.y)) {
                component = null;
            } else {
                int n = this.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = this.getComponent(i);
                    if (component2 == null || !component2.isShowing()) continue;
                    Point point4 = component2.getLocation();
                    if (!component2.contains(point.x - point4.x, point.y - point4.y)) continue;
                    component = component2;
                }
            }
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessibleChildrenCount() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleChild(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    return (Accessible)((Object)componentArray[i]);
                }
                ++n2;
            }
            return null;
        }
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Container.initIDs();
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        private volatile transient int propertyListenersCount;
        protected ContainerListener accessibleContainerHandler;

        protected AccessibleAWTContainer() {
            super(Container.this);
            this.accessibleContainerHandler = null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return Container.this.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return Container.this.getAccessibleChild(i);
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return Container.this.getAccessibleAt(p);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
            }
            if (this.propertyListenersCount++ == 0) {
                Container.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyListenersCount == 0) {
                Container.this.removeContainerListener(this.accessibleContainerHandler);
            }
            super.removePropertyChangeListener(listener);
        }

        protected class AccessibleContainerHandler
        implements ContainerListener,
        Serializable {
            private static final long serialVersionUID = -480855353991814677L;

            protected AccessibleContainerHandler() {
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c instanceof Accessible) {
                    Accessible accessible = (Accessible)((Object)c);
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, accessible.getAccessibleContext());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c instanceof Accessible) {
                    Accessible accessible = (Accessible)((Object)c);
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", accessible.getAccessibleContext(), null);
                }
            }
        }
    }

    static class DropTargetEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new DropTargetEventTargetFilter();

        private DropTargetEventTargetFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            DropTarget dt = comp.getDropTarget();
            return dt != null && dt.isActive();
        }
    }

    static interface EventTargetFilter {
        public boolean accept(Component var1);
    }

    static class MouseEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new MouseEventTargetFilter();

        private MouseEventTargetFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            return (comp.eventMask & 0x20L) != 0L || (comp.eventMask & 0x10L) != 0L || (comp.eventMask & 0x20000L) != 0L || comp.mouseListener != null || comp.mouseMotionListener != null || comp.mouseWheelListener != null;
        }
    }
}

